/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.runtime.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.hamanagerservice.HAManagerService;
import com.ibm.websphere.models.config.process.ThreadPool;
import com.ibm.ws.hamanager.runtime.config.ConfigUtils;
import com.ibm.ws.hamanager.runtime.config.HAParseException;
import com.ibm.ws.hamanager.utils.MapUtils;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class LocalServer {
    private static final TraceComponent TC = Tr.register(LocalServer.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static String svClassName = LocalServer.class.getName();
    private boolean ivIsEnabled;
    private boolean ivActivate;
    private String ivCoreGroupName;
    private int ivIsAliveTimeSec;
    private int ivTransportBufferSize;
    private int ivDCSThreads;
    private int ivHAMMaxSize;
    private int ivHAMMinSize;
    private int ivInactiveTimeout;
    private boolean ivIsGrowable = false;
    private HashMap ivCustomProperties;

    LocalServer(HAManagerService hAManagerService) throws HAParseException {
        this.ivIsEnabled = hAManagerService.isEnable();
        this.ivActivate = hAManagerService.isActivateEnabled();
        this.ivCoreGroupName = hAManagerService.getCoreGroupName();
        if (this.ivCoreGroupName == null || this.ivCoreGroupName.equals("")) {
            Tr.error(TC, "HMGR0026", new Object[]{"hamanager", "coreGroupName", null});
            throw new HAParseException("null or empty coreGroupName attribute");
        }
        this.ivIsAliveTimeSec = hAManagerService.getIsAlivePeriodSec();
        this.ivTransportBufferSize = hAManagerService.getTransportBufferSize();
        if (this.ivTransportBufferSize < 10) {
            this.ivTransportBufferSize = 10;
        }
        ThreadPool threadPool = hAManagerService.getThreadPool();
        this.ivInactiveTimeout = threadPool.getInactivityTimeout();
        int n = threadPool.getMaximumSize();
        int n2 = n % 3;
        if (n2 == 1) {
            ++n;
        } else if (n2 == 2) {
            n += 2;
        }
        this.ivHAMMaxSize = n / 3;
        this.ivDCSThreads = 2 * this.ivHAMMaxSize;
        this.ivHAMMinSize = threadPool.getMinimumSize();
        this.ivIsGrowable = false;
        EList eList = hAManagerService.getProperties();
        if (eList != null) {
            this.ivCustomProperties = ConfigUtils.extractUntypedProperties((List)eList);
        }
    }

    boolean activateAllowed() {
        return this.ivActivate;
    }

    public int getIsAlivePeriod() {
        return this.ivIsAliveTimeSec;
    }

    String getCoreGroupName() {
        return this.ivCoreGroupName;
    }

    int getTransportBufferSize() {
        return this.ivTransportBufferSize;
    }

    public int getThreadPoolMaxSize() {
        return this.ivHAMMaxSize;
    }

    public int getThreadPoolMinSize() {
        return this.ivHAMMinSize;
    }

    public int getThreadPoolInactivityTime() {
        return this.ivInactiveTimeout;
    }

    int getNumberOfDCSThreads() {
        return this.ivDCSThreads;
    }

    HashMap getCustomProperties() {
        return this.ivCustomProperties;
    }

    boolean isEnabled() {
        return this.ivIsEnabled;
    }

    void merge(LocalServer localServer) throws HAInternalStateException {
        boolean bl;
        boolean bl2 = false;
        if (this.ivIsEnabled != localServer.ivIsEnabled) {
            this.ivIsEnabled = localServer.ivIsEnabled;
            bl2 = true;
        }
        if (this.ivActivate != localServer.ivActivate) {
            this.ivActivate = localServer.ivActivate;
            bl2 = true;
        }
        if (this.ivIsAliveTimeSec != localServer.ivIsAliveTimeSec) {
            this.ivIsAliveTimeSec = localServer.ivIsAliveTimeSec;
            bl2 = true;
        }
        if (this.ivHAMMaxSize != localServer.ivHAMMaxSize) {
            this.ivHAMMaxSize = localServer.ivHAMMaxSize;
            bl2 = true;
        }
        if (this.ivHAMMinSize != localServer.ivHAMMinSize) {
            this.ivHAMMinSize = localServer.ivHAMMinSize;
            bl2 = true;
        }
        if (!this.ivCoreGroupName.equals(localServer.ivCoreGroupName)) {
            this.ivCoreGroupName = localServer.ivCoreGroupName;
            bl2 = true;
        }
        if (!(bl = MapUtils.compareMaps(this.ivCustomProperties, localServer.ivCustomProperties))) {
            this.ivCustomProperties = localServer.ivCustomProperties;
            bl2 = true;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LocalServer : Enabled ");
        stringBuffer.append(this.ivIsEnabled);
        stringBuffer.append(", core group name ");
        stringBuffer.append(this.ivCoreGroupName);
        stringBuffer.append(", transport buffer size ");
        stringBuffer.append(this.ivTransportBufferSize);
        stringBuffer.append(", number DCS threads ");
        stringBuffer.append(this.ivDCSThreads);
        stringBuffer.append(", max HAM threads ");
        stringBuffer.append(this.ivHAMMaxSize);
        stringBuffer.append(", thread timeout ");
        stringBuffer.append(this.ivInactiveTimeout);
        stringBuffer.append(", is alive time ");
        stringBuffer.append(this.ivIsAliveTimeSec);
        return stringBuffer.toString();
    }
}

