/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.runtime.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.models.config.coregroup.CoreGroup;
import com.ibm.ws.dcs.common.StateBlob;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.Version;
import com.ibm.ws.hamanager.runtime.config.Config;
import com.ibm.ws.hamanager.runtime.config.ConfigUtils;
import com.ibm.ws.hamanager.runtime.config.CoreGroupConfig;
import com.ibm.ws.hamanager.runtime.config.CoreGroupConfigV2;
import com.ibm.ws.hamanager.runtime.config.HAParseException;
import com.ibm.wsspi.hamanager.HAException;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class StateBlobBuilder {
    private static final TraceComponent TC = Tr.register(StateBlobBuilder.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static String svClassName = StateBlobBuilder.class.getName();
    private static ConfigRepository svConfigRepository = null;

    public static synchronized void initialize(ConfigRepository configRepository) {
        svConfigRepository = configRepository;
    }

    public static synchronized StateBlob buildBlob(String string, boolean bl, boolean bl2) throws HAException {
        if (svConfigRepository == null) {
            throw new HAException("Uninitialized!");
        }
        String string2 = null;
        String string3 = StateBlobBuilder.getCoreGroupXmlUri(string);
        try {
            DocumentDigest documentDigest = svConfigRepository.getDigest(string3);
            Resource resource = Config.getCellRelativeConfigDoc(StateBlobBuilder.rebuildUri(string3));
            CoreGroup coreGroup = (CoreGroup)resource.getContents().get(0);
            if (coreGroup == null) {
                Tr.error(TC, "HMGR0020", "coregroup");
                throw new HAParseException("Unable to read the " + string3 + " document.");
            }
            string2 = coreGroup.getName();
            if (string2 == null || string2.equals("")) {
                Tr.error(TC, "HMGR0026", new Object[]{"coregroup", "coreGroupName", string2});
                throw new HAParseException("coregroup name is null or empty");
            }
            if (!string2.equals(string)) {
                Tr.error(TC, "HMGR0026", new Object[]{"coregroup", "coreGroupName", string2});
                throw new HAParseException("Read core group name " + string2 + " didn't match expected " + string);
            }
            String string4 = StateBlobBuilder.getWireFormatVersion(coreGroup);
            String string5 = Config.getDCSProtocolVersion(coreGroup);
            int n = Version.getDCSProtocolVersionMapping(string5);
            if (n < 10) {
                CoreGroupConfig coreGroupConfig = new CoreGroupConfig(documentDigest, Config.getCell(), coreGroup, Config.getServer(), bl);
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "buildBlob", new Object[]{coreGroupConfig, string4});
                }
                return coreGroupConfig;
            }
            String string6 = Config.getHamProtocolVersion(coreGroup, string5);
            CoreGroupConfigV2 coreGroupConfigV2 = new CoreGroupConfigV2(documentDigest, Config.getCell(), coreGroup, Config.getServer(), bl, string5, string6);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "buildBlobV2", new Object[]{coreGroupConfigV2, string4});
            }
            return coreGroupConfigV2;
        }
        catch (HAException hAException) {
            FFDCFilter.processException(hAException, svClassName, "208");
            throw hAException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "212");
            Tr.error(TC, "HMGR0021", throwable);
            throw new HAException("Error parsing CoreGroup " + string2, throwable);
        }
    }

    private static String rebuildUri(String string) {
        String string2 = "";
        String[] stringArray = string.split("/");
        for (int i = 2; i < stringArray.length; ++i) {
            string2 = string2 + stringArray[i] + "/";
        }
        string2.subSequence(0, string2.length() - 1);
        return string2;
    }

    private static String getCoreGroupXmlUri(String string) {
        return Config.svCoreGroupDocumentPath + "/" + string + "/" + "coregroup.xml";
    }

    private static String getWireFormatVersion(CoreGroup coreGroup) {
        String string = coreGroup.getProtocolVersion();
        String string2 = null;
        String string3 = "IBM_CS_WIRE_FORMAT_VERSION";
        try {
            HashMap hashMap;
            EList eList = coreGroup.getCustomProperties();
            if (eList.size() > 0 && (hashMap = ConfigUtils.extractUntypedProperties((List)eList)) != null) {
                string2 = (String)hashMap.get(string3);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "1076");
            Tr.error(TC, "HMGR0023", new Object[]{string3, null, "String", throwable});
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "getWireFormatVersion", new Object[]{string, string2});
        }
        if (string2 == null) {
            if (string == null) {
                return "6.0.0";
            }
            return string;
        }
        if (string == null || "6.0.0".equals(string)) {
            return string2;
        }
        return string;
    }
}

