/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.hamanager.GroupMemberId;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;

public class DebugUtils {
    private static char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static String svLineSep = null;

    private DebugUtils() {
    }

    public static String dumpMap(String string, Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(" : ");
        try {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("[");
                Object k = iterator.next();
                stringBuffer.append(k);
                stringBuffer.append(":");
                Object v = map.get(k);
                stringBuffer.append(v);
                stringBuffer.append("]");
            }
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            stringBuffer.append("...error");
            return stringBuffer.toString();
        }
    }

    public static String dumpGroupMemberList(GroupMemberId[] groupMemberIdArray) {
        if (groupMemberIdArray == null || groupMemberIdArray.length == 0) {
            return "empty";
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = groupMemberIdArray.length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(groupMemberIdArray[i]);
                stringBuffer.append(" ");
            }
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            stringBuffer.append("...error");
            return stringBuffer.toString();
        }
    }

    public static String getNewLine() {
        if (svLineSep != null) {
            return svLineSep;
        }
        try {
            String string = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("line.separator");
                }
            });
            return string;
        }
        catch (SecurityException securityException) {
            FFDCFilter.processException(securityException, "com.ibm.ws.hamanager.utils.DebugUtils.getNewLine", "138");
            return "\n";
        }
    }

    public static String byteArrayToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(hexChars[byArray[i] >> 4 & 0xF]);
            stringBuffer.append(hexChars[byArray[i] & 0xF]);
        }
        return new String(stringBuffer);
    }
}

