/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.io.WSByteArrayOutputStream;
import com.ibm.ws.util.WsObjectInputStream;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class HAMUtil {
    public static final String SERVER_NAME_SEPARATOR = "\\";

    private HAMUtil() {
    }

    public static String createFullyQualifiedServerName(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.setLength(0);
        stringBuffer.append(string);
        stringBuffer.append(SERVER_NAME_SEPARATOR);
        stringBuffer.append(string2);
        stringBuffer.append(SERVER_NAME_SEPARATOR);
        stringBuffer.append(string3);
        String string4 = stringBuffer.toString();
        return string4;
    }

    public static String[] splitFullyQualifiedServerName(String string) {
        String string2 = "\\\\";
        String[] stringArray = string.split(string2);
        return stringArray;
    }

    public static int calculateCoordinatorIndex(Object object, int n) {
        int n2 = Math.abs(object.hashCode());
        int n3 = n2 % n;
        return n3;
    }

    public static void writeSetToStream(ObjectOutputStream objectOutputStream, Set set) throws IOException {
        if (set == null) {
            objectOutputStream.writeInt(-1);
        } else {
            int n = set.size();
            objectOutputStream.writeInt(n);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                objectOutputStream.writeObject(e2);
            }
        }
    }

    public static HashSet readSetFromStream(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        if (n == -1) {
            return null;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                Object object = objectInputStream.readObject();
                hashSet.add(object);
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(Serializable serializable) throws IOException {
        WSByteArrayOutputStream wSByteArrayOutputStream = new WSByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(wSByteArrayOutputStream);
            objectOutputStream.writeObject(serializable);
            objectOutputStream.reset();
        }
        finally {
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
        }
        return wSByteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object toObject(byte[] byArray) throws OptionalDataException, ClassNotFoundException, IOException {
        if (byArray == null) {
            return null;
        }
        Object object = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        WsObjectInputStream wsObjectInputStream = null;
        try {
            wsObjectInputStream = new WsObjectInputStream(byteArrayInputStream);
            object = wsObjectInputStream.readObject();
        }
        finally {
            if (wsObjectInputStream != null) {
                wsObjectInputStream.close();
            }
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
        }
        if (object == null) {
            return null;
        }
        if (!object.getClass().getName().equals("[B")) {
            return object;
        }
        byteArrayInputStream = new ByteArrayInputStream((byte[])object);
        try {
            wsObjectInputStream = new WsObjectInputStream(byteArrayInputStream);
            object = wsObjectInputStream.readObject();
        }
        finally {
            if (wsObjectInputStream != null) {
                wsObjectInputStream.close();
            }
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
        }
        return object;
    }

    public static final Class getClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        clazz = Class.forName(string);
        return clazz;
    }

    public static Object getObject(Class clazz, Class[] classArray, Object[] objectArray) throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object var3_3 = null;
        var3_3 = (classArray == null ? clazz.newInstance() : clazz.getConstructor(classArray).newInstance(objectArray));
        return var3_3;
    }

    public static Map copyHashMap(Map map) {
        return new HashMap(map);
    }

    public static boolean compareGroupMemberIdArrays(GroupMemberId[] groupMemberIdArray, GroupMemberId[] groupMemberIdArray2) {
        if (groupMemberIdArray == null) {
            return groupMemberIdArray2 == null;
        }
        if (groupMemberIdArray2 == null) {
            return false;
        }
        int n = groupMemberIdArray2.length;
        if (n != groupMemberIdArray.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            GroupMemberId groupMemberId = groupMemberIdArray[i];
            for (int j = 0; j < n && !groupMemberId.equals(groupMemberIdArray2[j]); ++j) {
                if (j != n - 1) continue;
                return false;
            }
        }
        return true;
    }

    public static String[] getServerNames(GroupMemberId[] groupMemberIdArray) throws HAParameterRejectedException {
        if (groupMemberIdArray == null) {
            throw new HAParameterRejectedException("HAMUtil.getServerNames() - GroupMemberId[] parm is null.");
        }
        int n = groupMemberIdArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            if (groupMemberIdArray[i] == null) {
                throw new HAParameterRejectedException("HAMUtil.getServerNames() - GroupMemberId[] parm contains null entries.");
            }
            stringArray[i] = groupMemberIdArray[i].getServerName();
        }
        return stringArray;
    }

    public static GroupMemberId[] getIntersectingMemberList(GroupMemberId[] groupMemberIdArray, GroupMemberId[] groupMemberIdArray2) {
        String[] stringArray;
        try {
            stringArray = HAMUtil.getServerNames(groupMemberIdArray2);
        }
        catch (HAParameterRejectedException hAParameterRejectedException) {
            FFDCFilter.processException(hAParameterRejectedException, "com.ibm.ws.hamanager.utils.HAMUtil.getIntersectingMemberList", "426");
            return new GroupMemberId[0];
        }
        return HAMUtil.getIntersectingMemberList(groupMemberIdArray, stringArray);
    }

    public static GroupMemberId[] getIntersectingMemberList(GroupMemberId[] groupMemberIdArray, String[] stringArray) {
        int n = groupMemberIdArray.length;
        ArrayList<GroupMemberId> arrayList = new ArrayList<GroupMemberId>(n);
        block0: for (int i = 0; i < n; ++i) {
            for (int j = 0; j < stringArray.length; ++j) {
                if (!groupMemberIdArray[i].getServerName().equals(stringArray[j])) continue;
                arrayList.add(groupMemberIdArray[i]);
                continue block0;
            }
        }
        GroupMemberId[] groupMemberIdArray2 = new GroupMemberId[arrayList.size()];
        groupMemberIdArray2 = arrayList.toArray(groupMemberIdArray2);
        return groupMemberIdArray2;
    }
}

