/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.utils;

import com.ibm.websphere.management.AdminService;
import com.ibm.ws.hamanager.utils.HAMUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;

public class JMXUtils {
    private JMXUtils() {
    }

    public static boolean isServerRunning(AdminService adminService, String string, String string2, String string3, QueryExp queryExp) throws MalformedObjectNameException {
        ObjectName objectName = new ObjectName(adminService.getDomainName() + ":*,type=HAManager,cell=" + string + ",node=" + string2 + ",process=" + string3);
        Set set = adminService.queryNames(objectName, queryExp);
        return set != null && set.size() > 0;
    }

    public static boolean isNodeAgentRunning(AdminService adminService, String string, String string2, QueryExp queryExp) throws MalformedObjectNameException {
        return JMXUtils.isServerRunning(adminService, string, string2, "nodeagent", queryExp);
    }

    public static ObjectName getHAMBeanForServer(AdminService adminService, String string, String string2, String string3, String string4, QueryExp queryExp) throws MalformedObjectNameException {
        ObjectName objectName = null;
        ObjectName objectName2 = new ObjectName(adminService.getDomainName() + ":*,type=HAManager,coregroup=" + string + ",cell=" + string2 + ",node=" + string3 + ",process=" + string4);
        Set set = adminService.queryNames(objectName2, queryExp);
        if (set != null && set.size() > 0) {
            objectName = (ObjectName)set.toArray()[0];
        }
        return objectName;
    }

    public static ObjectName findHAMBeanForCG(AdminService adminService, String string, String[] stringArray, QueryExp queryExp) throws MalformedObjectNameException {
        Arrays.sort(stringArray);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            ObjectName objectName;
            String[] stringArray2 = HAMUtil.splitFullyQualifiedServerName(stringArray[i]);
            String string2 = stringArray2[0];
            String string3 = stringArray2[1];
            String string4 = stringArray2[2];
            if (arrayList.contains(string3)) {
                objectName = JMXUtils.getHAMBeanForServer(adminService, string, string2, string3, string4, queryExp);
                if (objectName == null) continue;
                return objectName;
            }
            if (arrayList2.contains(string3)) continue;
            if (string4.equals("dmgr") || string4.equals("nodeagent")) {
                objectName = JMXUtils.getHAMBeanForServer(adminService, string, string2, string3, string4, queryExp);
                if (objectName != null) {
                    return objectName;
                }
                arrayList2.add(string3);
                continue;
            }
            if (JMXUtils.isNodeAgentRunning(adminService, string2, string3, null)) {
                arrayList.add(string3);
                objectName = JMXUtils.getHAMBeanForServer(adminService, string, string2, string3, string4, queryExp);
                if (objectName == null) continue;
                return objectName;
            }
            arrayList2.add(string3);
        }
        return null;
    }
}

