/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.hamanager.utils.HAMUtil;
import com.ibm.ws.hamanager.utils.StringUtils;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.HAMapException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MapUtils {
    private static final TraceComponent TC = Tr.register(MapUtils.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static final char GN_SEPERATOR_CHAR = ',';

    private MapUtils() {
    }

    public static Map copyHashMap(Map map) {
        return new HashMap(map);
    }

    public static void writeMapToStream(ObjectOutput objectOutput, Map map) throws IOException {
        if (map == null) {
            objectOutput.writeInt(-1);
        } else {
            int n = map.size();
            objectOutput.writeInt(n);
            Set set = map.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                objectOutput.writeObject(k);
                objectOutput.writeObject(v);
            }
        }
    }

    public static HashMap readMapFromStream(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        if (n == -1) {
            return null;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                Object object = objectInput.readObject();
                Object object2 = objectInput.readObject();
                hashMap.put(object, object2);
            }
        }
        return hashMap;
    }

    public static boolean compareMaps(Map map, Map map2) throws HAInternalStateException {
        if (map == null) {
            return map2 == null;
        }
        if (map2 == null) {
            return false;
        }
        if (map.size() != map2.size()) {
            return false;
        }
        try {
            Set set = map.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (!map2.containsKey(k)) {
                    return false;
                }
                Object v2 = map2.get(k);
                if (!(v == null ? v2 != null : !v.equals(v2))) continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, HAMUtil.class.getName(), "459");
            throw new HAInternalStateException("error while comparing maps", throwable);
        }
    }

    public static boolean validateUserMap(Map map, String string) throws HAMapException {
        if (map == null) {
            throw new HAMapException("Map " + string + " is null. The Map must be non-null");
        }
        if (map.isEmpty()) {
            throw new HAMapException("Map " + string + " is empty. An empty Map is not allowed.");
        }
        try {
            Set set = map.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string2 = (String)entry.getKey();
                if (string2.charAt(0) == '_') {
                    throw new HAMapException("Key " + string2 + " in Map " + string + " begins with a reserved character");
                }
                MapUtils.checkMapString(string2, string);
                String string3 = (String)entry.getValue();
                MapUtils.checkMapString(string3, string);
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            throw new HAMapException("Map " + string + " contains a key or value that is not a String. This is not allowed.", classCastException);
        }
    }

    public static boolean isMap1ProperSupersetOfMap2(Map map, Map map2) throws HAInternalStateException {
        try {
            Set set = map2.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (!map.containsKey(k)) {
                    return false;
                }
                Object v2 = map.get(k);
                if (v.equals(v2)) continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, HAMUtil.class.getName(), "444");
            throw new HAInternalStateException("error while comparing maps", throwable);
        }
    }

    public static String sortAndStringifyMap(Map map, String string) throws HAMapException {
        ArrayList arrayList = MapUtils.getSortedKeysForMap(map, string);
        int n = arrayList.size();
        try {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)arrayList.get(i);
                String string3 = (String)map.get(string2);
                stringBuffer.append(string2);
                stringBuffer.append("=");
                stringBuffer.append(string3);
                if (i >= n - 1) continue;
                stringBuffer.append(',');
            }
            return stringBuffer.toString();
        }
        catch (ClassCastException classCastException) {
            throw new HAMapException("Map " + string + " contains a value that is not a String. This is not allowed.", classCastException);
        }
    }

    public static Map reconstructMapFromString(String string) throws HAInternalStateException {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ArrayList arrayList = StringUtils.splitString(string, 44);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)arrayList.get(i);
                ArrayList arrayList2 = StringUtils.splitString(string2, 61);
                String string3 = (String)arrayList2.get(0);
                String string4 = (String)arrayList2.get(1);
                hashMap.put(string3, string4);
            }
            if (hashMap.size() == 0) {
                HAInternalStateException hAInternalStateException = new HAInternalStateException("Reconstructed Map has no entries");
                Tr.error(TC, "HMGR5010", hAInternalStateException);
                throw hAInternalStateException;
            }
            return hashMap;
        }
        catch (HAInternalStateException hAInternalStateException) {
            throw hAInternalStateException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, HAMUtil.class.getName(), "356");
            throw new HAInternalStateException("Error reconstructing Map from String", throwable);
        }
    }

    private static ArrayList getSortedKeysForMap(Map map, String string) throws HAMapException {
        ArrayList<String> arrayList = new ArrayList<String>(map.size());
        int n = 0;
        try {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                boolean bl = false;
                int n2 = 0;
                while (!bl && n2 < n) {
                    if (string2.compareTo((String)arrayList.get(n2)) > 0) {
                        ++n2;
                        continue;
                    }
                    arrayList.add(n2, string2);
                    bl = true;
                    ++n;
                }
                if (bl) continue;
                arrayList.add(string2);
                ++n;
            }
            return arrayList;
        }
        catch (ClassCastException classCastException) {
            throw new HAMapException("Map " + string + " contains a key that is not a String. This is not allowed.", classCastException);
        }
    }

    private static void checkMapString(String string, String string2) throws HAMapException {
        if (string.indexOf(44) != -1) {
            throw new HAMapException("Map " + string2 + " contains invalid characters.  Key or value [" + string + "] contains an invalid comma (',') character.");
        }
        if (string.indexOf(124) != -1) {
            throw new HAMapException("Map " + string2 + " contains invalid characters.  Key or value [" + string + "] contains an invalid vertical bar ('|') character.");
        }
        if (string.indexOf(61) != -1) {
            throw new HAMapException("Map " + string2 + " contains invalid characters.  Key or value [" + string + "] contains an invalid equals ('=') character.");
        }
    }

    void dumpDiagnostic(IncidentStream incidentStream, Map map) {
    }
}

