/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.hamanager.utils.HAMUtil;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class StringUtils {
    private static final TraceComponent TC = Tr.register(HAMUtil.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");

    private StringUtils() {
    }

    public static boolean arrayContainsString(String string, String[] stringArray) {
        if (string == null || stringArray == null) {
            return false;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean compareStringArraysForExactEquality(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            return stringArray2 == null;
        }
        if (stringArray2 == null) {
            return false;
        }
        int n = stringArray.length;
        if (n != stringArray2.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (!(stringArray[i] == null ? stringArray2[i] != null : !stringArray[i].equals(stringArray2[i]))) continue;
            return false;
        }
        return true;
    }

    public static boolean compareStringArraysForContentEquality(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            return stringArray2 == null;
        }
        if (stringArray2 == null) {
            return false;
        }
        boolean bl = StringUtils.areAllStringsInArrayOneInArrayTwo(stringArray, stringArray2);
        if (!bl) {
            return false;
        }
        return StringUtils.areAllStringsInArrayOneInArrayTwo(stringArray2, stringArray);
    }

    public static ArrayList splitString(String string, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || string.equals("")) {
            return arrayList;
        }
        int n2 = 0;
        int n3 = -1;
        boolean bl = true;
        while (bl) {
            n3 = string.indexOf(n, n2);
            if (n3 == -1) {
                bl = false;
                arrayList.add(string.substring(n2));
                continue;
            }
            arrayList.add(string.substring(n2, n3));
            n2 = n3 + 1;
        }
        return arrayList;
    }

    public static Set computeRemovedStrings(String[] stringArray, String[] stringArray2) {
        int n;
        HashSet<String> hashSet = new HashSet<String>();
        if (stringArray == null) {
            return hashSet;
        }
        int n2 = stringArray.length;
        if (n2 == 0) {
            return hashSet;
        }
        for (n = 0; n < n2; ++n) {
            hashSet.add(stringArray[n]);
        }
        if (stringArray2 == null) {
            return hashSet;
        }
        n2 = stringArray2.length;
        if (n2 == 0) {
            return hashSet;
        }
        for (n = 0; n < n2; ++n) {
            hashSet.remove(stringArray2[n]);
        }
        return hashSet;
    }

    public static void writeStringArrayToStream(ObjectOutput objectOutput, String[] stringArray) throws IOException {
        if (stringArray == null) {
            objectOutput.writeInt(-1);
        } else {
            int n = stringArray.length;
            objectOutput.writeInt(n);
            for (int i = 0; i < n; ++i) {
                objectOutput.writeUTF(stringArray[i]);
            }
        }
    }

    public static String[] readStringArrayFromStream(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        if (n == -1) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = objectInput.readUTF();
        }
        return stringArray;
    }

    public static String convertStringArrayToString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append(",");
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private static boolean areAllStringsInArrayOneInArrayTwo(String[] stringArray, String[] stringArray2) {
        int n = stringArray.length;
        int n2 = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            if (stringArray[i] == null) continue;
            boolean bl = false;
            for (int j = 0; j < n2; ++j) {
                if (!stringArray[i].equals(stringArray2[j])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public static String[] removeElementAndAllDupsFromStringArray(String[] stringArray, String string) {
        int n = stringArray.length;
        if (n == 0) {
            return stringArray;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < n; ++i) {
            hashSet.add(stringArray[i]);
        }
        hashSet.remove(string);
        if (hashSet.size() == n) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "removeElementFromStringArray, no elements were removed, source array: " + Arrays.toString(stringArray) + ", element to be removed: " + string + ", source array returned.");
            }
            return stringArray;
        }
        Object[] objectArray = new String[hashSet.size()];
        hashSet.toArray(objectArray);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "removeElementFromStringArray, elements were removed, source array: " + Arrays.toString(stringArray) + ", element to be removed: " + string + ", array returned: " + Arrays.toString(objectArray));
        }
        return objectArray;
    }
}

