/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.handlerfw.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.handlerfw.HandlerFrameworkService;
import com.ibm.ws.handlerfw.impl.ApplicationEventManager;
import com.ibm.ws.handlerfw.impl.HandlerFrameworkImpl;
import com.ibm.ws.handlerfw.impl.HandlerFrameworkServiceImpl;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectListener;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.wsspi.handlerfw.HandlerFramework;
import com.ibm.wsspi.handlerfw.exception.HFConfigException;
import java.io.FileNotFoundException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class ApplicationHandlerManagerService
extends ComponentImpl
implements DeployedObjectListener {
    private static final TraceComponent tc = Tr.register(ApplicationHandlerManagerService.class, "HandlerFramework", "com.ibm.ws.handlerfw.resources.handlerframework");
    HandlerFrameworkService handlerFrameworkService = null;
    ApplicationEventManager eventManager = null;

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        String string = "initialize()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        this.addService(ApplicationHandlerManagerService.class);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Added as Service.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        String string = "start()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        this.handlerFrameworkService = this.getHandlerFrameworkService();
        if (this.handlerFrameworkService == null) {
            throw new RuntimeWarning("Failed to lookup HandlerFrameworkService in JNDI.");
        }
        HandlerFramework handlerFramework = ((HandlerFrameworkServiceImpl)this.handlerFrameworkService).getHandlerFramework();
        this.eventManager = ((HandlerFrameworkImpl)handlerFramework).getApplicationEventManager();
        ApplicationMgr applicationMgr = (ApplicationMgr)this.getService(ApplicationMgr.class);
        if (applicationMgr == null) {
            Tr.error(tc, "SERVICE_LOOKUP_FAILURE", "ApplicationMgr");
            throw new RuntimeWarning("Failed to lookup ApplicationMgr service.");
        }
        applicationMgr.addDeployedObjectListener(this);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Registered to receive DeployedObjectEvents");
        }
        this.releaseService(applicationMgr);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private HandlerFrameworkService getHandlerFrameworkService() {
        HandlerFrameworkService handlerFrameworkService = null;
        try {
            InitialContext initialContext = new InitialContext();
            handlerFrameworkService = (HandlerFrameworkService)initialContext.lookup("services:websphere/HandlerFrameworkService");
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.handlerfw.impl.ApplicationHandlerManagerService.getHandlerFrameworkService", "143", this);
            Tr.error(tc, "SERVICE_LOOKUP_FAILURE", "HandlerFramework");
        }
        return handlerFrameworkService;
    }

    public void stop() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        block34: {
            String string = "stateChanged()";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, string);
            }
            DeployedObject deployedObject = deployedObjectEvent.getDeployedObject();
            String string2 = (String)deployedObjectEvent.getNewValue();
            if (!string2.equals("STARTED") && !string2.equals("STOPPING")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Ignoring Event: " + string2);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, string);
                }
                return;
            }
            MetaData metaData = deployedObject.getMetaData();
            if (metaData == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Null MetaData object.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, string);
                }
                return;
            }
            ModuleFile moduleFile = (ModuleFile)deployedObject.getModuleFile();
            if (moduleFile == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Null ModuleFile.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, string);
                }
                return;
            }
            ClassLoader classLoader = deployedObject.getClassLoader();
            if (classLoader == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Null ClassLoader.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, string);
                }
                return;
            }
            try {
                Object object;
                boolean bl;
                J2EEName j2EEName;
                block35: {
                    if (!(deployedObject instanceof DeployedModule)) break block34;
                    ModuleMetaData moduleMetaData = (ModuleMetaData)metaData;
                    j2EEName = moduleMetaData.getJ2EEName();
                    String string3 = j2EEName.getApplication();
                    String string4 = j2EEName.getModule();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "EJB Module Event=" + string2 + ",old state=" + deployedObjectEvent.getOldValue());
                        Tr.debug(tc, "Application=" + string3);
                        Tr.debug(tc, "Module=" + string4);
                    }
                    bl = false;
                    if (!moduleFile.isEJBJarFile()) break block34;
                    try {
                        object = moduleFile.getMofResource("META-INF/ws-handler.xmi");
                        if (object != null) {
                            bl = true;
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block35;
                        Tr.debug(tc, "Error while looking for Handler Descripor: " + exception);
                    }
                }
                object = moduleFile.getAbsolutePath();
                moduleFile.close();
                if (!bl) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Handler Descriptor not found in the module: " + (String)object);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Handler Descriptor found in module: " + (String)object);
                }
                if (string2.equals("STARTED")) {
                    block36: {
                        if (bl) {
                            try {
                                this.handlerFrameworkService.loadHandlerConfig((String)object, j2EEName.getApplication(), j2EEName.getModule());
                            }
                            catch (HFConfigException hFConfigException) {
                                FFDCFilter.processException((Throwable)hFConfigException, "com.ibm.ws.handlerfw.impl.ApplicationHandlerManagerService.stateChanged", "273", this);
                                if (!tc.isDebugEnabled()) break block36;
                                Tr.debug(tc, "Error Loading Handler Configuration :" + hFConfigException);
                                Tr.debug(tc, "JarPath=" + (String)object);
                            }
                        }
                    }
                    this.eventManager.moduleStarted(j2EEName.getApplication(), j2EEName.getModule(), classLoader);
                    break block34;
                }
                if (string2.equals("STOPPING")) {
                    this.eventManager.moduleStopped(j2EEName.getApplication(), j2EEName.getModule());
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error loading Configuration: " + exception);
                }
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, string);
                }
            }
        }
    }
}

