/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.handlerfw.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.handlerfw.impl.ApplicationEventManager;
import com.ibm.ws.handlerfw.impl.EJBHandlerConfigImpl;
import com.ibm.ws.handlerfw.impl.HandlerEventListener;
import com.ibm.ws.handlerfw.impl.ModuleEventListener;
import com.ibm.wsspi.handlerfw.HandlerConfig;
import com.ibm.wsspi.handlerfw.WsHandler;
import com.ibm.wsspi.handlerfw.exception.HandlerInstantiationException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;

public class EJBHandlerImpl
implements WsHandler,
ModuleEventListener {
    private static final TraceComponent tc = Tr.register(EJBHandlerImpl.class, "HandlerFramework", "com.ibm.ws.handlerfw.resources.handlerframework");
    private static Class j2EENameClass;
    private static Class j2EENameFactoryClass;
    private static Method createJ2EENameMethod;
    private static Class ejbContainerClass;
    private static Method getNameFactoryMethod;
    private static Method getEJBLocalHomeMethod;
    private static boolean ejbClassesLoaded;
    EJBHandlerConfigImpl config = null;
    private Object invokeTarget = null;
    private int status = 1;
    private List eventListenerList = new ArrayList(10);

    public EJBHandlerImpl(EJBHandlerConfigImpl eJBHandlerConfigImpl, ApplicationEventManager applicationEventManager) throws HandlerInstantiationException {
        this.config = eJBHandlerConfigImpl;
        if (!ejbClassesLoaded) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not loading EJB handler since EJB classes are not available:" + eJBHandlerConfigImpl.getName());
            }
            throw new HandlerInstantiationException("EJB Classes not available to load Handler: " + eJBHandlerConfigImpl.getName());
        }
        boolean bl = applicationEventManager.hasModuleStarted(eJBHandlerConfigImpl.getApplicationName(), eJBHandlerConfigImpl.getModuleName());
        if (bl) {
            this.invokeTarget = this.initialize();
            if (this.invokeTarget == null) {
                throw new HandlerInstantiationException("Failed to initialize EJB Handler: " + eJBHandlerConfigImpl.getName());
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Defer initialization until module starts: " + eJBHandlerConfigImpl.getName());
        }
        applicationEventManager.addListener(this, eJBHandlerConfigImpl.getApplicationName(), eJBHandlerConfigImpl.getModuleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Object initialize() {
        String string = "initialize()";
        Object object = null;
        String string2 = this.config.getApplicationName();
        String string3 = this.config.getModuleName();
        String string4 = this.config.getEJBName();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        String string5 = string2 + ":" + string3 + ":" + string4;
        try {
            Object object2 = null;
            Object object3 = null;
            Object object4 = null;
            Object object5 = null;
            InitialContext initialContext = new InitialContext();
            object2 = initialContext.lookup("services:websphere/EJBContainer");
            object3 = getNameFactoryMethod.invoke(object2, null);
            object4 = createJ2EENameMethod.invoke(object3, string2, string3, string4);
            object5 = getEJBLocalHomeMethod.invoke(object2, object4);
            Method method2 = object5.getClass().getMethod("create", null);
            object = method2.invoke(object5, null);
            if (object != null) {
                this.status = 0;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initialized EJB Handler: " + string5);
                }
            } else {
                this.status = 2;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initialized failed for EJB Handler: " + string5);
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.handlerfw.impl.EJBHandlerImpl.initialize", "215", this);
            this.status = 2;
            object = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error Initializing EJB Handler: " + string5 + ",exception:" + exception);
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string);
            }
        }
        return object;
    }

    public HandlerConfig getConfig() {
        return this.config;
    }

    public boolean isInitialized() {
        return this.status == 0;
    }

    public boolean requiresSynchronization() {
        return false;
    }

    public Object getInvokeTarget() {
        return this.invokeTarget;
    }

    public synchronized int getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(HandlerEventListener handlerEventListener) {
        String string = "addListener()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        if (null == handlerEventListener) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot add Null Listener");
            }
        } else {
            List list = this.eventListenerList;
            synchronized (list) {
                this.eventListenerList.add(handlerEventListener);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(HandlerEventListener handlerEventListener) {
        String string = "removeListener()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        if (null == handlerEventListener) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot remove Null Listener");
            }
        } else {
            List list = this.eventListenerList;
            synchronized (list) {
                this.eventListenerList.remove(handlerEventListener);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(int n, int n2) {
        String string = "notifyListners()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        List list = this.eventListenerList;
        synchronized (list) {
            for (int i = 0; i < this.eventListenerList.size(); ++i) {
                HandlerEventListener handlerEventListener = (HandlerEventListener)this.eventListenerList.get(i);
                handlerEventListener.stateChanged(this.config, n, n2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String string, String string2) {
        String string3 = "start()";
        int n = this.status;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string3);
        }
        try {
            Tr.info(tc, "HANDLER_START_EVENT", new Object[]{this.config.getName(), this.config.getApplicationName(), this.config.getModuleName()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Handler: " + this.config.getName() + ", AppName=" + string + ", moduleName=" + string2 + ", status=" + this.status);
            }
            if (this.status == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Handler already initialized: " + this.config.getName());
                }
            } else {
                this.status = 1;
                this.invokeTarget = this.initialize();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Handler status(after init):" + this.status);
                }
            }
            if (n != this.status) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Notifying status change: old status=" + n + ", new status=" + this.status);
                }
                this.notifyListeners(n, this.status);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.handlerfw.impl.EJBHandlerImpl.start", "365", this);
            Tr.error(tc, "HANDLER_INIT_FAILURE", new Object[]{this, string, string2});
            this.status = 2;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(String string, String string2) {
        String string3 = "stop()";
        int n = this.status;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string3);
        }
        EJBHandlerImpl eJBHandlerImpl = this;
        synchronized (eJBHandlerImpl) {
            this.status = 1;
            this.invokeTarget = null;
        }
        if (n != 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Notifying HandlerLists of State change: " + this.status);
            }
            this.notifyListeners(n, this.status);
        }
        Tr.info(tc, "HANDLER_STOP_EVENT", new Object[]{this.config.getName(), this.config.getApplicationName(), this.config.getModuleName()});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string3);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" **** EJBHandlerImpl **** \n\n");
        stringBuffer.append("Static variables --> \n");
        stringBuffer.append("\t j2EENameClass=" + j2EENameClass + "\n");
        stringBuffer.append("\t j2EENameFactoryClass=" + j2EENameFactoryClass + "\n");
        stringBuffer.append("\t createJ2EENameMethod=" + createJ2EENameMethod + "\n");
        stringBuffer.append("\t bContainerClass=" + ejbContainerClass + "\n");
        stringBuffer.append("\t getNameFactoryMethod=" + getNameFactoryMethod + "\n");
        stringBuffer.append("\t getEJBLocalHomeMethod=" + getEJBLocalHomeMethod + "\n\n");
        stringBuffer.append("Non-static member variables --> \n");
        stringBuffer.append("\t ejbClassesLoaded=" + ejbClassesLoaded + "\n");
        stringBuffer.append("\t config=" + this.config + "\n");
        stringBuffer.append("\t invokeTarget=" + this.invokeTarget + "\n");
        stringBuffer.append("\t initStatus=" + this.status + "\n\n");
        stringBuffer.append("**** EJBHandlerImpl **** \n");
        return stringBuffer.toString();
    }

    static {
        ejbClassesLoaded = false;
        try {
            j2EENameClass = Class.forName("com.ibm.websphere.csi.J2EEName");
            j2EENameFactoryClass = Class.forName("com.ibm.websphere.csi.J2EENameFactory");
            createJ2EENameMethod = j2EENameFactoryClass.getMethod("create", String.class, String.class, String.class);
            ejbContainerClass = Class.forName("com.ibm.ws.runtime.service.EJBContainer");
            getNameFactoryMethod = ejbContainerClass.getMethod("getJ2EENameFactory", null);
            getEJBLocalHomeMethod = ejbContainerClass.getMethod("getEJBLocalHome", j2EENameClass);
            ejbClassesLoaded = true;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.handlerfw.impl.EJBHandlerImpl(static initializer)", "98");
            Tr.error(tc, "EJB_ENV_LOAD_FAILURE", exception);
            ejbClassesLoaded = false;
        }
    }
}

