/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.handlerfw.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.CommonarchivePackage;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.util.ArchiveInit;
import com.ibm.websphere.models.descriptor.handler.EJBHandlerDD;
import com.ibm.websphere.models.descriptor.handler.HandlerDD;
import com.ibm.websphere.models.descriptor.handler.HandlerFactory;
import com.ibm.websphere.models.descriptor.handler.HandlerListDD;
import com.ibm.websphere.models.descriptor.handler.HandlerListRef;
import com.ibm.websphere.models.descriptor.handler.JavaHandlerDD;
import com.ibm.websphere.models.descriptor.handler.impl.HandlerPackageImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.handlerfw.impl.GenericUtils;
import com.ibm.ws.handlerfw.impl.HandlerConfigFactoryImpl;
import com.ibm.ws.handlerfw.impl.HandlerListConfigFactoryImpl;
import com.ibm.wsspi.handlerfw.EJBHandlerConfig;
import com.ibm.wsspi.handlerfw.HandlerConfig;
import com.ibm.wsspi.handlerfw.HandlerListConfig;
import com.ibm.wsspi.handlerfw.JavabeanHandlerConfig;
import com.ibm.wsspi.handlerfw.JavabeanParam;
import com.ibm.wsspi.handlerfw.exception.HFConfigException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.TypeKind;
import org.eclipse.jst.j2ee.common.EnvEntryType;
import org.eclipse.jst.j2ee.common.internal.impl.EnvEntryImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.J2EEInit;

public class HandlerConfigXMIUtils {
    private static final TraceComponent tc;

    public static void serializeHandlerListConfig(HandlerListConfig[] handlerListConfigArray, String string) throws HFConfigException {
        String string2 = "serializeHandlerListConfig";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2);
        }
        if (handlerListConfigArray == null) {
            throw new HFConfigException(" Null HandlerListConfig array");
        }
        try {
            URI uRI = URI.createFileURI((String)new File(string).getAbsolutePath());
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "xmifileAbsolutePath " + string);
            }
            ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
            Resource resource = resourceSetImpl.createResource(uRI);
            HandlerListConfig handlerListConfig = null;
            HandlerListDD handlerListDD = null;
            for (int i = 0; i < handlerListConfigArray.length; ++i) {
                if (null == handlerListConfigArray[i]) {
                    throw new HFConfigException("Null HandlerListConfig parameter at index:" + i);
                }
                handlerListConfig = handlerListConfigArray[i];
                handlerListDD = HandlerFactory.eINSTANCE.createHandlerListDD();
                if (handlerListConfig.getName() == null) {
                    throw new HFConfigException("Null name found in HandlerListConfig at index: " + i);
                }
                handlerListDD.setName(handlerListConfig.getName());
                if (handlerListConfig.getTraversalClass() != null) {
                    handlerListDD.setTraversalClass(HandlerConfigXMIUtils.createJavaClass(handlerListConfig.getTraversalClass(), TypeKind.CLASS_LITERAL));
                }
                handlerListDD.getSupportedInterfaces().addAll(HandlerConfigXMIUtils.createJavaClassList(handlerListConfig.getInvokeInterfaces(), TypeKind.INTERFACE_LITERAL));
                resource.getContents().add((Object)handlerListDD);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Added to the resource " + handlerListDD);
            }
            resource.save(null);
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.handlerfw.impl.HandlerConfigXMIUtils.serializeHandlerListConfig", "206");
            throw new HFConfigException(" Error while serializing HandlerLists  Exception message follows: " + iOException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.handlerfw.impl.HandlerConfigXMIUtils.serializeHandlerListConfig", "216");
            throw new HFConfigException(" Exception while serializing HandlerLists: " + exception.getMessage());
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string2);
            }
        }
    }

    public static void serializeJavaBeanHandlerConfig(JavabeanHandlerConfig[] javabeanHandlerConfigArray, String string) throws HFConfigException {
        String string2 = "serializeJavaBeanHandlerConfig";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2);
        }
        if (javabeanHandlerConfigArray == null) {
            throw new HFConfigException("parameter handlerCfgArr is null");
        }
        if (null == string) {
            throw new HFConfigException("parameter xmifileAbsolutePath is null");
        }
        try {
            URI uRI = URI.createFileURI((String)new File(string).getAbsolutePath());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "XMI file path: " + string);
            }
            ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
            Resource resource = resourceSetImpl.createResource(uRI);
            JavaHandlerDD javaHandlerDD = null;
            for (int i = 0; i < javabeanHandlerConfigArray.length; ++i) {
                if (null != javabeanHandlerConfigArray[i]) {
                    javaHandlerDD = HandlerFactory.eINSTANCE.createJavaHandlerDD();
                    HandlerConfigXMIUtils.initHandlerDD(javabeanHandlerConfigArray[i], (HandlerDD)javaHandlerDD);
                    HandlerConfigXMIUtils.initJavaHandlerDD(javabeanHandlerConfigArray[i], javaHandlerDD);
                    resource.getContents().add((Object)javaHandlerDD);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Added to the resource " + javaHandlerDD);
                    continue;
                }
                throw new HFConfigException("Handler config object is null");
            }
            resource.save(null);
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.handlerfw.impl.HandlerConfigXMIUtils.serializeJavaBeanHandlerConfig", "298");
            throw new HFConfigException(" IOException while serializing Javabean Handlers  Exception message follows: " + iOException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.handlerfw.impl.HandlerConfigXMIUtils.serializeJavaBeanHandlerConfig", "308");
            throw new HFConfigException(" Exception while serializing Javabean Handlers: " + exception.getMessage());
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string2);
            }
        }
    }

    public static void serializeEJBHandlerConfig(EJBHandlerConfig[] eJBHandlerConfigArray, String string, String string2) throws HFConfigException {
        String string3 = "serializeEJBHandlerConfig";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string3);
        }
        if (null == eJBHandlerConfigArray) {
            throw new HFConfigException("Parameter ejbHandlerConfigArr is null");
        }
        if (null == string) {
            throw new HFConfigException("Parameter ejbModuleRootAbsPath is null");
        }
        try {
            String string4 = string + "META-INF/ejb-jar.xml";
            URI uRI = URI.createFileURI((String)string2);
            ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
            Resource resource = resourceSetImpl.createResource(uRI);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ejbModuleRootAbsPath " + string);
                Tr.debug(tc, "XMI file path " + string2);
                Tr.debug(tc, "ejbPath " + string4);
            }
            CommonarchiveFactory commonarchiveFactory = (CommonarchiveFactory)CommonarchivePackage.eINSTANCE.getEFactoryInstance();
            ArchiveOptions archiveOptions = new ArchiveOptions();
            archiveOptions.setIsReadOnly(true);
            archiveOptions.setUseJavaReflection(false);
            EJBJarFile eJBJarFile = commonarchiveFactory.openEJBJarFile(archiveOptions, string);
            EJBJar eJBJar = eJBJarFile.getDeploymentDescriptor();
            String string5 = null;
            EnterpriseBean enterpriseBean = null;
            EJBHandlerDD eJBHandlerDD = null;
            for (int i = 0; i < eJBHandlerConfigArray.length; ++i) {
                if (null == eJBHandlerConfigArray[i] || null == eJBHandlerConfigArray[i].getEJBName()) {
                    throw new HFConfigException("No EJB name provided for the EJBHandlerConfig " + eJBHandlerConfigArray[i].getName());
                }
                string5 = eJBHandlerConfigArray[i].getEJBName();
                enterpriseBean = eJBJar.getEnterpriseBeanNamed(string5);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Retrieved EnterpriseBean " + enterpriseBean);
                }
                eJBHandlerDD = HandlerFactory.eINSTANCE.createEJBHandlerDD();
                HandlerConfigXMIUtils.initHandlerDD(eJBHandlerConfigArray[i], (HandlerDD)eJBHandlerDD);
                HandlerConfigXMIUtils.initEJBHandlerDD(eJBHandlerDD, enterpriseBean);
                resource.getContents().add((Object)eJBHandlerDD);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Added the resource " + eJBHandlerDD);
            }
            resource.save(null);
        }
        catch (OpenFailureException openFailureException) {
            FFDCFilter.processException(openFailureException, "com.ibm.ws.handlerfw.impl.HandlerConfigXMIUtils.serializeEJBHandlerConfig", "415");
            throw new HFConfigException(" OpenFailureException while serializing Javabean Handlers. Unable to open the EJB Module specified by " + string + " Exception message follows: " + openFailureException.getMessage());
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.handlerfw.impl.HandlerConfigXMIUtils.serializeEJBHandlerConfig", "426");
            throw new HFConfigException(" IOException  while serializing EJB Handlers  Exception message follows: " + iOException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.handlerfw.impl.HandlerConfigXMIUtils.serializeEJBHandlerConfig", "436");
            throw new HFConfigException("Exception  while serializing EJB Handlers: " + exception.getMessage());
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string3);
            }
        }
    }

    private static void initHandlerDD(HandlerConfig handlerConfig, HandlerDD handlerDD) throws HFConfigException {
        String string = "initHandlerDD(HandlerConfig, HandlerDD)";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        if (null == handlerConfig) {
            throw new HFConfigException("Handler Config is null");
        }
        if (handlerConfig.getName() == null) {
            throw new HFConfigException("Handler Config name is null");
        }
        handlerDD.setName(handlerConfig.getName());
        HandlerListRef handlerListRef = null;
        if (handlerConfig.getHandlerListRefs() != null) {
            com.ibm.wsspi.handlerfw.HandlerListRef[] handlerListRefArray = handlerConfig.getHandlerListRefs();
            for (int i = 0; i < handlerListRefArray.length; ++i) {
                handlerListRef = HandlerFactory.eINSTANCE.createHandlerListRef();
                handlerListRef.setListName(handlerListRefArray[i].getHandlerListName());
                handlerListRef.setSequence(handlerListRefArray[i].getPriority());
                handlerDD.getLists().add((Object)handlerListRef);
            }
        }
        if (handlerConfig.isCritical()) {
            handlerDD.setCritical(true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private static void initJavaHandlerDD(JavabeanHandlerConfig javabeanHandlerConfig, JavaHandlerDD javaHandlerDD) throws HFConfigException {
        String string = "initJavaHandlerDD(JavabeanHandlerConfig, JavaHandlerDD)";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        if (javabeanHandlerConfig.getHandlerClass() == null) {
            throw new HFConfigException("Javabean Handler class is null");
        }
        javaHandlerDD.setHandlerClass(HandlerConfigXMIUtils.createJavaClass(javabeanHandlerConfig.getHandlerClass(), TypeKind.CLASS_LITERAL));
        if (javabeanHandlerConfig.requiresSynchronization()) {
            javaHandlerDD.setSynchronizationRequired(true);
        }
        int n = -1;
        String string2 = null;
        EnvEntryImpl envEntryImpl = null;
        String string3 = null;
        Class clazz = null;
        Object object = null;
        JavabeanParam[] javabeanParamArray = javabeanHandlerConfig.getBeanParms();
        if (null != javabeanParamArray) {
            for (int i = 0; i < javabeanParamArray.length; ++i) {
                JavabeanParam javabeanParam = javabeanParamArray[i];
                string3 = javabeanParam.getName();
                clazz = javabeanParam.getType();
                object = javabeanParam.getValue();
                if (null == string3 || null == clazz || null == object) {
                    throw new HFConfigException("Invalid JavabeanParam: " + javabeanParam);
                }
                envEntryImpl = new EnvEntryImpl();
                envEntryImpl.setName(string3);
                string2 = GenericUtils.getWrapper(clazz).getName();
                n = string2.lastIndexOf(46);
                envEntryImpl.setType(EnvEntryType.get((String)string2.substring(n + 1)));
                envEntryImpl.setValue(object.toString());
                javaHandlerDD.getParameters().add((Object)envEntryImpl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private static void initEJBHandlerDD(EJBHandlerDD eJBHandlerDD, EnterpriseBean enterpriseBean) throws HFConfigException {
        String string = "initEJBHandlerDD(ejbHandlerDD,EnterpriseBean)";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        if (null == enterpriseBean) {
            throw new HFConfigException("Argument EnterpriseBean " + enterpriseBean + " passed in to initEJBHandlerDD is null");
        }
        eJBHandlerDD.setEjb(enterpriseBean);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private static JavaClass createJavaClass(String string, TypeKind typeKind) {
        JavaClass javaClass = JavaRefFactory.eINSTANCE.createJavaClass();
        javaClass.setName(string);
        javaClass.setFinal(false);
        javaClass.setKind(typeKind);
        javaClass.setPublic(true);
        return javaClass;
    }

    private static Collection createJavaClassList(String[] stringArray, TypeKind typeKind) {
        LinkedList<JavaClass> linkedList = new LinkedList<JavaClass>();
        if (null != stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                linkedList.add(HandlerConfigXMIUtils.createJavaClass(stringArray[i], typeKind));
            }
        }
        return linkedList;
    }

    public static HandlerConfig[] deserializeHandlerConfig(String string) throws HFConfigException {
        HandlerConfig[] handlerConfigArray;
        String string2 = "deserializeHandlerConfig(String)";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2);
        }
        if (null == string) {
            throw new HFConfigException("Parameter archiveRootPath is null");
        }
        Resource resource = null;
        Archive archive = null;
        URI uRI = URI.createFileURI((String)new File(string).getAbsolutePath());
        try {
            handlerConfigArray = (HandlerConfig[])CommonarchivePackage.eINSTANCE.getEFactoryInstance();
            ArchiveOptions archiveOptions = new ArchiveOptions();
            archiveOptions.setIsReadOnly(true);
            archiveOptions.setUseJavaReflection(false);
            archive = handlerConfigArray.openArchive(archiveOptions, string);
            resource = archive.getMofResource("META-INF/ws-handler.xmi");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " Read ws-handler.xmi DD from archive " + archive.getName());
            }
        }
        catch (OpenFailureException openFailureException) {
            FFDCFilter.processException(openFailureException, "com.ibm.ws.handlerfw.impl.HandlerConfigXMIUtils.deserializeHandlerConfig", "727");
            throw new HFConfigException("Error opening archive: " + openFailureException.toString(), openFailureException);
        }
        catch (ResourceLoadException resourceLoadException) {
            FFDCFilter.processException(resourceLoadException, "com.ibm.ws.handlerfw.impl.HandlerConfigXMIUtils.deserializeHandlerConfig", "735");
            throw new HFConfigException("Error loading resource: " + resourceLoadException.toString(), resourceLoadException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException(fileNotFoundException, "com.ibm.ws.handlerfw.impl.HandlerConfigXMIUtils.deserializeHandlerConfig", "744");
            throw new HFConfigException("Handler Descriptor not found: " + fileNotFoundException.toString(), fileNotFoundException);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.handlerfw.impl.HandlerConfigXMIUtils.deserializeHandlerConfig", "753");
            throw new HFConfigException("Exception parsing Handler Descriptor: " + exception.toString(), exception);
        }
        handlerConfigArray = HandlerConfigXMIUtils.createAndInitializeHandlerConfigs(uRI, resource);
        archive.close();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2);
        }
        return handlerConfigArray;
    }

    public static HandlerListConfig[] deserializeHandlerListConfig(String string) throws HFConfigException {
        HandlerListConfig[] handlerListConfigArray;
        String string2 = "deserializeHandlerListConfig(String)";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2);
        }
        if (null == string) {
            throw new HFConfigException("Parameter xmifileURI is null");
        }
        Resource resource = null;
        Archive archive = null;
        URI uRI = URI.createFileURI((String)new File(string).getAbsolutePath());
        try {
            handlerListConfigArray = (HandlerListConfig[])CommonarchivePackage.eINSTANCE.getEFactoryInstance();
            ArchiveOptions archiveOptions = new ArchiveOptions();
            archiveOptions.setIsReadOnly(true);
            archiveOptions.setUseJavaReflection(false);
            archive = handlerListConfigArray.openArchive(archiveOptions, string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Parsing HandlerList deployment descriptor from archive: " + archive.getName());
            }
            resource = archive.getMofResource("META-INF/ws-handlerlist.xmi");
        }
        catch (OpenFailureException openFailureException) {
            FFDCFilter.processException(openFailureException, "com.ibm.ws.handlerfw.impl.HandlerConfigXMIUtils.deserializeHandlerListConfig", "822");
            throw new HFConfigException("Exception while opening the archive: " + openFailureException.getMessage());
        }
        catch (ResourceLoadException resourceLoadException) {
            FFDCFilter.processException(resourceLoadException, "com.ibm.ws.handlerfw.impl.HandlerConfigXMIUtils.deserializeHandlerListConfig", "830");
            throw new HFConfigException("ResourceLoad Exception while loading ws-handlerlist.xmi: " + resourceLoadException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException(fileNotFoundException, "com.ibm.ws.handlerfw.impl.HandlerConfigXMIUtils.deserializeHandlerListConfig", "839");
            throw new HFConfigException("Exception while locating the ws-handlerlist.xmi: " + fileNotFoundException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.handlerfw.impl.HandlerConfigXMIUtils.deserializeHandlerListConfig", "849");
            throw new HFConfigException("Exception while loading the ws-handlerlist.xmi: " + exception.getMessage());
        }
        handlerListConfigArray = HandlerConfigXMIUtils.createAndInitializeHandlerListConfigs(uRI, resource);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2);
        }
        return handlerListConfigArray;
    }

    private static HandlerConfig[] createAndInitializeHandlerConfigs(URI uRI, Resource resource) throws HFConfigException {
        List list = new LinkedList();
        if (null == resource) {
            throw new HFConfigException("Could not load Handler URI: " + uRI + ". configResource " + resource);
        }
        list = HandlerConfigXMIUtils.initConfigObjects(resource.getContents(), HandlerConfig.class);
        HandlerConfig[] handlerConfigArray = new HandlerConfig[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            handlerConfigArray[i] = (HandlerConfig)list.get(i);
        }
        return handlerConfigArray;
    }

    private static HandlerListConfig[] createAndInitializeHandlerListConfigs(URI uRI, Resource resource) throws HFConfigException {
        List list = new LinkedList();
        if (null == resource) {
            throw new HFConfigException("Could not load HandlerList URI: " + uRI);
        }
        list = HandlerConfigXMIUtils.initConfigObjects(resource.getContents(), HandlerListConfig.class);
        HandlerListConfig[] handlerListConfigArray = new HandlerListConfig[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            handlerListConfigArray[i] = (HandlerListConfig)list.get(i);
        }
        return handlerListConfigArray;
    }

    private static List initConfigObjects(EList eList, Class clazz) throws HFConfigException {
        Object object;
        String string = "initConfigObjects(EList,Class)";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        Iterator iterator = eList.iterator();
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<HandlerListConfig> arrayList = new ArrayList<HandlerListConfig>();
        ArrayList<HandlerConfig> arrayList2 = new ArrayList<HandlerConfig>();
        while (iterator.hasNext()) {
            object = (EObject)iterator.next();
            if (object instanceof HandlerListDD) {
                bl = true;
                arrayList.add(HandlerConfigXMIUtils.initHandlerListConfig((HandlerListDD)object));
            } else if (object instanceof JavaHandlerDD) {
                bl2 = true;
                arrayList2.add(HandlerConfigXMIUtils.initJavaHandlerConfig((JavaHandlerDD)object));
            } else if (object instanceof EJBHandlerDD) {
                bl2 = true;
                arrayList2.add(HandlerConfigXMIUtils.initEJBHandlerConfig((EJBHandlerDD)object));
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "read: " + object);
        }
        if (bl2 && bl) {
            throw new HFConfigException("The Deployment Descriptor contains both Handler and HandlerList objects");
        }
        object = null;
        String string2 = clazz.getName();
        if (string2.equals(HandlerListConfig.class.getName())) {
            object = arrayList;
        } else if (string2.equals(HandlerConfig.class.getName())) {
            object = arrayList2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
        return object;
    }

    private static HandlerListConfig initHandlerListConfig(HandlerListDD handlerListDD) throws HFConfigException {
        HandlerListConfig handlerListConfig;
        String string = "initHandlerConfig(HandlerListDD)";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        try {
            int n = 0;
            EList eList = handlerListDD.getSupportedInterfaces();
            String[] stringArray = new String[eList.size()];
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                stringArray[n++] = ((JavaClass)iterator.next()).getName();
            }
            handlerListConfig = new HandlerListConfigFactoryImpl().create(handlerListDD.getName(), handlerListDD.getTraversalClass().getName(), stringArray, null);
        }
        catch (HFConfigException hFConfigException) {
            throw hFConfigException;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.handlerfw.impl.HandlerConfigXMIUtils.initHandlerListConfig", "1079");
            throw new HFConfigException("Could not instantiate handlerListConfig " + exception.getMessage());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "created: " + handlerListConfig);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
        return handlerListConfig;
    }

    private static JavabeanHandlerConfig initJavaHandlerConfig(JavaHandlerDD javaHandlerDD) throws HFConfigException {
        String string = "initJavaHandlerConfig(JavaHandlerDD)";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        JavabeanHandlerConfig javabeanHandlerConfig = null;
        try {
            com.ibm.wsspi.handlerfw.HandlerListRef[] handlerListRefArray;
            EList eList = javaHandlerDD.getParameters();
            JavabeanParam[] javabeanParamArray = new JavabeanParam[eList.size()];
            for (int i = 0; i < eList.size(); ++i) {
                handlerListRefArray = (com.ibm.wsspi.handlerfw.HandlerListRef[])eList.get(i);
                javabeanParamArray[i] = new JavabeanParam(handlerListRefArray.getName(), Class.forName("java.lang.".concat(handlerListRefArray.getType().toString())), handlerListRefArray.getValue());
            }
            EList eList2 = javaHandlerDD.getLists();
            handlerListRefArray = new com.ibm.wsspi.handlerfw.HandlerListRef[eList2.size()];
            for (int i = 0; i < eList2.size(); ++i) {
                handlerListRefArray[i] = new HandlerListConfigFactoryImpl().createHandlerListRef(((HandlerListRef)eList2.get(i)).getListName(), ((HandlerListRef)eList2.get(i)).getSequence());
            }
            javabeanHandlerConfig = new HandlerConfigFactoryImpl().createJavabeanHandlerConfig(javaHandlerDD.getName(), javaHandlerDD.isCritical(), javaHandlerDD.isSynchronizationRequired(), javaHandlerDD.getHandlerClass().getName(), null, null, javabeanParamArray, handlerListRefArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException(classNotFoundException, "com.ibm.ws.handlerfw.impl.HandlerConfigXMIUtils.initJavaHandlerConfig", "1156");
            throw new HFConfigException("exception initializing java bean prameters");
        }
        catch (HFConfigException hFConfigException) {
            throw hFConfigException;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.handlerfw.impl.HandlerConfigXMIUtils.initJavaHandlerConfig", "1169");
            throw new HFConfigException("Could not instantiate the JavabeanHandlerConfig " + exception.getMessage());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "created " + javabeanHandlerConfig);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
        return javabeanHandlerConfig;
    }

    private static EJBHandlerConfig initEJBHandlerConfig(EJBHandlerDD eJBHandlerDD) throws HFConfigException {
        EJBHandlerConfig eJBHandlerConfig;
        String string = "initEJBHandlerConfig(EJBHandlerDD)";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        try {
            EList eList = eJBHandlerDD.getLists();
            com.ibm.wsspi.handlerfw.HandlerListRef[] handlerListRefArray = new com.ibm.wsspi.handlerfw.HandlerListRef[eList.size()];
            for (int i = 0; i < eList.size(); ++i) {
                handlerListRefArray[i] = new HandlerListConfigFactoryImpl().createHandlerListRef(((HandlerListRef)eList.get(i)).getListName(), ((HandlerListRef)eList.get(i)).getSequence());
            }
            eJBHandlerConfig = new HandlerConfigFactoryImpl().createEJBHandlerConfig(eJBHandlerDD.getName(), eJBHandlerDD.isCritical(), null, null, eJBHandlerDD.getEjb().getName(), handlerListRefArray);
        }
        catch (HFConfigException hFConfigException) {
            throw hFConfigException;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.handlerfw.impl.HandlerConfigXMIUtils.initEJBHandlerConfig", "1238");
            throw new HFConfigException("Could not instantiate the EJBHandlerConfig " + exception.getMessage());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "created " + eJBHandlerConfig);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
        return eJBHandlerConfig;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HandlerConfigXMIUtils\n");
        stringBuffer.append("HandlerFactory=" + HandlerFactory.eINSTANCE + "\n");
        stringBuffer.append("CommonarchiveFactory=" + CommonarchivePackage.eINSTANCE.getCommonarchiveFactory());
        return stringBuffer.toString();
    }

    static {
        try {
            HandlerPackageImpl.init();
            ArchiveInit.init();
            J2EEInit.init();
            if (Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().get("*") == null) {
                Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.handlerfw.impl.HandlerConfigXMIUtils(static initializer)", "101");
        }
        tc = Tr.register(HandlerConfigXMIUtils.class, "HandlerFramework", "com.ibm.ws.handlerfw.resources.handlerframework");
    }
}

