/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.handlerfw.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.handlerfw.impl.ApplicationEventManager;
import com.ibm.ws.handlerfw.impl.ApplicationJavabeanHandlerImpl;
import com.ibm.ws.handlerfw.impl.DefaultHandlerListTraversal;
import com.ibm.ws.handlerfw.impl.EJBHandlerConfigImpl;
import com.ibm.ws.handlerfw.impl.EJBHandlerImpl;
import com.ibm.ws.handlerfw.impl.HandlerConfigFactoryImpl;
import com.ibm.ws.handlerfw.impl.HandlerConfigImpl;
import com.ibm.ws.handlerfw.impl.HandlerFrameworkFFDC;
import com.ibm.ws.handlerfw.impl.HandlerListConfigFactoryImpl;
import com.ibm.ws.handlerfw.impl.HandlerListConfigImpl;
import com.ibm.ws.handlerfw.impl.HandlerListImpl;
import com.ibm.ws.handlerfw.impl.JavabeanHandlerConfigImpl;
import com.ibm.ws.handlerfw.impl.SystemJavabeanHandlerImpl;
import com.ibm.wsspi.handlerfw.HandlerConfig;
import com.ibm.wsspi.handlerfw.HandlerConfigFactory;
import com.ibm.wsspi.handlerfw.HandlerFramework;
import com.ibm.wsspi.handlerfw.HandlerList;
import com.ibm.wsspi.handlerfw.HandlerListConfig;
import com.ibm.wsspi.handlerfw.HandlerListConfigFactory;
import com.ibm.wsspi.handlerfw.HandlerListRef;
import com.ibm.wsspi.handlerfw.HandlerListTraversal;
import com.ibm.wsspi.handlerfw.HandlerRef;
import com.ibm.wsspi.handlerfw.WsHandler;
import com.ibm.wsspi.handlerfw.exception.HFConfigException;
import com.ibm.wsspi.handlerfw.exception.HFRuntimeException;
import com.ibm.wsspi.handlerfw.exception.HandlerExistsException;
import com.ibm.wsspi.handlerfw.exception.HandlerInstantiationException;
import com.ibm.wsspi.handlerfw.exception.HandlerListNotFoundException;
import com.ibm.wsspi.handlerfw.exception.HandlerNotFoundException;
import java.util.HashMap;

public class HandlerFrameworkImpl
implements HandlerFramework {
    private static final TraceComponent tc = Tr.register(HandlerFrameworkImpl.class, "HandlerFramework", "com.ibm.ws.handlerfw.resources.handlerframework");
    private HashMap handlerListConfigMap = null;
    private HashMap handlerConfigMap = null;
    private HashMap handlerMap = null;
    private HashMap handlerListMap = null;
    private HandlerConfigFactory handlerConfigFactoryImpl = null;
    private HandlerListConfigFactory handlerListConfigFactoryImpl = null;
    private ApplicationEventManager applicationEventManager = null;
    private HandlerListTraversal traverse = new DefaultHandlerListTraversal();
    private static HandlerFramework _singleton = new HandlerFrameworkImpl();

    public static final HandlerFramework getInstance() {
        return _singleton;
    }

    private HandlerFrameworkImpl() {
        this.resetConfig();
        this.applicationEventManager = new ApplicationEventManager(this);
        this.handlerConfigFactoryImpl = new HandlerConfigFactoryImpl();
        this.handlerListConfigFactoryImpl = new HandlerListConfigFactoryImpl();
        HandlerFrameworkFFDC.createSingleton(this);
    }

    public ApplicationEventManager getApplicationEventManager() {
        return this.applicationEventManager;
    }

    public WsHandler createHandler(HandlerConfigImpl handlerConfigImpl) throws HandlerInstantiationException {
        if (handlerConfigImpl instanceof JavabeanHandlerConfigImpl) {
            if (handlerConfigImpl.isSystemHandler()) {
                return new SystemJavabeanHandlerImpl((JavabeanHandlerConfigImpl)handlerConfigImpl);
            }
            return new ApplicationJavabeanHandlerImpl((JavabeanHandlerConfigImpl)handlerConfigImpl, this.applicationEventManager);
        }
        if (handlerConfigImpl instanceof EJBHandlerConfigImpl) {
            return new EJBHandlerImpl((EJBHandlerConfigImpl)handlerConfigImpl, this.applicationEventManager);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unknown Handler type found: " + handlerConfigImpl.toString());
        }
        throw new HandlerInstantiationException("Unknown Handler type: " + handlerConfigImpl.toString());
    }

    public void resetConfig() {
        this.handlerListConfigMap = new HashMap();
        this.handlerListMap = new HashMap();
        this.handlerConfigMap = new HashMap();
        this.handlerMap = new HashMap();
    }

    protected HandlerListTraversal getDefaultHandlerListTraversal() {
        return this.traverse;
    }

    public HandlerListConfigFactory getHandlerListConfigFactory() {
        return this.handlerListConfigFactoryImpl;
    }

    public HandlerConfigFactory getHandlerConfigFactory() {
        return this.handlerConfigFactoryImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addHandlerConfig(HandlerConfig handlerConfig) throws HFConfigException {
        String string = "addHandlerConfig()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        try {
            if (handlerConfig == null) {
                throw new HFConfigException("Null Handler Configuration object.");
            }
            if (!(handlerConfig instanceof HandlerConfigImpl)) {
                throw new HFConfigException("HandlerConfig object not HF implementation.");
            }
            String string2 = handlerConfig.getName();
            HandlerListRef[] handlerListRefArray = this.handlerConfigMap;
            synchronized (this.handlerConfigMap) {
                if (this.handlerConfigMap.containsKey(string2)) {
                    throw new HandlerExistsException("HandlerConfig exists: " + string2);
                }
                this.handlerConfigMap.put(string2, handlerConfig);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Added HandlerConfig: " + handlerConfig);
                }
                if ((handlerListRefArray = handlerConfig.getHandlerListRefs()) == null || handlerListRefArray.length <= 0) return;
                HashMap hashMap = this.handlerListConfigMap;
                synchronized (hashMap) {
                    for (int i = 0; i < handlerListRefArray.length; ++i) {
                        if (handlerListRefArray[i] == null) continue;
                        String string3 = handlerListRefArray[i].getHandlerListName();
                        HandlerRef handlerRef = this.handlerConfigFactoryImpl.createHandlerRef(handlerConfig, handlerListRefArray[i].getPriority());
                        HandlerListConfigImpl handlerListConfigImpl = (HandlerListConfigImpl)this.handlerListConfigMap.get(string3);
                        if (handlerListConfigImpl == null) {
                            handlerListConfigImpl = new HandlerListConfigImpl(string3);
                            this.handlerListConfigMap.put(string3, handlerListConfigImpl);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Created new HandlerList with default attributes");
                                Tr.debug(tc, "handlerListConfigMap" + this.handlerListConfigMap);
                            }
                        }
                        handlerListConfigImpl.addHandlerRef(handlerRef);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Added Handler :" + handlerConfig.getName() + " to list: " + string3);
                    }
                    return;
                }
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandlerConfig(String string) throws HFConfigException {
        String string2 = "removeHandlerConfig()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2);
        }
        try {
            if (null == string) {
                throw new HFConfigException("Null HandlerConfig name.");
            }
            HashMap hashMap = this.handlerConfigMap;
            synchronized (hashMap) {
                HandlerConfigImpl handlerConfigImpl = (HandlerConfigImpl)this.handlerConfigMap.remove(string);
                if (null == handlerConfigImpl) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "HandlerConfig not found: " + string);
                    }
                    throw new HandlerNotFoundException("HandlerConfig not found: " + string);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removed HandlerConfig: " + string);
                }
                HashMap hashMap2 = this.handlerMap;
                synchronized (hashMap2) {
                    WsHandler wsHandler = (WsHandler)this.handlerMap.get(string);
                    if (tc.isDebugEnabled()) {
                        if (null == wsHandler) {
                            Tr.debug(tc, "No active Handler instance found: " + string);
                        } else {
                            Tr.debug(tc, "Removed Handler instance: " + string);
                        }
                    }
                }
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addHandlerListConfig(HandlerListConfig handlerListConfig) throws HFConfigException {
        String string = "addHandlerListConfig()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        try {
            if (handlerListConfig == null) {
                throw new HFConfigException("Null HandlerListConfig object.");
            }
            if (!(handlerListConfig instanceof HandlerListConfigImpl)) {
                throw new HFConfigException("HandlerListConfig not HF implementation.");
            }
            String string2 = handlerListConfig.getName();
            HandlerListConfigImpl handlerListConfigImpl = null;
            HandlerRef[] handlerRefArray = this.handlerListConfigMap;
            synchronized (this.handlerListConfigMap) {
                handlerListConfigImpl = (HandlerListConfigImpl)this.handlerListConfigMap.get(string2);
                if (handlerListConfigImpl == null) {
                    this.handlerListConfigMap.put(string2, handlerListConfig);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Added HandlerListConfig: " + handlerListConfig);
                    }
                } else {
                    if (!handlerListConfigImpl.isDefaultList()) {
                        throw new HFConfigException("HandlerListConfig exists: " + string2);
                    }
                    if (handlerListConfigImpl.isInvoked()) {
                        throw new HFConfigException("HandlerList invoked: " + string2 + "Cannot merge config:" + handlerListConfig.toString());
                    }
                    handlerListConfigImpl.mergeConfig(handlerListConfig);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Merged with HandlerListConfig: " + handlerListConfigImpl);
                    }
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                handlerRefArray = handlerListConfig.getHandlerRefs();
                if (handlerRefArray == null || handlerRefArray.length <= 0) return;
                HashMap hashMap = this.handlerConfigMap;
                synchronized (hashMap) {
                    for (int i = 0; i < handlerRefArray.length; ++i) {
                        if (handlerRefArray[i] == null) continue;
                        HandlerConfigImpl handlerConfigImpl = (HandlerConfigImpl)handlerRefArray[i].getHandler();
                        HandlerConfigImpl handlerConfigImpl2 = (HandlerConfigImpl)this.handlerConfigMap.get(handlerConfigImpl.getName());
                        if (handlerConfigImpl2 == null) {
                            this.handlerConfigMap.put(handlerConfigImpl.getName(), handlerConfigImpl);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Added HandlerConfig: " + handlerConfigImpl);
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Handler Configuration exists (ignored): " + handlerConfigImpl2);
                    }
                    return;
                }
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandlerListConfig(String string) throws HFConfigException {
        String string2 = "removeHandlerListConfig()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2);
        }
        try {
            if (null == string) {
                throw new HFConfigException("Null HandlerListConfig name.");
            }
            HashMap hashMap = this.handlerListConfigMap;
            synchronized (hashMap) {
                HandlerListConfigImpl handlerListConfigImpl = (HandlerListConfigImpl)this.handlerListConfigMap.remove(string);
                if (null == handlerListConfigImpl) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "HandlerListConfig not found: " + string);
                    }
                    throw new HandlerListNotFoundException("HandlerListConfig not found: " + string);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removed HandlerListConfig: " + string);
                }
                HashMap hashMap2 = this.handlerListMap;
                synchronized (hashMap2) {
                    HandlerListImpl handlerListImpl = (HandlerListImpl)this.handlerListMap.remove(string);
                    if (tc.isDebugEnabled()) {
                        if (null != handlerListImpl) {
                            Tr.debug(tc, "Removed HandlerList: " + string);
                        } else {
                            Tr.debug(tc, "No active HandlerList instances found: " + string);
                        }
                    }
                }
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlerList getHandlerList(String string) throws HFConfigException, HFRuntimeException {
        String string2 = "getHandlerList()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2);
        }
        HandlerListImpl handlerListImpl = null;
        boolean bl = false;
        try {
            if (string == null) {
                throw new IllegalArgumentException("Null HandlerList name.");
            }
            Object object = this.handlerListMap;
            synchronized (object) {
                handlerListImpl = (HandlerListImpl)this.handlerListMap.get(string);
                if (handlerListImpl == null) {
                    HandlerListConfig handlerListConfig = null;
                    HashMap hashMap = this.handlerListConfigMap;
                    synchronized (hashMap) {
                        handlerListConfig = (HandlerListConfig)this.handlerListConfigMap.get(string);
                    }
                    if (handlerListConfig == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "HandlerListConfig not found: " + string);
                        }
                        throw new HandlerListNotFoundException("HandlerListConfig not found: " + string);
                    }
                    handlerListImpl = new HandlerListImpl(this, handlerListConfig);
                    this.handlerListMap.put(string, handlerListImpl);
                    bl = true;
                }
            }
            if (tc.isDebugEnabled()) {
                if (bl) {
                    Tr.debug(tc, "Created HandlerList: " + string);
                } else {
                    Tr.debug(tc, "Found HandlerList: " + string);
                }
            }
            object = handlerListImpl;
            return object;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean listExists(String string) {
        String string2 = "listExists()";
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2);
        }
        if (string == null) {
            bl = false;
        } else {
            HashMap hashMap = this.handlerListConfigMap;
            synchronized (hashMap) {
                bl = this.handlerListConfigMap.get(string) != null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WsHandler getHandler(String string) throws IllegalArgumentException, HandlerNotFoundException, HandlerInstantiationException {
        String string2 = "getHandler()";
        WsHandler wsHandler = null;
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2);
        }
        try {
            if (string == null) {
                throw new IllegalArgumentException("Null handler name");
            }
            Object object = this.handlerMap;
            synchronized (object) {
                wsHandler = (WsHandler)this.handlerMap.get(string);
                if (wsHandler == null) {
                    HandlerConfigImpl handlerConfigImpl;
                    HashMap hashMap = this.handlerConfigMap;
                    synchronized (hashMap) {
                        handlerConfigImpl = (HandlerConfigImpl)this.handlerConfigMap.get(string);
                    }
                    if (handlerConfigImpl == null) {
                        throw new HandlerNotFoundException("Handler not found: " + string);
                    }
                    wsHandler = this.createHandler(handlerConfigImpl);
                    this.handlerMap.put(string, wsHandler);
                    bl = true;
                }
            }
            if (tc.isDebugEnabled()) {
                if (bl) {
                    Tr.debug(tc, "Created Handler: " + string);
                } else {
                    Tr.debug(tc, "Found Handler: " + string);
                }
            }
            object = wsHandler;
            return object;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlerConfig getHandlerConfig(String string) {
        HashMap hashMap = this.handlerConfigMap;
        synchronized (hashMap) {
            return (HandlerConfig)this.handlerConfigMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlerConfig[] getAllHandlerConfigs() {
        HandlerConfig[] handlerConfigArray = new HandlerConfig[]{};
        HashMap hashMap = this.handlerConfigMap;
        synchronized (hashMap) {
            int n = this.handlerConfigMap.size();
            if (n > 0) {
                handlerConfigArray = new HandlerConfig[n];
                Object[] objectArray = this.handlerConfigMap.values().toArray();
                for (int i = 0; i < n; ++i) {
                    handlerConfigArray[i] = (HandlerConfig)objectArray[i];
                }
            }
        }
        return handlerConfigArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlerListConfig getHandlerListConfig(String string) {
        HashMap hashMap = this.handlerListConfigMap;
        synchronized (hashMap) {
            return (HandlerListConfig)this.handlerListConfigMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlerListConfig[] getAllHandlerListConfigs() {
        HandlerListConfig[] handlerListConfigArray = new HandlerListConfig[]{};
        HashMap hashMap = this.handlerListConfigMap;
        synchronized (hashMap) {
            int n = this.handlerListConfigMap.size();
            if (n > 0) {
                handlerListConfigArray = new HandlerListConfig[n];
                Object[] objectArray = this.handlerListConfigMap.values().toArray();
                for (int i = 0; i < n; ++i) {
                    handlerListConfigArray[i] = (HandlerListConfig)objectArray[i];
                }
            }
        }
        return handlerListConfigArray;
    }

    public HashMap getHandlerConfigMap() {
        return this.handlerConfigMap;
    }

    public HashMap getHandlerListConfigMap() {
        return this.handlerListConfigMap;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("*********  ---- " + super.toString() + " -----  *********\n");
        stringBuffer.append("handlerListConfigMap \n");
        stringBuffer.append(this.handlerListConfigMap + "\n");
        stringBuffer.append("handlerListMap \n");
        stringBuffer.append(this.handlerListMap + "\n");
        stringBuffer.append("handlerConfigMap \n");
        stringBuffer.append(this.handlerConfigMap + "\n");
        stringBuffer.append("handlerMap \n");
        stringBuffer.append(this.handlerMap + "\n");
        stringBuffer.append(this.applicationEventManager + "\n");
        stringBuffer.append("HandlerListTraversal  \n");
        stringBuffer.append(this.traverse + "\n");
        stringBuffer.append("********* -----  ************ ----- *********\n");
        return stringBuffer.toString();
    }
}

