/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.handlerfw.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.naming.JndiHelper;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.handlerfw.HandlerFrameworkService;
import com.ibm.ws.handlerfw.impl.HandlerConfigImpl;
import com.ibm.ws.handlerfw.impl.HandlerConfigXMIUtils;
import com.ibm.ws.handlerfw.impl.HandlerFrameworkImpl;
import com.ibm.ws.handlerfw.impl.HandlerListConfigImpl;
import com.ibm.ws.handlerfw.impl.HandlerListRefImpl;
import com.ibm.ws.handlerfw.impl.JavabeanHandlerConfigImpl;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import com.ibm.wsspi.handlerfw.HandlerConfig;
import com.ibm.wsspi.handlerfw.HandlerConfigFactory;
import com.ibm.wsspi.handlerfw.HandlerFramework;
import com.ibm.wsspi.handlerfw.HandlerList;
import com.ibm.wsspi.handlerfw.HandlerListConfig;
import com.ibm.wsspi.handlerfw.HandlerListConfigFactory;
import com.ibm.wsspi.handlerfw.HandlerListRef;
import com.ibm.wsspi.handlerfw.JavabeanParam;
import com.ibm.wsspi.handlerfw.exception.HFConfigException;
import com.ibm.wsspi.handlerfw.exception.HFRuntimeException;
import com.ibm.wsspi.handlerfw.exception.HandlerExistsException;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;

public class HandlerFrameworkServiceImpl
extends WsComponentImpl
implements HandlerFrameworkService {
    private static final String SERVICE_NAME = "HandlerFrameworkService";
    private static final TraceComponent tc = Tr.register(HandlerFrameworkServiceImpl.class, "HandlerFramework", "com.ibm.ws.handlerfw.resources.handlerframework");
    HandlerFrameworkImpl framework = null;
    Context context = null;
    boolean inClient = false;

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        String string;
        block10: {
            String string2;
            string = "initialize()";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, string);
            }
            this.inClient = (string2 = System.getProperty("com.ibm.ws.container")) != null && string2.equalsIgnoreCase("client");
            this.framework = (HandlerFrameworkImpl)HandlerFrameworkImpl.getInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "Handler Framework instance created.");
            }
            if (!this.inClient) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Service running in server environment");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Service running in ApplicationClient environment");
            }
            try {
                WsServiceRegistry.addService((Object)this, (Class)HandlerFrameworkService.class);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.handlerfw.impl.HandlerFrameworkServiceImpl.initialize", "140", this);
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "Unable to add as a service", exception);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + "added as service.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        String string = "start()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        this.bindServiceToJNDI();
        this.loadConfig();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private void loadConfigFromExtensionRegistry() {
        IExtensionRegistry iExtensionRegistry;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadConfigFromExtensionRegistry");
        }
        if ((iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry()) != null) {
            IConfigurationElement[] iConfigurationElementArray;
            String string;
            String string2;
            int n;
            String string3 = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".handlerlist";
            IConfigurationElement[] iConfigurationElementArray2 = iExtensionRegistry.getConfigurationElementsFor(string3);
            for (n = 0; n < iConfigurationElementArray2.length; ++n) {
                string2 = iConfigurationElementArray2[n].getAttribute("name");
                string = iConfigurationElementArray2[n].getAttribute("traversalAlgorithm");
                IConfigurationElement[] iConfigurationElementArray3 = iConfigurationElementArray2[n].getChildren("supportedInterface");
                ArrayList<String> arrayList = new ArrayList<String>(iConfigurationElementArray3.length);
                for (int i = 0; i < iConfigurationElementArray3.length; ++i) {
                    arrayList.add(iConfigurationElementArray3[i].getAttribute("interface"));
                }
                iConfigurationElementArray = new HandlerListConfigImpl();
                iConfigurationElementArray.setName(string2);
                iConfigurationElementArray.setTraversalClass(string);
                iConfigurationElementArray.setInvokeInterfaces(arrayList.toArray(new String[0]));
                iConfigurationElementArray.setBundleName(iConfigurationElementArray2[n].getNamespace());
                try {
                    this.addHandlerListConfig((HandlerListConfig)iConfigurationElementArray);
                    continue;
                }
                catch (HFConfigException hFConfigException) {
                    FFDCFilter.processException((Throwable)hFConfigException, "com.ibm.ws.handlerfw.impl.HandlerFrameworkServiceImpl.loadConfigFromExtensionRegistry", "208", this);
                    if (!tc.isEventEnabled()) continue;
                    Tr.event(tc, "unable to add handler list configuration", hFConfigException);
                }
            }
            string3 = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".handler";
            iConfigurationElementArray2 = iExtensionRegistry.getConfigurationElementsFor(string3);
            for (n = 0; n < iConfigurationElementArray2.length; ++n) {
                Object object;
                Object object2;
                string2 = iConfigurationElementArray2[n].getAttribute("name");
                string = iConfigurationElementArray2[n].getAttribute("class");
                boolean bl = Boolean.valueOf(iConfigurationElementArray2[n].getAttribute("critical"));
                boolean bl2 = Boolean.valueOf(iConfigurationElementArray2[n].getAttribute("synchronizationRequired"));
                iConfigurationElementArray = iConfigurationElementArray2[n].getChildren("list");
                ArrayList<HandlerListRefImpl> arrayList = new ArrayList<HandlerListRefImpl>(iConfigurationElementArray.length);
                for (int i = 0; i < iConfigurationElementArray.length; ++i) {
                    object2 = iConfigurationElementArray[i].getAttribute("name");
                    int n2 = -1;
                    try {
                        n2 = Integer.parseInt(iConfigurationElementArray[i].getAttribute("priority"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        FFDCFilter.processException((Throwable)numberFormatException, "com.ibm.ws.handlerfw.impl.HandlerFrameworkServiceImpl.loadConfigFromExtensionRegistry", "240", this);
                        if (!tc.isEventEnabled()) continue;
                        Tr.event(tc, "invalid priority", numberFormatException);
                        continue;
                    }
                    object = new HandlerListRefImpl((String)object2, n2);
                    arrayList.add((HandlerListRefImpl)object);
                }
                iConfigurationElementArray = iConfigurationElementArray2[n].getChildren("param");
                ArrayList<JavabeanParam> arrayList2 = new ArrayList<JavabeanParam>(iConfigurationElementArray.length);
                for (int i = 0; i < iConfigurationElementArray.length; ++i) {
                    String string4 = iConfigurationElementArray[i].getAttribute("name");
                    object = iConfigurationElementArray[i].getAttribute("value");
                    String string5 = iConfigurationElementArray[i].getAttribute("type");
                    try {
                        arrayList2.add(new JavabeanParam(string4, Class.forName(string5), (String)object));
                        continue;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.handlerfw.impl.HandlerFrameworkServiceImpl.loadConfigFromExtensionRegistry", "248", this);
                        if (!tc.isEventEnabled()) continue;
                        Tr.event(tc, "invalid parameter type", classNotFoundException);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        FFDCFilter.processException((Throwable)numberFormatException, "com.ibm.ws.handlerfw.impl.HandlerFrameworkServiceImpl.loadConfigFromExtensionRegistry", "253", this);
                        if (!tc.isEventEnabled()) continue;
                        Tr.event(tc, "invalid value", numberFormatException);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        FFDCFilter.processException((Throwable)illegalArgumentException, "com.ibm.ws.handlerfw.impl.HandlerFrameworkServiceImpl.loadConfigFromExtensionRegistry", "258", this);
                        if (!tc.isEventEnabled()) continue;
                        Tr.event(tc, "illegal value", illegalArgumentException);
                    }
                }
                object2 = new JavabeanHandlerConfigImpl();
                ((HandlerConfigImpl)object2).setName(string2);
                ((JavabeanHandlerConfigImpl)object2).setHandlerClass(string);
                ((HandlerConfigImpl)object2).setCritical(bl);
                ((HandlerConfigImpl)object2).setRequiresSynchronization(bl2);
                ((HandlerConfigImpl)object2).setHandlerListRefs(arrayList.toArray(new HandlerListRef[arrayList.size()]));
                ((JavabeanHandlerConfigImpl)object2).setBeanParms(arrayList2.toArray(new JavabeanParam[arrayList2.size()]));
                ((JavabeanHandlerConfigImpl)object2).setBundleName(iConfigurationElementArray2[n].getNamespace());
                try {
                    this.addHandlerConfig((HandlerConfig)object2);
                    continue;
                }
                catch (HFConfigException hFConfigException) {
                    FFDCFilter.processException((Throwable)hFConfigException, "com.ibm.ws.handlerfw.impl.HandlerFrameworkServiceImpl.loadConfigFromExtensionRegistry", "278", this);
                    if (!tc.isEventEnabled()) continue;
                    Tr.event(tc, "unable to add handler configuration", hFConfigException);
                }
            }
        } else {
            Tr.event(tc, "Unable to obtain extensions registry");
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadConfigFromExtensionRegistry");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig() {
        String string = "loadConfig()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.loadConfigFromExtensionRegistry();
        try {
            String string2;
            String string3;
            Object object;
            Enumeration<URL> enumeration = classLoader.getResources("META-INF/ws-handlerlist.xmi");
            URL uRL = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Loading HandlerLists from System ClassPath");
            }
            while (enumeration.hasMoreElements()) {
                uRL = enumeration.nextElement();
                object = uRL.getFile();
                string3 = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Loading HandlerList: " + (String)object);
                }
                string2 = this.trimURLString((String)object, "META-INF/ws-handlerlist.xmi");
                try {
                    this.loadHandlerListConfig(string2);
                }
                catch (HFConfigException hFConfigException) {
                    FFDCFilter.processException((Throwable)hFConfigException, "com.ibm.ws.handlerfw.impl.HandlerFrameworkServiceImpl.loadConfig", "194", this);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Error Loading HandlerList configuration: " + hFConfigException);
                }
            }
            object = classLoader.getResources("META-INF/ws-handler.xmi");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Loading Handlers from System ClassPath");
            }
            while (object.hasMoreElements()) {
                uRL = (URL)object.nextElement();
                string3 = uRL.getFile();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Loading Handler: " + string3);
                }
                string2 = this.trimURLString(string3, "META-INF/ws-handler.xmi");
                try {
                    this.loadHandlerConfig(string2, null, null);
                }
                catch (HFConfigException hFConfigException) {
                    FFDCFilter.processException((Throwable)hFConfigException, "com.ibm.ws.handlerfw.impl.HandlerFrameworkServiceImpl.loadConfig", "218", this);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Error Loading Handler Configuration: " + hFConfigException);
                }
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.handlerfw.impl.HandlerFrameworkServiceImpl.loadConfig", "225", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "IOException locating descriptors in ClassPath: " + iOException);
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string);
            }
        }
    }

    private String trimURLString(String string, String string2) {
        File file;
        int n;
        String string3 = string;
        int n2 = string.lastIndexOf("file:/");
        if (n2 == -1) {
            n2 = 0;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Missing file:/ in URL String: " + string);
            }
        } else {
            n2 += "file:/".length();
        }
        if ((string3 = (n = string.lastIndexOf(string2)) == -1 ? string.substring(n2) : string.substring(n2, n)).endsWith("!/")) {
            n = string3.lastIndexOf("!/");
            string3 = string3.substring(0, n);
        }
        if (!(file = new File(string3)).exists() && !(file = new File(string3 = "/" + string3)).exists() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Jar File does not exist: " + string3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Jar Path: " + string3);
        }
        return string3;
    }

    private void bindServiceToJNDI() throws RuntimeError {
        block3: {
            String string = "bindServiceToJNDI()";
            try {
                JndiHelper.recursiveBind(this.getContext(), "websphere/HandlerFrameworkService", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "service bound to JNDI.");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.handlerfw.impl.HandlerFrameworkServiceImpl.bindServiceToJNDI", "169", this);
                Tr.error(tc, "SERVICE_BIND_FAILURE", "HandlerFramework");
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, string + "failed to bind service to JNDI, exception: ", exception);
            }
        }
    }

    private Context getContext() throws RuntimeError {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "com.ibm.websphere.naming.genericURLInitialContextFactory");
        hashtable.put("com.ibm.websphere.naming.generic.url.schemeid", "services");
        hashtable.put("com.ibm.websphere.naming.generic.url.package", "com.ibm.ws.runtime");
        try {
            this.context = new InitialContext(hashtable);
        }
        catch (NamingException namingException) {
            Tr.error(tc, "NAMING_CONTEXT_FAILURE", "HandlerFramework");
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.handlerfw.impl.HandlerFrameworkServiceImpl.getContext", "198", this);
            throw new RuntimeError("Error creating service: namespace", namingException);
        }
        return this.context;
    }

    public void stop() {
        String string = "HandlerFrameworkService: stop() ";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + " Stopped");
        }
    }

    public void loadHandlerConfig(String string, String string2, String string3) throws HFConfigException {
        String string4 = "loadHandlerConfig()";
        HandlerConfig[] handlerConfigArray = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string4);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsing Handler deployment descriptor:" + string);
            Tr.debug(tc, "Application=" + string2 + ", Module=" + string3);
        }
        try {
            handlerConfigArray = HandlerConfigXMIUtils.deserializeHandlerConfig(string);
        }
        catch (HFConfigException hFConfigException) {
            Throwable throwable = hFConfigException.getCause();
            if (throwable != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception loading Handler Config, cause: " + throwable.toString());
                }
                Tr.error(tc, "HANDLER_CONFIG_LOAD_FAILURE", new Object[]{string2, string3, string});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string4);
            }
            return;
        }
        if (handlerConfigArray != null && handlerConfigArray.length > 0) {
            for (int i = 0; i < handlerConfigArray.length; ++i) {
                HandlerConfigImpl handlerConfigImpl = (HandlerConfigImpl)handlerConfigArray[i];
                handlerConfigImpl.setApplicationName(string2);
                handlerConfigImpl.setModuleName(string3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Add Handler Config:" + handlerConfigImpl);
                }
                try {
                    this.addHandlerConfig(handlerConfigImpl);
                    continue;
                }
                catch (HandlerExistsException handlerExistsException) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Handler already added, ignoring : " + handlerConfigImpl.getName());
                    continue;
                }
                catch (HFConfigException hFConfigException) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Exception adding Handler Config: " + hFConfigException.toString());
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No valid Handlers exist in descriptor for Jar: " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadHandlerListConfig(String string) throws HFConfigException {
        String string2 = "loadHandlerListConfig";
        HandlerListConfig[] handlerListConfigArray = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2);
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Parsing Handler deployment descriptor:" + string);
            }
            if ((handlerListConfigArray = HandlerConfigXMIUtils.deserializeHandlerListConfig(string)) != null && handlerListConfigArray.length > 0) {
                for (int i = 0; i < handlerListConfigArray.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Add HandlerList Config:" + handlerListConfigArray[i]);
                    }
                    try {
                        this.addHandlerListConfig(handlerListConfigArray[i]);
                        continue;
                    }
                    catch (HFConfigException hFConfigException) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Could not add HandlerList: " + handlerListConfigArray[i].getName());
                    }
                }
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadHandlerConfig(String string, String string2, String string3) throws HFConfigException {
        String string4 = "unloadHandlerConfig";
        HandlerConfig[] handlerConfigArray = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string4);
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Parsing Handler deployment descriptor:" + string);
                Tr.debug(tc, "Application=" + string2 + ", Module=" + string3);
            }
            if ((handlerConfigArray = HandlerConfigXMIUtils.deserializeHandlerConfig(string)) != null && handlerConfigArray.length > 0) {
                for (int i = 0; i < handlerConfigArray.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Remove Handler Config:" + handlerConfigArray[i].getName());
                    }
                    this.removeHandlerConfig(handlerConfigArray[i].getName());
                }
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadHandlerListConfig(String string) throws HFConfigException {
        String string2 = "unloadHandlerListConfig";
        HandlerListConfig[] handlerListConfigArray = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2);
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Parsing Handler deployment descriptor:" + string);
            }
            if ((handlerListConfigArray = HandlerConfigXMIUtils.deserializeHandlerListConfig(string)) != null && handlerListConfigArray.length > 0) {
                for (int i = 0; i < handlerListConfigArray.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Remove HandlerList Config:" + handlerListConfigArray[i]);
                    }
                    this.removeHandlerListConfig(handlerListConfigArray[i].getName());
                }
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string2);
            }
        }
    }

    public void addHandlerListConfig(HandlerListConfig handlerListConfig) throws HFConfigException {
        this.framework.addHandlerListConfig(handlerListConfig);
    }

    public void removeHandlerListConfig(String string) throws HFConfigException {
        this.framework.removeHandlerListConfig(string);
    }

    public HandlerListConfig getHandlerListConfig(String string) {
        return this.framework.getHandlerListConfig(string);
    }

    public HandlerListConfig[] getAllHandlerListConfigs() {
        return this.framework.getAllHandlerListConfigs();
    }

    public void addHandlerConfig(HandlerConfig handlerConfig) throws HFConfigException {
        this.framework.addHandlerConfig(handlerConfig);
    }

    public void removeHandlerConfig(String string) throws HFConfigException {
        this.framework.removeHandlerConfig(string);
    }

    public HandlerConfig getHandlerConfig(String string) {
        return this.framework.getHandlerConfig(string);
    }

    public HandlerConfig[] getAllHandlerConfigs() {
        return this.framework.getAllHandlerConfigs();
    }

    public HandlerListConfigFactory getHandlerListConfigFactory() {
        return this.framework.getHandlerListConfigFactory();
    }

    public HandlerConfigFactory getHandlerConfigFactory() {
        return this.framework.getHandlerConfigFactory();
    }

    public HandlerList getHandlerList(String string) throws HFConfigException, HFRuntimeException {
        return this.framework.getHandlerList(string);
    }

    public void resetConfig() {
        this.framework.resetConfig();
    }

    public boolean listExists(String string) {
        return this.framework.listExists(string);
    }

    public HandlerFramework getHandlerFramework() {
        return this.framework;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("***** HandlerFrameworkServiceImpl ****");
        stringBuffer.append(super.toString() + "\n");
        stringBuffer.append("Context=" + this.context + "\n");
        stringBuffer.append("inClient=" + this.inClient + "\n");
        return stringBuffer.toString();
    }
}

