/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.handlerfw.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.handlerfw.impl.EJBHandlerImpl;
import com.ibm.ws.handlerfw.impl.GenericUtils;
import com.ibm.ws.handlerfw.impl.HandlerAccessImpl;
import com.ibm.ws.handlerfw.impl.HandlerEventListener;
import com.ibm.ws.handlerfw.impl.HandlerFrameworkImpl;
import com.ibm.ws.handlerfw.impl.HandlerListConfigImpl;
import com.ibm.ws.handlerfw.impl.HandlerListStatusImpl;
import com.ibm.ws.handlerfw.impl.WsListHandler;
import com.ibm.wsspi.handlerfw.HandlerAccess;
import com.ibm.wsspi.handlerfw.HandlerConfig;
import com.ibm.wsspi.handlerfw.HandlerList;
import com.ibm.wsspi.handlerfw.HandlerListConfig;
import com.ibm.wsspi.handlerfw.HandlerListEventListener;
import com.ibm.wsspi.handlerfw.HandlerListStatus;
import com.ibm.wsspi.handlerfw.HandlerListTraversal;
import com.ibm.wsspi.handlerfw.HandlerRef;
import com.ibm.wsspi.handlerfw.WsHandler;
import com.ibm.wsspi.handlerfw.exception.HFConfigException;
import com.ibm.wsspi.handlerfw.exception.HFRuntimeException;
import com.ibm.wsspi.handlerfw.exception.HandlerNotFoundException;
import com.ibm.wsspi.handlerfw.exception.InvalidSequenceNumberException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class HandlerListImpl
implements HandlerList,
HandlerEventListener {
    private static final TraceComponent tc = Tr.register(HandlerListImpl.class, "HandlerFramework", "com.ibm.ws.handlerfw.resources.handlerframework");
    private HandlerListConfig config = null;
    private List handlerList = new ArrayList(10);
    private List eventListenerList = new ArrayList(10);
    private HandlerFrameworkImpl framework = null;
    private Object statusLock = new Object();
    private WsListHandler[] arrayHandlerList = null;
    private HandlerListTraversal traversal = null;
    private boolean isInvoked = false;
    static /* synthetic */ Class class$java$lang$Object;

    protected HandlerListImpl(HandlerFrameworkImpl handlerFrameworkImpl, HandlerListConfig handlerListConfig) throws HFConfigException {
        HandlerRef[] handlerRefArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Constructor", handlerListConfig);
        }
        this.framework = handlerFrameworkImpl;
        this.config = handlerListConfig;
        String string = handlerListConfig.getTraversalClass();
        if (string == null) {
            this.traversal = handlerFrameworkImpl.getDefaultHandlerListTraversal();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Set default HandlerList traversal");
            }
        } else {
            try {
                handlerRefArray = this.loadTraversalClass();
                this.traversal = (HandlerListTraversal)handlerRefArray.newInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.handlerfw.impl.HandlerListImpl(constructor)", "114", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception creating Traversal object: " + string);
                }
                throw new HFRuntimeException("Exception instantiating Traversal object: " + string);
            }
        }
        if ((handlerRefArray = handlerListConfig.getHandlerRefs()) != null && handlerRefArray.length > 0) {
            for (int i = 0; i < handlerRefArray.length; ++i) {
                String string2 = handlerRefArray[i].getHandler().getName();
                this.addHandler(string2, handlerRefArray[i].getPriority());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Constructor");
        }
    }

    private Class loadTraversalClass() throws ClassNotFoundException {
        Class<Object> clazz;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadTraversalClass");
        }
        if ((string = ((HandlerListConfigImpl)this.config).getBundleName()) != null) {
            Bundle bundle;
            block7: {
                bundle = Platform.getBundle((String)string);
                if (bundle.getState() == 4) {
                    try {
                        bundle.start();
                    }
                    catch (BundleException bundleException) {
                        FFDCFilter.processException((Throwable)bundleException, "com.ibm.ws.handlerfw.impl.HandlerListImpl.loadTraversalClass", "158", this);
                        if (!tc.isEventEnabled()) break block7;
                        Tr.event(tc, "unable to start bundle " + string);
                    }
                }
            }
            clazz = bundle.loadClass(this.config.getTraversalClass());
        } else {
            ExtClassLoader extClassLoader = ExtClassLoader.getInstance();
            clazz = extClassLoader == null ? Class.forName(this.config.getTraversalClass()) : Class.forName(this.config.getTraversalClass(), true, (ClassLoader)extClassLoader);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadTraversalClass", clazz);
        }
        return clazz;
    }

    public synchronized void setHandlerListTraversal(HandlerListTraversal handlerListTraversal) {
        String string = "setHandlerListTraversal()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string, handlerListTraversal);
        }
        if (handlerListTraversal != null) {
            this.traversal = handlerListTraversal;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Set new traversal " + handlerListTraversal + " for HandlerList: " + this.config.getName());
            }
        } else {
            this.traversal = this.framework.getDefaultHandlerListTraversal();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Reset to default traversal for HandlerList: " + this.config.getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProxy(Class clazz) throws NullPointerException, IllegalArgumentException {
        String string = "getProxy()";
        Object object = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Null Interface object");
        }
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("Not a interface class");
        }
        try {
            Class[] classArray = new Class[]{clazz};
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting proxy for Interface: " + clazz);
            }
            if (object == null) {
                object = Proxy.newProxyInstance(clazz.getClassLoader(), classArray, (InvocationHandler)new HandlerProxy(clazz));
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(Class[] classArray) throws IllegalArgumentException, NullPointerException {
        String string = "validate()";
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        try {
            if (classArray == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Null interface class array parameter.");
                }
                throw new NullPointerException("Null interface class array parameter.");
            }
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i] == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Null interface class at index: " + i);
                    }
                    throw new NullPointerException("Null interface class at index: " + i);
                }
                if (!classArray[i].isInterface()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Class: " + classArray[i].getName() + " is not an interface at index: " + i);
                    }
                    throw new IllegalArgumentException("Class: " + classArray[i].getName() + " is not an interface at index: " + i);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "index: [" + i + "] Interface class: " + classArray[i].getName());
            }
            HandlerListImpl handlerListImpl = this;
            synchronized (handlerListImpl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HandlerList has " + this.handlerList.size() + " Handlers.");
                }
                for (int i = 0; i < this.handlerList.size(); ++i) {
                    WsListHandler wsListHandler = (WsListHandler)this.handlerList.get(i);
                    WsHandler wsHandler = wsListHandler.getHandler();
                    String string2 = wsHandler.getConfig().getName();
                    bl = false;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Validating interfaces for Handler: " + string2);
                    }
                    if (!wsHandler.isInitialized()) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Skipping uninitialized Handler:" + string2);
                        continue;
                    }
                    Object object = wsHandler.getInvokeTarget();
                    if (object == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Target object is null for Handler:" + string2);
                        continue;
                    }
                    for (int j = 0; j < classArray.length; ++j) {
                        if (!classArray[j].isInstance(object)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Handler: " + string2 + " implements interface:" + classArray[j].getName());
                        }
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "No validation interfaces implemented by Handler: " + string2);
                    break;
                }
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string + " returns: " + bl);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlerListStatus getStatus() {
        String string = "getStatus()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        HandlerListStatusImpl handlerListStatusImpl = new HandlerListStatusImpl();
        WsHandler wsHandler = null;
        Object object = this.statusLock;
        synchronized (object) {
            Iterator iterator = this.handlerList.iterator();
            block8: while (iterator.hasNext()) {
                wsHandler = ((WsListHandler)iterator.next()).getHandler();
                handlerListStatusImpl.getCompleteList().add(wsHandler.getConfig());
                switch (wsHandler.getStatus()) {
                    case 2: {
                        handlerListStatusImpl.getFailedList().add(wsHandler.getConfig());
                        continue block8;
                    }
                    case 0: {
                        handlerListStatusImpl.getInitializedList().add(wsHandler.getConfig());
                        continue block8;
                    }
                    case 1: {
                        handlerListStatusImpl.getWaitingList().add(wsHandler.getConfig());
                        continue block8;
                    }
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Unknown Handler state: " + wsHandler.getStatus());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
        return handlerListStatusImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(String string, int n) throws HFConfigException, HFRuntimeException {
        String string2 = "addHandler()";
        boolean bl = false;
        WsHandler wsHandler = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2);
        }
        try {
            if (n < 0 || n > Integer.MAX_VALUE) {
                throw new InvalidSequenceNumberException("Invalid SeqNo: " + n);
            }
            if (string == null) {
                throw new HFConfigException("Null Handler Name.");
            }
            HandlerListImpl handlerListImpl = this;
            synchronized (handlerListImpl) {
                Object object;
                int n2;
                wsHandler = this.framework.getHandler(string);
                if (null == wsHandler) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Handler not found: " + string);
                    }
                    throw new HandlerNotFoundException("Handler: " + string + " not found");
                }
                WsListHandler wsListHandler = new WsListHandler(wsHandler, n);
                for (n2 = 0; n2 < this.handlerList.size() && n >= ((WsListHandler)(object = (WsListHandler)this.handlerList.get(n2))).getPosition(); ++n2) {
                }
                this.handlerList.add(n2, wsListHandler);
                if (wsHandler instanceof EJBHandlerImpl) {
                    object = (EJBHandlerImpl)wsHandler;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding HandlerList: " + this.config.getName() + " to receive Handler events for: " + string);
                    }
                    ((EJBHandlerImpl)object).addListener(this);
                }
                bl = true;
                this.arrayHandlerList = null;
            }
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Added Handler: " + string + " to list: " + this.config.getName() + " at seqNo: " + n);
                }
                this.notifyListeners();
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string2);
            }
        }
    }

    public void addHandler(String string) throws HFConfigException, HFRuntimeException {
        this.addHandler(string, 0x3FFFFFFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandler(String string) throws HandlerNotFoundException {
        String string2 = "removeHandler()";
        boolean bl = false;
        WsListHandler wsListHandler = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string2);
        }
        HandlerListImpl handlerListImpl = this;
        synchronized (handlerListImpl) {
            for (int i = 0; i < this.handlerList.size(); ++i) {
                wsListHandler = (WsListHandler)this.handlerList.get(i);
                if (!wsListHandler.getHandler().getConfig().getName().equals(string)) continue;
                this.handlerList.remove(i);
                bl = true;
                this.arrayHandlerList = null;
                break;
            }
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Removed Handler: " + string + " from List: " + this.config.getName());
            }
        } else {
            throw new HandlerNotFoundException("Handler: " + string + " not found in List: " + this.config.getName());
        }
        this.notifyListeners();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(HandlerListEventListener handlerListEventListener) {
        String string = "addListener()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        if (null == handlerListEventListener) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot add Null Listener");
            }
        } else {
            List list = this.eventListenerList;
            synchronized (list) {
                this.eventListenerList.add(handlerListEventListener);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(HandlerListEventListener handlerListEventListener) {
        String string = "removeListener()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        if (null == handlerListEventListener) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot remove Null Listener");
            }
        } else {
            List list = this.eventListenerList;
            synchronized (list) {
                this.eventListenerList.remove(handlerListEventListener);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    public void stateChanged(HandlerConfig handlerConfig, int n, int n2) {
        String string = "stateChanged()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Handler State Changed: " + handlerConfig.getName());
            Tr.debug(tc, "old state=" + n + ", new state=" + n2);
        }
        this.notifyListeners();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        String string = "notifyListners()";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        HandlerListStatus handlerListStatus = this.getStatus();
        List list = this.eventListenerList;
        synchronized (list) {
            for (int i = 0; i < this.eventListenerList.size(); ++i) {
                HandlerListEventListener handlerListEventListener = (HandlerListEventListener)this.eventListenerList.get(i);
                handlerListEventListener.listChanged(handlerListStatus);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeHandlers(Class clazz, Method method2, Object[] objectArray) throws Throwable {
        String string = "invokeHandlers()";
        Object object = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        try {
            Object object2 = this;
            synchronized (object2) {
                int n;
                if (this.arrayHandlerList == null && (n = this.handlerList.size()) > 0) {
                    this.arrayHandlerList = new WsListHandler[this.handlerList.size()];
                    this.handlerList.toArray(this.arrayHandlerList);
                }
            }
            object2 = new HandlerAccessImpl(this.config, clazz, method2, objectArray, this.arrayHandlerList);
            object = this.traversal.traverse((HandlerAccess)object2);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, string);
            }
        }
        return object;
    }

    public HandlerListTraversal getTraversal() {
        return this.traversal;
    }

    public void setTraversal(HandlerListTraversal handlerListTraversal) {
        this.traversal = handlerListTraversal;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\t**** HandlerListImpl **** \n");
        stringBuffer.append("\t1 config=" + this.config + "\n");
        stringBuffer.append("\t2 handlerList=" + this.handlerList + "\n");
        stringBuffer.append("\t3 eventListenerList=" + this.eventListenerList + "\n");
        stringBuffer.append("\t4 " + GenericUtils.toArrayString("arrayHandlerList", this.arrayHandlerList) + "\n");
        stringBuffer.append("\t5 HandlerListTraversal=" + this.traversal + "\n");
        stringBuffer.append("\t6 isInvoked=" + this.isInvoked + "\n");
        stringBuffer.append("\t **** ***** **** \n");
        return stringBuffer.toString();
    }

    class HandlerProxy
    implements InvocationHandler {
        private Class invocationInterface = null;

        HandlerProxy(Class clazz) {
            this.invocationInterface = clazz;
        }

        public Object invoke(Object object, Method method2, Object[] objectArray) throws Throwable {
            Object object2;
            if (method2.getDeclaringClass() == (class$java$lang$Object == null ? (class$java$lang$Object = HandlerListImpl.class$("java.lang.Object")) : class$java$lang$Object)) {
                object2 = method2.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Method with declaring class is java.lang.Object invoked: " + (String)object2);
                }
                if (((String)object2).equals("hashCode")) {
                    return new Integer(System.identityHashCode(object));
                }
                if (((String)object2).equals("equals")) {
                    return object == objectArray[0] ? Boolean.TRUE : Boolean.FALSE;
                }
                if (((String)object2).equals("toString")) {
                    return object.getClass().getName() + '@' + Integer.toHexString(object.hashCode());
                }
            }
            if (!HandlerListImpl.this.isInvoked) {
                HandlerListImpl.this.isInvoked = true;
                object2 = (HandlerListConfigImpl)HandlerListImpl.this.config;
                ((HandlerListConfigImpl)object2).setInvoked(true);
            }
            return HandlerListImpl.this.invokeHandlers(this.invocationInterface, method2, objectArray);
        }
    }
}

