/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.HttpRequest;
import com.ibm.ws.io.Stream;
import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends Stream {
    protected HttpRequest request;
    protected int chunkSize;
    private static TraceComponent tc = Tr.register(ChunkedInputStream.class.getName(), "HTTP_Transport");

    public void init(HttpRequest httpRequest, InputStream inputStream) {
        super.init(inputStream, null);
        this.request = httpRequest;
        this.chunkSize = 0;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "read", new Object[]{byArray, new Integer(n), new Integer(n2)});
        }
        try {
            if (this.chunkSize > 0) {
                if (this.chunkSize < n2) {
                    n2 = this.chunkSize;
                }
                if ((n2 = this.is.read(byArray, n, n2)) > 0) {
                    this.chunkSize -= n2;
                }
            } else if (this.chunkSize == 0) {
                this.chunkSize = this.readChunkLength();
                if (this.chunkSize > 0) {
                    if (this.chunkSize < n2) {
                        n2 = this.chunkSize;
                    }
                    if ((n2 = this.is.read(byArray, n, n2)) > 0) {
                        this.chunkSize -= n2;
                    }
                } else {
                    this.chunkSize = -1;
                    n2 = -1;
                }
            } else {
                n2 = -1;
            }
        }
        catch (IOException iOException) {
            this.request.getHttpConnection().setshouldStayAlive(false);
            throw iOException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "read", new Integer(n2));
        }
        return n2;
    }

    private int readChunkLength() throws IOException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readChunkLength");
        }
        int n2 = 0;
        while ((n = this.is.read()) == 13 || n == 10) {
        }
        while (n > 0 && n != 13 && n != 10 && n != 59) {
            if (n >= 48 && n <= 57) {
                n2 = 16 * n2 + n - 48;
            } else if (n >= 97 && n <= 102) {
                n2 = 16 * n2 + n - 97 + 10;
            } else if (n >= 65 && n <= 70) {
                n2 = 16 * n2 + n - 65 + 10;
            } else if (n != 32 && n != 9) {
                throw new IOException("HTTP/1.1 protocol error: bad chunk");
            }
            n = this.is.read();
        }
        if (n == 13) {
            n = this.is.read();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readChunkLength", new Integer(n2));
        }
        return n2;
    }

    public void close() throws IOException {
        byte[] byArray = null;
        if (this.chunkSize != -1) {
            byArray = new byte[8192];
        }
        while (this.chunkSize != -1) {
            int n = byArray.length;
            if (this.chunkSize < n) {
                n = this.chunkSize;
            }
            if ((n = this.is.read(byArray)) > 0) {
                this.chunkSize -= n;
            }
            if (this.chunkSize != 0) continue;
            this.chunkSize = this.readChunkLength();
        }
        super.close();
    }

    public int available() throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "available", new Integer(this.chunkSize));
        }
        return this.chunkSize;
    }
}

