/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.HttpException;
import com.ibm.ws.http.HttpRequest;
import com.ibm.ws.http.HttpResponse;
import com.ibm.ws.http.HttpServer;
import com.ibm.ws.http.HttpTransport;
import com.ibm.ws.http.Logger;
import com.ibm.ws.io.ReadStream;
import com.ibm.ws.io.Stream;
import com.ibm.ws.io.WriteStream;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.TransportLogger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.PrivilegedAction;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;

public class HttpConnection
implements Runnable {
    protected HttpRequest request = this.createHttpRequest();
    protected HttpResponse response = this.createHttpResponse();
    protected static final int defaultWaitTime = 10;
    private static TraceComponent tc = Tr.register(HttpConnection.class.getName(), "HTTP_Transport");
    private static final String WAIT_PROPERTY = "com.ibm.ws.http.waitBeforeCloseTime";
    private HttpServer httpServer = null;
    private HttpTransport transport = null;
    private InputStream inStream = null;
    private OutputStream outStream = null;
    private Stream stream = new Stream();
    private ReadStream readStream = new ReadStream();
    private WriteStream writeStream = new WriteStream();
    private Socket socket = null;
    private boolean allowKeepAlive;
    private boolean isKeptAlive;
    private boolean shouldStayAlive;
    private boolean Allocated = false;
    private boolean Aborted = false;
    private int curKeepAliveRequests;
    private boolean waitBeforeClose = false;
    private int waitBeforeCloseTime = 10;
    Logger logger;
    HttpServer httpserver;

    public HttpConnection() {
        this.setWaitBeforeClose(WAIT_PROPERTY, false, 10);
    }

    protected void setWaitBeforeClose(String string, boolean bl, int n) {
        String string2 = System.getProperty(string);
        this.waitBeforeClose = bl;
        this.waitBeforeCloseTime = n;
        try {
            int n2 = Integer.parseInt(string2);
            if (n2 == 0) {
                this.waitBeforeClose = false;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, string + " is disabled");
                }
            } else if (n2 > 0) {
                this.waitBeforeCloseTime = n2;
                this.waitBeforeClose = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, string + " = " + this.waitBeforeCloseTime + "ms");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init(HttpTransport httpTransport, Socket socket) {
        this.transport = httpTransport;
        this.socket = socket;
        this.setFlushMode(false);
        this.setAborted(false);
    }

    public HttpServer getHttpServer() {
        return this.httpServer;
    }

    public HttpTransport getHttpTransport() {
        return this.transport;
    }

    public HttpRequest getHttpRequest() {
        return this.request;
    }

    public HttpResponse getHttpResponse() {
        return this.response;
    }

    public String getConnectionScheme() {
        return this.transport.getScheme();
    }

    public String getConnectionServerName() {
        String string = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return HttpConnection.this.socket.getLocalAddress().getHostName();
            }
        });
        if (string == null || string.equalsIgnoreCase("localhost")) {
            string = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    try {
                        return InetAddress.getLocalHost().getHostName();
                    }
                    catch (Throwable throwable) {
                        return null;
                    }
                }
            });
        }
        return string;
    }

    public int getConnectionServerPort() {
        return this.socket.getLocalPort();
    }

    public String getConnectionRemoteHost() {
        return (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return HttpConnection.this.socket.getInetAddress().getHostName();
            }
        });
    }

    public String getConnectionRemoteAddr() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public int getConnectionRemotePort() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Getting Connection Remote Port - ConnectionRemotePort " + this.socket.getPort());
        }
        return this.socket.getPort();
    }

    public String getConnectionLocalName() {
        return (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return HttpConnection.this.socket.getLocalAddress().getHostName();
            }
        });
    }

    public String getConnectionLocalAddr() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Getting Connection Local Address - ConnectionLocalAddress " + this.socket.getLocalAddress().getHostAddress());
        }
        return this.socket.getLocalAddress().getHostAddress();
    }

    public int getConnectionLocalPort() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Getting Connection Local Port - ConnectionLocalPort " + this.socket.getLocalPort());
        }
        return this.socket.getLocalPort();
    }

    public boolean isConnectionSecure() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Determining if Connection is Secure");
        }
        return this.transport.isSecure();
    }

    public java.security.cert.X509Certificate[] getConnectionPeerCertificates() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Getting Connection Peer Certificates (Client Certificates");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionPeerCertificates");
        }
        try {
            java.security.cert.X509Certificate[] x509CertificateArray = null;
            if (this.isConnectionSecure() && this.sslSocket().getNeedClientAuth()) {
                X509Certificate[] x509CertificateArray2 = null;
                try {
                    x509CertificateArray2 = this.sslSocket().getSession().getPeerCertificateChain();
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    if (!HttpServer.errorLogDisable) {
                        Logger.log(1, "HTTP0200E Could not Verify Client Certificate");
                    }
                    Tr.error(tc, "unverified client certificate", sSLPeerUnverifiedException);
                }
                if (x509CertificateArray2 != null) {
                    if (x509CertificateArray2 instanceof X509Certificate[]) {
                        if (HttpServer.debugEnabled) {
                            Logger.log(4, "HttpConnection: Client Certificate is instance of javax.security.cert.X509Certificate");
                        }
                        x509CertificateArray = this.convertCertificateChain(x509CertificateArray2);
                    } else {
                        x509CertificateArray = (java.security.cert.X509Certificate[])x509CertificateArray2;
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConnectionPeerCertificates", x509CertificateArray);
            }
            if (HttpServer.debugEnabled) {
                Logger.log(4, "HttpConnection: Client Certificate Chain");
            }
            return x509CertificateArray;
        }
        catch (Exception exception) {
            if (!HttpServer.errorLogDisable) {
                Logger.log(1, "HTTP0201E Peer Ceritificate is Invalid");
            }
            Tr.error(tc, "invalid peer certificate: " + exception.getMessage());
            return null;
        }
    }

    private java.security.cert.X509Certificate[] convertCertificateChain(X509Certificate[] x509CertificateArray) throws Exception {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Converting Certificate Chain - inChain");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertCertificateChain", x509CertificateArray);
        }
        java.security.cert.X509Certificate[] x509CertificateArray2 = new java.security.cert.X509Certificate[x509CertificateArray.length];
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            x509CertificateArray2[i] = (java.security.cert.X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(x509CertificateArray[i].getEncoded()));
        }
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Converted Certificate Chain-outChain");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertCertificateChain", x509CertificateArray2);
        }
        return x509CertificateArray2;
    }

    public String getConnectionCipherSuite() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionCipherSuite");
        }
        String string = null;
        if (this.isConnectionSecure()) {
            string = ((SSLSocket)this.socket).getSession().getCipherSuite();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnectionCipherSuite", string);
        }
        if (!HttpServer.errorLogDisable) {
            Logger.log(3, "HTTP0203I Connection Cipher Suite = " + string);
        }
        return string;
    }

    public Integer getAlgorithmBitSize() {
        Integer n = null;
        String string = this.getConnectionCipherSuite();
        if (string != null) {
            // empty if block
        }
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Cipher Suite Algorithm Bitsize = " + n);
        }
        return n;
    }

    public byte[] getConnectionSessionId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionSessionId");
        }
        byte[] byArray = null;
        if (this.isConnectionSecure()) {
            byArray = ((SSLSocket)this.socket).getSession().getId();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnectionSessionId", byArray);
        }
        return byArray;
    }

    private SSLSocket sslSocket() {
        return (SSLSocket)this.socket;
    }

    public boolean shouldSignalClose() {
        if (!(this.transport.isAlive() && this.transport.isKeepAlive() && this.allowKeepAlive && this.request.wantsToStayAlive())) {
            this.shouldStayAlive = false;
            return true;
        }
        int n = this.transport.getMaxKeepAliveRequests();
        if (n != 0 && ++this.curKeepAliveRequests > n) {
            this.shouldStayAlive = false;
            return true;
        }
        if (!this.isKeptAlive) {
            this.isKeptAlive = this.allowKeepAlive = this.httpServer.allocateKeepAlive();
            if (!this.allowKeepAlive) {
                this.shouldStayAlive = false;
                return true;
            }
        }
        return false;
    }

    public boolean getAllowKeepAlive() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Determine if allowing Keepalive");
        }
        return this.allowKeepAlive;
    }

    public void setAllowKeepAlive(boolean bl) {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Setting allowing Keepalive");
        }
        this.allowKeepAlive = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block99: {
            Object object3222;
            int n;
            Object object2;
            block89: {
                block88: {
                    boolean bl;
                    if (HttpServer.debugEnabled) {
                        Logger.log(4, "HttpConnection: Running Connection");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "run");
                    }
                    object2 = this;
                    synchronized (object2) {
                        if (this.Aborted) {
                            this.socket = null;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Run Aborted [" + this + "]");
                            }
                            return;
                        }
                    }
                    object2 = "unknown";
                    n = -1;
                    if (!HttpServer.errorLogDisable) {
                        Logger.log(3, "HTTP0400I Initializing Socket Input/Output Stream");
                    }
                    if (TransportLogger.debugEnabled()) {
                        TransportLogger.debug("HttpConnection.run(): thread started: " + Thread.currentThread().getName());
                        object2 = this.socket.getInetAddress().getHostAddress();
                        n = this.socket.getPort();
                        TransportLogger.debug("HttpConnection.run(): remoteAddress: " + (String)object2);
                        TransportLogger.debug("HttpConnection.run(): remotePort: " + n);
                    }
                    this.httpServer = this.transport.getHttpServer();
                    this.inStream = this.socket.getInputStream();
                    this.outStream = this.socket.getOutputStream();
                    this.stream.init(this.inStream, this.outStream);
                    this.readStream.init(this.stream);
                    this.writeStream.init(this.stream);
                    this.readStream.setDisableClose(true);
                    this.writeStream.setDisableClose(true);
                    this.request.init(this.readStream);
                    this.response.init(this.writeStream);
                    int n2 = this.transport.getConnectionIOTimeout();
                    int n3 = this.transport.getConnectionKeepAliveTimeout();
                    this.socket.setTcpNoDelay(this.transport.getTcpNoDelay());
                    this.socket.setSoTimeout(n2);
                    this.socket.setSoLinger(true, 20);
                    this.allowKeepAlive = true;
                    this.isKeptAlive = false;
                    this.shouldStayAlive = true;
                    this.curKeepAliveRequests = 0;
                    this.readAndHandleRequest(true);
                    boolean bl2 = bl = n2 != n3;
                    while (this.shouldStayAlive) {
                        if (bl) {
                            this.socket.setSoTimeout(n3);
                        }
                        if (this.readStream.read() != -1) {
                            this.readStream.unread();
                            if (bl) {
                                this.socket.setSoTimeout(n2);
                            }
                            this.readAndHandleRequest(false);
                            continue;
                        }
                        if (!HttpServer.errorLogDisable) {
                            Logger.log(2, "HTTP0400W error Reading data - Connection is being closed");
                        }
                        this.shouldStayAlive = false;
                    }
                    Object var7_11 = null;
                    if (TransportLogger.debugEnabled()) {
                        TransportLogger.debug("HttpConnection.run(): socket closed: remotePort=[" + n + "] remoteAddress=[" + (String)object2 + "]");
                    }
                    try {
                        if (this.waitBeforeClose && ((String)(object3222 = System.getProperty("os.name"))).toLowerCase().indexOf("windows") >= 0 && ((InetSocketAddress)this.socket.getRemoteSocketAddress()).getAddress().isLoopbackAddress()) {
                            Thread.sleep(this.waitBeforeCloseTime);
                        }
                    }
                    catch (Exception object3222) {
                        // empty catch block
                    }
                    try {
                        this.writeStream.setDisableClose(false);
                        this.writeStream.close();
                        this.outStream.close();
                    }
                    catch (Throwable object3222) {
                        if (HttpServer.errorLogDisable) break block88;
                        Logger.log(2, "HTTP0402W Could not Close Output Stream");
                    }
                }
                try {
                    this.readStream.setDisableClose(false);
                    this.readStream.close();
                    this.inStream.close();
                }
                catch (Throwable object3222) {
                    if (HttpServer.errorLogDisable) break block89;
                    Logger.log(2, "HTTP0403W Could not Close Input Stream");
                }
            }
            try {
                if (HttpServer.debugEnabled) {
                    Logger.log(4, "HttpConnection: Closing Socket");
                }
                this.socket.close();
            }
            catch (Throwable object3222) {
                if (!HttpServer.errorLogDisable) {
                    Logger.log(1, "HTTP0401E Could not Close Socket");
                }
            }
            finally {
                this.socket = null;
            }
            this.inStream = null;
            this.outStream = null;
            if (this.isKeptAlive) {
                try {
                    this.httpServer.freeKeepAlive();
                }
                catch (Throwable object3222) {
                    // empty catch block
                }
            }
            try {
                if (this.httpServer.freeConnection(this)) {
                    this.cleanup();
                }
            }
            catch (Throwable object3222) {
                // empty catch block
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
            break block99;
            {
                catch (IOException iOException) {
                    Object object42222;
                    block95: {
                        block94: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, iOException.getMessage(), iOException);
                            }
                            Object var7_12 = null;
                            if (TransportLogger.debugEnabled()) {
                                TransportLogger.debug("HttpConnection.run(): socket closed: remotePort=[" + n + "] remoteAddress=[" + (String)object2 + "]");
                            }
                            try {
                                if (this.waitBeforeClose && ((String)(object42222 = System.getProperty("os.name"))).toLowerCase().indexOf("windows") >= 0 && ((InetSocketAddress)this.socket.getRemoteSocketAddress()).getAddress().isLoopbackAddress()) {
                                    Thread.sleep(this.waitBeforeCloseTime);
                                }
                            }
                            catch (Exception object42222) {
                                // empty catch block
                            }
                            try {
                                this.writeStream.setDisableClose(false);
                                this.writeStream.close();
                                this.outStream.close();
                            }
                            catch (Throwable object42222) {
                                if (HttpServer.errorLogDisable) break block94;
                                Logger.log(2, "HTTP0402W Could not Close Output Stream");
                            }
                        }
                        try {
                            this.readStream.setDisableClose(false);
                            this.readStream.close();
                            this.inStream.close();
                        }
                        catch (Throwable object42222) {
                            if (HttpServer.errorLogDisable) break block95;
                            Logger.log(2, "HTTP0403W Could not Close Input Stream");
                        }
                    }
                    try {
                        if (HttpServer.debugEnabled) {
                            Logger.log(4, "HttpConnection: Closing Socket");
                        }
                        this.socket.close();
                        this.socket = null;
                    }
                    catch (Throwable object42222) {
                        try {}
                        catch (Throwable throwable) {
                            this.socket = null;
                            throw throwable;
                        }
                        if (!HttpServer.errorLogDisable) {
                            Logger.log(1, "HTTP0401E Could not Close Socket");
                        }
                        this.socket = null;
                    }
                    this.inStream = null;
                    this.outStream = null;
                    if (this.isKeptAlive) {
                        try {
                            this.httpServer.freeKeepAlive();
                        }
                        catch (Throwable object42222) {
                            // empty catch block
                        }
                    }
                    try {
                        if (this.httpServer.freeConnection(this)) {
                            this.cleanup();
                        }
                    }
                    catch (Throwable object42222) {
                        // empty catch block
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "run");
                    }
                    break block99;
                }
                catch (Throwable throwable) {
                    Object object52222;
                    block103: {
                        block102: {
                            block100: {
                                String string = "HttpConnection.run: " + throwable;
                                Tr.error(tc, string);
                                FFDCFilter.processException(throwable, "com.ibm.ws.http.HttpConnection.run", "483");
                                if (!this.response.isCommitted()) {
                                    try {
                                        this.response.sendError(new HttpException(500, string));
                                    }
                                    catch (IOException iOException) {
                                        if (!tc.isDebugEnabled()) break block100;
                                        Tr.debug(tc, iOException.getMessage(), iOException);
                                    }
                                }
                            }
                            Object var7_13 = null;
                            if (TransportLogger.debugEnabled()) {
                                TransportLogger.debug("HttpConnection.run(): socket closed: remotePort=[" + n + "] remoteAddress=[" + (String)object2 + "]");
                            }
                            try {
                                if (this.waitBeforeClose && ((String)(object52222 = System.getProperty("os.name"))).toLowerCase().indexOf("windows") >= 0 && ((InetSocketAddress)this.socket.getRemoteSocketAddress()).getAddress().isLoopbackAddress()) {
                                    Thread.sleep(this.waitBeforeCloseTime);
                                }
                            }
                            catch (Exception object52222) {
                                // empty catch block
                            }
                            try {
                                this.writeStream.setDisableClose(false);
                                this.writeStream.close();
                                this.outStream.close();
                            }
                            catch (Throwable object52222) {
                                if (HttpServer.errorLogDisable) break block102;
                                Logger.log(2, "HTTP0402W Could not Close Output Stream");
                            }
                        }
                        try {
                            this.readStream.setDisableClose(false);
                            this.readStream.close();
                            this.inStream.close();
                        }
                        catch (Throwable object52222) {
                            if (HttpServer.errorLogDisable) break block103;
                            Logger.log(2, "HTTP0403W Could not Close Input Stream");
                        }
                    }
                    try {
                        if (HttpServer.debugEnabled) {
                            Logger.log(4, "HttpConnection: Closing Socket");
                        }
                        this.socket.close();
                        this.socket = null;
                    }
                    catch (Throwable object52222) {
                        try {}
                        catch (Throwable throwable2) {
                            this.socket = null;
                            throw throwable2;
                        }
                        if (!HttpServer.errorLogDisable) {
                            Logger.log(1, "HTTP0401E Could not Close Socket");
                        }
                        this.socket = null;
                    }
                    this.inStream = null;
                    this.outStream = null;
                    if (this.isKeptAlive) {
                        try {
                            this.httpServer.freeKeepAlive();
                        }
                        catch (Throwable object52222) {
                            // empty catch block
                        }
                    }
                    try {
                        if (this.httpServer.freeConnection(this)) {
                            this.cleanup();
                        }
                    }
                    catch (Throwable object52222) {
                        // empty catch block
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "run");
                    }
                }
            }
            catch (Throwable throwable) {
                Object object62222;
                block108: {
                    block107: {
                        Object var7_14 = null;
                        if (TransportLogger.debugEnabled()) {
                            TransportLogger.debug("HttpConnection.run(): socket closed: remotePort=[" + n + "] remoteAddress=[" + (String)object2 + "]");
                        }
                        try {
                            if (this.waitBeforeClose && ((String)(object62222 = System.getProperty("os.name"))).toLowerCase().indexOf("windows") >= 0 && ((InetSocketAddress)this.socket.getRemoteSocketAddress()).getAddress().isLoopbackAddress()) {
                                Thread.sleep(this.waitBeforeCloseTime);
                            }
                        }
                        catch (Exception object62222) {
                            // empty catch block
                        }
                        try {
                            this.writeStream.setDisableClose(false);
                            this.writeStream.close();
                            this.outStream.close();
                        }
                        catch (Throwable object62222) {
                            if (HttpServer.errorLogDisable) break block107;
                            Logger.log(2, "HTTP0402W Could not Close Output Stream");
                        }
                    }
                    try {
                        this.readStream.setDisableClose(false);
                        this.readStream.close();
                        this.inStream.close();
                    }
                    catch (Throwable object62222) {
                        if (HttpServer.errorLogDisable) break block108;
                        Logger.log(2, "HTTP0403W Could not Close Input Stream");
                    }
                }
                try {
                    if (HttpServer.debugEnabled) {
                        Logger.log(4, "HttpConnection: Closing Socket");
                    }
                    this.socket.close();
                    this.socket = null;
                }
                catch (Throwable object62222) {
                    try {}
                    catch (Throwable throwable3) {
                        this.socket = null;
                        throw throwable3;
                    }
                    if (!HttpServer.errorLogDisable) {
                        Logger.log(1, "HTTP0401E Could not Close Socket");
                    }
                    this.socket = null;
                }
                this.inStream = null;
                this.outStream = null;
                if (this.isKeptAlive) {
                    try {
                        this.httpServer.freeKeepAlive();
                    }
                    catch (Throwable object62222) {
                        // empty catch block
                    }
                }
                try {
                    if (this.httpServer.freeConnection(this)) {
                        this.cleanup();
                    }
                }
                catch (Throwable object62222) {
                    // empty catch block
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "run");
                }
                throw throwable;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void readAndHandleRequest(boolean var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void handleRequest() throws HttpException, IOException {
        String string = this.request.getURI();
        this.response.setStatus(200);
        PrintWriter printWriter = this.response.getWriter();
        printWriter.print("<HTML><BODY><p>This is a do nothing handler for uri '" + string + "'</BODY></HTML>");
        printWriter.print("<HTML><BODY><p>This handleRequest method should be overridden!</BODY></HTML>");
    }

    protected void cleanup() {
    }

    protected HttpRequest createHttpRequest() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Creating HTTP Request");
        }
        return new HttpRequest(this);
    }

    protected HttpResponse createHttpResponse() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpConnection: Creating HTTP Response");
        }
        return new HttpResponse(this);
    }

    public void setFlushMode(boolean bl) {
        this.response.setFlushMode(bl);
    }

    public void setshouldStayAlive(boolean bl) {
        this.shouldStayAlive = bl;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Connection should stay alive = ", new Boolean(this.shouldStayAlive));
        }
    }

    public boolean isAllocated() {
        return this.Allocated;
    }

    public void setAllocated(boolean bl) {
        this.Allocated = bl;
    }

    public boolean isAborted() {
        return this.Aborted;
    }

    public void setAborted(boolean bl) {
        this.Aborted = bl;
    }
}

