/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.HttpConnection;
import com.ibm.ws.http.HttpException;
import com.ibm.ws.http.HttpRequest;
import com.ibm.ws.http.HttpServer;
import com.ibm.ws.http.Logger;
import com.ibm.ws.http.ResponseStream;
import com.ibm.ws.io.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;

public class HttpResponse {
    Logger logger;
    HttpServer httpserver;
    private static final TraceComponent tc = Tr.register(HttpResponse.class, "HTTP_Transport", null);
    protected HttpConnection connection;
    protected WriteStream outStream;
    protected ResponseStream responseStream;
    protected int status;
    protected String reason;
    protected ArrayList headerKeys = new ArrayList();
    protected ArrayList headerValues = new ArrayList();
    protected boolean headersWritten;
    protected boolean isClosed;
    private int contentLength;
    protected String contentLengthString = "-";

    public HttpResponse(HttpConnection httpConnection) {
        this.connection = httpConnection;
        this.outStream = new WriteStream();
        this.responseStream = new ResponseStream();
    }

    public void init(WriteStream writeStream) {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpResponse: Sending Response");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        this.responseStream.init(this, writeStream);
        this.outStream.init(this.responseStream);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void start() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        this.status = 200;
        this.reason = null;
        this.responseStream.start();
        this.headersWritten = false;
        this.contentLength = -1;
        this.contentLengthString = "-";
        this.isClosed = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(boolean bl) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "finish");
        }
        try {
            if (!this.isClosed) {
                this.isClosed = true;
                this.responseStream.setFlushMode(false);
                this.outStream.flush();
                this.responseStream.setFlushMode(true);
                this.responseStream.finish(!this.connection.getAllowKeepAlive(), bl);
                if (this.contentLength >= 0 && this.responseStream.getNumBytesWritten() != this.contentLength) {
                    String string = this.responseStream.getNumBytesWritten() + " response bytes written, but Content-Length header equals " + this.contentLength;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "finish", "invalid Content-Length header");
                    }
                    throw new IllegalStateException(string);
                }
            }
        }
        finally {
            this.headerKeys.clear();
            this.headerValues.clear();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "finish");
        }
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public int getStatus() {
        return this.status;
    }

    public void setReason(String string) {
        this.reason = string;
    }

    public String getReason() {
        if (this.reason != null) {
            return this.reason;
        }
        return StatusMessage.get(this.status);
    }

    public void sendContinue() throws IOException {
        this.responseStream.sendContinue();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "sendContinue");
        }
    }

    public void sendExtendedHandshake() throws IOException {
        this.responseStream.sendExtendedHandshake();
        this.isClosed = true;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "sendExtendedHandshake");
        }
    }

    public boolean isCommitted() {
        return this.responseStream.isCommitted();
    }

    public void sendError(HttpException httpException) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendError", httpException);
        }
        this.sendError(httpException.getCode(), httpException.getMessage());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendError");
        }
    }

    public void sendError(int n, String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendError", string);
        }
        this.responseStream.clear();
        if (this.responseStream.isCommitted()) {
            throw new IllegalStateException("Response can't be sent");
        }
        this.setStatus(n);
        try {
            this.addHeader("Content-Type", "text/html");
            this.outStream.print("<HTML><TITLE>");
            this.outStream.print(this.status);
            this.outStream.print(" - ");
            this.outStream.print(StatusMessage.get(this.status));
            this.outStream.print("</TITLE><BODY><h1>");
            this.outStream.print(this.status);
            this.outStream.print(' ');
            this.outStream.print(this.encodeDataString(string));
            this.outStream.print("</h1></BODY></HTML>");
        }
        catch (Exception exception) {
            if (!HttpServer.errorLogDisable) {
                Logger.log(1, "HTTP0416E error sending error");
            }
            Tr.error(tc, "error sending error", exception);
        }
        this.connection.setAllowKeepAlive(false);
        this.finish(true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendError");
        }
    }

    public void addHeader(String string, String string2) {
        if (string == null || string2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addHeader: header dropped due to NULL value", new Object[]{string, string2});
            }
        } else {
            this.headerKeys.add(string);
            this.headerValues.add(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addHeader", new Object[]{string, string2});
            }
        }
    }

    public OutputStream getOutputStream() throws IOException {
        return this.outStream;
    }

    public WriteStream getStream() {
        return this.outStream;
    }

    public PrintWriter getWriter() throws IOException {
        return this.outStream.getPrintWriter();
    }

    boolean writeHeaders(WriteStream writeStream, int n) throws IOException {
        int n2;
        HttpRequest httpRequest;
        int n3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeHeaders", new Integer(n));
        }
        if ((n3 = (httpRequest = this.connection.getHttpRequest()).getVersion()) < 1000) {
            return false;
        }
        this.headersWritten = true;
        String string = httpRequest.getMethod();
        boolean bl = string != null && string.equals("HEAD");
        boolean bl2 = this.status >= 200 && this.status != 204 && this.status != 304;
        if (bl || !bl2) {
            this.responseStream.setNoBody();
        }
        writeStream.print(n3 >= 1000 ? "HTTP/1.1 " : "HTTP/1.0 ");
        writeStream.write(this.status / 100 + 48);
        writeStream.write(this.status / 10 % 10 + 48);
        writeStream.write(this.status % 10 + 48);
        writeStream.write(32);
        writeStream.print(this.getReason());
        writeStream.write(ResponseStream.CRLF);
        if (!this.headerKeys.contains("Server") && !this.connection.getHttpTransport().isRemoveServerHeader()) {
            this.writeMessageHeader(writeStream, "Server", this.connection.getHttpTransport().getServerHeader());
        }
        boolean bl3 = false;
        boolean bl4 = false;
        for (n2 = 0; n2 < this.headerKeys.size(); ++n2) {
            String string2 = (String)this.headerKeys.get(n2);
            String string3 = (String)this.headerValues.get(n2);
            if (!bl3 && string2.equalsIgnoreCase("content-type")) {
                bl3 = true;
            } else if (string2.equalsIgnoreCase("content-length")) {
                if (!bl2) continue;
                if (!bl) {
                    this.contentLength = Integer.parseInt(string3);
                }
            } else if (string2.equalsIgnoreCase("transfer-encoding")) {
                if (!bl2) continue;
                if (string3.equalsIgnoreCase("chunked")) {
                    bl4 = true;
                }
            } else if (string2.equalsIgnoreCase("server") && this.connection.getHttpTransport().isRemoveServerHeader()) continue;
            this.writeMessageHeader(writeStream, string2, string3);
        }
        n2 = 0;
        if (bl2 && !bl && this.contentLength < 0 && !bl4) {
            if (n >= 0) {
                this.writeMessageHeader(writeStream, "Content-Length", n);
                this.contentLength = n;
                this.contentLengthString = String.valueOf(n);
            } else if (n3 >= 1001) {
                writeStream.print("Transfer-Encoding: chunked\r\n");
                n2 = 1;
            }
        }
        if (this.connection.shouldSignalClose()) {
            writeStream.print("Connection: close\r\n");
        }
        writeStream.write(ResponseStream.CRLF);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeHeaders", new Boolean(n2 != 0));
        }
        return n2 != 0;
    }

    private void writeMessageHeader(WriteStream writeStream, String string, String string2) throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeMessageHeader", new Object[]{string, string2});
        }
        writeStream.print(string);
        writeStream.write(58);
        writeStream.write(32);
        writeStream.print(string2);
        writeStream.write(ResponseStream.CRLF);
    }

    private void writeMessageHeader(WriteStream writeStream, String string, int n) throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeMessageHeader", new Object[]{string, new Integer(n)});
        }
        writeStream.print(string);
        writeStream.write(58);
        writeStream.write(32);
        writeStream.print(n);
        writeStream.write(ResponseStream.CRLF);
    }

    public String encodeDataString(String string) {
        if (string == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "encodeDataString input string is null");
            }
            return "";
        }
        boolean bl = false;
        int n = string.length();
        if (n < 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "encodeDataString input string length invalid [" + n + "]");
            }
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        block12: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block12;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block12;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block12;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block12;
                }
                case '+': {
                    stringBuffer.append("&#43;");
                    continue block12;
                }
                case '(': {
                    stringBuffer.append("&#40;");
                    continue block12;
                }
                case ')': {
                    stringBuffer.append("&#41;");
                    continue block12;
                }
                case '\'': {
                    stringBuffer.append("&#39;");
                    continue block12;
                }
                case '%': {
                    stringBuffer.append("&#37;");
                    continue block12;
                }
                case ';': {
                    stringBuffer.append("&#59;");
                    continue block12;
                }
                default: {
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "encodeDataString: Input string [" + string + "], encoded result is [" + stringBuffer.toString() + "]");
        }
        return stringBuffer.toString();
    }

    public void setFlushMode(boolean bl) {
        this.responseStream.setFlushMode(bl);
    }

    protected static class StatusMessage {
        public int status;
        public String message;
        private static StatusMessage[] messages = new StatusMessage[]{new StatusMessage(100, "Continue"), new StatusMessage(101, "Switching Protocols"), new StatusMessage(200, "OK"), new StatusMessage(201, "Created"), new StatusMessage(202, "Accepted"), new StatusMessage(203, "Non-Authoritative Information"), new StatusMessage(204, "No Content"), new StatusMessage(205, "Reset Content"), new StatusMessage(206, "Partial Content"), new StatusMessage(300, "Multiple Choices"), new StatusMessage(301, "Moved Perminantly"), new StatusMessage(302, "Found"), new StatusMessage(303, "See Other"), new StatusMessage(304, "Not Modified"), new StatusMessage(305, "Use Proxy"), new StatusMessage(307, "Temporary Redirect"), new StatusMessage(400, "Bad Request"), new StatusMessage(401, "Unauthorized"), new StatusMessage(402, "Payment Required"), new StatusMessage(403, "Forbidden"), new StatusMessage(404, "Not Found"), new StatusMessage(405, "Method Not Allowed"), new StatusMessage(406, "Not Acceptable"), new StatusMessage(407, "Proxy Authentication Required"), new StatusMessage(408, "Request Timeout"), new StatusMessage(409, "Conflict"), new StatusMessage(410, "Gone"), new StatusMessage(411, "Length Required"), new StatusMessage(412, "Precondition Failed"), new StatusMessage(413, "Request Entity Too Large"), new StatusMessage(414, "Request-URI Too Long"), new StatusMessage(415, "Unsupported Media Type"), new StatusMessage(416, "Requested Range Not Satisfiable"), new StatusMessage(417, "Expectation Failed"), new StatusMessage(500, "Internal Server Error"), new StatusMessage(501, "Not Implemented"), new StatusMessage(502, "Bad Gateway"), new StatusMessage(503, "Service Unavailable"), new StatusMessage(504, "Gateway Timeout"), new StatusMessage(505, "Http Version Not Supported")};

        public static String get(int n) {
            for (int i = 0; i < messages.length; ++i) {
                if (n != StatusMessage.messages[i].status) continue;
                return StatusMessage.messages[i].message;
            }
            return "Unknown";
        }

        public StatusMessage(int n, String string) {
            this.status = n;
            this.message = string;
        }
    }
}

