/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.models.config.applicationserver.webcontainer.HTTPTransport;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.product.WASProduct;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.HttpConnection;
import com.ibm.ws.http.HttpServer;
import com.ibm.ws.http.Logger;
import com.ibm.ws.ssl.core.Constants;
import com.ibm.ws.util.TransportLogger;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Properties;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocket;

public class HttpTransport
implements Runnable,
AlarmListener {
    public static final String HOST = "Host";
    public static final String PORT = "Port";
    public static final String MAX_CONNECT_BACKLOG = "MaxConnectBacklog";
    public static final String TCP_NO_DELAY = "TcpNoDelay";
    public static final String KEEP_ALIVE_ENABLE = "KeepAliveEnabled";
    Logger logger;
    HttpServer httpserver;
    public static final String SERVER_HEADER_VALUE = "ServerHeaderValue";
    public static final String REMOVE_SERVER_HEADER = "RemoveServerHeader";
    private static TraceComponent tc = Tr.register(HttpTransport.class.getName(), "HTTP_Transport");
    private boolean removeServerHeader;
    private String serverHeader;
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private HttpServer httpServer;
    private Transport _transport;
    private Properties sslProps;
    private static final int retryDelay = 30;
    private String host;
    private int port;
    private int maxBacklog;
    private boolean tcpNoDelay;
    InetAddress ia;
    private ServerSocket serverSocket;
    private boolean alive;
    private String scheme;
    private boolean isSecure;
    private Thread acceptThread;
    private boolean prevAcceptError;
    private int AcceptErrCnt;
    private int maxKeepAliveRequests;
    private int connectionIOTimeout;
    private int connectionKeepAliveTimeout;
    private boolean isKeepAlive;

    public HttpTransport() {
        block4: {
            this.removeServerHeader = false;
            this.httpServer = null;
            this.host = null;
            this.port = -1;
            this.maxBacklog = 511;
            this.tcpNoDelay = true;
            this.ia = null;
            this.scheme = HTTP;
            this.isSecure = false;
            this.acceptThread = null;
            this.prevAcceptError = false;
            this.AcceptErrCnt = 0;
            this.isKeepAlive = true;
            this.maxKeepAliveRequests = 100;
            this.connectionKeepAliveTimeout = 5000;
            this.connectionIOTimeout = 5000;
            String string = System.getProperty("com.ibm.ws.http.ConnectionIOTimeout");
            if (string != null) {
                try {
                    this.connectionIOTimeout = Integer.parseInt(string);
                    if (HttpServer.debugEnabled) {
                        Logger.log(4, "HttpTransport: ctor: setting connectionIOTimeout to " + string);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (!HttpServer.debugEnabled) break block4;
                    Logger.log(4, "HttpTransport: ctor: " + string + " is an invalid value for connectionIOTimeout");
                }
            }
        }
        WASProduct wASProduct = new WASProduct();
        this.serverHeader = "WebSphere Application Server/" + wASProduct.getPlatform().getVersion();
    }

    public void reinitialize(Properties properties) throws Exception {
        block19: {
            if (!HttpServer.errorLogDisable) {
                Logger.log(3, "HTTP0101I Reinitializing . . .");
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "reinitialize");
            }
            this.sslProps = properties;
            try {
                this.shutdown(true);
                for (int i = 0; !this.serverSocket.isClosed() || i >= 5; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Waiting for server socket to close.");
                    }
                    Thread.sleep(200L);
                }
                this.alive = true;
                ServerSocketFactory serverSocketFactory = this.getSSLServerSocketFactory(properties);
                this.serverSocket = serverSocketFactory.createServerSocket(this.port, this.maxBacklog, this.ia);
                if (this.serverSocket != null) {
                    if (!HttpServer.errorLogDisable) {
                        Logger.log(3, "HTTP0200I  SSL is enabled for port " + this.port);
                    }
                    if (HttpServer.debugEnabled) {
                        Logger.log(4, "HttpTransport: Socket has be opened for port " + this.port + " with Security Enabled");
                    }
                    if (properties != null) {
                        boolean bl;
                        String string = properties.getProperty("com.ibm.ssl.clientAuthenticationSupported");
                        boolean bl2 = string != null && string.equals("true");
                        String string2 = properties.getProperty("com.ibm.ssl.clientAuthentication");
                        boolean bl3 = bl = string2 != null && string2.equals("true");
                        if (bl) {
                            ((SSLServerSocket)this.serverSocket).setNeedClientAuth(bl);
                        } else if (bl2) {
                            ((SSLServerSocket)this.serverSocket).setWantClientAuth(bl2);
                        }
                        String[] stringArray = this.parseEnabledCiphers(properties.getProperty("com.ibm.ssl.enabledCipherSuites"));
                        if (stringArray != null && stringArray.length > 0) {
                            ((SSLServerSocket)this.serverSocket).setEnabledCipherSuites(stringArray);
                        } else {
                            String[] stringArray2 = ((SSLServerSocket)this.serverSocket).getSupportedCipherSuites();
                            String string3 = properties.getProperty("com.ibm.ssl.securityLevel");
                            if (stringArray2 != null && string3 != null) {
                                stringArray2 = HttpTransport.adjustSupportedCiphersToSecurityLevel(stringArray2, string3);
                            }
                            if (stringArray2 != null && stringArray2.length > 0) {
                                ((SSLServerSocket)this.serverSocket).setEnabledCipherSuites(stringArray2);
                            }
                        }
                    }
                    this.acceptThread = new Thread((Runnable)this, this.serverSocket.toString());
                    this.acceptThread.setDaemon(true);
                    this.acceptThread.start();
                }
            }
            catch (Exception exception) {
                Tr.error(tc, exception.toString());
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.http.HttpTransport.reinitialize", "169", this);
                if (!tc.isDebugEnabled()) break block19;
                Tr.debug(tc, "Exception reinitialization SOAP server socket.", new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reinitialize");
        }
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpTransport: Reinitialization has completed");
        }
    }

    public void alarm(Object object) {
        block3: {
            try {
                this.initialize(this.httpServer, this._transport, this.sslProps);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception from calling initialize", exception);
                }
                this.alive = false;
                AlarmManager.createNonDeferrable(30000L, this);
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "...will call initialize again in 30 secs");
            }
        }
    }

    public void initialize(HttpServer httpServer, Transport transport2) throws Exception {
        this.initialize(httpServer, transport2, new Properties());
    }

    public void initialize(HttpServer httpServer, Transport transport2, Properties properties) throws Exception {
        if (!HttpServer.errorLogDisable) {
            Logger.log(3, "HTTP0101I Initializing . . .");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        this.httpServer = httpServer;
        this._transport = transport2;
        this.sslProps = properties;
        this.alive = true;
        if (this.host != null && this.host.length() != 0 && !this.host.equals("*")) {
            this.ia = InetAddress.getByName(this.host);
            if (HttpServer.debugEnabled) {
                Logger.log(4, "HttpTransport: Determined Internet Address " + this.ia + "from host " + this.host);
            }
        }
        if (transport2 != null && ((HTTPTransport)transport2).isSslEnabled()) {
            this.scheme = HTTPS;
            this.isSecure = true;
            if (this.port == -1) {
                this.port = 443;
            }
            ServerSocketFactory serverSocketFactory = this.getSSLServerSocketFactory(properties);
            this.serverSocket = serverSocketFactory.createServerSocket(this.port, this.maxBacklog, this.ia);
            if (this.serverSocket != null) {
                if (!HttpServer.errorLogDisable) {
                    Logger.log(3, "HTTP0200I  SSL is enabled for port " + this.port);
                }
                if (HttpServer.debugEnabled) {
                    Logger.log(4, "HttpTransport: Socket has be opened for port " + this.port + " with Security Enabled");
                }
                if (properties != null) {
                    boolean bl;
                    String string = properties.getProperty("com.ibm.ssl.clientAuthenticationSupported");
                    boolean bl2 = string != null && string.equals("true");
                    String string2 = properties.getProperty("com.ibm.ssl.clientAuthentication");
                    boolean bl3 = bl = string2 != null && string2.equals("true");
                    if (bl) {
                        ((SSLServerSocket)this.serverSocket).setNeedClientAuth(bl);
                    } else if (bl2) {
                        ((SSLServerSocket)this.serverSocket).setWantClientAuth(bl2);
                    }
                    String[] stringArray = this.parseEnabledCiphers(properties.getProperty("com.ibm.ssl.enabledCipherSuites"));
                    if (stringArray != null && stringArray.length > 0) {
                        ((SSLServerSocket)this.serverSocket).setEnabledCipherSuites(stringArray);
                    } else {
                        String[] stringArray2 = ((SSLServerSocket)this.serverSocket).getSupportedCipherSuites();
                        String string3 = properties.getProperty("com.ibm.ssl.securityLevel");
                        if (stringArray2 != null && string3 != null) {
                            stringArray2 = HttpTransport.adjustSupportedCiphersToSecurityLevel(stringArray2, string3);
                        }
                        if (stringArray2 != null && stringArray2.length > 0) {
                            ((SSLServerSocket)this.serverSocket).setEnabledCipherSuites(stringArray2);
                        }
                    }
                }
            }
        } else {
            String string;
            String string4;
            if (this.port == -1) {
                this.port = 80;
            }
            if ((string4 = System.getProperty(string = "com.ibm.ws.http.socketProps." + this.port)) != null) {
                Properties properties2 = new Properties();
                properties2.load(new FileInputStream(string4));
                this.serverSocket = com.ibm.ws.util.ServerSocketFactory.getInstance(this.port, this.maxBacklog, this.ia, this, properties2);
                if (this.serverSocket != null && !HttpServer.errorLogDisable) {
                    Logger.log(3, "HTTP0201I  SSL is not enabled for port " + this.port);
                }
                if (HttpServer.debugEnabled) {
                    Logger.log(4, "HttpTransport: Socket has been opened for port " + this.port);
                }
            } else {
                this.serverSocket = new ServerSocket(this.port, this.maxBacklog, this.ia);
                if (this.serverSocket != null && !HttpServer.errorLogDisable) {
                    Logger.log(3, "HTTP0202I  SSL is not enabled for port " + this.port);
                }
                if (HttpServer.debugEnabled) {
                    Logger.log(4, "HttpTransport: Socket has been opened for port " + this.port);
                }
            }
        }
        this.acceptThread = new Thread((Runnable)this, this.serverSocket.toString());
        this.acceptThread.setDaemon(true);
        this.acceptThread.start();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpTransport: Initialization has completed");
        }
    }

    private String[] parseEnabledCiphers(String string) {
        if (string != null) {
            return string.split("\\s");
        }
        return null;
    }

    public static String[] adjustSupportedCiphersToSecurityLevel(String[] stringArray, String string) {
        return Constants.adjustSupportedCiphersToSecurityLevel(stringArray, string);
    }

    public static String convertCipherListToString(String[] stringArray) {
        return Constants.convertCipherListToString(stringArray);
    }

    private ServerSocketFactory getSSLServerSocketFactory(Properties properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLServerSocketFactory");
        }
        Class<?> clazz = Class.forName("com.ibm.websphere.ssl.JSSEHelper");
        Object obj = clazz.newInstance();
        Method method2 = clazz.getMethod("getSSLServerSocketFactory", Properties.class);
        Object object = method2.invoke(obj, properties);
        if (object != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSSLServerSocketFactory");
            }
            return (ServerSocketFactory)object;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLServerSocketFactory");
        }
        throw new IllegalArgumentException("Could not get the server socket factory.");
    }

    public void shutdown(boolean bl) {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "shutdown");
            }
            this.alive = false;
            try {
                InetAddress inetAddress = this.serverSocket.getInetAddress();
                try {
                    if (inetAddress != null) {
                        Socket socket = new Socket(inetAddress, this.serverSocket.getLocalPort());
                    } else {
                        Socket socket = new Socket("127.0.0.1", this.serverSocket.getLocalPort());
                    }
                }
                catch (Exception exception) {
                    if (!HttpServer.errorLogDisable) {
                        Logger.log(0, "HTTP0104C Local Connection Failed");
                    }
                    FFDCFilter.processException(exception, "com.ibm.ws.http.HttpTransport.run", "125");
                    this.acceptThread.interrupt();
                }
                this.acceptThread.join(10000L);
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException(interruptedException, "com.ibm.ws.http.HttpTransport.run", "134");
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "shutdown", interruptedException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdown");
        }
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpTransport: Shutdown has completed");
        }
    }

    public boolean isAlive() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpTransport: Determine if socket is alive");
        }
        return this.alive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block38: {
            if (HttpServer.debugEnabled) {
                Logger.log(4, "HttpTransport: Running Thread");
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "run");
            }
            while (this.alive) {
                Socket socket;
                block36: {
                    socket = null;
                    try {
                        socket = this.serverSocket.accept();
                        this.prevAcceptError = false;
                        if (HttpServer.debugEnabled) {
                            Logger.log(4, "HttpTransport: Accept Socket");
                        }
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException(iOException, "com.ibm.ws.http.HttpTransport.run", "153");
                        if (!this.alive) break block36;
                        if (!HttpServer.errorLogDisable) {
                            Logger.log(1, "HTTP0102E Server Socket Accept Failed");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "server socket accept failure", iOException);
                        }
                        if (iOException instanceof SocketException && iOException.toString().indexOf("EDC5122I") > 0) {
                            block37: {
                                try {
                                    this.serverSocket.close();
                                }
                                catch (Exception exception) {
                                    if (!tc.isDebugEnabled()) break block37;
                                    Tr.debug(tc, "Closing serverSocket, ", exception);
                                }
                            }
                            this.alive = false;
                            AlarmManager.createNonDeferrable(30000L, this);
                            if (!tc.isDebugEnabled()) break;
                            Tr.debug(tc, "...will call initialize again in 30 secs");
                            break;
                        }
                        if (this.prevAcceptError) {
                            if (++this.AcceptErrCnt > 50) {
                                try {
                                    Thread.sleep(3000L);
                                    this.AcceptErrCnt = 1;
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                        this.prevAcceptError = true;
                        this.AcceptErrCnt = 1;
                    }
                }
                if (socket == null) continue;
                if (this.alive) {
                    HttpConnection httpConnection = null;
                    int n = -1;
                    String string = "unknown";
                    if (TransportLogger.debugEnabled()) {
                        n = socket.getPort();
                        string = socket.getInetAddress().getHostAddress();
                        TransportLogger.debug("HttpTransport.run():  accept: remotePort=[" + n + "] remoteAddress=[" + string + "]");
                    }
                    try {
                        httpConnection = this.httpServer.allocateConnection();
                        httpConnection.init(this, socket);
                        HttpConnection httpConnection2 = httpConnection;
                        synchronized (httpConnection2) {
                            try {
                                this.httpServer.handleConnection(httpConnection);
                            }
                            catch (Throwable throwable) {
                                httpConnection.setAborted(true);
                                httpConnection.cleanup();
                                throw throwable;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.http.HttpTransport.run", "175");
                        if (TransportLogger.debugEnabled()) {
                            TransportLogger.debug("HttpTransport.run(): error handling the connection " + throwable.getMessage() + " remotePort=[" + n + "] remoteAddress=[" + string + "]");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "failure handling connection", throwable);
                        }
                        if (!HttpServer.errorLogDisable) {
                            Logger.log(1, "HTTP0103E Could not handle Connection");
                        }
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {
                            if (HttpServer.errorLogDisable) continue;
                            Logger.log(1, "HTTP0104E Could not close Socket");
                        }
                        continue;
                    }
                }
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    if (HttpServer.errorLogDisable) continue;
                    Logger.log(1, "HTTP0105E Could not close Socket");
                }
            }
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException(iOException, "com.ibm.ws.http.HttpTransport.run", "198");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "error closing server socket", iOException);
                    }
                    if (HttpServer.errorLogDisable) break block38;
                    Logger.log(1, "HTTP0106E Could not close Socket");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "run");
        }
    }

    public boolean isSecure() {
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpTransport: Determine if is secure Connection");
        }
        return this.isSecure;
    }

    public String getScheme() {
        return this.scheme;
    }

    public HttpServer getHttpServer() {
        return this.httpServer;
    }

    public void setHttpServer(HttpServer httpServer) {
        this.httpServer = httpServer;
        if (HttpServer.debugEnabled) {
            Logger.log(4, "HttpTransport: Setting HttpServer");
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(String string) {
        this.port = Integer.parseInt(string);
    }

    public int getMaxBacklog() {
        return this.maxBacklog;
    }

    public void setMaxBacklog(String string) {
        this.maxBacklog = Integer.parseInt(string);
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(String string) {
        this.tcpNoDelay = this.getBooleanValue(TCP_NO_DELAY, string, true);
    }

    private boolean getBooleanValue(String string, String string2, boolean bl) {
        if (string2.equalsIgnoreCase("true")) {
            Tr.debug(tc, string + " set to true");
            if (HttpServer.debugEnabled) {
                Logger.log(4, "HttpTransport: " + string + " set to true");
            }
            return true;
        }
        if (string2.equalsIgnoreCase("false")) {
            Tr.debug(tc, string + " set to false");
            if (HttpServer.debugEnabled) {
                Logger.log(4, "HttpTransport: " + string + " set to false");
            }
            return false;
        }
        Tr.warning(tc, "invalid value for " + string + ": '" + string2 + "'; setting to " + bl);
        if (!HttpServer.errorLogDisable) {
            Logger.log(2, "HTTP0309W invalid value for " + string + ": '" + string2 + "'; setting to " + bl);
        }
        return bl;
    }

    public int getConnectionIOTimeout() {
        return this.connectionIOTimeout;
    }

    public int getConnectionKeepAliveTimeout() {
        return this.connectionKeepAliveTimeout;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setConnectionIOTimeout(int n) {
        this.connectionIOTimeout = n * 1000;
    }

    public void setConnectionKeepAliveTimeout(int n) {
        this.connectionKeepAliveTimeout = n * 1000;
    }

    public void setMaxKeepAliveRequests(int n) {
        this.maxKeepAliveRequests = n;
    }

    public boolean isKeepAlive() {
        return this.isKeepAlive;
    }

    public void setIsKeepAlive(boolean bl) {
        this.isKeepAlive = bl;
    }

    public String getServerHeader() {
        return this.serverHeader;
    }

    public void setServerHeader(String string) {
        if (string != null) {
            this.serverHeader = string;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setServerHeader: " + string);
        }
    }

    public void setRemoveServerHeader(boolean bl) {
        this.removeServerHeader = bl;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setRemoveServerHeader: " + bl);
        }
    }

    public boolean isRemoveServerHeader() {
        return this.removeServerHeader;
    }
}

