/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundServiceContextImpl;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;

public class HttpISCBodyReadCallback
implements TCPReadCompletedCallback {
    private static final TraceComponent tc = Tr.register(HttpISCBodyReadCallback.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static HttpISCBodyReadCallback myInstance = null;

    private HttpISCBodyReadCallback() {
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new HttpISCBodyReadCallback();
        }
    }

    public static final HttpISCBodyReadCallback getRef() {
        if (null == myInstance) {
            HttpISCBodyReadCallback.createSingleton();
        }
        return myInstance;
    }

    public void complete(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "complete() called: vc=" + virtualConnection);
        }
        HttpInboundServiceContextImpl httpInboundServiceContextImpl = (HttpInboundServiceContextImpl)virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPISC);
        httpInboundServiceContextImpl.continueRead();
    }

    public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
        HttpInboundServiceContextImpl httpInboundServiceContextImpl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "error() called: vc=" + virtualConnection + " ioe=" + iOException);
        }
        if ((httpInboundServiceContextImpl = (HttpInboundServiceContextImpl)virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPISC)).canceledRead()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Ignoring error callback on canceled read");
            }
            httpInboundServiceContextImpl.resetCanceledRead();
            return;
        }
        httpInboundServiceContextImpl.setPersistent(false);
        if (null != httpInboundServiceContextImpl.getAppReadCallback()) {
            httpInboundServiceContextImpl.getAppReadCallback().error(virtualConnection, (Throwable)iOException);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Error on the request body read but no app cb");
        }
    }
}

