/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundServiceContextImpl;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpServiceContext;

public class HttpISCWriteErrorCallback
implements InterChannelCallback {
    private static final TraceComponent tc = Tr.register(HttpISCWriteErrorCallback.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static HttpISCWriteErrorCallback myInstance = null;

    private HttpISCWriteErrorCallback() {
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new HttpISCWriteErrorCallback();
        }
    }

    public static final HttpISCWriteErrorCallback getRef() {
        if (null == myInstance) {
            HttpISCWriteErrorCallback.createSingleton();
        }
        return myInstance;
    }

    public void complete(VirtualConnection virtualConnection) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "complete() called: vc=" + virtualConnection);
        }
        HttpInboundServiceContextImpl httpInboundServiceContextImpl = (HttpInboundServiceContextImpl)virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPISC);
        httpInboundServiceContextImpl.finishSendError();
    }

    public void error(VirtualConnection virtualConnection, Throwable throwable) {
        HttpInboundServiceContextImpl httpInboundServiceContextImpl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "error() called: vc=" + virtualConnection + " t=" + throwable);
        }
        if ((httpInboundServiceContextImpl = (HttpInboundServiceContextImpl)virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPISC)).canceledWrite()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Ignoring error callback on canceled write");
            }
            httpInboundServiceContextImpl.resetCanceledWrite();
            return;
        }
        if (httpInboundServiceContextImpl.getHttpConfig().isErrorLoggingEnabled()) {
            httpInboundServiceContextImpl.getHttpConfig().getHttpLogger().log(HttpConstants.LOG_WARN, "The write of the response failed from a socket exception.", (HttpServiceContext)httpInboundServiceContextImpl);
        }
        httpInboundServiceContextImpl.finishSendError();
    }
}

