/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundLink;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundServiceContextImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.VirtualConnection;

public class HttpIgnoreBodyCallback
implements InterChannelCallback {
    private static final TraceComponent tc = Tr.register(HttpIgnoreBodyCallback.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static HttpIgnoreBodyCallback myInstance = null;

    private HttpIgnoreBodyCallback() {
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new HttpIgnoreBodyCallback();
        }
    }

    public static final HttpIgnoreBodyCallback getRef() {
        if (null == myInstance) {
            HttpIgnoreBodyCallback.createSingleton();
        }
        return myInstance;
    }

    public void complete(VirtualConnection virtualConnection) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "complete() called: " + virtualConnection);
        }
        if (null == virtualConnection) {
            return;
        }
        Object v = virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPISC);
        if (null == v) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR: null ISC in complete()");
            }
            return;
        }
        HttpInboundServiceContextImpl httpInboundServiceContextImpl = (HttpInboundServiceContextImpl)v;
        try {
            VirtualConnection virtualConnection2 = null;
            do {
                WsByteBuffer wsByteBuffer;
                if (null == (wsByteBuffer = httpInboundServiceContextImpl.getRequestBodyBuffer())) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Reached end of the body being purged");
                    }
                    httpInboundServiceContextImpl.getLink().close(virtualConnection, null);
                    return;
                }
                wsByteBuffer.release();
                virtualConnection2 = httpInboundServiceContextImpl.getRequestBodyBuffer(this, false);
            } while (null != virtualConnection2);
        }
        catch (Exception exception) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception purging request body: " + exception);
            }
            httpInboundServiceContextImpl.getLink().close(virtualConnection, exception);
        }
    }

    public void error(VirtualConnection virtualConnection, Throwable throwable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "error() called: " + virtualConnection);
        }
        if (null == virtualConnection) {
            return;
        }
        Object v = virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPICL);
        if (null == v) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR: null ICL in error()");
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Error occurring while purging body: " + throwable);
        }
        ((HttpInboundLink)((Object)v)).close(virtualConnection, (Exception)throwable);
    }
}

