/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.impl.HttpChannelConfig;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundChannelFactory;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundLink;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundServiceContextImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.Discriminator;
import com.ibm.wsspi.channel.base.InboundProtocolChannel;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.genericbnf.exception.MalformedMessageException;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.util.Map;

public class HttpInboundChannel
extends InboundProtocolChannel
implements Discriminator {
    private static final TraceComponent tc = Tr.register(HttpInboundChannel.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final int STATE_STOPPED = 0;
    private static final int STATE_STOPPING = 1;
    private static final int STATE_RUNNING = 2;
    private HttpObjectFactory myObjectFactory = null;
    private HttpInboundChannelFactory channelFactory = null;
    private HttpChannelConfig myConfig = null;
    private int myState = 0;
    private boolean limitedMessageSize = false;

    public HttpInboundChannel(ChannelData channelData, HttpInboundChannelFactory httpInboundChannelFactory, HttpObjectFactory httpObjectFactory) {
        super(channelData);
        this.channelFactory = httpInboundChannelFactory;
        this.myObjectFactory = httpObjectFactory;
        this.update(channelData);
        if (this.myConfig.isControlRegion()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HttpInboundChannel ctor", "On z/OS, defaulting to limited message sizes");
            }
            this.limitedMessageSize = true;
            Map map = channelData.getPropertyBag();
            String string = (String)map.get("UNLIMITED_HTTP_MESSAGE_SIZE");
            if (string != null && string.equalsIgnoreCase("TRUE")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HttpInboundChannel ctor", "Unlimited messages explicitly set on channel: " + this.getConfig().getName());
                }
                this.limitedMessageSize = false;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Created channel: " + this.getConfig().getName() + " " + (Object)((Object)this));
        }
    }

    public final Discriminator getDiscriminator() {
        return this;
    }

    public final Class getApplicationInterface() {
        return HttpInboundServiceContext.class;
    }

    public final Class getDeviceInterface() {
        return TCPConnectionContext.class;
    }

    public final Channel getChannel() {
        return this;
    }

    public final Class getDiscriminatoryDataType() {
        return WsByteBuffer.class;
    }

    public final Class getDiscriminatoryType() {
        return HttpRequestMessage.class;
    }

    public final HttpChannelConfig getHttpConfig() {
        return this.myConfig;
    }

    public final void setHttpConfig(HttpChannelConfig httpChannelConfig) {
        this.myConfig = httpChannelConfig;
    }

    public final HttpInboundChannelFactory getFactory() {
        return this.channelFactory;
    }

    public final HttpObjectFactory getObjectFactory() {
        return this.myObjectFactory;
    }

    public final int getWeight() {
        return this.getConfig().getDiscriminatorWeight();
    }

    public ConnectionLink getConnectionLink(VirtualConnection virtualConnection) {
        HttpInboundLink httpInboundLink = (HttpInboundLink)((Object)virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPICL));
        if (null == httpInboundLink) {
            httpInboundLink = new HttpInboundLink(this, virtualConnection);
        }
        return httpInboundLink;
    }

    public boolean isRunning() {
        return 2 == this.myState;
    }

    public boolean isStopping() {
        return 2 != this.myState;
    }

    public boolean isStopped() {
        return 0 == this.myState;
    }

    private void setState(int n) {
        this.myState = n;
    }

    public void start() {
        this.setState(2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Starting up channel: " + this.getConfig().getName() + " " + (Object)((Object)this));
        }
    }

    public void stop(long l) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Stopping channel with (" + l + ") : " + this.getConfig().getName() + " " + (Object)((Object)this));
        }
        if (0L == l) {
            this.setState(0);
        } else {
            this.setState(1);
        }
    }

    public void init() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Initializing channel: " + this.getConfig().getName() + " " + (Object)((Object)this));
        }
    }

    public void destroy() {
        this.setState(0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Destroying channel: " + this.getConfig().getName() + " " + (Object)((Object)this));
        }
        this.channelFactory.destroyChannel(this.getConfig().getName());
        this.channelFactory = null;
        this.myConfig = null;
        this.myObjectFactory = null;
    }

    public int discriminate(VirtualConnection virtualConnection, Object object) {
        WsByteBuffer[] wsByteBufferArray;
        if (this.isStopped()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Channel stopped, ignoring discriminate on: " + virtualConnection);
            }
            return 0;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Discriminating against " + virtualConnection + " with " + object);
        }
        if (null == (wsByteBufferArray = (WsByteBuffer[])object) || 0 == wsByteBufferArray.length) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No data provided, returning MAYBE");
            }
            return -1;
        }
        HttpInboundLink httpInboundLink = (HttpInboundLink)((Object)virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPICL));
        if (null == httpInboundLink) {
            httpInboundLink = new HttpInboundLink(this, virtualConnection);
        } else {
            httpInboundLink.init(virtualConnection, this);
        }
        HttpInboundServiceContextImpl httpInboundServiceContextImpl = (HttpInboundServiceContextImpl)httpInboundLink.getChannelAccessor();
        boolean bl = false;
        for (int i = 0; i < wsByteBufferArray.length && null != wsByteBufferArray[i]; ++i) {
            WsByteBuffer wsByteBuffer = wsByteBufferArray[i];
            int n = wsByteBuffer.limit();
            int n2 = wsByteBuffer.position();
            httpInboundServiceContextImpl.enableBufferModification();
            httpInboundServiceContextImpl.configurePostReadBuffer(wsByteBuffer);
            try {
                bl = httpInboundServiceContextImpl.getRequestImpl().parseLineDiscrim(wsByteBuffer);
            }
            catch (MalformedMessageException malformedMessageException) {
                wsByteBuffer.limit(n);
                wsByteBuffer.position(n2);
                httpInboundLink.destroy(null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Discriminate returning NO for non-HTTP msg");
                }
                return 0;
            }
            catch (Exception exception) {
                wsByteBuffer.limit(n);
                wsByteBuffer.position(n2);
                httpInboundLink.destroy(null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unexpected exception [" + exception + "]");
                    Tr.debug(tc, "Discriminate returning NO");
                }
                return 0;
            }
            httpInboundServiceContextImpl.setOldLimit(wsByteBuffer.limit());
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Discrimination returning YES");
                }
                virtualConnection.getStateMap().put(CallbackIDs.CALLBACK_HTTPICL, httpInboundLink);
                return 1;
            }
            wsByteBuffer.limit(n);
            wsByteBuffer.position(n2);
        }
        virtualConnection.getStateMap().put(CallbackIDs.CALLBACK_HTTPICL, httpInboundLink);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning MAYBE for " + virtualConnection);
        }
        return -1;
    }

    public void cleanUpState(VirtualConnection virtualConnection) {
        HttpInboundLink httpInboundLink = (HttpInboundLink)((Object)virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPICL));
        if (null != httpInboundLink) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing cleanup after discrim MAYBE");
            }
            httpInboundLink.destroy(null);
        }
    }

    public void update(ChannelData channelData) {
        this.setHttpConfig(new HttpChannelConfig(channelData));
        super.setConfig(channelData);
    }

    protected boolean isMessageSizeLimited() {
        return this.limitedMessageSize;
    }
}

