/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.channelservice.InboundTransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelFactory;
import com.ibm.websphere.models.config.channelservice.channels.HTTPInboundChannel;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundChannel;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundChannelFactory;
import com.ibm.ws.http.channel.inbound.impl.WSHttpOutboundDefinition;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.WSChannelFactory;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.OutboundChannelDefinition;
import com.ibm.wsspi.channel.framework.exception.InvalidChannelFactoryException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

public class WSHttpInboundChannelFactory
extends HttpInboundChannelFactory
implements WSChannelFactory {
    private static final TraceComponent tc = Tr.register(WSHttpInboundChannelFactory.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final String ZOS_DEFAULT_MESSAGE_SIZE = "10485760";
    private static final String ZOS_DEFAULT_LARGE_MESSAGE_SIZE = "104857600";
    private static String configuredZOSLargeMessageSize = "10485760";
    private boolean messageSizesSetOnFactoryConfig = false;
    private static int bitmode = 31;
    private static boolean limiting64BitMessageSize = false;
    private static String configuredZOSLargeMessageSize64Bit = "-1";

    public WSHttpInboundChannelFactory() throws InvalidChannelFactoryException {
        if (PlatformHelperFactory.getPlatformHelper().isControlJvm()) {
            try {
                Object object;
                try {
                    object = System.getProperty("com.ibm.vm.bitmode");
                    bitmode = Integer.parseInt((String)object);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WSHttpInboundChannelFactory", "Unknown JVM bitmode; assuming 31-bit");
                    }
                    bitmode = 31;
                }
                object = AdminServiceImpl.getPlatformUtils();
                if (object != null) {
                    if (bitmode == 64) {
                        String string = object.getenv("protocol_http_large_data_inbound_buffer_64bit");
                        if (string != null && !string.equals("")) {
                            configuredZOSLargeMessageSize64Bit = new String("" + Long.parseLong(string) * 0x100000L);
                            limiting64BitMessageSize = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "WSHttpInboundChannelFactory", "protocol_http_large_data_inbound_buffer_64bit set via getenv to: " + configuredZOSLargeMessageSize64Bit);
                            }
                        }
                    } else {
                        configuredZOSLargeMessageSize = object.getenv("protocol_http_large_data_inbound_buffer");
                        if (configuredZOSLargeMessageSize != null && !configuredZOSLargeMessageSize.equals("")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "WSHttpInboundChannelFactory", "protocol_http_large_data_inbound_buffer set via getenv to: " + configuredZOSLargeMessageSize);
                            }
                        } else {
                            configuredZOSLargeMessageSize = ZOS_DEFAULT_MESSAGE_SIZE;
                        }
                    }
                }
            }
            catch (Exception exception) {
                configuredZOSLargeMessageSize = ZOS_DEFAULT_MESSAGE_SIZE;
                configuredZOSLargeMessageSize64Bit = "-1";
                limiting64BitMessageSize = false;
                FFDCFilter.processException(exception, this.getClass().getName() + ".createFactoryConfigurationMap", "150");
            }
        }
    }

    public Channel createChannel(ChannelData channelData) {
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        if (platformHelper.isZOS()) {
            channelData.getPropertyBag().put("RunningOnZOS", "true");
            if (platformHelper.isBaseServantJvm()) {
                channelData.getPropertyBag().put("ServantRegion", "true");
                channelData.getPropertyBag().put("MaxKeepAliveRequests", "-1");
            } else if (platformHelper.isControlJvm()) {
                channelData.getPropertyBag().put("ControlRegion", "true");
                if (bitmode == 64) {
                    Map map = channelData.getPropertyBag();
                    if (limiting64BitMessageSize) {
                        String string = (String)map.get("UNLIMITED_HTTP_MESSAGE_SIZE");
                        if (string == null || !string.equalsIgnoreCase("TRUE")) {
                            map.put("UNLIMITED_HTTP_MESSAGE_SIZE", "FALSE");
                        }
                    } else {
                        map.put("UNLIMITED_HTTP_MESSAGE_SIZE", "TRUE");
                    }
                }
                if (!this.messageSizesSetOnFactoryConfig) {
                    this.messageSizesSetOnFactoryConfig = true;
                    if (bitmode != 64) {
                        this.getConfig().setMessageSize(ZOS_DEFAULT_MESSAGE_SIZE);
                        this.getConfig().setLargerBufferSize(configuredZOSLargeMessageSize);
                    } else {
                        this.getConfig().setMessageSize(configuredZOSLargeMessageSize64Bit);
                        this.getConfig().setLargerBufferSize(configuredZOSLargeMessageSize64Bit);
                    }
                }
            }
        }
        return new HttpInboundChannel(channelData, this, this.getObjectFactory());
    }

    public Map createFactoryConfigurationMap(TransportChannelFactory transportChannelFactory, ChannelFrameworkService channelFrameworkService) {
        EList eList;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        if (platformHelper.isZOS()) {
            hashMap.put("MessageSizeLimit", ZOS_DEFAULT_MESSAGE_SIZE);
            hashMap.put("LargeMessageSize", ZOS_DEFAULT_LARGE_MESSAGE_SIZE);
        }
        if (null != (eList = transportChannelFactory.getProperties())) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                hashMap.put(property.getName(), property.getValue());
            }
        }
        return hashMap;
    }

    public Map createChannelConfigurationMap(TransportChannel transportChannel, ChannelFrameworkService channelFrameworkService) {
        EList eList;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HTTPInboundChannel hTTPInboundChannel = (HTTPInboundChannel)transportChannel;
        if (hTTPInboundChannel.isSetMaximumPersistentRequests()) {
            hashMap.put("MaxKeepAliveRequests", String.valueOf(hTTPInboundChannel.getMaximumPersistentRequests()));
        }
        if (hTTPInboundChannel.isSetKeepAlive()) {
            hashMap.put("defaultToOutgoingKeepAlive", String.valueOf(hTTPInboundChannel.isKeepAlive()));
        }
        if (hTTPInboundChannel.isSetPersistentTimeout()) {
            hashMap.put("persistTimeout", String.valueOf(hTTPInboundChannel.getPersistentTimeout()));
        }
        if (hTTPInboundChannel.isSetReadTimeout()) {
            hashMap.put("readTimeout", String.valueOf(hTTPInboundChannel.getReadTimeout()));
        }
        if (hTTPInboundChannel.isSetWriteTimeout()) {
            hashMap.put("writeTimeout", String.valueOf(hTTPInboundChannel.getWriteTimeout()));
        }
        if (hTTPInboundChannel.isSetEnableLogging()) {
            hashMap.put("loggingDisable", String.valueOf(!hTTPInboundChannel.isEnableLogging()));
        }
        if (null != (eList = hTTPInboundChannel.getProperties())) {
            VariableMap variableMap = (VariableMap)channelFrameworkService.lookupService(VariableMap.class);
            Iterator iterator = eList.iterator();
            Property property = null;
            while (iterator.hasNext()) {
                property = (Property)iterator.next();
                property = this.checkVarExpansion(property, variableMap);
                hashMap.put(property.getName(), property.getValue());
            }
        }
        return hashMap;
    }

    private Property checkVarExpansion(Property property, VariableMap variableMap) {
        if (null == variableMap) {
            return property;
        }
        String string = property.getName();
        try {
            if ("accessLogFileName".equals(string) || "errorLogFileName".equals(string)) {
                property.setValue(variableMap.expand(property.getValue()));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException(illegalArgumentException, this.getClass().getName() + ".checkVarExpansion", "155");
        }
        return property;
    }

    public OutboundChannelDefinition getOutboundChannelDefinition(Map map) {
        return new WSHttpOutboundDefinition(map);
    }

    public String determineAcceptorID(InboundTransportChannel inboundTransportChannel) {
        return null;
    }
}

