/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.matcher.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.QuickCaseInsensitiveMatcher;
import com.ibm.ws.http.channel.values.impl.CookieCommentData;
import com.ibm.ws.http.channel.values.impl.CookieCommentURL;
import com.ibm.ws.http.channel.values.impl.CookieData;
import com.ibm.ws.http.channel.values.impl.CookieDiscard;
import com.ibm.ws.http.channel.values.impl.CookieDomainData;
import com.ibm.ws.http.channel.values.impl.CookieExpiresData;
import com.ibm.ws.http.channel.values.impl.CookieHttpOnlyData;
import com.ibm.ws.http.channel.values.impl.CookieMaxAgeData;
import com.ibm.ws.http.channel.values.impl.CookiePathData;
import com.ibm.ws.http.channel.values.impl.CookiePort;
import com.ibm.ws.http.channel.values.impl.CookieSecureData;
import com.ibm.ws.http.channel.values.impl.CookieVersionData;
import java.util.Iterator;

public class CookieDataMatcher
extends QuickCaseInsensitiveMatcher {
    private static final TraceComponent tc = Tr.register(CookieDataMatcher.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    public static final CookieData cookieVersion = new CookieVersionData();
    public static final CookieData cookieDomain = new CookieDomainData();
    public static final CookieData cookieMaxAge = new CookieMaxAgeData();
    public static final CookieData cookiePath = new CookiePathData();
    public static final CookieData cookieSecure = new CookieSecureData();
    public static final CookieData cookieExpires = new CookieExpiresData();
    public static final CookieData cookieComment = new CookieCommentData();
    public static final CookieData cookieDiscard = new CookieDiscard();
    public static final CookieData cookiePort = new CookiePort();
    public static final CookieData cookieCommentURL = new CookieCommentURL();
    public static final CookieData cookieHttpOnly = new CookieHttpOnlyData();
    private static CookieDataMatcher myInstance = null;

    private CookieDataMatcher() {
        super(true);
        this.init();
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new CookieDataMatcher();
        }
    }

    public static final CookieDataMatcher getRef() {
        if (null == myInstance) {
            CookieDataMatcher.createSingleton();
        }
        return myInstance;
    }

    public CookieData matchCookie(String string) {
        return (CookieData)super.match(string);
    }

    public CookieData matchCookie(StringBuffer stringBuffer) {
        return (CookieData)super.match(stringBuffer);
    }

    public CookieData matchCookie(byte[] byArray) {
        return (CookieData)super.match(byArray);
    }

    public void init() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Intializing the CookieData matcher");
        }
        Iterator iterator = CookieData.getAllKeys().iterator();
        CookieData cookieData = null;
        while (iterator.hasNext()) {
            cookieData = (CookieData)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Storing key: " + cookieData);
            }
            super.add(cookieData);
        }
        super.init();
    }

    public static void main(String[] stringArray) {
        System.out.println("Started");
        CookieDataMatcher cookieDataMatcher = CookieDataMatcher.getRef();
        System.out.println("matching...");
        System.out.println();
        System.out.println("Following should find matches...");
        System.out.println("Matching (String) Version " + cookieDataMatcher.matchCookie("Version"));
        String string = "PaTH";
        System.out.println("Matching (StringBuffer) " + string + " " + cookieDataMatcher.matchCookie(new StringBuffer(string)));
        string = "EXPIRES";
        System.out.println("Matching (byte[]) " + string + " " + cookieDataMatcher.matchCookie(string.getBytes()));
        string = "$path";
        System.out.println();
        System.out.println("Following should return null responses...");
        string = "WhoDare";
        System.out.println("Matching (StringBuffer) " + string + " " + cookieDataMatcher.matchCookie(new StringBuffer(string)));
        string = "$whodat";
        System.out.println("Matching (byte[]) " + string + " " + cookieDataMatcher.matchCookie(string.getBytes()));
    }
}

