/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.outbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundServiceContextImpl;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.exception.ExpectationFailedException;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;

public class HttpOSC100ReadCallback
implements TCPReadCompletedCallback {
    private static final TraceComponent tc = Tr.register(HttpOSC100ReadCallback.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static HttpOSC100ReadCallback myInstance = null;

    private HttpOSC100ReadCallback() {
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new HttpOSC100ReadCallback();
        }
    }

    public static final HttpOSC100ReadCallback getRef() {
        if (null == myInstance) {
            HttpOSC100ReadCallback.createSingleton();
        }
        return myInstance;
    }

    private boolean handleNewData(HttpOutboundServiceContextImpl httpOutboundServiceContextImpl, VirtualConnection virtualConnection) {
        if (!httpOutboundServiceContextImpl.headersParsed()) {
            try {
                return httpOutboundServiceContextImpl.parseMessage();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, this.getClass().getName() + ".handleNewData", "73", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught exception: " + exception.getMessage());
                }
                httpOutboundServiceContextImpl.setPersistent(false);
                httpOutboundServiceContextImpl.getAppWriteCallback().error(virtualConnection, (Throwable)exception);
                return false;
            }
        }
        return true;
    }

    public void complete(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "complete() called: vc=" + virtualConnection);
        }
        HttpOutboundServiceContextImpl httpOutboundServiceContextImpl = (HttpOutboundServiceContextImpl)virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC);
        boolean bl = false;
        while (!bl && null != virtualConnection) {
            bl = this.handleNewData(httpOutboundServiceContextImpl, virtualConnection);
            if (bl) continue;
            virtualConnection = tCPReadRequestContext.read(1L, (TCPReadCompletedCallback)this, false, httpOutboundServiceContextImpl.getReadTimeout());
        }
        if (bl) {
            StatusCodes statusCodes = httpOutboundServiceContextImpl.getResponse().getStatusCode();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "100-continue scenario received " + statusCodes);
            }
            if (statusCodes.equals(HttpConstants.STATUS_CONTINUE)) {
                httpOutboundServiceContextImpl.resetRead();
                httpOutboundServiceContextImpl.getAppWriteCallback().complete(virtualConnection);
            } else {
                httpOutboundServiceContextImpl.setPersistent(false);
                httpOutboundServiceContextImpl.getAppWriteCallback().error(virtualConnection, (Throwable)new ExpectationFailedException(statusCodes.getIntCode() + " " + httpOutboundServiceContextImpl.getResponse().getReasonPhrase()));
            }
        }
    }

    public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
        HttpOutboundServiceContextImpl httpOutboundServiceContextImpl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "error() called: vc=" + virtualConnection + " ioe=" + iOException);
        }
        if ((httpOutboundServiceContextImpl = (HttpOutboundServiceContextImpl)virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC)).canceledRead()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Ignoring error callback on canceled read");
            }
            httpOutboundServiceContextImpl.resetCanceledRead();
            return;
        }
        httpOutboundServiceContextImpl.setPersistent(false);
        httpOutboundServiceContextImpl.reConnect(virtualConnection, iOException);
    }
}

