/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.outbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.channelservice.InboundTransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelFactory;
import com.ibm.websphere.models.config.channelservice.channels.HTTPOutboundChannel;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundChannel;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundChannelFactory;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.WSChannelFactory;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.OutboundChannelDefinition;
import com.ibm.wsspi.channel.framework.exception.InvalidChannelFactoryException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

public class WSHttpOutboundChannelFactory
extends HttpOutboundChannelFactory
implements WSChannelFactory {
    private static final TraceComponent tc = Tr.register(HttpOutboundChannelFactory.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");

    public Channel createChannel(ChannelData channelData) {
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        if (platformHelper.isZOS()) {
            channelData.getPropertyBag().put("RunningOnZOS", "true");
            if (platformHelper.isBaseServantJvm()) {
                channelData.getPropertyBag().put("ServantRegion", "true");
            }
        }
        String string = System.getProperty("outboundAutoDecompress");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "outBoundAutoDecompress: " + string);
        }
        if (channelData != null && channelData.getPropertyBag() != null && string != null && string.equalsIgnoreCase("false")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "outboundAutoDecompress detected");
            }
            channelData.getPropertyBag().put("AutoDecompression", "false");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Property bag: " + channelData.getPropertyBag().get("AutoDecompression"));
            }
        }
        return new HttpOutboundChannel(channelData, this, this.getObjectFactory());
    }

    public Map createFactoryConfigurationMap(TransportChannelFactory transportChannelFactory, ChannelFrameworkService channelFrameworkService) {
        return null;
    }

    public Map createChannelConfigurationMap(TransportChannel transportChannel, ChannelFrameworkService channelFrameworkService) {
        EList eList;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HTTPOutboundChannel hTTPOutboundChannel = (HTTPOutboundChannel)transportChannel;
        if (hTTPOutboundChannel.isSetKeepAlive()) {
            hashMap.put("defaultToOutgoingKeepAlive", String.valueOf(hTTPOutboundChannel.isKeepAlive()));
        }
        if (hTTPOutboundChannel.isSetReadTimeout()) {
            hashMap.put("readTimeout", String.valueOf(hTTPOutboundChannel.getReadTimeout()));
        }
        if (hTTPOutboundChannel.isSetWriteTimeout()) {
            hashMap.put("writeTimeout", String.valueOf(hTTPOutboundChannel.getWriteTimeout()));
        }
        if (null != (eList = hTTPOutboundChannel.getProperties())) {
            Iterator iterator = eList.iterator();
            Property property = null;
            while (iterator.hasNext()) {
                property = (Property)iterator.next();
                hashMap.put(property.getName(), property.getValue());
            }
        }
        return hashMap;
    }

    public OutboundChannelDefinition getOutboundChannelDefinition(Map map) {
        return null;
    }

    public String determineAcceptorID(InboundTransportChannel inboundTransportChannel) {
        return null;
    }
}

