/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.validation;

import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelFactory;
import com.ibm.websphere.models.config.channelservice.channels.HTTPInboundChannel;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.validation.base.config.MOFValidator;
import com.ibm.wsspi.channel.impl.BaseChannelTypeValidator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.validation.internal.core.ValidationException;

public class HttpInboundChannelValidator
extends BaseChannelTypeValidator {
    public HttpInboundChannelValidator(MOFValidator mOFValidator) {
        super(mOFValidator);
    }

    public void validate(TransportChannelFactory transportChannelFactory) throws ValidationException {
    }

    private void validateMinimum(int n, int n2, String string, Object object) throws ValidationException {
        if (n2 < n) {
            String[] stringArray = new String[]{Integer.toString(n2), Integer.toString(n)};
            this.addError(string, stringArray, object);
        }
    }

    private void validateRange(int n, int n2, String string, String string2, Object object) throws ValidationException {
        int n3 = 0;
        boolean bl = false;
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        if (bl || n3 < n || n3 > n2) {
            String[] stringArray = new String[]{string, Integer.toString(n), Integer.toString(n2)};
            this.addError(string2, stringArray, object);
        }
    }

    public void validate(TransportChannel transportChannel) throws ValidationException {
        EList eList;
        HTTPInboundChannel hTTPInboundChannel = (HTTPInboundChannel)transportChannel;
        if (hTTPInboundChannel.isSetMaximumPersistentRequests()) {
            this.validateMinimum(-1, hTTPInboundChannel.getMaximumPersistentRequests(), "config.maxpersist", hTTPInboundChannel);
        }
        if (hTTPInboundChannel.isSetPersistentTimeout()) {
            this.validateMinimum(0, hTTPInboundChannel.getPersistentTimeout(), "config.persisttimeout", hTTPInboundChannel);
        }
        if (hTTPInboundChannel.isSetReadTimeout()) {
            this.validateMinimum(0, hTTPInboundChannel.getReadTimeout(), "config.readtimeout", hTTPInboundChannel);
        }
        if (hTTPInboundChannel.isSetWriteTimeout()) {
            this.validateMinimum(0, hTTPInboundChannel.getWriteTimeout(), "config.writetimeout", hTTPInboundChannel);
        }
        if (null != (eList = hTTPInboundChannel.getProperties())) {
            int n = eList.size();
            for (int i = 0; i < n; ++i) {
                Property property = (Property)eList.get(i);
                String string = property.getName();
                String string2 = property.getValue();
                if (string.equals("byteCacheSize")) {
                    this.validateRange(256, 2048, string2, "config.bytecachesize", hTTPInboundChannel);
                    continue;
                }
                if (string.equals("incomingBodyBufferSize")) {
                    this.validateRange(1024, 0x100000, string2, "config.incomingbody", hTTPInboundChannel);
                    continue;
                }
                if (string.equals("incomingHdrBufferSize")) {
                    this.validateRange(1024, 0x100000, string2, "config.incomingheader", hTTPInboundChannel);
                    continue;
                }
                if (string.equals("outgoingHdrBufferSize")) {
                    this.validateRange(1024, 0x100000, string2, "config.outgoingbuffer", hTTPInboundChannel);
                    continue;
                }
                if (string.equals("limitFieldSize")) {
                    this.validateRange(50, 32768, string2, "config.fieldsize", hTTPInboundChannel);
                    continue;
                }
                if (!string.equals("limitNumHeaders")) continue;
                this.validateRange(50, 4000, string2, "config.numheaders", hTTPInboundChannel);
            }
        }
    }

    public void crossValidate(TransportChannel transportChannel) throws ValidationException {
    }

    public void crossValidate(TransportChannelFactory transportChannelFactory) throws ValidationException {
    }

    protected String getLocalBundleID() {
        return "com.ibm.ws.http.channel.resources.httpchannelmessages";
    }

    protected String getLocalTraceName() {
        return "HTTPChannel";
    }
}

