/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.httptunnel.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.plugincfg.generator.ConfigurationParser;
import com.ibm.websphere.plugincfg.generator.PluginDocumentGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public class WSHttpTunnelPluginConfigHelper {
    private static final TraceComponent tc = Tr.register(WSHttpTunnelPluginConfigHelper.class, "HTTPTunnelChannel", "com.ibm.wkplc.httptunnel.resources.tunnelMessages");
    private static final char[] S_BASE64CHAR = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final char S_BASE64PAD = '=';

    private static String encode(byte[] byArray) {
        return WSHttpTunnelPluginConfigHelper.encode(byArray, 0, byArray.length);
    }

    private static String encode(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        if (n2 <= 0) {
            return "";
        }
        char[] cArray = new char[n2 / 3 * 4 + 4];
        int n5 = n;
        int n6 = 0;
        for (n4 = n2 - n; n4 >= 3; n4 -= 3) {
            n3 = ((byArray[n5] & 0xFF) << 16) + ((byArray[n5 + 1] & 0xFF) << 8) + (byArray[n5 + 2] & 0xFF);
            cArray[n6++] = S_BASE64CHAR[n3 >> 18];
            cArray[n6++] = S_BASE64CHAR[n3 >> 12 & 0x3F];
            cArray[n6++] = S_BASE64CHAR[n3 >> 6 & 0x3F];
            cArray[n6++] = S_BASE64CHAR[n3 & 0x3F];
            n5 += 3;
        }
        if (n4 == 1) {
            n3 = byArray[n5] & 0xFF;
            cArray[n6++] = S_BASE64CHAR[n3 >> 2];
            cArray[n6++] = S_BASE64CHAR[n3 << 4 & 0x3F];
            cArray[n6++] = 61;
            cArray[n6++] = 61;
        } else if (n4 == 2) {
            n3 = ((byArray[n5] & 0xFF) << 8) + (byArray[n5 + 1] & 0xFF);
            cArray[n6++] = S_BASE64CHAR[n3 >> 10];
            cArray[n6++] = S_BASE64CHAR[n3 >> 4 & 0x3F];
            cArray[n6++] = S_BASE64CHAR[n3 << 2 & 0x3F];
            cArray[n6++] = 61;
        }
        return new String(cArray, 0, n6);
    }

    public static String getMD5String(String string) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occured during MD5 computation: " + noSuchAlgorithmException.toString());
            }
            return string;
        }
        messageDigest.update(string.getBytes());
        byte[] byArray = messageDigest.digest();
        return WSHttpTunnelPluginConfigHelper.encode(byArray);
    }

    public static List getURIList(ConfigurationParser.TransportData transportData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getURIList(): host=" + transportData.host + ", port=" + transportData.port);
        }
        String string = WSHttpTunnelPluginConfigHelper.getURIAddition(transportData.host, transportData.port);
        String string2 = "/IBM_HTTP_TUNNEL/" + string + "/*";
        PluginDocumentGenerator.URIData uRIData = new PluginDocumentGenerator.URIData(string2, "JSESSIONID", "jsessionid");
        ArrayList<PluginDocumentGenerator.URIData> arrayList = new ArrayList<PluginDocumentGenerator.URIData>();
        arrayList.add(uRIData);
        return arrayList;
    }

    public static String getURIAddition(String string, int n) {
        return WSHttpTunnelPluginConfigHelper.getMD5String(string + ":" + n);
    }

    public static String getURIAddition(String string, String string2) {
        return WSHttpTunnelPluginConfigHelper.getMD5String(string + ":" + string2);
    }
}

