/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.i18n.context;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.net.InetAddress;
import java.util.Random;

public class GlobalId {
    private static final TraceComponent tc = Tr.register("com.ibm.ws.i18n.context.GlobalId", "InternationalizationService", "com.ibm.ws.i18n.context.rsrc.i18nctx");
    protected static Object lock = new Object();
    protected static long lastTime = 0L;
    protected static int clockSequence = new Random().nextInt() % 8192;
    protected static String processId = null;
    protected static String IPAddress = null;
    protected static String processUUID = null;
    protected static final char[] nibble = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProcessUUID() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessUUID");
        }
        Object object = lock;
        synchronized (object) {
            if (processId == null) {
                processUUID = GlobalId.generateUUID();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessUUID", processUUID);
        }
        return processUUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getProcessId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessId");
        }
        Object object = lock;
        synchronized (object) {
            if (processId == null) {
                byte[] pid = new byte[2];
                new Random().nextBytes(pid);
                StringBuffer buffer = new StringBuffer(4);
                GlobalId.appendBytesToStringBuffer(buffer, pid);
                processId = buffer.toString();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessId", processId);
        }
        return processId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getIPAddress() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIPAddress");
        }
        Object object = lock;
        synchronized (object) {
            if (IPAddress == null) {
                byte[] ip;
                try {
                    ip = InetAddress.getLocalHost().getAddress();
                }
                catch (Exception e2) {
                    FFDCFilter.processException(e2, "com.ibm.ws.i18n.context.GlobalId.getIPAddress", "171");
                    ip = new byte[4];
                    new Random().nextBytes(ip);
                }
                StringBuffer buffer = new StringBuffer(4);
                GlobalId.appendBytesToStringBuffer(buffer, ip);
                IPAddress = buffer.toString();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIPAddress", IPAddress);
        }
        return IPAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String generateUUID() {
        int clockSequence;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateUUID");
        }
        long time = System.currentTimeMillis();
        Object object = lock;
        synchronized (object) {
            if (lastTime == time) {
                ++GlobalId.clockSequence;
            } else {
                lastTime = time;
            }
            clockSequence = GlobalId.clockSequence;
        }
        long uuidHigh = 0x1000000000000000L | time & 0xFFFFFFFFFFFFFFFL;
        short uuidLow = (short)(0xE000 | clockSequence & Short.MAX_VALUE);
        StringBuffer string = new StringBuffer(36);
        string.append(nibble[(int)((uuidHigh & 0xF0000000L) >> 28)]);
        string.append(nibble[(int)((uuidHigh & 0xF000000L) >> 24)]);
        string.append(nibble[(int)((uuidHigh & 0xF00000L) >> 20)]);
        string.append(nibble[(int)((uuidHigh & 0xF0000L) >> 16)]);
        string.append(nibble[(int)((uuidHigh & 0xF000L) >> 12)]);
        string.append(nibble[(int)((uuidHigh & 0xF00L) >> 8)]);
        string.append(nibble[(int)((uuidHigh & 0xF0L) >> 4)]);
        string.append(nibble[(int)((uuidHigh & 0xFL) >> 0)]);
        string.append('-');
        string.append(nibble[(int)((uuidHigh & 0xF00000000000L) >> 44)]);
        string.append(nibble[(int)((uuidHigh & 0xF0000000000L) >> 40)]);
        string.append(nibble[(int)((uuidHigh & 0xF000000000L) >> 36)]);
        string.append(nibble[(int)((uuidHigh & 0xF00000000L) >> 32)]);
        string.append('-');
        string.append(nibble[((int)((uuidHigh & 0xF000000000000000L) >> 60) + 16) % 16]);
        string.append(nibble[(int)((uuidHigh & 0xF00000000000000L) >> 56)]);
        string.append(nibble[(int)((uuidHigh & 0xF0000000000000L) >> 52)]);
        string.append(nibble[(int)((uuidHigh & 0xF000000000000L) >> 48)]);
        string.append('-');
        string.append(nibble[(((uuidLow & 0xF000) >> 12) + 16) % 16]);
        string.append(nibble[(uuidLow & 0xF00) >> 8]);
        string.append(nibble[(uuidLow & 0xF0) >> 4]);
        string.append(nibble[(uuidLow & 0xF) >> 0]);
        string.append('-');
        string.append(GlobalId.getProcessId());
        string.append(GlobalId.getIPAddress());
        String result = string.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateUUID", result);
        }
        return result;
    }

    protected static void appendByteToStringBuffer(StringBuffer buffer, byte b) {
        buffer.append(nibble[(b & 0xF0) >> 4]);
        buffer.append(nibble[(b & 0xF) >> 0]);
    }

    protected static void appendBytesToStringBuffer(StringBuffer buffer, byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            GlobalId.appendByteToStringBuffer(buffer, bytes[i]);
        }
    }
}

