/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.i18n.context;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.HLSLiteDataInterface;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.i18n.context.ContextType;
import com.ibm.ws.i18n.context.I18nObjectPool;
import com.ibm.ws.i18n.context.I18nService;
import com.ibm.ws.i18n.context.LocalThreadContext_20;
import com.ibm.ws.i18n.context.Messages;
import com.ibm.ws.i18n.context.ServiceContext_20;
import com.ibm.ws.i18n.context.ThreadContextManager;
import com.ibm.ws.i18n.context.util.ServiceContext;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.util.Properties;
import org.omg.CORBA.Any;
import org.omg.CosActivity.PropertyGroupIdentity;

public class I18nLiteDataImpl
implements HLSLiteDataInterface {
    private static final TraceComponent tc = Tr.register("com.ibm.ws.i18n.context.I18nLiteDataImpl", null, "com.ibm.ws.i18n.context.rsrc.i18nctx");
    private static I18nLiteDataImpl instance = null;
    protected static final String I18N_PROPERTY_GROUP_NAME = "com.ibm.ws.i18n";
    private static final ThreadContextManager threadContextManager = ThreadContextManager.getInstance();
    private I18nObjectPool i18nObjectPool = I18nObjectPool.getInstance();
    private LocalThreadContext_20 ltc = null;
    private ServiceContext_20 sc = null;
    private MarshalledObject mo = null;
    private Any any = I18nService.getInstance().getRmiOrb().create_any();

    private I18nLiteDataImpl() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "ctor");
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "ctor", this);
        }
    }

    public static I18nLiteDataImpl getInstance() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getInstance");
        }
        if (null == instance) {
            I18nLiteDataImpl.setInstance(new I18nLiteDataImpl());
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getInstance", instance);
        }
        return instance;
    }

    public static void setInstance(I18nLiteDataImpl instance) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "setInstance", instance);
        }
        I18nLiteDataImpl.instance = instance;
        if (isEntryEnabled) {
            Tr.exit(tc, "setInstance");
        }
    }

    public Properties getProperties() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getProperties");
        }
        Properties result = new Properties();
        result.put("newGlobalId", "false");
        if (isEntryEnabled) {
            Tr.exit(tc, "getProperties", result);
        }
        return result;
    }

    public synchronized PropertyGroupIdentity getData() {
        PropertyGroupIdentity result;
        boolean isDumpEnabled;
        boolean isDebugEnabled;
        boolean isEntryEnabled;
        block13: {
            isEntryEnabled = tc.isEntryEnabled();
            isDebugEnabled = tc.isDebugEnabled();
            boolean bl = isDumpEnabled = I18nService.isBackDoorDumpEnabled() && isDebugEnabled;
            if (isEntryEnabled) {
                Tr.entry(tc, "getData");
            }
            if (isDumpEnabled) {
                Tr.debug(tc, "getData", "TCM=" + Messages.LOG_EOLN + threadContextManager.toString());
            }
            result = null;
            try {
                if (2 != I18nService.getState()) {
                    if (isDebugEnabled) {
                        Tr.debug(tc, "getData", "Internationaliation service is not started on " + I18nService.getProcessName() + "; exit immediately, return null property group.");
                    }
                    if (isEntryEnabled) {
                        Tr.exit(tc, "getData");
                    }
                    return result;
                }
                this.ltc = (LocalThreadContext_20)threadContextManager.getCurrentContext();
                if (null == this.ltc) {
                    this.ltc = this.i18nObjectPool.getLtc();
                    if (isDebugEnabled) {
                        Tr.debug(tc, "getData", "No Internationalization context scoped to current thread; default to process Locale and Timezone on " + I18nService.getProcessName() + ".");
                    }
                }
                this.sc = this.ltc.toServiceContext(ContextType.INVOCATION);
                this.mo = new MarshalledObject<ServiceContext_20>(this.sc);
                this.any.insert_Value((Serializable)this.mo);
                result = new PropertyGroupIdentity(I18N_PROPERTY_GROUP_NAME, this.any);
            }
            catch (Exception exc) {
                FFDCFilter.processException((Throwable)exc, "com.ibm.ws.i18n.context.I18nLiteDataImpl.getData", "277", this);
                Tr.error(tc, "ERR.INTRNL.EXC", Messages.toArgs(I18nService.getProcessName(), exc));
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "getData", "An unexpected exception occurred getting IIOP service context on " + I18nService.getProcessName() + ": " + exc.toString());
                }
                if (!isDebugEnabled) break block13;
                Tr.debug(tc, "getData", "An unexpected exception occurred getting IIOP service context on " + I18nService.getProcessName() + ": " + exc.toString());
            }
        }
        if (isDebugEnabled) {
            Tr.debug(tc, "getData", "Instance data:" + Messages.LOG_EOLN + "ltc=" + LocalThreadContext_20.toString(this.ltc) + Messages.LOG_EOLN + "sc=" + ServiceContext.toString_20(this.sc) + Messages.LOG_EOLN + "mo=" + this.moToString(this.mo) + Messages.LOG_EOLN + "any=" + this.anyToString(this.any));
        }
        if (isDumpEnabled) {
            Tr.debug(tc, "getData", "TCM=" + Messages.LOG_EOLN + threadContextManager.toString());
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getData", result);
        }
        return result;
    }

    public synchronized void setData(PropertyGroupIdentity pgi) {
        boolean isDumpEnabled;
        boolean isDebugEnabled;
        boolean isEntryEnabled;
        block11: {
            isEntryEnabled = tc.isEntryEnabled();
            isDebugEnabled = tc.isDebugEnabled();
            boolean bl = isDumpEnabled = I18nService.isBackDoorDumpEnabled() && isDebugEnabled;
            if (isEntryEnabled) {
                Tr.entry(tc, "setData", pgi);
            }
            if (isDumpEnabled) {
                Tr.debug(tc, "setData", "TCM=" + Messages.LOG_EOLN + threadContextManager.toString());
            }
            if (2 != I18nService.getState()) {
                if (isDebugEnabled) {
                    Tr.debug(tc, "setData", "Internationalization service is not started on " + I18nService.getProcessName() + "; exit immediately.");
                }
                if (isEntryEnabled) {
                    Tr.exit(tc, "setData");
                }
                return;
            }
            try {
                this.any = pgi.context_data;
                this.mo = (MarshalledObject)this.any.extract_Value();
                this.sc = (ServiceContext_20)this.mo.get();
                this.ltc = (LocalThreadContext_20)LocalThreadContext_20.fromServiceContext(this.sc, ContextType.CALLER);
                threadContextManager.addCurrentContext(this.ltc);
            }
            catch (Exception exc) {
                FFDCFilter.processException((Throwable)exc, "com.ibm.ws.i18n.context.I18nLiteDataImpl.setData", "348", this);
                Tr.error(tc, "ERR.INTRNL.EXC", Messages.toArgs(I18nService.getProcessName(), exc));
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "setData", "An unexpected error occurred while setting IIOP context on " + I18nService.getProcessName() + ": " + exc);
                }
                if (!isDebugEnabled) break block11;
                Tr.debug(tc, "setData", "An unexpected error occurred while setting IIOP context on " + I18nService.getProcessName() + ": " + exc);
            }
        }
        if (isDebugEnabled) {
            Tr.debug(tc, "setData", "Static helper data:" + Messages.LOG_EOLN + "ltc=" + LocalThreadContext_20.toString(this.ltc) + Messages.LOG_EOLN + "sc=" + ServiceContext.toString_20(this.sc) + Messages.LOG_EOLN + "mo=" + this.moToString(this.mo) + Messages.LOG_EOLN + "any=" + this.anyToString(this.any));
        }
        if (isDumpEnabled) {
            Tr.debug(tc, "setData", "TCM=" + Messages.LOG_EOLN + threadContextManager.toString());
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "setData");
        }
    }

    public synchronized void requestComplete() {
        boolean isDumpEnabled;
        boolean isEntryEnabled;
        block10: {
            isEntryEnabled = tc.isEntryEnabled();
            boolean isDebugEnabled = tc.isDebugEnabled();
            boolean bl = isDumpEnabled = I18nService.isBackDoorDumpEnabled() && isDebugEnabled;
            if (isEntryEnabled) {
                Tr.entry(tc, "requestComplete");
            }
            if (isDumpEnabled) {
                Tr.debug(tc, "requestComplete", "TCM=" + Messages.LOG_EOLN + threadContextManager.toString());
            }
            if (2 != I18nService.getState()) {
                if (isDebugEnabled) {
                    Tr.debug(tc, "requestComplete", "Internationalization service is not started on " + I18nService.getProcessName() + "; exit immediately.");
                }
                if (isEntryEnabled) {
                    Tr.exit(tc, "requestComplete");
                }
                return;
            }
            try {
                threadContextManager.cleanCurrentThread();
            }
            catch (Exception exc) {
                FFDCFilter.processException((Throwable)exc, "com.ibm.ws.i18n.context.I18nLiteDataImpl.requestComplete", "402", this);
                Tr.error(tc, "ERR.INTRNL.EXC", Messages.toArgs(I18nService.getProcessName(), exc));
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "requestComplete", "An unexpected error occurred while cleaning IIOP context on " + I18nService.getProcessName() + ": " + exc);
                }
                if (!isDebugEnabled) break block10;
                Tr.debug(tc, "requestComplete", "An unexpected error occurred while cleaning IIOP context on " + I18nService.getProcessName() + ": " + exc);
            }
        }
        if (isDumpEnabled) {
            Tr.debug(tc, "requestComplete", "TCM=" + Messages.LOG_EOLN + threadContextManager.toString());
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "requestComplete");
        }
    }

    private String moToString(MarshalledObject mo) {
        if (null == mo) {
            return "null";
        }
        try {
            if (null == mo.get()) {
                return "mo.value = null";
            }
            return ServiceContext.toString_20((ServiceContext_20)mo.get());
        }
        catch (Exception e2) {
            FFDCFilter.processException((Throwable)e2, "com.ibm.ws.i18n.context.I18nLiteDataImpl.moToString", "436", this);
            return e2.toString();
        }
    }

    private String anyToString(Any any) {
        if (null == any) {
            return "null";
        }
        try {
            if (null == any.extract_Value()) {
                return "any.value = null";
            }
            return this.moToString((MarshalledObject)any.extract_Value());
        }
        catch (Exception e2) {
            FFDCFilter.processException((Throwable)e2, "com.ibm.ws.i18n.context.I18nLiteDataImpl.anyToString", "462", this);
            return e2.toString();
        }
    }
}

