/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.i18n.context;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.pool.ObjectPool;
import com.ibm.websphere.asynchbeans.pool.ObjectPoolManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.i18n.context.I18nService;
import com.ibm.ws.i18n.context.LocalThreadContext_20;
import com.ibm.ws.i18n.context.ServiceContext_20;
import com.ibm.ws.i18n.context.util.ServiceContext;
import com.ibm.ws.objectpool.naming.ObjectPoolManagerFactory;
import java.util.Stack;

public class I18nObjectPool {
    private static final TraceComponent tc = Tr.register("com.ibm.ws.i18n.context.I18nObjectPool", "InternationalizationService", "com.ibm.ws.i18n.context.rsrc.i18nctx");
    private static I18nObjectPool instance = null;
    protected static ObjectPoolManager poolManager = null;
    protected static ObjectPool ltc_20ObjectPool = null;
    protected static ObjectPool stackObjectPool = null;
    protected static ObjectPool sc_20ObjectPool = null;

    protected I18nObjectPool() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "ctor");
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "ctor");
        }
    }

    public static synchronized I18nObjectPool getInstance() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getInstance");
        }
        if (null == instance) {
            I18nObjectPool.setInstance(new I18nObjectPool());
            I18nObjectPool.init();
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getInstance", instance);
        }
        return instance;
    }

    private static void setInstance(I18nObjectPool i18nObjectPool) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "setInstance", i18nObjectPool);
        }
        instance = i18nObjectPool;
        if (isEntryEnabled) {
            Tr.exit(tc, "setInstance");
        }
    }

    protected static void init() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "init");
        }
        if (null == poolManager) {
            block6: {
                try {
                    poolManager = ObjectPoolManagerFactory.getSystemObjectPoolManager();
                }
                catch (Exception e2) {
                    FFDCFilter.processException((Throwable)e2, "com.ibm.ws.i18n.context.I18nObjectPool.init", "179", instance);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "init", "An exception occurred initializing the system object pool manager on " + I18nService.getProcessName() + ".");
                    }
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "init", "An exception occurred initializing the system object pool manager on " + I18nService.getProcessName() + ".");
                }
            }
            ltc_20ObjectPool = I18nObjectPool.getPool(LocalThreadContext_20.class);
            stackObjectPool = I18nObjectPool.getPool(Stack.class);
            sc_20ObjectPool = I18nObjectPool.getPool(ServiceContext_20.class);
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "init");
        }
    }

    protected static ObjectPool getPool(Class objectClass) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getPool", objectClass.getName());
        }
        ObjectPool result = null;
        Exception unexpected = null;
        try {
            result = poolManager.getPool(objectClass);
        }
        catch (InstantiationException e2) {
            FFDCFilter.processException((Throwable)e2, "com.ibm.ws.i18n.context.I18nObjectPool.getPool", "218", instance);
            unexpected = e2;
        }
        catch (IllegalAccessException e3) {
            FFDCFilter.processException((Throwable)e3, "com.ibm.ws.i18n.context.I18nObjectPool.getPool", "223", instance);
            unexpected = e3;
        }
        catch (Exception e4) {
            FFDCFilter.processException((Throwable)e4, "com.ibm.ws.i18n.context.I18nObjectPool.getPool", "228", instance);
            unexpected = e4;
        }
        if (null != unexpected) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "getPool", "An exception occurred getting an object pool on " + I18nService.getProcessName() + ".");
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getPool", "An exception occurred getting an object pool on " + I18nService.getProcessName() + ".");
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getPool", result);
        }
        return result;
    }

    public LocalThreadContext_20 getLtc() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getLtc");
        }
        LocalThreadContext_20 result = null;
        result = null != ltc_20ObjectPool ? (LocalThreadContext_20)ltc_20ObjectPool.getObject() : new LocalThreadContext_20();
        if (isEntryEnabled) {
            Tr.exit(tc, "getLtc", result);
        }
        return result;
    }

    public void putLtc(LocalThreadContext_20 ltc_20) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "putLtc", ltc_20);
        }
        if (null != ltc_20) {
            ltc_20.reset();
            if (null != ltc_20ObjectPool) {
                ltc_20ObjectPool.returnObject(ltc_20);
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "putLtc");
        }
    }

    public Stack getStack() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getStack");
        }
        Stack result = null;
        if (null == stackObjectPool) {
            return new Stack();
        }
        result = (Stack)stackObjectPool.getObject();
        if (isEntryEnabled) {
            Tr.exit(tc, "getStack", result);
        }
        return result;
    }

    public void putStack(Stack stack) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "putStack", stack);
        }
        if (null != stack) {
            stack.clear();
            if (null != stackObjectPool) {
                stackObjectPool.returnObject(stack);
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "putStack");
        }
    }

    public ServiceContext_20 getSc() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getSc");
        }
        ServiceContext_20 result = null;
        result = null != sc_20ObjectPool ? (ServiceContext_20)sc_20ObjectPool.getObject() : new ServiceContext_20();
        if (isEntryEnabled) {
            Tr.exit(tc, "getSc", result);
        }
        return result;
    }

    public void putSc(ServiceContext_20 sc_20) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "putSc", sc_20);
        }
        if (null != sc_20) {
            ServiceContext.reset_20(sc_20);
            if (null != sc_20ObjectPool) {
                sc_20ObjectPool.returnObject(sc_20);
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "putSc");
        }
    }
}

