/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.i18n.context;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.rmi.corba.ORBSingleton;
import com.ibm.websphere.i18n.context.UserInternationalization;
import com.ibm.websphere.models.config.i18nservice.I18NService;
import com.ibm.websphere.runtime.ServerName;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.i18n.context.I18nLiteDataImpl;
import com.ibm.ws.i18n.context.I18nObjectPool;
import com.ibm.ws.i18n.context.Messages;
import com.ibm.ws.i18n.context.ThreadContextManager;
import com.ibm.ws.i18n.context.UserI18nImpl;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.wccm.services.pme.metadata.impl.PMEServerConfigLocator;
import java.util.StringTokenizer;

public abstract class I18nService {
    private static final TraceComponent tc = Tr.register("com.ibm.ws.i18n.context.I18nService", "InternationalizationService", "com.ibm.ws.i18n.context.rsrc.i18nctx");
    protected static I18nService instance = null;
    protected static ComponentImpl componentImpl = null;
    protected ORBSingleton rmiOrb = null;
    protected I18nObjectPool objectPool = null;
    protected ThreadContextManager threadContextManager = null;
    protected I18nLiteDataImpl liteData = null;
    protected UserI18nImpl userI18n = null;
    protected static boolean isUserEnabled = false;
    protected static Boolean isBackDoorDisabled = null;
    protected static Boolean isBackDoorDumpEnabled = null;
    private static String processName = null;
    private static String versionInfo = null;
    public static final short CREATED = 0;
    public static final short INITIALIZED = 1;
    public static final short STARTED = 2;
    public static final short BLOCKED = 3;
    public static final short STOPPED = 4;
    public static final short DESTROYED = 5;
    protected static short state = 0;
    protected static short prevState = 0;
    private static Boolean wccmIsEnable = null;

    protected I18nService() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ctor");
        }
        I18nService.isBackDoorDisabled();
        I18nService.isBackDoorDumpEnabled();
        I18nService.setInstance(this);
        I18nService.setProcessName(this.computeProcessName());
        I18nService.setState((short)0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ctor", this);
        }
    }

    public static synchronized I18nService getInstance() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getInstance");
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getInstance", instance);
        }
        return instance;
    }

    protected static void setInstance(I18nService instance) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "setInstance", instance);
        }
        I18nService.instance = instance;
        if (isEntryEnabled) {
            Tr.exit(tc, "setInstance");
        }
    }

    public abstract String computeProcessName();

    public abstract void initialize(Object var1) throws ConfigurationWarning, ComponentDisabledException;

    public abstract void start();

    public abstract void stop();

    public abstract void destroy();

    public static ComponentImpl getComponentImpl() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getComponentImpl");
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getComponentImpl", componentImpl);
        }
        return componentImpl;
    }

    public static void setComponentImpl(ComponentImpl componentImpl) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "setComponentImpl", componentImpl);
        }
        I18nService.componentImpl = componentImpl;
        if (isEntryEnabled) {
            Tr.exit(tc, "setComponentImpl");
        }
    }

    public ORBSingleton getRmiOrb() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getRmiOrb");
        }
        if (null == this.rmiOrb) {
            this.setRmiOrb((ORBSingleton)ORBSingleton.init());
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getRmiOrb", this.rmiOrb);
        }
        return this.rmiOrb;
    }

    public void setRmiOrb(ORBSingleton rmiOrb) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "setRmiOrb", rmiOrb);
        }
        this.rmiOrb = rmiOrb;
        if (isEntryEnabled) {
            Tr.exit(tc, "setRmiOrb");
        }
    }

    public ThreadContextManager getThreadContextManager() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getThreadContextManager");
        }
        if (null == this.threadContextManager) {
            this.setThreadContextManager(ThreadContextManager.getInstance());
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getThreadContextManager", this.threadContextManager);
        }
        return this.threadContextManager;
    }

    protected void setThreadContextManager(ThreadContextManager threadContextManager) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "setThreadContextManager", threadContextManager);
        }
        this.threadContextManager = threadContextManager;
        if (isEntryEnabled) {
            Tr.exit(tc, "setThreadContextManager");
        }
    }

    public I18nObjectPool getObjectPool() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getObjectPool");
        }
        if (null == this.objectPool) {
            this.setObjectPool(I18nObjectPool.getInstance());
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getObjectPool", this.objectPool);
        }
        return this.objectPool;
    }

    protected void setObjectPool(I18nObjectPool objectPool) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "setObjectPool", objectPool);
        }
        this.objectPool = objectPool;
        if (isEntryEnabled) {
            Tr.exit(tc, "setObjectPool");
        }
    }

    public I18nLiteDataImpl getLiteData() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getLiteData");
        }
        if (null == this.liteData) {
            this.setLiteData(I18nLiteDataImpl.getInstance());
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getLiteData", this.liteData);
        }
        return this.liteData;
    }

    protected void setLiteData(I18nLiteDataImpl liteData) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "setLiteData", liteData);
        }
        this.liteData = liteData;
        if (isEntryEnabled) {
            Tr.exit(tc, "setLiteData");
        }
    }

    public UserInternationalization getUserInternationalization() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getUserInternationalization");
        }
        if (null == this.userI18n) {
            this.setUserInternationalization(UserI18nImpl.getInstance());
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getUserInternationalization", this.userI18n);
        }
        return this.userI18n;
    }

    protected void setUserInternationalization(UserI18nImpl userI18n) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "setUserInternationalization", userI18n);
        }
        this.userI18n = userI18n;
        if (isEntryEnabled) {
            Tr.exit(tc, "setUserInternationalization");
        }
    }

    public static short getState() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getState");
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getState", new Short(state));
        }
        return state;
    }

    public static void setState(short state) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "setState", I18nService.stateToString(state));
        }
        prevState = I18nService.state;
        I18nService.state = state;
        Tr.info(tc, "INF.STATE", Messages.toArgs(I18nService.stateToString(I18nService.state), I18nService.getProcessName()));
        if (tc.isEventEnabled()) {
            Tr.event(tc, "setState", "Internationalization service " + I18nService.stateToString(state) + " on " + I18nService.getProcessName() + ".");
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setState", "Internationalization service " + I18nService.stateToString(state) + " on " + I18nService.getProcessName() + ".");
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "setState");
        }
    }

    protected static String stateToString(short state) {
        switch (state) {
            case 0: {
                return Messages.getMsg("MSG.CREATED");
            }
            case 1: {
                return Messages.getMsg("MSG.INITIALIZED");
            }
            case 2: {
                return Messages.getMsg("MSG.STARTED");
            }
            case 3: {
                return Messages.getMsg("MSG.BLOCKED");
            }
            case 4: {
                return Messages.getMsg("MSG.STOPPED");
            }
            case 5: {
                return Messages.getMsg("MSG.TERMINATED");
            }
        }
        return "?";
    }

    public static String getVersionInfo() {
        boolean isEntryEnabled;
        boolean bl = isEntryEnabled = null == versionInfo && tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getVersionInfo");
        }
        if (null == versionInfo) {
            I18nService.setVersionInfo(Messages.getMsg("MSG.VERSION.INFO").trim());
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getVersionInfo", versionInfo);
        }
        return versionInfo;
    }

    protected static void setVersionInfo(String versionInfo) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "setVersionInfo", versionInfo);
        }
        String string = I18nService.versionInfo = null == versionInfo ? "2.0" : versionInfo.trim();
        if (isEntryEnabled) {
            Tr.exit(tc, "setVersionInfo");
        }
    }

    public static String getProcessName() {
        boolean isEntryEnabled;
        boolean bl = isEntryEnabled = null == processName && tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getProcessName");
        }
        if (null == processName) {
            if (null != instance) {
                I18nService.setProcessName(instance.computeProcessName());
            } else {
                I18nService.setProcessName(null);
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getProcessName", processName);
        }
        return processName;
    }

    public static void setProcessName(String processName) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "setProcessName", processName);
        }
        I18nService.processName = null != processName ? processName : "[unknown]";
        if (isEntryEnabled) {
            Tr.exit(tc, "setProcessName");
        }
    }

    public static Boolean getWccmIsEnable() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        boolean isDebugEnabled = tc.isDebugEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getWccmIsEnable");
        }
        if (null != wccmIsEnable) {
            if (isEntryEnabled) {
                Tr.exit(tc, "getWccmIsEnable", wccmIsEnable);
            }
            return wccmIsEnable;
        }
        String fullName = ServerName.getFullName();
        if (null == fullName) {
            if (isDebugEnabled) {
                Tr.debug(tc, "getWccmIsEnable", "Full server name unavailable; assume client environment and exit");
            }
            wccmIsEnable = Boolean.TRUE;
        } else {
            if (isDebugEnabled) {
                Tr.debug(tc, "Full server name=" + fullName);
            }
            try {
                StringTokenizer st = new StringTokenizer(fullName, "\\");
                String cell = st.nextToken();
                String node = st.nextToken();
                String server2 = st.nextToken();
                String root = System.getProperty("user.install.root");
                if (root == null || root.length() <= 0) {
                    root = System.getProperty("was.install.root");
                }
                if (isDebugEnabled) {
                    Tr.debug(tc, "cell=" + (null == cell ? "<null>" : cell) + ",node=" + (null == node ? "<null>" : node) + ",server=" + (null == server2 ? "<null>" : server2) + ",root=" + (null == root ? "<null>" : root));
                }
                Repository repository2 = RepositoryFactory.createRepository(root + "/config", cell, node, server2);
                PMEServerConfigLocator pmeServerConfigLocator = new PMEServerConfigLocator();
                pmeServerConfigLocator.initialize(repository2);
                I18NService i18nServ = (I18NService)pmeServerConfigLocator.getConfig(null, "i18nservice.I18NService");
                wccmIsEnable = new Boolean(i18nServ.isEnable());
            }
            catch (Exception e2) {
                FFDCFilter.processException((Throwable)e2, "com.ibm.ws.i18n.context.I18nService.getWccmIsEnable", "840", I18nService.class);
                if (isDebugEnabled) {
                    Tr.debug(tc, "getWccmIsEnable", "Exception: " + e2);
                }
                e2.printStackTrace();
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getWccmIsEnable", wccmIsEnable);
        }
        return wccmIsEnable;
    }

    public static boolean isBackDoorDisabled() {
        block4: {
            if (null == isBackDoorDisabled) {
                try {
                    String enableProperty = System.getProperty("I18NService.enable");
                    isBackDoorDisabled = null == enableProperty ? new Boolean(false) : new Boolean("false".equals(enableProperty.toLowerCase()) || "no".equals(enableProperty.toLowerCase()));
                }
                catch (Exception e2) {
                    isBackDoorDisabled = new Boolean(false);
                    FFDCFilter.processException((Throwable)e2, "com.ibm.ws.i18n.context.I18nService.isBackDoorDisabled", "837", I18nService.getInstance());
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "isBackDoorDisabled", "An exception occurred obtaining back-door enablement property.");
                    }
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug(tc, "isBackDoorDisabled", "An exception occurred obtaining back-door enablement property.");
                }
            }
        }
        return isBackDoorDisabled;
    }

    public static boolean isBackDoorDumpEnabled() {
        block4: {
            if (null == isBackDoorDumpEnabled) {
                try {
                    String dumpProperty = System.getProperty("I18NService.dump");
                    isBackDoorDumpEnabled = null == dumpProperty ? new Boolean(false) : new Boolean("true".equals(dumpProperty.toLowerCase()) || "yes".equals(dumpProperty.toLowerCase()));
                }
                catch (Exception e2) {
                    isBackDoorDumpEnabled = new Boolean(false);
                    FFDCFilter.processException((Throwable)e2, "com.ibm.ws.i18n.context.I18nService.isBackDoorDumpEnabled", "870", I18nService.getInstance());
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "initialize", "An exception occurred obtaining back-door dump property.");
                    }
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug(tc, "initialize", "An exception occurred obtaining back-door dump property.");
                }
            }
        }
        return isBackDoorDumpEnabled;
    }
}

