/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.i18n.context;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.activity.ActivityService;
import com.ibm.ws.client.applicationclient.ClientProcessService;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.i18n.context.I18nClientComponentImpl;
import com.ibm.ws.i18n.context.I18nJndiSupport;
import com.ibm.ws.i18n.context.I18nService;
import com.ibm.ws.i18n.context.Messages;
import javax.naming.InitialContext;

public final class I18nServiceClient
extends I18nService {
    private static final TraceComponent tc = Tr.register("com.ibm.ws.i18n.context.I18nServiceClient", "InternationalizationService", "com.ibm.ws.i18n.context.rsrc.i18nctx");

    private I18nServiceClient() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "ctor");
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "ctor", this);
        }
    }

    public static synchronized I18nService getInstance() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getInstance");
        }
        if (null == I18nService.instance) {
            new I18nServiceClient();
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getInstance", I18nService.instance);
        }
        return I18nService.instance;
    }

    public String computeProcessName() {
        String result;
        boolean isEntryEnabled;
        block8: {
            isEntryEnabled = tc.isEntryEnabled();
            if (isEntryEnabled) {
                Tr.entry(tc, "computeProcessName");
            }
            result = null;
            try {
                int idx;
                ClientProcessService cps = ((I18nClientComponentImpl)I18nServiceClient.getComponentImpl()).getClientProcessService();
                if (null != cps && null != (result = ((Object)cps.getJ2EEName()).toString()) && (idx = result.lastIndexOf(35)) >= 0 && result.length() > 0) {
                    result = result.substring(idx + 1);
                }
            }
            catch (Exception exc) {
                FFDCFilter.processException((Throwable)exc, "com.ibm.ws.i18n.context.I18nServiceClient.computeProcessName", "146", I18nServiceClient.getInstance());
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "computeProcessName", "An exception occurred while obtaining the client process name.");
                }
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "computeProcessName", "An exception occurred while obtaining the client process name.");
            }
        }
        if (null == result) {
            result = Messages.getMsg("MSG.PROCESS.NAME.CLIENT");
        }
        if (null == result) {
            result = "[client]";
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "computeProcessName", result);
        }
        return result;
    }

    public void initialize(Object initConfig) throws ComponentDisabledException, ConfigurationWarning {
        Exception err;
        boolean isEventEnabled;
        boolean isDebugEnabled;
        boolean isEntryEnabled;
        block45: {
            block47: {
                block46: {
                    block44: {
                        isEntryEnabled = tc.isEntryEnabled();
                        isDebugEnabled = tc.isDebugEnabled();
                        isEventEnabled = tc.isEventEnabled();
                        if (isEntryEnabled) {
                            Tr.entry(tc, "initialize", initConfig);
                        }
                        if (0 < state) {
                            if (isEventEnabled) {
                                Tr.event(tc, "initialize", "Internationalization service already attempted initialization on " + I18nServiceClient.getProcessName() + "; exit immediately.");
                            } else if (isDebugEnabled) {
                                Tr.debug(tc, "initialize", "Internationalization service already attempted initialization on " + I18nServiceClient.getProcessName() + "; exit immediately.");
                            }
                            if (isEntryEnabled) {
                                Tr.exit(tc, "initialize");
                            }
                            return;
                        }
                        err = null;
                        boolean bl = isUserEnabled = !I18nService.isBackDoorDisabled();
                        if (isUserEnabled) {
                            Tr.info(tc, "INF.STATE", Messages.toArgs(Messages.getMsg("MSG.USER.ENABLED"), I18nServiceClient.getProcessName()));
                            if (isEventEnabled) {
                                Tr.event(tc, "initialize", "Internationalization service is enabled on " + I18nServiceClient.getProcessName() + ".");
                            } else if (isDebugEnabled) {
                                Tr.debug(tc, "initialize", "Internationalization service is enabled on " + I18nServiceClient.getProcessName() + ".");
                            }
                        } else {
                            Tr.info(tc, "INF.STATE", Messages.toArgs(Messages.getMsg("MSG.USER.DISABLED"), I18nServiceClient.getProcessName()));
                            if (isEventEnabled) {
                                Tr.event(tc, "initialize", "Internationalization service is disabled on " + I18nServiceClient.getProcessName() + "; abort.");
                            } else if (isDebugEnabled) {
                                Tr.debug(tc, "initialize", "Internationalization service is disabled on " + I18nServiceClient.getProcessName() + "; abort.");
                            }
                            if (isEntryEnabled) {
                                Tr.exit(tc, "initialize");
                            }
                            throw new ComponentDisabledException();
                        }
                        try {
                            this.getRmiOrb();
                            if (!isDebugEnabled) break block44;
                            Tr.debug(tc, "initialize", "RMI singleton ORB succesfully obtained on " + I18nServiceClient.getProcessName() + ".");
                        }
                        catch (Exception e2) {
                            FFDCFilter.processException((Throwable)e2, "com.ibm.ws.i18n.context.I18nService.initialize", "215", this);
                            Tr.error(tc, "ERR.NO.ORB.SUPPORT", I18nServiceClient.getProcessName());
                            if (isEventEnabled) {
                                Tr.event(tc, "initialize", "An exception occurred while obtaining RMI singleton ORB on " + I18nServiceClient.getProcessName() + "; abort.");
                            } else if (isDebugEnabled) {
                                Tr.debug(tc, "initialize", "An exception occurred while obtaining RMI singleton ORB on " + I18nServiceClient.getProcessName() + "; abort.");
                            }
                            err = e2;
                            break block45;
                        }
                    }
                    try {
                        this.getThreadContextManager();
                        if (isEventEnabled) {
                            Tr.event(tc, "initialize", "Thread context manager successfully initialized on " + I18nServiceClient.getProcessName() + ".");
                            break block46;
                        }
                        if (!isDebugEnabled) break block46;
                        Tr.debug(tc, "initialize", "Thread context manager successfully initialized on " + I18nServiceClient.getProcessName() + ".");
                    }
                    catch (Exception e3) {
                        FFDCFilter.processException((Throwable)e3, "com.ibm.ws.i18n.context.I18nService.initialize", "236", this);
                        Tr.error(tc, "ERR.NO.TCM.SUPPORT", I18nServiceClient.getProcessName());
                        if (isEventEnabled) {
                            Tr.event(tc, "initialize", "An exception occurred while initializing the ThreadContextManager on " + I18nServiceClient.getProcessName() + "; abort.");
                        } else if (isDebugEnabled) {
                            Tr.debug(tc, "initialize", "An exception occurred while initializing the ThreadContextManager on " + I18nServiceClient.getProcessName() + "; abort.");
                        }
                        err = e3;
                        break block45;
                    }
                }
                try {
                    ActivityService.registerLiteService("com.ibm.ws.i18n", this.getLiteData());
                    if (isEventEnabled) {
                        Tr.event(tc, "initialize", "IIOP handler successfully registered with Activity Service on " + I18nServiceClient.getProcessName() + ".");
                        break block47;
                    }
                    if (!isDebugEnabled) break block47;
                    Tr.debug(tc, "initialize", "IIOP handler successfully registered with Activity Service on " + I18nServiceClient.getProcessName() + ".");
                }
                catch (Exception e4) {
                    FFDCFilter.processException((Throwable)e4, "com.ibm.ws.i18n.context.I18nService.initialize", "258", this);
                    Tr.error(tc, "ERR.NO.IIOP.SUPPORT", I18nServiceClient.getProcessName());
                    if (isEventEnabled) {
                        Tr.event(tc, "initialize", "An exception occurred while registering IIOP handler with the Activity Service on " + I18nServiceClient.getProcessName() + "; abort.");
                    } else if (isDebugEnabled) {
                        Tr.debug(tc, "initialize", "An exception occurred while registering IIOP handler with the Activity Service on " + I18nServiceClient.getProcessName() + "; abort.");
                    }
                    err = e4;
                    break block45;
                }
            }
            I18nServiceClient.setState((short)1);
        }
        if (isUserEnabled) {
            if (1 == state) {
                if (isEventEnabled) {
                    Tr.event(tc, "initialize", "Internationalization service succesfully initialized on " + I18nServiceClient.getProcessName() + ".");
                } else if (isDebugEnabled) {
                    Tr.debug(tc, "initialize", "Internationalization service successfully initialized on " + I18nServiceClient.getProcessName() + ".");
                }
            } else {
                I18nServiceClient.setState((short)3);
                if (null != err) {
                    Tr.error(tc, "ERR.INTRNL.EXC", Messages.toArgs(I18nService.getProcessName(), err));
                }
                Tr.info(tc, "INF.STATE.NOT", Messages.toArgs(Messages.getMsg("MSG.INITIALIZED"), I18nServiceClient.getProcessName()));
                if (isEventEnabled) {
                    Tr.event(tc, "initialize", "Internationalization service failed to initialize on " + I18nServiceClient.getProcessName() + ".");
                } else if (isDebugEnabled) {
                    Tr.debug(tc, "initialize", "Internationalization service failed to initialize on " + I18nServiceClient.getProcessName() + ".");
                }
                if (isEntryEnabled) {
                    Tr.exit(tc, "initialize");
                }
                ConfigurationWarning cw = new ConfigurationWarning(new ComponentDisabledException());
                throw cw;
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "initialize");
        }
    }

    public void start() {
        Exception err;
        boolean isEventEnabled;
        boolean isDebugEnabled;
        boolean isEntryEnabled;
        block38: {
            isEntryEnabled = tc.isEntryEnabled();
            isDebugEnabled = tc.isDebugEnabled();
            isEventEnabled = tc.isEventEnabled();
            if (isEntryEnabled) {
                Tr.entry(tc, "start");
            }
            if (!isUserEnabled) {
                if (isEventEnabled) {
                    Tr.event(tc, "start", "Internationalization service not enabled on " + I18nServiceClient.getProcessName() + "; abort.");
                } else if (isDebugEnabled) {
                    Tr.debug(tc, "start", "Internationalization service not enabled on " + I18nServiceClient.getProcessName() + "; abort.");
                }
                if (isEntryEnabled) {
                    Tr.exit(tc, "start");
                }
                return;
            }
            if (4 == state) {
                I18nServiceClient.setState((short)2);
                if (isEntryEnabled) {
                    Tr.exit(tc, "start");
                }
                return;
            }
            err = null;
            if (1 < state) {
                Tr.warning(tc, "INF.STATE.ALREADY", Messages.toArgs(Messages.getMsg("MSG.STARTED"), I18nServiceClient.getProcessName()));
                if (isEventEnabled) {
                    Tr.event(tc, "start", "Internationalization service already started on " + I18nServiceClient.getProcessName() + "; exit immediately.");
                } else if (isDebugEnabled) {
                    Tr.debug(tc, "start", "Internationalization service already started on " + I18nServiceClient.getProcessName() + "; exit immediately.");
                }
            } else if (1 > state) {
                Tr.warning(tc, "INF.STATE.NOT", Messages.toArgs(Messages.getMsg("MSG.STARTED"), I18nServiceClient.getProcessName()));
                if (isEventEnabled) {
                    Tr.event(tc, "start", "Internationalization service not yet initialized on " + I18nServiceClient.getProcessName() + "; abort.");
                } else if (isDebugEnabled) {
                    Tr.debug(tc, "start", "Internationalization service not yet initialized on " + I18nServiceClient.getProcessName() + "; abort.");
                }
            } else {
                try {
                    this.getUserInternationalization();
                }
                catch (Exception e2) {
                    FFDCFilter.processException((Throwable)e2, "com.ibm.ws.i18n.context.I18nService.start", "360", this);
                    Tr.warning(tc, "ERR.NO.API.SUPPORT", I18nServiceClient.getProcessName());
                    if (isEventEnabled) {
                        Tr.event(tc, "start", "An exception occurred while initializing Internationalization API on " + I18nServiceClient.getProcessName() + "; service API unavailable.");
                    } else if (isDebugEnabled) {
                        Tr.debug(tc, "start", "An exception occurred while initializing Internationalization API on " + I18nServiceClient.getProcessName() + "; service API unavailable.");
                    }
                    err = e2;
                    break block38;
                }
                try {
                    ClientProcessService cps = ((I18nClientComponentImpl)componentImpl).getClientProcessService();
                    InitialContext javaColonCtx = (InitialContext)cps.getJavaColonCtx();
                    I18nJndiSupport.bindI18nContextApi(javaColonCtx);
                }
                catch (Exception e3) {
                    FFDCFilter.processException((Throwable)e3, "com.ibm.ws.i18n.context.I18nService.initialize", "380", this);
                    Tr.warning(tc, "ERR.NO.JNDI.SUPPORT", I18nServiceClient.getProcessName());
                    if (isEventEnabled) {
                        Tr.event(tc, "start", "An exception occurred while initializing the JNDI reference for UserInternationalization on " + I18nServiceClient.getProcessName() + "; service API unavailable to client.");
                    } else if (isDebugEnabled) {
                        Tr.debug(tc, "start", "An exception occurred while initializing the JNDI reference for UserInternationalization on " + I18nServiceClient.getProcessName() + "; service API unavailable to client.");
                    }
                    err = e3;
                    break block38;
                }
                I18nServiceClient.setState((short)2);
            }
        }
        if (2 == state) {
            if (isEventEnabled) {
                Tr.event(tc, "start", "Internationalization service successfully started on " + I18nServiceClient.getProcessName() + ".");
            } else if (isDebugEnabled) {
                Tr.debug(tc, "start", "Internationalization service successfully started on " + I18nServiceClient.getProcessName() + ".");
            }
        } else {
            I18nServiceClient.setState((short)3);
            if (null != err) {
                Tr.error(tc, "ERR.INTRNL.EXC", Messages.toArgs(I18nServiceClient.getProcessName(), err));
            }
            Tr.info(tc, "INF.STATE.NOT", Messages.toArgs(Messages.getMsg("MSG.STARTED"), I18nServiceClient.getProcessName()));
            if (isEventEnabled) {
                Tr.event(tc, "start", "Internationalization service failed to start on " + I18nServiceClient.getProcessName() + ".");
            } else if (isDebugEnabled) {
                Tr.debug(tc, "start", "Internationalization service failed to start on " + I18nServiceClient.getProcessName() + ".");
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "stop");
        }
        if (isUserEnabled) {
            I18nServiceClient.setState((short)4);
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "stop");
        }
    }

    public void destroy() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "destroy");
        }
        if (isUserEnabled) {
            I18nServiceClient.setState((short)5);
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "destroy");
        }
    }
}

