/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.i18n.context;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.i18nservice.I18NService;
import com.ibm.websphere.runtime.ServerName;
import com.ibm.ws.activity.ActivityService;
import com.ibm.ws.asynchbeans.AsynchBeansService;
import com.ibm.ws.asynchbeans.AsynchBeansServiceCollaborator;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.i18n.context.I18nEjbCollaboratorImpl;
import com.ibm.ws.i18n.context.I18nMetaDataListenerImpl;
import com.ibm.ws.i18n.context.I18nObjectPool;
import com.ibm.ws.i18n.context.I18nServerComponentImpl;
import com.ibm.ws.i18n.context.I18nServerObjectPool;
import com.ibm.ws.i18n.context.I18nService;
import com.ibm.ws.i18n.context.I18nWebCollaboratorImpl;
import com.ibm.ws.i18n.context.I18nWithContextImpl;
import com.ibm.ws.i18n.context.Messages;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MethodMetaData;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.ws.runtime.service.MetaDataService;
import com.ibm.ws.wccm.services.pme.metadata.MetaDataHelperService;
import com.ibm.ws.webcontainer.WebContainerService;
import com.ibm.ws.webcontainer.webapp.collaborator.WebAppCollaborator;

public final class I18nServiceServer
extends I18nService {
    private static final TraceComponent tc = Tr.register("com.ibm.ws.i18n.context.I18nServiceServer", "InternationalizationService", "com.ibm.ws.i18n.context.rsrc.i18nctx");
    protected I18nServerObjectPool serverObjectPool = null;
    private I18nWithContextImpl serviceWithContext = null;
    private I18nMetaDataListenerImpl metaDataListener = null;
    private I18nEjbCollaboratorImpl ejbCollaborator = null;
    private I18nWebCollaboratorImpl webCollaborator = null;

    private I18nServiceServer() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "ctor");
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "ctor", this);
        }
    }

    public static synchronized I18nService getInstance() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getInstance");
        }
        if (null == I18nService.instance) {
            new I18nServiceServer();
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getInstance", I18nService.instance);
        }
        return I18nService.instance;
    }

    public String computeProcessName() {
        String result;
        boolean isEntryEnabled;
        block7: {
            isEntryEnabled = tc.isEntryEnabled();
            if (isEntryEnabled) {
                Tr.entry(tc, "computeProcessName");
            }
            result = null;
            try {
                result = ServerName.getDisplayName();
            }
            catch (Exception e2) {
                FFDCFilter.processException((Throwable)e2, "com.ibm.ws.i18n.context.I18nService.computeProcessName", "183", I18nServiceServer.getInstance());
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "computeProcessName", "An exception occurred while obtaining the server process name.");
                }
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "computeProcessName", "An exception occurred while obtaining the server process name.");
            }
        }
        if (null == result) {
            result = Messages.getMsg("MSG.PROCESS.NAME.SERVER");
        }
        if (null == result) {
            result = "[server]";
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "computeProcessName", result);
        }
        return result;
    }

    public void initialize(Object initConfig) throws ConfigurationWarning, ComponentDisabledException {
        Exception err;
        boolean isEventEnabled;
        boolean isDebugEnabled;
        boolean isEntryEnabled;
        block94: {
            block103: {
                block102: {
                    block101: {
                        block100: {
                            block99: {
                                block98: {
                                    block97: {
                                        block96: {
                                            block95: {
                                                isEntryEnabled = tc.isEntryEnabled();
                                                isDebugEnabled = tc.isDebugEnabled();
                                                isEventEnabled = tc.isEventEnabled();
                                                if (isEntryEnabled) {
                                                    Tr.entry(tc, "initialize", initConfig);
                                                }
                                                if (0 < state) {
                                                    if (isDebugEnabled) {
                                                        Tr.debug(tc, "initialize", "Internationalization service already attempted initialization on " + I18nServiceServer.getProcessName() + "; exit immediately.");
                                                    }
                                                    if (isEntryEnabled) {
                                                        Tr.exit(tc, "initialize");
                                                    }
                                                    return;
                                                }
                                                err = null;
                                                try {
                                                    I18NService wccmI18nService = (I18NService)initConfig;
                                                    isUserEnabled = wccmI18nService.isEnable();
                                                }
                                                catch (Exception e2) {
                                                    FFDCFilter.processException((Throwable)e2, "com.ibm.ws.i18n.context.I18nServiceServer.initialize", "248", this);
                                                    if (isEventEnabled) {
                                                        Tr.event(tc, "initialize", "An exception occurred while obtaining enablement setting from Service meta-data on" + I18nServiceServer.getProcessName() + "; default to enabled.");
                                                    } else if (isDebugEnabled) {
                                                        Tr.debug(tc, "initialize", "An exception occurred while obtaining enablement setting from Service meta-data on" + I18nServiceServer.getProcessName() + "; default to enabled.");
                                                    }
                                                    isUserEnabled = false;
                                                    err = e2;
                                                    break block94;
                                                }
                                                if (isUserEnabled) {
                                                    Tr.info(tc, "INF.STATE", Messages.toArgs(Messages.getMsg("MSG.USER.ENABLED"), I18nServiceServer.getProcessName()));
                                                    if (isEventEnabled) {
                                                        Tr.event(tc, "initialize", "Internationalization service is enabled on " + I18nServiceServer.getProcessName() + ".");
                                                    } else if (isDebugEnabled) {
                                                        Tr.debug(tc, "initialize", "Internationalization service is enabled on " + I18nServiceServer.getProcessName() + ".");
                                                    }
                                                } else {
                                                    Tr.info(tc, "INF.STATE", Messages.toArgs(Messages.getMsg("MSG.USER.DISABLED"), I18nServiceServer.getProcessName()));
                                                    if (isEventEnabled) {
                                                        Tr.event(tc, "initialize", "Internationalization service is disabled on " + I18nServiceServer.getProcessName() + "; abort.");
                                                    } else if (isDebugEnabled) {
                                                        Tr.debug(tc, "initialize", "Internationalization service is disabled on " + I18nServiceServer.getProcessName() + "; abort.");
                                                    }
                                                    if (isEntryEnabled) {
                                                        Tr.exit(tc, "initialize");
                                                    }
                                                    throw new ComponentDisabledException();
                                                }
                                                try {
                                                    this.getRmiOrb();
                                                    if (isEventEnabled) {
                                                        Tr.event(tc, "initialize", "RMI singleton ORB successfully obtained on " + I18nServiceServer.getProcessName() + ".");
                                                        break block95;
                                                    }
                                                    if (!isDebugEnabled) break block95;
                                                    Tr.debug(tc, "initialize", "RMI singleton ORB successfully obtained on " + I18nServiceServer.getProcessName() + ".");
                                                }
                                                catch (Exception e3) {
                                                    FFDCFilter.processException((Throwable)e3, "com.ibm.ws.i18n.context.I18nService.initialize", "294", this);
                                                    Tr.warning(tc, "ERR.NO.ORB.SUPPORT", I18nServiceServer.getProcessName());
                                                    if (isEventEnabled) {
                                                        Tr.event(tc, "initialize", "An exception occurred while obtaining RMI singleton ORB on " + I18nServiceServer.getProcessName() + "; abort.");
                                                    } else if (isDebugEnabled) {
                                                        Tr.debug(tc, "initialize", "An exception occurred while obtaining RMI singleton ORB on " + I18nServiceServer.getProcessName() + "; abort.");
                                                    }
                                                    err = e3;
                                                    break block94;
                                                }
                                            }
                                            try {
                                                this.getObjectPool();
                                                if (isEventEnabled) {
                                                    Tr.event(tc, "initialize", "Object pools successfully initialized on " + I18nServiceServer.getProcessName() + ".");
                                                    break block96;
                                                }
                                                if (!isDebugEnabled) break block96;
                                                Tr.debug(tc, "initialize", "Object pools successfully initialized on " + I18nServiceServer.getProcessName() + ".");
                                            }
                                            catch (Exception e4) {
                                                FFDCFilter.processException((Throwable)e4, "com.ibm.ws.i18n.context.I18nService.initialize", "315", this);
                                                if (isEventEnabled) {
                                                    Tr.event(tc, "initialize", "An exception occurred while initializing object pools on " + I18nServiceServer.getProcessName() + "; abort.");
                                                } else if (isDebugEnabled) {
                                                    Tr.debug(tc, "initialize", "An exception occurred while initializing object pools on " + I18nServiceServer.getProcessName() + "; abort.");
                                                }
                                                err = e4;
                                                break block94;
                                            }
                                        }
                                        try {
                                            this.getServerObjectPool();
                                            if (isEventEnabled) {
                                                Tr.event(tc, "initialize", "Server object pools successfully initialized on " + I18nServiceServer.getProcessName() + ".");
                                            } else if (isDebugEnabled) {
                                                Tr.debug(tc, "initialize", "Server object pools successfully initialized on " + I18nServiceServer.getProcessName() + ".");
                                            }
                                        }
                                        catch (Exception e5) {
                                            FFDCFilter.processException((Throwable)e5, "com.ibm.ws.i18n.context.I18nService.initialize", "334", this);
                                            if (isEventEnabled) {
                                                Tr.event(tc, "initialize", "An exception occurred while initializing server object pools on " + I18nServiceServer.getProcessName() + "; object pooling unsupported.");
                                            }
                                            if (!isDebugEnabled) break block97;
                                            Tr.debug(tc, "initialize", "An exception occurred while initializing server object pools on " + I18nServiceServer.getProcessName() + "; object pooling unsupported.");
                                        }
                                    }
                                    try {
                                        this.getThreadContextManager();
                                        if (isEventEnabled) {
                                            Tr.event(tc, "initialize", "Thread context manager successfully initialized on " + I18nServiceServer.getProcessName() + ".");
                                            break block98;
                                        }
                                        if (!isDebugEnabled) break block98;
                                        Tr.debug(tc, "initialize", "Thread context manager successfully initialized on " + I18nServiceServer.getProcessName() + ".");
                                    }
                                    catch (Exception e6) {
                                        FFDCFilter.processException((Throwable)e6, "com.ibm.ws.i18n.context.I18nService.initialize", "353", this);
                                        Tr.error(tc, "ERR.NO.TCM.SUPPORT", I18nServiceServer.getProcessName());
                                        if (isEventEnabled) {
                                            Tr.event(tc, "initialize", "An exception occurred while initializing thread context manager on " + I18nServiceServer.getProcessName() + "; abort.");
                                        } else if (isDebugEnabled) {
                                            Tr.debug(tc, "initialize", "An exception occurred while initializing thread context manager on " + I18nServiceServer.getProcessName() + "; abort.");
                                        }
                                        err = e6;
                                        break block94;
                                    }
                                }
                                try {
                                    ActivityService.registerLiteService("com.ibm.ws.i18n", this.getLiteData());
                                    if (isEventEnabled) {
                                        Tr.event(tc, "initialize", "IIOP handler successfully registered with Activity Service on " + I18nServiceServer.getProcessName() + ".");
                                        break block99;
                                    }
                                    if (!isDebugEnabled) break block99;
                                    Tr.debug(tc, "initialize", "IIOP handler successfully registered with Activity Service on " + I18nServiceServer.getProcessName() + ".");
                                }
                                catch (Exception e7) {
                                    FFDCFilter.processException((Throwable)e7, "com.ibm.ws.i18n.context.I18nService.initialize", "375", this);
                                    Tr.error(tc, "ERR.NO.IIOP.SUPPORT", I18nServiceServer.getProcessName());
                                    if (isEventEnabled) {
                                        Tr.event(tc, "initialize", "An exception occurred while registering IIOP handler with Activity Service on " + I18nServiceServer.getProcessName() + "; abort.");
                                    } else if (isDebugEnabled) {
                                        Tr.debug(tc, "initialize", "An exception occurred while registering IIOP handler with Activity Service on " + I18nServiceServer.getProcessName() + "; abort.");
                                    }
                                    err = e7;
                                    break block94;
                                }
                            }
                            try {
                                AsynchBeansService asynchBeans = ((I18nServerComponentImpl)componentImpl).getAsynchBeansService();
                                if (null != asynchBeans) {
                                    ((AsynchBeansServiceCollaborator)asynchBeans).register(this.getServiceWithContext());
                                    if (isEventEnabled) {
                                        Tr.event(tc, "initialize", "Context helper successfully registered with AsynchBeans on " + I18nServiceServer.getProcessName() + ".");
                                        break block100;
                                    }
                                    if (!isDebugEnabled) break block100;
                                    Tr.debug(tc, "initialize", "Context helper successfully registered with AsynchBeans on " + I18nServiceServer.getProcessName() + ".");
                                    break block100;
                                }
                                Tr.warning(tc, "ERR.NO.ASYNCHBEANS.SUPPORT", I18nServiceServer.getProcessName());
                                if (isEventEnabled) {
                                    Tr.event(tc, "initialize", "Context helper not registered with AsynchBeans: AsynchBeans service unavailable on " + I18nServiceServer.getProcessName() + ".");
                                    break block100;
                                }
                                if (!isDebugEnabled) break block100;
                                Tr.debug(tc, "initialize", "Context helper not registered with AsynchBeans: AsynchBeans service unavailable on " + I18nServiceServer.getProcessName() + ".");
                            }
                            catch (Exception e8) {
                                FFDCFilter.processException((Throwable)e8, "com.ibm.ws.i18n.context.I18nService.initialize", "408", this);
                                Tr.warning(tc, "ERR.NO.ASYNCHBEANS.SUPPORT", I18nServiceServer.getProcessName());
                                if (isEventEnabled) {
                                    Tr.event(tc, "initialize", "An exception occurred while registering context helper with AsynchBeans on " + I18nServiceServer.getProcessName() + "; abort.");
                                } else if (isDebugEnabled) {
                                    Tr.debug(tc, "initialize", "An exception occurred while registering context helper with AsynchBeans on " + I18nServiceServer.getProcessName() + "; abort.");
                                }
                                err = e8;
                                break block94;
                            }
                        }
                        try {
                            EJBContainer ejbContainer = ((I18nServerComponentImpl)componentImpl).getEJBContainer();
                            if (null != ejbContainer) {
                                ejbContainer.addCollaborator(this.getEjbCollaborator());
                                if (isEventEnabled) {
                                    Tr.event(tc, "initialize", "Collaborator successfully registered with EJB Container on " + I18nServiceServer.getProcessName() + ".");
                                    break block101;
                                }
                                if (!isDebugEnabled) break block101;
                                Tr.debug(tc, "initialize", "Collaborator successfully registered with EJB Container on " + I18nServiceServer.getProcessName() + ".");
                                break block101;
                            }
                            Tr.warning(tc, "ERR.NO.EJB.SUPPORT", I18nServiceServer.getProcessName());
                            if (isEventEnabled) {
                                Tr.event(tc, "initialize", "Collaborator not registered with EJB Container: EJB Container service unavailable on " + I18nServiceServer.getProcessName() + "; no EJB support.");
                                break block101;
                            }
                            if (!isDebugEnabled) break block101;
                            Tr.debug(tc, "initialize", "Collaborator not registered with EJB Container: EJB Container service unavailable on " + I18nServiceServer.getProcessName() + "; no EJB support.");
                        }
                        catch (Exception e9) {
                            FFDCFilter.processException((Throwable)e9, "com.ibm.ws.i18n.context.I18nService.initialize", "441", this);
                            Tr.warning(tc, "ERR.NO.EJB.SUPPORT", I18nServiceServer.getProcessName());
                            if (isEventEnabled) {
                                Tr.event(tc, "initialize", "An exception occurred while registering collaborator with EJB Container on " + I18nServiceServer.getProcessName() + "; abort.");
                            } else if (isDebugEnabled) {
                                Tr.debug(tc, "initialize", "An exception occurred while registering collaborator with EJB Container on " + I18nServiceServer.getProcessName() + "; abort.");
                            }
                            err = e9;
                            break block94;
                        }
                    }
                    try {
                        WebContainerService webContainer = ((I18nServerComponentImpl)componentImpl).getWebContainerService();
                        if (null != webContainer) {
                            webContainer.addWebAppCollaborator((WebAppCollaborator)this.getWebCollaborator());
                            if (isEventEnabled) {
                                Tr.event(tc, "initialize", "Collaborator successfully registered with Web Container on " + I18nServiceServer.getProcessName() + ".");
                                break block102;
                            }
                            if (!isDebugEnabled) break block102;
                            Tr.debug(tc, "initialize", "Collaborator successfully registered with Web Container on " + I18nServiceServer.getProcessName() + ".");
                            break block102;
                        }
                        Tr.warning(tc, "ERR.NO.WEB.SUPPORT", I18nServiceServer.getProcessName());
                        if (isEventEnabled) {
                            Tr.event(tc, "initialize", "Collaborator not registered with Web Container: Web Container service unavailable on " + I18nServiceServer.getProcessName() + "; no servlet support.");
                            break block102;
                        }
                        if (!isDebugEnabled) break block102;
                        Tr.debug(tc, "initialize", "Collaborator not registered with Web Container: Web Container service unavailable on " + I18nServiceServer.getProcessName() + "; no servlet support.");
                    }
                    catch (Exception e10) {
                        FFDCFilter.processException((Throwable)e10, "com.ibm.ws.i18n.context.I18nService.initialize", "474", this);
                        Tr.warning(tc, "ERR.NO.WEB.SUPPORT", I18nServiceServer.getProcessName());
                        if (isEventEnabled) {
                            Tr.event(tc, "initialize", "An exception occurred while registering collaborator with Web Container on " + I18nServiceServer.getProcessName() + ".");
                        } else if (isDebugEnabled) {
                            Tr.debug(tc, "initialize", "An exception occurred while registering collaborator with Web Container on " + I18nServiceServer.getProcessName() + ".");
                        }
                        err = e10;
                        break block94;
                    }
                }
                try {
                    MetaDataService metaData = ((I18nServerComponentImpl)componentImpl).getMetaDataService();
                    MetaDataHelperService metaDataHelper = ((I18nServerComponentImpl)componentImpl).getMetaDataHelperService();
                    if (null == metaData) {
                        Tr.warning(tc, "ERR.NO.METADATA.SUPPORT", I18nServiceServer.getProcessName());
                        if (isEventEnabled) {
                            Tr.event(tc, "initialize", "Listener not registered with Meta: Meta-Data service unavailable on " + I18nServiceServer.getProcessName() + "; default context management support, only.");
                            break block103;
                        }
                        if (!isDebugEnabled) break block103;
                        Tr.debug(tc, "initialize", "Listener not registered with Meta: Meta-Data service unavailable on " + I18nServiceServer.getProcessName() + "; default context management support, only.");
                        break block103;
                    }
                    if (null == metaDataHelper) {
                        Tr.warning(tc, "ERR.NO.METADATA.SUPPORT", I18nServiceServer.getProcessName());
                        if (isEventEnabled) {
                            Tr.event(tc, "initialize", "Listener not registered with Meta: Meta-Data Helper service unavailable on " + I18nServiceServer.getProcessName() + "; default context management support, only.");
                            break block103;
                        }
                        if (!isDebugEnabled) break block103;
                        Tr.debug(tc, "initialize", "Listener not registered with Meta: Meta-Data Helper service unavailable on " + I18nServiceServer.getProcessName() + "; default context management support, only.");
                        break block103;
                    }
                    this.getMetaDataListener();
                    this.metaDataListener.setComponentSlot(metaData.reserveSlot(ComponentMetaData.class));
                    this.metaDataListener.setMethodSlot(metaData.reserveSlot(MethodMetaData.class));
                    metaData.addMetaDataListener(this.metaDataListener);
                    if (isEventEnabled) {
                        Tr.event(tc, "initialize", "Listener successfully registered with Meta-Data service on " + I18nServiceServer.getProcessName() + ".");
                        break block103;
                    }
                    if (!isDebugEnabled) break block103;
                    Tr.debug(tc, "initialize", "Listener successfully registered with Meta-Data service on " + I18nServiceServer.getProcessName() + ".");
                }
                catch (Exception e11) {
                    FFDCFilter.processException((Throwable)e11, "com.ibm.ws.i18n.context.I18nService.initialize", "523", this);
                    Tr.warning(tc, "ERR.NO.METADATA.SUPPORT", I18nServiceServer.getProcessName());
                    if (isEventEnabled) {
                        Tr.event(tc, "initialize", "An exception occurred while registering with the MetaData service on " + I18nServiceServer.getProcessName() + "; abort.");
                    } else if (isDebugEnabled) {
                        Tr.debug(tc, "initialize", "An exception occurred while registering with the MetaData service on " + I18nServiceServer.getProcessName() + "; abort.");
                    }
                    err = e11;
                    break block94;
                }
            }
            I18nServiceServer.setState((short)1);
        }
        if (isUserEnabled) {
            if (1 == state) {
                if (isEventEnabled) {
                    Tr.event(tc, "initialize", "Internationalization service initialized on " + I18nServiceServer.getProcessName() + ".");
                } else if (isDebugEnabled) {
                    Tr.debug(tc, "initialize", "Internationalization service initialized on " + I18nServiceServer.getProcessName() + ".");
                }
            } else {
                I18nServiceServer.setState((short)3);
                if (null != err) {
                    Tr.error(tc, "ERR.INTRNL.EXC", Messages.toArgs(I18nService.getProcessName(), err));
                }
                Tr.info(tc, "INF.STATE.NOT", Messages.toArgs(Messages.getMsg("MSG.INITIALIZED"), I18nServiceServer.getProcessName()));
                if (isEventEnabled) {
                    Tr.event(tc, "initialize", "Internationalization service failed to initialize on " + I18nServiceServer.getProcessName() + ".");
                } else if (isDebugEnabled) {
                    Tr.debug(tc, "initialize", "Internationalization service failed to initialize on " + I18nServiceServer.getProcessName() + ".");
                }
                if (isEntryEnabled) {
                    Tr.exit(tc, "initialize");
                }
                ConfigurationWarning cw = new ConfigurationWarning(new ComponentDisabledException());
                throw cw;
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "initialize");
        }
    }

    public void start() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        boolean isDebugEnabled = tc.isDebugEnabled();
        boolean isEventEnabled = tc.isEventEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "start");
        }
        if (!isUserEnabled) {
            if (isEventEnabled) {
                Tr.event(tc, "start", "Internationalization service not enabled on " + I18nServiceServer.getProcessName() + "; abort.");
            } else if (isDebugEnabled) {
                Tr.debug(tc, "start", "Internationalization service not enabled on " + I18nServiceServer.getProcessName() + "; abort.");
            }
            if (isEntryEnabled) {
                Tr.exit(tc, "start");
            }
            return;
        }
        switch (state) {
            case 0: {
                if (isEventEnabled) {
                    Tr.event(tc, "start", "Attempt to start Internationalization service before initialization on " + I18nServiceServer.getProcessName() + "; abort.");
                    break;
                }
                if (!isDebugEnabled) break;
                Tr.debug(tc, "start", "Attempt to start Internationalization service before initialization on " + I18nServiceServer.getProcessName() + "; abort.");
                break;
            }
            case 1: {
                try {
                    this.getUserInternationalization();
                }
                catch (Exception e2) {
                    FFDCFilter.processException((Throwable)e2, "com.ibm.ws.i18n.context.I18nService.start", "620", this);
                    Tr.error(tc, "ERR.INTRNL.EXC", Messages.toArgs(I18nServiceServer.getProcessName(), e2));
                    Tr.warning(tc, "ERR.NO.API.SUPPORT", I18nServiceServer.getProcessName());
                    if (isEventEnabled) {
                        Tr.event(tc, "start", "An exception occurred while initializing the Internationalization API on " + I18nServiceServer.getProcessName() + "; service API unavailable.");
                    } else if (isDebugEnabled) {
                        Tr.debug(tc, "start", "An exception occurred while initializing the Internationalization API on " + I18nServiceServer.getProcessName() + "; service API unavailable.");
                    }
                    I18nServiceServer.setState((short)3);
                    break;
                }
                I18nServiceServer.setState((short)2);
                break;
            }
            case 3: {
                if (isEventEnabled) {
                    Tr.event(tc, "start", "Internationalization service resuming (unblocking) on " + I18nServiceServer.getProcessName() + ".");
                } else if (isDebugEnabled) {
                    Tr.debug(tc, "start", "Internationalization service resuming (unblocking) on " + I18nServiceServer.getProcessName() + ".");
                }
                I18nServiceServer.setState((short)2);
                break;
            }
            case 4: {
                if (isEventEnabled) {
                    Tr.event(tc, "start", "Internationalization service resuming (unstopping) on " + I18nServiceServer.getProcessName() + ".");
                } else if (isDebugEnabled) {
                    Tr.debug(tc, "start", "Internationalization service resuming (unstopping) on " + I18nServiceServer.getProcessName() + ".");
                }
                I18nServiceServer.setState((short)2);
                break;
            }
            case 5: {
                if (isEventEnabled) {
                    Tr.event(tc, "start", "Attempt to restart Internationalization service after destruction " + I18nServiceServer.getProcessName() + "; abort.");
                    break;
                }
                if (!isDebugEnabled) break;
                Tr.debug(tc, "start", "Attempt to restart Internationalization service after destruction " + I18nServiceServer.getProcessName() + "; abort.");
                break;
            }
            default: {
                if (isEventEnabled) {
                    Tr.event(tc, "start", "Internationalization service resuming (unblocking) on " + I18nServiceServer.getProcessName() + "; exit immediately.");
                    break;
                }
                if (!isDebugEnabled) break;
                Tr.debug(tc, "start", "Internationalization service resuming (unblocking) on " + I18nServiceServer.getProcessName() + "; exit immediately.");
            }
        }
        if (2 == state) {
            if (isEventEnabled) {
                Tr.event(tc, "start", "Internationalization service successfully started on " + I18nServiceServer.getProcessName() + ".");
            } else if (isDebugEnabled) {
                Tr.debug(tc, "start", "Internationalization service successfully started on " + I18nServiceServer.getProcessName() + ".");
            }
        } else {
            Tr.info(tc, "INF.STATE.NOT", Messages.toArgs(Messages.getMsg("MSG.STARTED"), I18nServiceServer.getProcessName()));
            if (isEventEnabled) {
                Tr.event(tc, "start", "Internationalization service failed to start on " + I18nServiceServer.getProcessName() + ".");
            } else if (isDebugEnabled) {
                Tr.debug(tc, "start", "Internationalization service failed to start on " + I18nServiceServer.getProcessName() + ".");
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "stop");
        }
        if (isUserEnabled) {
            I18nServiceServer.setState((short)4);
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "stop");
        }
    }

    public void destroy() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "destroy");
        }
        if (isUserEnabled) {
            I18nServiceServer.setState((short)5);
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "destroy");
        }
    }

    public I18nObjectPool getServerObjectPool() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getServerObjectPool");
        }
        if (null == this.serverObjectPool) {
            this.setServerObjectPool(I18nServerObjectPool.getInstance());
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getServerObjectPool", this.serverObjectPool);
        }
        return this.serverObjectPool;
    }

    protected void setServerObjectPool(I18nObjectPool serverObjectPool) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "setServerObjectPool", serverObjectPool);
        }
        this.serverObjectPool = (I18nServerObjectPool)serverObjectPool;
        if (isEntryEnabled) {
            Tr.exit(tc, "setServerObjectPool");
        }
    }

    public I18nWithContextImpl getServiceWithContext() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getServiceWithContext");
        }
        if (null == this.serviceWithContext) {
            this.setServiceWithContext(new I18nWithContextImpl());
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getServiceWithContext", this.serviceWithContext);
        }
        return this.serviceWithContext;
    }

    private void setServiceWithContext(I18nWithContextImpl serviceWithContext) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "setServiceWithContext", serviceWithContext);
        }
        this.serviceWithContext = serviceWithContext;
        if (isEntryEnabled) {
            Tr.exit(tc, "setServiceWithContext");
        }
    }

    public I18nMetaDataListenerImpl getMetaDataListener() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getMetaDataListener");
        }
        if (null == this.metaDataListener) {
            this.setMetaDataListener(I18nMetaDataListenerImpl.getInstance());
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getMetaDataListener", this.metaDataListener);
        }
        return this.metaDataListener;
    }

    private void setMetaDataListener(I18nMetaDataListenerImpl metaDataListener) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "setMetaDataListener", metaDataListener);
        }
        this.metaDataListener = metaDataListener;
        if (isEntryEnabled) {
            Tr.exit(tc, "setMetaDataListener");
        }
    }

    public I18nEjbCollaboratorImpl getEjbCollaborator() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getEjbCollaborator");
        }
        if (null == this.ejbCollaborator) {
            this.setEjbCollaborator(I18nEjbCollaboratorImpl.getInstance());
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getEjbCollaborator", this.ejbCollaborator);
        }
        return this.ejbCollaborator;
    }

    private void setEjbCollaborator(I18nEjbCollaboratorImpl ejbCollaborator) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "setEjbCollaborator", ejbCollaborator);
        }
        this.ejbCollaborator = ejbCollaborator;
        if (isEntryEnabled) {
            Tr.exit(tc, "setEjbCollaborator");
        }
    }

    public I18nWebCollaboratorImpl getWebCollaborator() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getWebCollaborator");
        }
        if (null == this.webCollaborator) {
            this.setWebCollaborator(I18nWebCollaboratorImpl.getInstance());
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getWebCollaborator", this.webCollaborator);
        }
        return this.webCollaborator;
    }

    private void setWebCollaborator(I18nWebCollaboratorImpl webCollaborator) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "setWebCollaborator", webCollaborator);
        }
        this.webCollaborator = webCollaborator;
        if (isEntryEnabled) {
            Tr.exit(tc, "setWebCollaborator");
        }
    }
}

