/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.i18n.context;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.i18n.context.ContextType;
import com.ibm.ws.i18n.context.Messages;
import com.ibm.ws.i18n.context.ThreadContextManager;
import com.ibm.ws.i18n.context.util.LocaleList;
import com.ibm.ws.i18n.context.util.TimeZone;
import java.io.Serializable;
import java.util.Locale;

public abstract class LocalThreadContext
implements Serializable,
Cloneable {
    static final long serialVersionUID = -995871434888110741L;
    private static final TraceComponent tc = Tr.register("com.ibm.ws.i18n.context.LocalThreadContext", "InternationalizationService", "com.ibm.ws.i18n.context.rsrc.i18nctx");
    private static ThreadContextManager threadContextManager = ThreadContextManager.getInstance();
    protected Object[] callerLocaleList = null;
    protected Object[] invocationLocaleList = null;
    protected Object callerTimeZone = null;
    protected Object invocationTimeZone = null;

    public abstract void setDefaults(ContextType var1);

    public abstract boolean equals(LocalThreadContext var1);

    public abstract String toString();

    public Object getTimeZone(ContextType contextType) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getTimeZone", Messages.toArgs(null == contextType ? "null" : Integer.toString(contextType.value())));
        }
        Object result = null;
        switch (contextType.value()) {
            case 0: {
                result = this.callerTimeZone;
                break;
            }
            case 1: {
                result = this.invocationTimeZone;
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "getTimeZone", "Unknown context type: " + contextType);
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getTimeZone", result);
        }
        return result;
    }

    public void setTimeZone(Object timeZone, ContextType contextType) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "setTimeZone", Messages.toArgs(TimeZone.toString_20((java.util.TimeZone)timeZone), null == contextType ? "null" : Integer.toString(contextType.value())));
        }
        switch (contextType.value()) {
            case 0: {
                this.callerTimeZone = timeZone;
                break;
            }
            case 1: {
                this.invocationTimeZone = timeZone;
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "setTimeZone", "Unknown context type: " + contextType);
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "setTimeZone");
        }
    }

    public Object[] getLocaleList(ContextType contextType) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getLocaleList", Messages.toArgs(null == contextType ? "null" : Integer.toString(contextType.value())));
        }
        Object[] result = null;
        switch (contextType.value()) {
            case 0: {
                result = this.callerLocaleList;
                break;
            }
            case 1: {
                result = this.invocationLocaleList;
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "getLocaleList", "Unknown context type: " + contextType);
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getLocaleList", result);
        }
        return result;
    }

    public void setLocaleList(Object[] localeList, ContextType contextType) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "setLocaleList", Messages.toArgs(LocaleList.toString_20((Locale[])localeList), Messages.toArgs(null == contextType ? "null" : Integer.toString(contextType.value()))));
        }
        switch (contextType.value()) {
            case 0: {
                this.callerLocaleList = localeList;
                break;
            }
            case 1: {
                this.invocationLocaleList = localeList;
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "setLocaleList", "Unknown context type: " + contextType);
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "setLocaleList");
        }
    }

    public Object clone() {
        Object clone = null;
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "clone");
        }
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "clone");
        }
        return clone;
    }
}

