/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.i18n.context;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.rmi.corba.ORBSingleton;
import com.ibm.ws.i18n.context.ContextType;
import com.ibm.ws.i18n.context.I18nAttr;
import com.ibm.ws.i18n.context.I18nObjectPool;
import com.ibm.ws.i18n.context.I18nService;
import com.ibm.ws.i18n.context.LocalThreadContext;
import com.ibm.ws.i18n.context.Messages;
import com.ibm.ws.i18n.context.ServiceContext_20;
import com.ibm.ws.i18n.context.ThreadContextManager;
import com.ibm.ws.i18n.context.util.Locale;
import com.ibm.ws.i18n.context.util.LocaleList;
import com.ibm.ws.i18n.context.util.ServiceContext;
import com.ibm.ws.i18n.context.util.TimeZone;
import java.io.Serializable;

public class LocalThreadContext_20
extends LocalThreadContext {
    static final long serialVersionUID = -3284500019772670613L;
    private static final TraceComponent tc = Tr.register("com.ibm.ws.i18n.context.LocalThreadContext_20", "InternationalizationService", "com.ibm.ws.i18n.context.rsrc.i18nctx");
    private static final ThreadContextManager threadContextManager = ThreadContextManager.getInstance();
    private static final I18nObjectPool i18nObjectPool = I18nObjectPool.getInstance();
    protected I18nAttr i18nAttr = null;

    public LocalThreadContext_20() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ctor");
        }
        this.callerLocaleList = null;
        this.callerTimeZone = null;
        this.invocationLocaleList = null;
        this.invocationTimeZone = null;
        this.i18nAttr = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ctor", this);
        }
    }

    public static LocalThreadContext_20 newInstance() {
        LocalThreadContext_20 result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newInstance");
        }
        if (null == (result = i18nObjectPool.getLtc())) {
            result = new LocalThreadContext_20();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newInstance", result);
        }
        return result;
    }

    public static LocalThreadContext_20 newInstance(LocalThreadContext_20 ltc) {
        LocalThreadContext_20 result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newInstance");
        }
        if (null == (result = i18nObjectPool.getLtc())) {
            result = new LocalThreadContext_20();
        }
        result.callerLocaleList = ltc.callerLocaleList;
        result.callerTimeZone = ltc.callerTimeZone;
        result.invocationLocaleList = ltc.invocationLocaleList;
        result.invocationTimeZone = ltc.invocationTimeZone;
        result.i18nAttr = ltc.i18nAttr;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newInstance", result);
        }
        return result;
    }

    public static LocalThreadContext_20 newInstance(Object[] callerLocaleList, Object callerTimeZone, Object[] invocationLocaleList, Object invocationTimeZone, I18nAttr i18nAttr) {
        LocalThreadContext_20 result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newInstance");
        }
        if (null == (result = i18nObjectPool.getLtc())) {
            result = new LocalThreadContext_20();
        }
        result.callerLocaleList = callerLocaleList;
        result.callerTimeZone = callerTimeZone;
        result.invocationLocaleList = invocationLocaleList;
        result.invocationTimeZone = invocationTimeZone;
        result.i18nAttr = i18nAttr;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newInstance", result);
        }
        return result;
    }

    public void reset() {
        this.callerLocaleList = null;
        this.callerTimeZone = null;
        this.invocationLocaleList = null;
        this.invocationTimeZone = null;
        this.i18nAttr = null;
    }

    public I18nAttr getI18nAttr() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getI18nAttr");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getI18nAttr", this.i18nAttr);
        }
        return this.i18nAttr;
    }

    public void setI18nAttr(I18nAttr i18nAttr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setI18nAttr", i18nAttr.toString());
        }
        this.i18nAttr = i18nAttr;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setI18nAttr");
        }
    }

    public Object getTimeZone(ContextType contextType) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        boolean isDebugEnabled = tc.isDebugEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getTimeZone", Messages.toArgs(null == contextType ? "null" : Integer.toString(contextType.value())));
        }
        Object result = null;
        switch (contextType.value()) {
            case 0: {
                result = this.callerTimeZone;
                break;
            }
            case 1: {
                if (null != this.invocationTimeZone) {
                    result = this.invocationTimeZone;
                    break;
                }
                if (null != this.invocationTimeZone) break;
                if (null == this.i18nAttr) {
                    result = this.callerTimeZone;
                    if (!isDebugEnabled) break;
                    Tr.debug(tc, "getTimeZone", "I18nAttr is null, return caller's timezone:" + result);
                    break;
                }
                if (0 == this.i18nAttr.getRunAs()) {
                    result = this.callerTimeZone;
                    break;
                }
                if (1 == this.i18nAttr.getRunAs()) {
                    result = TimeZone.getDefault_20();
                    break;
                }
                if (2 == this.i18nAttr.getRunAs()) {
                    result = TimeZone.getById_20(this.i18nAttr.getTimeZoneId());
                    break;
                }
                if (isDebugEnabled) {
                    Tr.debug(tc, "getTimeZone", "Unknown I18nAttr type: " + this.i18nAttr.getRunAs());
                }
                result = TimeZone.getDefault_20();
                break;
            }
            default: {
                if (!isDebugEnabled) break;
                Tr.debug(tc, "getTimeZone", "Unknown context type: " + contextType);
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getTimeZone", result);
        }
        return result;
    }

    public Object[] getLocaleList(ContextType contextType) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        boolean isDebugEnabled = tc.isDebugEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getLocaleList", Messages.toArgs(null == contextType ? "null" : Integer.toString(contextType.value())));
        }
        Object[] result = null;
        switch (contextType.value()) {
            case 0: {
                result = this.callerLocaleList;
                break;
            }
            case 1: {
                if (null != this.invocationLocaleList) {
                    result = this.invocationLocaleList;
                    break;
                }
                if (null != this.invocationLocaleList) break;
                if (null == this.i18nAttr) {
                    result = this.callerLocaleList;
                    if (!isDebugEnabled) break;
                    Tr.debug(tc, "getLocaleList", "I18nAttr is null; return caller's locale.");
                    break;
                }
                if (0 == this.i18nAttr.getRunAs()) {
                    result = this.callerLocaleList;
                    break;
                }
                if (1 == this.i18nAttr.getRunAs()) {
                    result = LocaleList.getDefault_20();
                    break;
                }
                if (2 == this.i18nAttr.getRunAs()) {
                    result = this.i18nAttr.getLocales();
                    break;
                }
                if (isDebugEnabled) {
                    Tr.debug(tc, "getLocaleList", "Unknown I18nAttr type: " + this.i18nAttr);
                }
                result = LocaleList.getDefault_20();
                break;
            }
            default: {
                if (!isDebugEnabled) break;
                Tr.debug(tc, "getLocaleList", "Unknown context type: " + contextType);
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getLocaleList", LocaleList.toString_20((java.util.Locale[])result));
        }
        return result;
    }

    public static LocalThreadContext fromServiceContext(ServiceContext_20 sc, ContextType contextType) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        boolean isDebugEnabled = tc.isDebugEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "fromServiceContext", Messages.toArgs(ServiceContext.toString_20(sc), null == contextType ? "null" : Integer.toString(contextType.value())));
        }
        LocalThreadContext_20 result = LocalThreadContext_20.newInstance();
        switch (contextType.value()) {
            case 0: {
                result.callerLocaleList = (java.util.Locale[])sc.ll.extract_Value();
                result.callerTimeZone = (java.util.TimeZone)sc.tz.extract_Value();
                break;
            }
            case 1: {
                result.invocationLocaleList = (java.util.Locale[])sc.ll.extract_Value();
                result.invocationTimeZone = (java.util.TimeZone)sc.tz.extract_Value();
                break;
            }
            default: {
                if (!isDebugEnabled) break;
                Tr.debug(tc, "fromServiceContext", "Unknown context type: " + contextType);
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "fromServiceContext", result);
        }
        return result;
    }

    public ServiceContext_20 toServiceContext(ContextType contextType) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        boolean isDebugEnabled = tc.isDebugEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "toServiceContext", Messages.toArgs(contextType));
        }
        ServiceContext_20 result = new ServiceContext_20();
        I18nService service = I18nService.getInstance();
        ORBSingleton orb = service.getRmiOrb();
        if (null == contextType) {
            contextType = ContextType.INVOCATION;
            if (isDebugEnabled) {
                Tr.debug(tc, "toServiceContext", "Context type unavailable; default to invocation context.");
            }
        }
        switch (contextType.value()) {
            case 0: {
                result.uuid = new byte[0];
                result.ll = orb.create_any();
                result.tz = orb.create_any();
                result.ext = orb.create_any();
                if (null == this.callerLocaleList) {
                    result.ll.insert_Value((Serializable)new java.util.Locale[]{Locale.getDefault_20()});
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "toServiceContext", "Caller locale list unavailable on " + service.getProcessName() + ": use default.");
                    } else if (isDebugEnabled) {
                        Tr.debug(tc, "toServiceContext", "Caller locale list unavailable on " + service.getProcessName() + ": use default.");
                    }
                } else {
                    result.ll.insert_Value((Serializable)this.callerLocaleList);
                }
                if (null == this.callerTimeZone) {
                    result.tz.insert_Value((Serializable)TimeZone.getDefault_20());
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "toServiceContext", "Caller time zone unavailable on " + service.getProcessName() + ": use default.");
                        break;
                    }
                    if (!isDebugEnabled) break;
                    Tr.debug(tc, "toServiceContext", "Caller time zone unavailable on " + service.getProcessName() + ": use default.");
                    break;
                }
                result.tz.insert_Value((Serializable)((java.util.TimeZone)this.callerTimeZone));
                break;
            }
            case 1: {
                result.uuid = new byte[0];
                result.ll = orb.create_any();
                result.tz = orb.create_any();
                result.ext = orb.create_any();
                if (null == this.invocationLocaleList) {
                    result.ll.insert_Value((Serializable)new java.util.Locale[]{Locale.getDefault_20()});
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "toServiceContext", "Invocation locale list unavailable on " + service.getProcessName() + ": use default.");
                    } else if (isDebugEnabled) {
                        Tr.debug(tc, "toServiceContext", "Invocation locale list unavailable on " + service.getProcessName() + ": use default.");
                    }
                } else {
                    result.ll.insert_Value((Serializable)this.invocationLocaleList);
                }
                if (null == this.invocationTimeZone) {
                    result.tz.insert_Value((Serializable)TimeZone.getDefault_20());
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "toServiceContext", "Invocation time zonde unavailable on " + service.getProcessName() + ": use default.");
                        break;
                    }
                    if (!isDebugEnabled) break;
                    Tr.debug(tc, "toServiceContext", "Invocation time zonde unavailable on " + service.getProcessName() + ": use default.");
                    break;
                }
                result.tz.insert_Value((Serializable)((java.util.TimeZone)this.invocationTimeZone));
                break;
            }
            default: {
                if (!isDebugEnabled) break;
                Tr.debug(tc, "toServiceContext", "Unknown context type: " + contextType);
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "toServiceContext", result);
        }
        return result;
    }

    public void setDefaults(ContextType contextType) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        boolean isDebugEnabled = tc.isDebugEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "setDefaults", contextType);
        }
        switch (contextType.value()) {
            case 0: {
                this.callerLocaleList = LocaleList.getDefault_20();
                this.callerTimeZone = TimeZone.getDefault_20();
                break;
            }
            case 1: {
                this.invocationLocaleList = new java.util.Locale[1];
                this.invocationLocaleList[0] = Locale.getDefault_20();
                this.invocationTimeZone = TimeZone.getDefault_20();
                break;
            }
            default: {
                if (!isDebugEnabled) break;
                Tr.debug(tc, "setDefaults", "Unknown context type: " + contextType);
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "setDefaults");
        }
    }

    public static String toString(LocalThreadContext_20 ltc) {
        if (null == ltc) {
            return "null";
        }
        return ltc.toString();
    }

    public String toString() {
        return new String("Caller=[" + LocaleList.toString_20((java.util.Locale[])this.callerLocaleList) + ", " + TimeZone.toString_20((java.util.TimeZone)this.callerTimeZone) + "]" + Messages.LOG_EOLN + "Invocation=[" + LocaleList.toString_20((java.util.Locale[])this.invocationLocaleList) + ", " + TimeZone.toString_20((java.util.TimeZone)this.invocationTimeZone) + "]" + Messages.LOG_EOLN + "Policy=" + I18nAttr.toString(this.i18nAttr));
    }

    public boolean equals(LocalThreadContext ltc) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "equals");
        }
        boolean result = false;
        if (isEntryEnabled) {
            Tr.exit(tc, "equals", new Boolean(result));
        }
        return result;
    }
}

