/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.i18n.context;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.i18n.context.ContextType;
import com.ibm.ws.i18n.context.I18nObjectPool;
import com.ibm.ws.i18n.context.I18nService;
import com.ibm.ws.i18n.context.LocalThreadContext;
import com.ibm.ws.i18n.context.LocalThreadContext_20;
import com.ibm.ws.i18n.context.Messages;
import com.ibm.ws.i18n.context.util.LocaleList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;

public class ThreadContextManager {
    private static final TraceComponent tc = Tr.register("com.ibm.ws.i18n.context.ThreadContextManager", "InternationalizationService", "com.ibm.ws.i18n.context.rsrc.i18nctx");
    private static ThreadContextManager instance = null;
    protected HashMap threadContextMap = new HashMap();
    private static final I18nObjectPool i18nObjectPool = I18nObjectPool.getInstance();

    protected ThreadContextManager() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "ctor");
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "ctor", this);
        }
    }

    public static synchronized ThreadContextManager getInstance() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getInstance");
        }
        if (null == instance) {
            ThreadContextManager.setInstance(new ThreadContextManager());
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getInstance", instance);
        }
        return instance;
    }

    protected static void setInstance(ThreadContextManager instance) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "setInstance");
        }
        ThreadContextManager.instance = instance;
        if (isEntryEnabled) {
            Tr.exit(tc, "setInstance");
        }
    }

    public int getThreadContextMapSize() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getThreadContextMapSize");
        }
        int result = this.threadContextMap.size();
        if (isEntryEnabled) {
            Tr.exit(tc, "getThreadContextMapSize", Integer.toString(result));
        }
        return result;
    }

    public synchronized LocalThreadContext getCurrentContext() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        boolean isDebugEnabled = tc.isDebugEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getCurrentContext");
        }
        LocalThreadContext result = null;
        Stack ltcStack = (Stack)this.threadContextMap.get(Thread.currentThread());
        if (null == ltcStack) {
            if (isDebugEnabled) {
                Tr.debug(tc, "getCurrentContext", "No context stack; return null.");
            }
        } else if (ltcStack.empty()) {
            if (isDebugEnabled) {
                Tr.debug(tc, "getCurrentContext", "Empty context stack; return null.");
            }
        } else {
            result = (LocalThreadContext)ltcStack.peek();
            if (isDebugEnabled) {
                Tr.debug(tc, "setCurrentContext", "Context stack exists; get top context.");
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getCurrentContext", result);
        }
        return result;
    }

    public synchronized LocalThreadContext copyCurrentContext() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        boolean isDebugEnabled = tc.isDebugEnabled();
        boolean isEventEnabled = tc.isEventEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "copyCurrentContext");
        }
        LocalThreadContext result = null;
        LocalThreadContext copyResult = null;
        Stack ltcStack = (Stack)this.threadContextMap.get(Thread.currentThread());
        if (null == ltcStack) {
            if (isDebugEnabled) {
                Tr.debug(tc, "copyCurrentContext", "No context stack; return null.");
            }
        } else if (ltcStack.empty()) {
            if (isDebugEnabled) {
                Tr.debug(tc, "copyCurrentContext", "Empty context stack; return null.");
            }
        } else {
            result = (LocalThreadContext)ltcStack.peek();
            Locale[] currentLocaleList = (Locale[])result.getLocaleList(ContextType.CALLER);
            if (null == currentLocaleList || currentLocaleList.length < 1) {
                currentLocaleList = LocaleList.getDefault_20();
                if (isEventEnabled) {
                    Tr.event(tc, "getCurrentLocales_20", " ContextType.CALLER  locales unavailable; apply the default JVM locale.");
                } else if (isDebugEnabled) {
                    Tr.debug(tc, "getCurrentLocales_20", " ContextType.CALLER  locales unavailable; apply the default JVM locale.");
                }
            }
            result.setLocaleList(LocaleList.clone_20(currentLocaleList), ContextType.CALLER);
            currentLocaleList = (Locale[])result.getLocaleList(ContextType.INVOCATION);
            if (null == currentLocaleList || currentLocaleList.length < 1) {
                currentLocaleList = LocaleList.getDefault_20();
                if (isEventEnabled) {
                    Tr.event(tc, "getCurrentLocales_20", " ContextType.INVOCATION  locales unavailable; apply the default JVM locale.");
                } else if (isDebugEnabled) {
                    Tr.debug(tc, "getCurrentLocales_20", " ContextType.INVOCATION  locales unavailable; apply the default JVM locale.");
                }
            }
            result.setLocaleList(LocaleList.clone_20(currentLocaleList), ContextType.INVOCATION);
            copyResult = (LocalThreadContext)result.clone();
            if (isDebugEnabled) {
                Tr.debug(tc, "copyCurrentContext", "Context stack exists; copy top context.");
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "copyCurrentContext", copyResult);
        }
        return copyResult;
    }

    public synchronized void setCurrentContext(LocalThreadContext ltc) {
        Stack ltcStack;
        boolean isEntryEnabled = tc.isEntryEnabled();
        boolean isDebugEnabled = tc.isDebugEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "setCurrentContext", ltc);
        }
        if (null == (ltcStack = (Stack)this.threadContextMap.get(Thread.currentThread()))) {
            ltcStack = i18nObjectPool.getStack();
            ltcStack.push(ltc);
            this.threadContextMap.put(Thread.currentThread(), ltcStack);
            if (isDebugEnabled) {
                Tr.debug(tc, "setCurrentContext", "No context stack; create new stack and push context.");
            }
        } else if (ltcStack.empty()) {
            ltcStack.push(ltc);
            if (isDebugEnabled) {
                Tr.debug(tc, "setCurrentContext", "Empty context stack; push context.");
            }
        } else {
            ltcStack.setElementAt(ltc, ltcStack.size() - 1);
            if (isDebugEnabled) {
                Tr.debug(tc, "setCurrentContext", "Context stack exists; set top context.");
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "setCurrentContext");
        }
    }

    public synchronized void addCurrentContext(LocalThreadContext ltc) {
        Stack ltcStack;
        boolean isEntryEnabled = tc.isEntryEnabled();
        boolean isDebugEnabled = tc.isDebugEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "addCurrentContext", ltc);
        }
        if (null == (ltcStack = (Stack)this.threadContextMap.get(Thread.currentThread()))) {
            ltcStack = i18nObjectPool.getStack();
            ltcStack.push(ltc);
            this.threadContextMap.put(Thread.currentThread(), ltcStack);
            if (isDebugEnabled) {
                Tr.debug(tc, "addCurrentContext", "No context stack; create new stack and push context.");
            }
        } else {
            ltcStack.push(ltc);
            if (isDebugEnabled) {
                Tr.debug(tc, "setCurrentContext", "Context stack exists; add top context.");
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "addCurrentContext");
        }
    }

    public synchronized void removeCurrentContext() {
        Stack ltcStack;
        boolean isEntryEnabled = tc.isEntryEnabled();
        boolean isDebugEnabled = tc.isDebugEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "removeCurrentContext");
        }
        if (null != (ltcStack = (Stack)this.threadContextMap.get(Thread.currentThread()))) {
            if (ltcStack.isEmpty()) {
                if (isDebugEnabled) {
                    Tr.debug(tc, "removeCurrentContext", "Empty context stack; ignore.");
                }
            } else {
                LocalThreadContext_20 ltc = (LocalThreadContext_20)ltcStack.pop();
                if (isDebugEnabled) {
                    Tr.debug(tc, "removeCurrentContext", "Current context successfully removed.");
                }
                if (ltcStack.isEmpty()) {
                    this.cleanCurrentThread();
                }
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "removeCurrentContext");
        }
    }

    public synchronized void cleanCurrentThread() {
        Stack ltcStack;
        boolean isEntryEnabled = tc.isEntryEnabled();
        boolean isDebugEnabled = tc.isDebugEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "cleanCurrentThread");
        }
        if (null == (ltcStack = (Stack)this.threadContextMap.get(Thread.currentThread()))) {
            if (isDebugEnabled) {
                Tr.debug(tc, "cleanCurrentThread", "No context(s) to remove; ignore.");
            }
        } else {
            while (!ltcStack.isEmpty()) {
                i18nObjectPool.putLtc((LocalThreadContext_20)ltcStack.pop());
            }
            i18nObjectPool.putStack(ltcStack);
            this.threadContextMap.remove(Thread.currentThread());
            if (isDebugEnabled) {
                Tr.debug(tc, "cleanCurrentThread", "Successfully removed all contexts.");
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "cleanCurrentThread");
        }
    }

    public String toString() {
        if (I18nService.isBackDoorDumpEnabled() && tc.isDebugEnabled()) {
            StringBuffer result = new StringBuffer("  ****** START: THREAD CONTEXT MAP ******");
            Set keySet = this.threadContextMap.keySet();
            Iterator keyIterator = keySet.iterator();
            int i = 0;
            while (keyIterator.hasNext()) {
                Object key = keyIterator.next();
                result.append(Messages.LOG_EOLN + "[i=" + Integer.toString(i) + "] Key: " + key.toString());
                Object value2 = this.threadContextMap.get(key);
                result.append(this.valueToString(value2, "", Integer.toString(i), 0));
                ++i;
            }
            result.append(Messages.LOG_EOLN + "  ****** END: THREAD CONTEXT MAP ******");
            return result.toString();
        }
        return Integer.toString(this.hashCode());
    }

    public String valueToString(Object value2, String indent, String iString, int j) {
        if (null == value2) {
            return new String(Messages.LOG_EOLN + indent + "[i=" + iString + ",j=" + Integer.toString(j) + "] Value: null");
        }
        if (value2 instanceof LocalThreadContext_20) {
            return new String(Messages.LOG_EOLN + indent + "[i=" + iString + ",j=" + Integer.toString(j) + "] Value: " + LocalThreadContext_20.toString((LocalThreadContext_20)value2));
        }
        if (value2 instanceof LocalThreadContext) {
            return new String(Messages.LOG_EOLN + indent + "[i=" + iString + ",j=" + Integer.toString(j) + "] Value: " + ((LocalThreadContext)value2).toString());
        }
        if (value2 instanceof Stack) {
            StringBuffer result = new StringBuffer(Messages.LOG_EOLN + indent + "  ****** START: Context Stack ******");
            Iterator ltcIterator = ((Stack)value2).iterator();
            while (ltcIterator.hasNext()) {
                Object ltc = ltcIterator.next();
                result.append(this.valueToString(ltc, indent, iString, j));
                ++j;
            }
            result.append(Messages.LOG_EOLN + indent + "  ****** END: Context Stack ******");
            return result.toString();
        }
        return new String(Messages.LOG_EOLN + indent + "[i=" + iString + ",j=" + Integer.toString(j) + "] Value: <unknown>");
    }

    public void dump() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dump", "__________________________________________________________" + Messages.EOLN + "THREAD CONTEXT MAP" + Messages.EOLN + this.toString() + Messages.EOLN + "________________________________________________________");
        }
    }

    public static void main(String[] args) {
        ThreadContextManager me = ThreadContextManager.getInstance();
        me.exercise();
    }

    private void exercise() {
        I18nObjectPool pool2 = I18nObjectPool.getInstance();
        LocalThreadContext ltc = null;
        LocalThreadContext_20 ltc0 = LocalThreadContext_20.newInstance();
        LocalThreadContext_20 ltc1 = LocalThreadContext_20.newInstance();
        ltc1.setLocaleList(new Locale[]{Locale.GERMAN}, ContextType.CALLER);
        LocalThreadContext_20 ltc2 = LocalThreadContext_20.newInstance();
        ltc2.setLocaleList(new Locale[]{Locale.FRANCE}, ContextType.INVOCATION);
        LocalThreadContext_20 ltc3 = LocalThreadContext_20.newInstance();
        ltc3.setDefaults(ContextType.CALLER);
        ltc3.setDefaults(ContextType.INVOCATION);
        System.out.println("------------------------------------------------------");
        System.out.println(" GET, NO CTX STACK");
        System.out.println(this.getCurrentContext());
        System.out.println("------------------------------------------------------");
        System.out.println(" ADD, NO CTX STACK");
        this.addCurrentContext(ltc0);
        System.out.println(this.toString());
        System.out.println(" GET, CTX STACK, 1");
        System.out.println(this.getCurrentContext());
        System.out.println("------------------------------------------------------");
        System.out.println(" ADD, CTX STACK, 1");
        this.addCurrentContext(ltc1);
        System.out.println(this.toString());
        System.out.println(" GET, CTX STACK, 2");
        System.out.println(this.getCurrentContext());
        System.out.println("------------------------------------------------------");
        System.out.println(" ADD, CTX STACK, 2");
        this.addCurrentContext(ltc2);
        System.out.println(this.toString());
        System.out.println(" GET, CTX STACK, 3");
        System.out.println(this.getCurrentContext());
        System.out.println("------------------------------------------------------");
        System.out.println(" CLEAN");
        this.cleanCurrentThread();
        System.out.println(this.toString());
        System.out.println(" GET, NO CTX STACK");
        System.out.println(this.getCurrentContext());
        System.out.println("------------------------------------------------------");
        System.out.println(" SET, NO CTX STACK");
        this.addCurrentContext(ltc2);
        System.out.println(this.toString());
        System.out.println(" GET, CTX STACK, 1");
        ltc = this.getCurrentContext();
        System.out.println(ltc);
        System.out.println("------------------------------------------------------");
        System.out.println(" SET, CTX STACK, 1");
        this.setCurrentContext(ltc3);
        System.out.println(this.toString());
        System.out.println(" GET, CTX STACK, 1");
        ltc = this.getCurrentContext();
        System.out.println(ltc);
        this.addCurrentContext(ltc0);
        System.out.println("------------------------------------------------------");
        System.out.println(" REMOVE, CTX STACK, 2");
        this.removeCurrentContext();
        System.out.println(" GET, CTX STACK, 1");
        ltc = this.getCurrentContext();
        System.out.println(ltc);
        System.out.println("------------------------------------------------------");
        System.out.println(" REMOVE, CTX STACK, 1");
        this.removeCurrentContext();
        System.out.println(" GET, CTX STACK, 0");
        ltc = this.getCurrentContext();
        System.out.println(ltc);
        System.out.println("------------------------------------------------------");
        System.out.println(" REMOVE, CTX STACK, 0");
        this.removeCurrentContext();
        System.out.println(" GET, CTX STACK, 0");
        ltc = this.getCurrentContext();
        System.out.println(ltc);
        System.out.println(" CLEAN");
        this.cleanCurrentThread();
        System.out.println(this.toString());
        System.out.println("------------------------------------------------------");
        System.out.println(" REMOVE, NO CTX STACK");
        this.removeCurrentContext();
        System.out.println(" GET, NO CTX STACK");
        ltc = this.getCurrentContext();
        System.out.println(ltc);
    }
}

