/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.i18n.context.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.i18n.context.Messages;
import com.ibm.ws.i18n.context.ThreadContextManager;
import java.util.StringTokenizer;

public class Locale {
    private static final TraceComponent tc = Tr.register("com.ibm.ws.i18n.context.util.Locale", "InternationalizationService", "com.ibm.ws.i18n.context.rsrc.i18nctx");
    private static ThreadContextManager threadContextManager = ThreadContextManager.getInstance();
    private static final String POSIX = "C";
    private static final String ENGLISH = "en";
    private static final String AMERICA = "US";
    private static final char MODIFIER_START = '@';
    private static final char CODESET_START = '.';
    private static final char TERRITORY_START = '_';
    private static final String LOCALE_CATEGORY_PREFIX = "LC_";
    private static final String LC_CTYPE_CATEGORY = "LC_CTYPE";
    private static final int LC_CTYPE_LENGTH = "LC_CTYPE".length();
    private static final char EQUALS = '=';

    private Locale() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "ctor");
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "ctor", this);
        }
    }

    public static java.util.Locale getDefault_20() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getDefault_20");
        }
        java.util.Locale result = java.util.Locale.getDefault();
        if (isEntryEnabled) {
            Tr.exit(tc, "getDefault_20", result);
        }
        return result;
    }

    public static String toString_20(java.util.Locale locale) {
        boolean vExists;
        if (null == locale) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        String lc = locale.getLanguage();
        String cc = locale.getCountry();
        String v = locale.getVariant();
        boolean lcExists = null != lc && 0 < lc.length();
        boolean ccExists = null != cc && 0 < cc.length();
        boolean bl = vExists = null != v && 0 < v.length();
        if (lcExists) {
            sb.append(lc);
        }
        if (ccExists || vExists) {
            sb.append("_");
            if (ccExists) {
                sb.append(cc);
            }
            if (vExists) {
                sb.append("_" + v);
            }
        }
        return sb.toString();
    }

    public static com.ibm.ws.i18n.context.Locale newLocale_10() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "newLocale_10");
        }
        com.ibm.ws.i18n.context.Locale result = null;
        result = Boolean.getBoolean("NO_NULL") ? new com.ibm.ws.i18n.context.Locale("", "", "") : new com.ibm.ws.i18n.context.Locale();
        if (isEntryEnabled) {
            Tr.exit(tc, "newLocale_10", result);
        }
        return result;
    }

    public static com.ibm.ws.i18n.context.Locale getDefault_10() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getDefault_10");
        }
        com.ibm.ws.i18n.context.Locale result = Locale.fromJavaUtilLocale(java.util.Locale.getDefault());
        if (isEntryEnabled) {
            Tr.exit(tc, "getDefault_10", result);
        }
        return result;
    }

    public static java.util.Locale toJavaUtilLocale(com.ibm.ws.i18n.context.Locale icLocale) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "toJavaUtilLocale", icLocale);
        }
        java.util.Locale result = null;
        if (null != icLocale) {
            result = null != icLocale.languageCode ? new java.util.Locale(icLocale.languageCode.trim(), null == icLocale.countryCode ? "" : icLocale.countryCode.trim(), null == icLocale.variant ? "" : icLocale.variant.trim()) : Locale.fromVariant(icLocale.variant);
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "toJavaUtilLocale", result);
        }
        return result;
    }

    private static java.util.Locale fromVariant(String variant) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "fromVariant", variant);
        }
        java.util.Locale result = null;
        if (variant != null) {
            variant = variant.trim();
            java.util.Locale defaultLocale = java.util.Locale.getDefault();
            StringTokenizer variantParser = new StringTokenizer(variant, " ,;\t\n\r");
            int numOfTokens = variantParser.countTokens();
            if (numOfTokens == 1) {
                result = Locale.deriveLocale(variantParser.nextToken().trim(), defaultLocale);
            } else {
                int indx = variant.indexOf(LOCALE_CATEGORY_PREFIX, 0);
                if (indx != -1) {
                    if ((indx = variant.indexOf(LC_CTYPE_CATEGORY, indx)) == -1) {
                        result = defaultLocale;
                    } else {
                        if ((variant = variant.substring(indx + LC_CTYPE_LENGTH + 1).trim()).charAt(0) == '=') {
                            variant = variant.substring(1).trim();
                        }
                        StringTokenizer microsoftLocaleParser = new StringTokenizer(variant, " \t,;");
                        result = Locale.deriveLocale(microsoftLocaleParser.nextToken(), defaultLocale);
                    }
                } else if (numOfTokens > 1) {
                    variantParser.nextToken();
                    result = Locale.deriveLocale(variantParser.nextToken(), defaultLocale);
                } else {
                    result = defaultLocale;
                }
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "fromVariant", result);
        }
        return result;
    }

    private static java.util.Locale deriveLocale(String localeVal, java.util.Locale defaultLocale) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "deriveLocale", Messages.toArgs(localeVal, defaultLocale));
        }
        java.util.Locale result = null;
        if (1 == localeVal.length() && localeVal.equalsIgnoreCase(POSIX)) {
            result = new java.util.Locale(ENGLISH, AMERICA);
        }
        String language = "";
        String country = "";
        String variant = "";
        int indx = localeVal.indexOf(64);
        if (-1 != indx) {
            variant = localeVal.substring(indx + 1);
            localeVal = localeVal.substring(0, indx);
            indx = variant.indexOf(64);
            if (indx != -1) {
                variant = variant.substring(0, indx);
            }
        }
        if (-1 != (indx = localeVal.indexOf(46))) {
            localeVal = localeVal.substring(0, indx);
        }
        if (-1 != (indx = localeVal.indexOf(95))) {
            language = localeVal.substring(0, indx);
            country = localeVal.substring(indx + 1);
        } else {
            language = localeVal;
        }
        int countryLength = country.length();
        result = 2 == language.length() ? (2 == countryLength ? new java.util.Locale(language, country, variant) : new java.util.Locale(language, defaultLocale.getCountry(), variant)) : (2 == countryLength ? new java.util.Locale(defaultLocale.getLanguage(), country, variant) : new java.util.Locale(defaultLocale.getLanguage(), defaultLocale.getCountry(), variant));
        if (isEntryEnabled) {
            Tr.exit(tc, "deriveLocale", result);
        }
        return result;
    }

    public static com.ibm.ws.i18n.context.Locale fromJavaUtilLocale(java.util.Locale jmLocale) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "fromJavaUtilLocale", jmLocale);
        }
        com.ibm.ws.i18n.context.Locale result = null;
        if (null != jmLocale) {
            result = new com.ibm.ws.i18n.context.Locale(jmLocale.getLanguage(), jmLocale.getCountry(), jmLocale.getVariant());
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "fromJavaUtilLocale", Locale.toString_10(result));
        }
        return result;
    }

    public static boolean equals_10(com.ibm.ws.i18n.context.Locale loc1, com.ibm.ws.i18n.context.Locale loc2) {
        boolean result;
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "equals_10", Messages.toArgs(loc1, loc2));
        }
        boolean bl = result = loc1 == loc2;
        if (!result) {
            try {
                result = Locale.stringEquals(loc1.languageCode, loc2.languageCode) && Locale.stringEquals(loc1.countryCode, loc2.countryCode) && Locale.stringEquals(loc1.variant, loc2.variant);
            }
            catch (NullPointerException npe) {
                FFDCFilter.processException(npe, "com.ibm.ws.i18n.context.util.Locale.equals_10", "475");
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "equals_10", new Boolean(result));
        }
        return result;
    }

    private static boolean stringEquals(String str1, String str2) {
        boolean result;
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "stringEquals", Messages.toArgs(str1, str2));
        }
        boolean bl = result = str1 == str2;
        if (!result && null != str1 && null != str2) {
            result = str1.equals(str2);
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "stringEquals", new Boolean(result));
        }
        return result;
    }

    public static String toString_10(com.ibm.ws.i18n.context.Locale icLocale) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "toString_10", icLocale);
        }
        String result = null;
        if (null == icLocale) {
            result = "null";
        } else {
            boolean vExists;
            StringBuffer sb = new StringBuffer();
            boolean lcExists = icLocale.languageCode != null && icLocale.languageCode.length() > 0;
            boolean ccExists = icLocale.countryCode != null && icLocale.countryCode.length() > 0;
            boolean bl = vExists = icLocale.variant != null && icLocale.variant.length() > 0;
            if (lcExists) {
                sb.append(icLocale.languageCode);
            }
            if (ccExists || vExists) {
                sb.append("_");
                if (ccExists) {
                    sb.append(icLocale.countryCode);
                }
                if (vExists) {
                    sb.append("_" + icLocale.variant);
                }
            }
            result = sb.toString();
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "toString_10", result);
        }
        return result;
    }

    public static void dump_10(com.ibm.ws.i18n.context.Locale locale) {
    }
}

