/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.i18n.context.util;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.oa.EJSORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.i18n.context.I18nService;
import com.ibm.ws.i18n.context.Messages;
import com.ibm.ws.i18n.context.ServiceContext_10;
import com.ibm.ws.i18n.context.ServiceContext_10Helper;
import com.ibm.ws.i18n.context.ServiceContext_20;
import com.ibm.ws.i18n.context.ServiceContext_20Helper;
import com.ibm.ws.i18n.context.util.LocaleList;
import com.ibm.ws.i18n.context.util.TimeZone;
import java.util.Locale;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.PortableInterceptor.ServerRequestInfo;

public class ServiceContext {
    private static final TraceComponent tc = Tr.register("com.ibm.ws.i18n.context.util.ServiceContext", "InternationalizationService", "com.ibm.ws.i18n.context.rsrc.i18nctx");
    private static ORB orb = null;

    protected ServiceContext() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "ctor");
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "ctor", this);
        }
    }

    public static void init() {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "init");
        }
        orb = EJSORB.getORBInstance();
        if (isEntryEnabled) {
            Tr.exit(tc, "init");
        }
    }

    public static void reset_20(ServiceContext_20 sc_20) {
    }

    public static byte[] serviceContext_10ToBytes(ORB orb, ServiceContext_10 sc) {
        byte[] result;
        boolean isEntryEnabled;
        block6: {
            isEntryEnabled = tc.isEntryEnabled();
            if (isEntryEnabled) {
                Tr.entry(tc, "serviceContext_10ToBytes", sc);
            }
            result = null;
            try {
                if (null == orb) {
                    ServiceContext.init();
                }
                CDROutputStream os = ORB.createCDROutputStream((ORB)orb);
                os.putEndian();
                ServiceContext_10Helper.write((OutputStream)os, sc);
                result = os.toByteArray();
            }
            catch (Exception e2) {
                FFDCFilter.processException(e2, "com.ibm.ws.i18n.context.util.ServiceContext.serviceContext_10ToBytes", "165");
                Tr.error(tc, "ERR.INTRNL.EXC", Messages.toArgs(I18nService.getProcessName(), e2));
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "serviceContext_10ToBytes", "An unexcepted exception occurred converting service context to bytes: " + e2);
                }
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "serviceContext_10ToBytes", "An unexcepted exception occurred converting service context to bytes: " + e2);
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "serviceContext_10ToBytes");
        }
        return result;
    }

    public static byte[] serviceContext_20ToBytes(ORB orb, ServiceContext_20 sc) {
        byte[] result;
        boolean isEntryEnabled;
        block6: {
            isEntryEnabled = tc.isEntryEnabled();
            if (isEntryEnabled) {
                Tr.entry(tc, "serviceContext_20ToBytes", sc);
            }
            result = null;
            try {
                if (null == orb) {
                    ServiceContext.init();
                }
                CDROutputStream os = ORB.createCDROutputStream((ORB)orb);
                os.putEndian();
                ServiceContext_20Helper.write((OutputStream)os, sc);
                result = os.toByteArray();
            }
            catch (Exception e2) {
                FFDCFilter.processException(e2, "com.ibm.ws.i18n.context.util.ServiceContext.serviceContext_20ToBytes", "208");
                Tr.error(tc, "ERR.INTRNL.EXC", Messages.toArgs(I18nService.getProcessName(), e2));
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "serviceContext_20ToBytes", "An unexpected exception occurred converting service context to bytes: " + e2);
                }
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "serviceContext_20ToBytes", "An unexpected exception occurred converting service context to bytes: " + e2);
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "serviceContext_20ToBytes");
        }
        return result;
    }

    public static ServiceContext_10 bytesToServiceContext_10(byte[] bytes) {
        ServiceContext_10 result;
        boolean isEntryEnabled;
        block6: {
            isEntryEnabled = tc.isEntryEnabled();
            if (isEntryEnabled) {
                Tr.entry(tc, "bytesToServiceContext_10", bytes);
            }
            result = null;
            CDRInputStream is = null;
            try {
                is = ORB.createCDRInputStream((ORB)orb, (byte[])bytes, (int)bytes.length);
                is.consumeEndian();
                result = ServiceContext_10Helper.read((InputStream)is);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "bytesToServiceContext_10", "Converted bytes to input stream");
                }
            }
            catch (Exception e2) {
                FFDCFilter.processException(e2, "com.ibm.ws.i18n.context.util.ServiceContext.bytesToServiceContext_10", "251");
                Tr.error(tc, "ERR.INTRNL.EXC", Messages.toArgs(I18nService.getProcessName(), e2));
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "bytesToServiceContext_10", "An unexpected exception occurred converting bytes to input stream: " + e2);
                }
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "bytesToServiceContext_10", "An unexpected exception occurred converting bytes to input stream: " + e2);
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "bytesToServiceContext_10", ServiceContext.toString_10(result));
        }
        return result;
    }

    public static ServiceContext_20 bytesToServiceContext_20(ServerRequestInfo ri, byte[] bytes) throws Exception {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "bytesToServiceContext_20", bytes);
        }
        ServiceContext_20 result = null;
        CDRInputStream is = null;
        try {
            ORB theORB = (ORB)((LocalObject)ri)._orb();
            is = ORB.createCDRInputStream((ORB)theORB, (byte[])bytes, (int)bytes.length);
            is.consumeEndian();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "bytesToServiceContext_20", "Converted bytes to input stream");
            }
        }
        catch (Exception e2) {
            FFDCFilter.processException(e2, "com.ibm.ws.i18n.context.util.ServiceContext.bytesToServiceContext_20", "300");
            Tr.error(tc, "ERR.INTRNL.EXC", Messages.toArgs(I18nService.getProcessName(), e2));
            if (tc.isEventEnabled()) {
                Tr.event(tc, "bytesToServiceContext_20", "An unexpected exception occurred converting bytes to input stream: " + e2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "bytesToServiceContext_20", "An unexpected exception occurred converting bytes to input stream: " + e2);
            }
            throw e2;
        }
        int positionMarker = is.mark();
        String vid = null;
        try {
            vid = is.read_string();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "bytesToServiceContext_20", "Service context version: " + vid);
            }
        }
        catch (Exception e3) {
            FFDCFilter.processException(e3, "com.ibm.ws.i18n.context.util.ServiceContext.bytesToServiceContext_20", "319");
            Tr.error(tc, "ERR.INTRNL.EXC", Messages.toArgs(I18nService.getProcessName(), e3));
            if (tc.isEventEnabled()) {
                Tr.event(tc, "bytesToServiceContext_20", "An unexpected exception occurred reading service version number from input stream: " + e3);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "bytesToServiceContext_20", "An unexpected exception occurred reading service version number from input stream: " + e3);
            }
            throw e3;
        }
        is.reset(positionMarker);
        if ("2.0".equals(vid)) {
            result = ServiceContext_20Helper.read((InputStream)is);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "bytesToServiceContext_20", "Unable to read context for version level: " + vid);
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "bytesToServiceContext_20", "FIX LATER");
        }
        return result;
    }

    public static String toString_10(ServiceContext_10 sc) {
        Object result = null;
        if (null == sc) {
            return "null";
        }
        return new String("[" + (null == sc.vid ? "null" : sc.vid) + "," + (null == sc.uuid ? "null" : "uuid") + "," + (null == sc.ll ? "null" : LocaleList.toString_10(sc.ll)) + "," + (null == sc.tz ? "null" : TimeZone.toString_10(sc.tz)) + "," + (null == sc.ext ? "null" : "ext") + "]");
    }

    public static String toString_20(ServiceContext_20 sc_20) {
        if (null == sc_20) {
            return "null";
        }
        return new String("[" + (null == sc_20.vid ? "vid=null" : "vid=" + sc_20.vid) + "," + (null == sc_20.uuid ? "uuid=null" : "uuid=" + sc_20.uuid.toString()) + "," + (null == sc_20.ll ? "ll=null" : "ll=" + LocaleList.toString_20((Locale[])sc_20.ll.extract_Value())) + "," + (null == sc_20.tz ? "tz=null" : "tz=" + TimeZone.toString_20((java.util.TimeZone)sc_20.tz.extract_Value())) + "," + (null == sc_20.ext ? "ext=null" : "ext=" + sc_20.ext.toString()) + "]");
    }
}

