/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.i18n.context.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.i18n.context.ContextType;
import com.ibm.ws.i18n.context.I18nAttr;
import com.ibm.ws.i18n.context.LocalThreadContext_20;
import com.ibm.ws.i18n.context.util.TimeZone;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.SOAPPart;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPException;

public class XmlSoap {
    public static final SOAPFactory soapFactory = new SOAPFactory();
    private static final TraceComponent tc = Tr.register("com.ibm.ws.i18n.context.util.XmlSoap", "InternationalizationService", "com.ibm.ws.i18n.context.rsrc.i18nctx");
    public static final String I18N_CONTEXT_NAMESPACE = "http://www.ibm.com/webservices/InternationalizationContext";
    public static final String I18N_CONTEXT_PREFIX = "";
    public static final String I18N_CONTEXT_ELEMENT = "InternationalizationContext";
    public static final String LOCALES_ELEMENT = "Locales";
    public static final String LOCALE_ELEMENT = "Locale";
    public static final String COUNTRY_CODE_ELEMENT = "CountryCode";
    public static final String LANGUAGE_CODE_ELEMENT = "LanguageCode";
    public static final String VARIANT_CODE_ELEMENT = "VariantCode";
    public static final String TIMEZONE_ID_ELEMENT = "TimeZoneId";
    public static Name I18N_CONTEXT_SAAJ_NAME = null;
    private static Locale cachedDefaultLocale;
    private static javax.xml.soap.SOAPElement cachedDefaultLocalesElement;
    private static java.util.TimeZone cachedDefaultTimeZone;
    private static javax.xml.soap.SOAPElement cachedDefaultTimeZoneIdElement;

    public static SOAPHeader getSoapHeader(MessageContext mc) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "getSoapHeader", mc);
        }
        SOAPHeader result = null;
        try {
            Message sm = mc.getRequestMessage();
            SOAPPart sp = (SOAPPart)sm.getSOAPPart();
            SOAPEnvelope se = sp.getAsSOAPEnvelope();
            result = (SOAPHeader)se.getHeader();
        }
        catch (Exception e2) {
            FFDCFilter.processException((Throwable)e2, "com.ibm.ws.i18n.context.XmlSoap.getSoapHeader", "160", XmlSoap.class);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getSoapHeader", "Exception: " + e2);
            }
            e2.printStackTrace();
            if (e2 instanceof JAXRPCException) {
                throw (JAXRPCException)((Object)e2);
            }
            throw new JAXRPCException((Throwable)e2);
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "getSoapHeader", result);
        }
        return result;
    }

    public static javax.xml.soap.SOAPElement fromContext(LocalThreadContext_20 ltc) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "fromContext");
        }
        javax.xml.soap.SOAPElement i18nContextElement = null;
        try {
            i18nContextElement = soapFactory.createElement(I18N_CONTEXT_ELEMENT);
            i18nContextElement.addChildElement(XmlSoap.localesToElement((Locale[])ltc.getLocaleList(ContextType.INVOCATION)));
            i18nContextElement.addChildElement(XmlSoap.timeZoneIdToElement((java.util.TimeZone)ltc.getTimeZone(ContextType.INVOCATION)));
        }
        catch (SOAPException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.i18n.context.util.XmlSoap.fromContext", "190", XmlSoap.class);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "fromContext", "Exception: " + (Object)((Object)se));
            }
            se.printStackTrace();
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "fromContext", i18nContextElement);
        }
        return i18nContextElement;
    }

    private static javax.xml.soap.SOAPElement getDefaultLocalesElement() {
        return XmlSoap.localesToElement(new Locale[]{Locale.getDefault()});
    }

    private static javax.xml.soap.SOAPElement getDefaultTimeZoneIdElement() {
        java.util.TimeZone currDefaultTimeZone = null;
        currDefaultTimeZone = java.util.TimeZone.getDefault();
        return XmlSoap.timeZoneIdToElement(currDefaultTimeZone);
    }

    public static void appendContext(SOAPHeaderElement she, LocalThreadContext_20 ltc) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "appendContext");
        }
        Locale[] ll = null == ltc ? null : (Locale[])ltc.getLocaleList(ContextType.INVOCATION);
        try {
            if (null == ll) {
                she.addChildElement(XmlSoap.getDefaultLocalesElement());
            } else {
                she.addChildElement(XmlSoap.localesToElement(ll));
            }
        }
        catch (SOAPException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.i18n.context.util.XmlSoap.appendContext", "250", XmlSoap.class);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "appendContext", "Exception: " + (Object)((Object)se));
            }
            se.printStackTrace();
        }
        java.util.TimeZone tz = null == ltc ? null : (java.util.TimeZone)ltc.getTimeZone(ContextType.INVOCATION);
        try {
            if (null == ll) {
                she.addChildElement(XmlSoap.getDefaultTimeZoneIdElement());
            } else {
                she.addChildElement(XmlSoap.timeZoneIdToElement(tz));
            }
        }
        catch (SOAPException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.i18n.context.util.XmlSoap.appendContext", "269", XmlSoap.class);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "appendContext", "Exception: " + (Object)((Object)se));
            }
            se.printStackTrace();
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "appendContext");
        }
    }

    private static javax.xml.soap.SOAPElement localesToElement(Locale[] locales) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "localesToElement");
        }
        javax.xml.soap.SOAPElement localesElement = null;
        try {
            localesElement = soapFactory.createElement(LOCALES_ELEMENT);
        }
        catch (SOAPException se) {
            se.printStackTrace();
        }
        for (int i = 0; i < locales.length; ++i) {
            try {
                localesElement.addChildElement(XmlSoap.localeToElement(locales[i]));
                continue;
            }
            catch (SOAPException se) {
                FFDCFilter.processException((Throwable)se, "com.ibm.ws.i18n.context.util.XmlSoap.localesToElement", "230", class$com$ibm$ws$i18n$context$util$XmlSoap == null ? XmlSoap.class$("com.ibm.ws.i18n.context.util.XmlSoap") : class$com$ibm$ws$i18n$context$util$XmlSoap);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "localesToElement", "Exception: " + (Object)((Object)se));
                }
                se.printStackTrace();
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "localesToElement", localesElement);
        }
        return localesElement;
    }

    private static javax.xml.soap.SOAPElement localeToElement(Locale locale) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "localeToElement");
        }
        javax.xml.soap.SOAPElement localeElement = null;
        try {
            localeElement = soapFactory.createElement(LOCALE_ELEMENT);
        }
        catch (SOAPException se) {
            se.printStackTrace();
        }
        javax.xml.soap.SOAPElement countryElement = XmlSoap.countryCodeToElement(locale.getCountry());
        javax.xml.soap.SOAPElement languageElement = XmlSoap.languageCodeToElement(locale.getLanguage());
        javax.xml.soap.SOAPElement variantElement = XmlSoap.variantCodeToElement(locale.getVariant());
        if (null != languageElement) {
            try {
                localeElement.addChildElement(languageElement);
            }
            catch (SOAPException se) {
                FFDCFilter.processException((Throwable)se, "com.ibm.ws.i18n.context.util.XmlSoap.localeToElement", "280", XmlSoap.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "localeToElement", "Exception: " + (Object)((Object)se));
                }
                se.printStackTrace();
            }
        }
        if (null != countryElement) {
            try {
                localeElement.addChildElement(countryElement);
            }
            catch (SOAPException se) {
                FFDCFilter.processException((Throwable)se, "com.ibm.ws.i18n.context.util.XmlSoap.localeToElement", "290", XmlSoap.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "localeToElement", "Exception: " + (Object)((Object)se));
                }
                se.printStackTrace();
            }
        }
        if (null != variantElement) {
            try {
                localeElement.addChildElement(variantElement);
            }
            catch (SOAPException se) {
                FFDCFilter.processException((Throwable)se, "com.ibm.ws.i18n.context.util.XmlSoap.localeToElement", "302", XmlSoap.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "localeToElement", "Exception: " + (Object)((Object)se));
                }
                se.printStackTrace();
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "localeToElement", localeElement);
        }
        return localeElement;
    }

    private static javax.xml.soap.SOAPElement languageCodeToElement(String languageCode) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "languageCodeToElement");
        }
        javax.xml.soap.SOAPElement languageCodeElement = null;
        if (null != languageCode && !languageCode.equals(I18N_CONTEXT_PREFIX)) {
            try {
                languageCodeElement = soapFactory.createElement(LANGUAGE_CODE_ELEMENT);
                languageCodeElement.addTextNode(languageCode);
            }
            catch (SOAPException se) {
                FFDCFilter.processException((Throwable)se, "com.ibm.ws.i18n.context.util.XmlSoap.languageCodeToElement", "340", XmlSoap.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "languageCodeToElement", "Exception: " + (Object)((Object)se));
                }
                se.printStackTrace();
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "languageCodeToElement", languageCodeElement);
        }
        return languageCodeElement;
    }

    private static javax.xml.soap.SOAPElement countryCodeToElement(String countryCode) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "countryCodeToElement");
        }
        javax.xml.soap.SOAPElement countryCodeElement = null;
        if (null != countryCode && !countryCode.equals(I18N_CONTEXT_PREFIX)) {
            try {
                countryCodeElement = soapFactory.createElement(COUNTRY_CODE_ELEMENT);
                countryCodeElement.addTextNode(countryCode);
            }
            catch (SOAPException se) {
                FFDCFilter.processException((Throwable)se, "com.ibm.ws.i18n.context.util.XmlSoap.countryCodeToElement", "375", XmlSoap.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "countryCodeToElement", "Exception: " + (Object)((Object)se));
                }
                se.printStackTrace();
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "countryCodeToElement", countryCodeElement);
        }
        return countryCodeElement;
    }

    private static javax.xml.soap.SOAPElement variantCodeToElement(String variantCode) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "variantCodeToElement");
        }
        javax.xml.soap.SOAPElement variantCodeElement = null;
        if (null != variantCode && !variantCode.equals(I18N_CONTEXT_PREFIX)) {
            try {
                variantCodeElement = soapFactory.createElement(VARIANT_CODE_ELEMENT);
                variantCodeElement.addTextNode(variantCode);
            }
            catch (SOAPException se) {
                FFDCFilter.processException((Throwable)se, "com.ibm.ws.i18n.context.util.XmlSoap.variantCodeToElement", "410", XmlSoap.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "variantCodeToElement", "Exception: " + (Object)((Object)se));
                }
                se.printStackTrace();
            }
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "variantCodeToElement", variantCodeElement);
        }
        return variantCodeElement;
    }

    private static javax.xml.soap.SOAPElement timeZoneIdToElement(java.util.TimeZone tz) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "timeZoneIdToElement");
        }
        String tzid = null;
        if (null != tz && "Custom".equals(tzid = tz.getID())) {
            tzid = tz.getDisplayName();
        }
        javax.xml.soap.SOAPElement timeZoneIdElement = null;
        try {
            timeZoneIdElement = soapFactory.createElement(TIMEZONE_ID_ELEMENT);
            timeZoneIdElement.addTextNode(tzid);
        }
        catch (SOAPException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.i18n.context.util.XmlSoap.timeZoneIdToElement", "455", XmlSoap.class);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "timeZoneIdToElement", "Exception: " + (Object)((Object)se));
            }
            se.printStackTrace();
        }
        if (isEntryEnabled) {
            Tr.exit(tc, "timeZoneIdToElement", timeZoneIdElement);
        }
        return timeZoneIdElement;
    }

    public static LocalThreadContext_20 toContext(javax.xml.soap.SOAPElement i18nElement) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "toContext");
        }
        Object[] locales = null;
        java.util.TimeZone timezone = null;
        try {
            SOAPElement localesList = ((SOAPElement)i18nElement).getChildElement(I18N_CONTEXT_PREFIX, LOCALES_ELEMENT);
            SOAPElement timeZoneId = ((SOAPElement)i18nElement).getChildElement(I18N_CONTEXT_PREFIX, TIMEZONE_ID_ELEMENT);
            int numOfLocales = localesList.getNumChildren();
            locales = new Locale[numOfLocales];
            for (int i = 0; i < numOfLocales; ++i) {
                locales[i] = XmlSoap.elementToLocale(localesList.getChildElement(i));
            }
            timezone = TimeZone.getById_20(timeZoneId.getValue());
        }
        catch (SOAPException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.i18n.context.util.XmlSoap.toContext", "495", XmlSoap.class);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "toContext", "Exception: " + (Object)((Object)se));
            }
            se.printStackTrace();
        }
        LocalThreadContext_20 ltc = LocalThreadContext_20.newInstance(locales, timezone, null, null, I18nAttr.CMI_RUN_AS_CALLER);
        if (isEntryEnabled) {
            Tr.exit(tc, "toContext", ltc);
        }
        return ltc;
    }

    private static Locale elementToLocale(javax.xml.soap.SOAPElement localeElement) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "elementToLocale");
        }
        Locale locale = null;
        String languageCode = I18N_CONTEXT_PREFIX;
        String countryCode = I18N_CONTEXT_PREFIX;
        String variantCode = I18N_CONTEXT_PREFIX;
        Iterator children = localeElement.getChildElements();
        Node child2 = null;
        String childName = null;
        while (children.hasNext()) {
            child2 = (Node)children.next();
            childName = ((SOAPElement)child2).getLocalPart();
            if (LANGUAGE_CODE_ELEMENT.equals(childName)) {
                languageCode = XmlSoap.elementToLanguageCode((javax.xml.soap.SOAPElement)child2);
                continue;
            }
            if (COUNTRY_CODE_ELEMENT.equals(childName)) {
                countryCode = XmlSoap.elementToCountryCode((javax.xml.soap.SOAPElement)child2);
                continue;
            }
            if (!VARIANT_CODE_ELEMENT.equals(childName)) continue;
            variantCode = XmlSoap.elementToVariantCode((javax.xml.soap.SOAPElement)child2);
        }
        locale = I18N_CONTEXT_PREFIX.equals(variantCode) ? new Locale(languageCode, countryCode) : new Locale(languageCode, countryCode, variantCode);
        if (isEntryEnabled) {
            Tr.exit(tc, "elementToLocale", locale);
        }
        return locale;
    }

    private static String elementToCountryCode(javax.xml.soap.SOAPElement countryCodeElement) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "elementToCountryCode");
        }
        String countryCode = null;
        countryCode = null == countryCodeElement || null == countryCodeElement.getValue() ? null : countryCodeElement.getValue();
        if (isEntryEnabled) {
            Tr.exit(tc, "elementToCountryCode", countryCode);
        }
        return countryCode;
    }

    private static String elementToLanguageCode(javax.xml.soap.SOAPElement languageCodeElement) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "elementToLanguageCode");
        }
        String languageCode = null;
        languageCode = null == languageCodeElement || null == languageCodeElement.getValue() ? null : languageCodeElement.getValue();
        if (isEntryEnabled) {
            Tr.exit(tc, "elementToLanguageCode", languageCode);
        }
        return languageCode;
    }

    private static String elementToVariantCode(javax.xml.soap.SOAPElement variantCodeElement) {
        boolean isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry(tc, "elementToVariantCode");
        }
        String variantCode = null;
        variantCode = null == variantCodeElement || null == variantCodeElement.getValue() ? null : variantCodeElement.getValue();
        if (isEntryEnabled) {
            Tr.exit(tc, "elementToVariantCode", variantCode);
        }
        return variantCode;
    }

    public static void main(String[] args) {
        Object[] locales = new Locale[]{new Locale("en", "US", "MN"), new Locale("en", "US"), new Locale("en", I18N_CONTEXT_PREFIX, "MN"), new Locale(I18N_CONTEXT_PREFIX, "US", "MN"), new Locale("en", I18N_CONTEXT_PREFIX), new Locale(I18N_CONTEXT_PREFIX, "US")};
        java.util.TimeZone timezone = java.util.TimeZone.getTimeZone("CST");
        LocalThreadContext_20 ltc_2 = LocalThreadContext_20.newInstance(null, null, locales, timezone, I18nAttr.CMI_RUN_AS_CALLER);
        XmlSoap.initTest();
        try {
            javax.xml.soap.SOAPElement ccElement = null;
            ccElement = XmlSoap.countryCodeToElement(null);
            XmlSoap.log("countryCodeToElement(null): " + XmlSoap.elementToString(ccElement));
            XmlSoap.log("elementToCountryCode(CC): " + (null == XmlSoap.elementToCountryCode(ccElement) ? "<null>" : XmlSoap.elementToCountryCode(ccElement)));
            ccElement = XmlSoap.countryCodeToElement(I18N_CONTEXT_PREFIX);
            XmlSoap.log("countryCodeToElement(e): " + XmlSoap.elementToString(ccElement));
            XmlSoap.log("elementToCountryCode(CC): " + (null == XmlSoap.elementToCountryCode(ccElement) ? "<null>" : XmlSoap.elementToCountryCode(ccElement)));
            ccElement = XmlSoap.countryCodeToElement("CC");
            XmlSoap.log("countryCodeToElement(CC): " + XmlSoap.elementToString(ccElement));
            XmlSoap.log("countryCodeToElement(CC): " + XmlSoap.elementToCountryCode(ccElement));
            javax.xml.soap.SOAPElement vElement = null;
            vElement = XmlSoap.variantCodeToElement(null);
            XmlSoap.log("variantCodeToElement(null): " + XmlSoap.elementToString(vElement));
            vElement = XmlSoap.variantCodeToElement(I18N_CONTEXT_PREFIX);
            XmlSoap.log("variantCodeToElement(e): " + XmlSoap.elementToString(vElement));
            vElement = XmlSoap.variantCodeToElement("VC");
            XmlSoap.log("variantCodeToElement(VC): " + XmlSoap.elementToString(vElement));
            javax.xml.soap.SOAPElement lcElement = null;
            lcElement = XmlSoap.languageCodeToElement(null);
            XmlSoap.log("languageCodeToElement(null): " + XmlSoap.elementToString(lcElement));
            lcElement = XmlSoap.languageCodeToElement(I18N_CONTEXT_PREFIX);
            XmlSoap.log("languageCodeToElement(e): " + XmlSoap.elementToString(lcElement));
            lcElement = XmlSoap.languageCodeToElement("LC");
            XmlSoap.log("languageCodeToElement(LC): " + XmlSoap.elementToString(lcElement));
            javax.xml.soap.SOAPElement locElement = XmlSoap.localeToElement((Locale)locales[0]);
            XmlSoap.log("localeToElement(loc0): " + XmlSoap.elementToString(locElement));
            XmlSoap.log("elementToLocale(locE): " + XmlSoap.elementToLocale(locElement));
            locElement = XmlSoap.localeToElement((Locale)locales[1]);
            XmlSoap.log("localeToElement(loc1): " + XmlSoap.elementToString(locElement));
            XmlSoap.log("elementToLocale(locE): " + XmlSoap.elementToLocale(locElement));
            locElement = XmlSoap.localeToElement((Locale)locales[2]);
            XmlSoap.log("localeToElement(loc2): " + XmlSoap.elementToString(locElement));
            XmlSoap.log("elementToLocale(locE): " + XmlSoap.elementToLocale(locElement));
            locElement = XmlSoap.localeToElement((Locale)locales[3]);
            XmlSoap.log("localeToElement(loc3): " + XmlSoap.elementToString(locElement));
            XmlSoap.log("elementToLocale(locE): " + XmlSoap.elementToLocale(locElement));
            locElement = XmlSoap.localeToElement((Locale)locales[4]);
            XmlSoap.log("localeToElement(loc4): " + XmlSoap.elementToString(locElement));
            XmlSoap.log("elementToLocale(locE): " + XmlSoap.elementToLocale(locElement));
            locElement = XmlSoap.localeToElement((Locale)locales[5]);
            XmlSoap.log("localeToElement(loc5): " + XmlSoap.elementToString(locElement));
            XmlSoap.log("elementToLocale(locE): " + XmlSoap.elementToLocale(locElement));
            javax.xml.soap.SOAPElement locsElement = XmlSoap.localesToElement((Locale[])locales);
            XmlSoap.log("localesToElement(locs): " + XmlSoap.elementToString(locsElement));
            javax.xml.soap.SOAPElement tzidElement = XmlSoap.timeZoneIdToElement(timezone);
            XmlSoap.log("timeZoneIdToElement(loc1): " + XmlSoap.elementToString(tzidElement));
            javax.xml.soap.SOAPElement icElement = XmlSoap.fromContext(ltc_2);
            XmlSoap.log("fromContext(ltc_2): \n" + XmlSoap.elementToString(icElement));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void initTest() {
    }

    public static void log(String msg) {
        System.out.println(null == msg ? "null" : msg);
    }

    public static String elementToString(javax.xml.soap.SOAPElement element) {
        StringBuffer result = XmlSoap._elementToString(element, 0, new StringBuffer(I18N_CONTEXT_PREFIX));
        return result.toString();
    }

    public static StringBuffer _elementToString(javax.xml.soap.SOAPElement element, int indent, StringBuffer sb) {
        String iStr = XmlSoap.getIndent(indent);
        if (null == element) {
            sb.append(XmlSoap.getIndent(indent) + "null");
        } else if (((SOAPElement)element).getNumChildren() == 0) {
            sb.append(XmlSoap.getIndent(indent) + "<" + ((SOAPElement)element).getLocalPart() + " " + ((SOAPElement)element).getValue() + ">");
        } else {
            sb.append(XmlSoap.getIndent(indent) + "<" + ((SOAPElement)element).getLocalPart());
            sb.append("\n");
            ++indent;
            int n = 0;
            Iterator i = element.getChildElements();
            while (i.hasNext()) {
                ++n;
                XmlSoap._elementToString((javax.xml.soap.SOAPElement)i.next(), indent, sb);
                if (!i.hasNext()) continue;
                sb.append("\n");
            }
            sb.append(">");
        }
        return sb;
    }

    public static String getIndent(int indent) {
        StringBuffer sb = new StringBuffer(I18N_CONTEXT_PREFIX);
        for (int i = 0; i < indent; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }

    static {
        try {
            I18N_CONTEXT_SAAJ_NAME = soapFactory.createName(I18N_CONTEXT_ELEMENT, I18N_CONTEXT_PREFIX, I18N_CONTEXT_NAMESPACE);
        }
        catch (SOAPException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.i18n.context.util.XmlSoap.static", "109", XmlSoap.class);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "static", "Exception: " + (Object)((Object)se));
            }
            se.printStackTrace();
        }
        cachedDefaultLocale = Locale.getDefault();
        cachedDefaultLocalesElement = XmlSoap.localesToElement(new Locale[]{cachedDefaultLocale});
        cachedDefaultTimeZone = java.util.TimeZone.getDefault();
        cachedDefaultTimeZoneIdElement = XmlSoap.timeZoneIdToElement(cachedDefaultTimeZone);
    }
}

