/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.iiop.channel.impl;

import com.ibm.CORBA.channel.ConnectionKeyGenerator;
import com.ibm.CORBA.channel.IIOPChannelPlugin;
import com.ibm.CORBA.channel.giop.GIOPChannelHelper;
import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.channel.giop.GIOPInboundChannelFactory;
import com.ibm.CORBA.channel.giop.GIOPOutboundChannelFactory;
import com.ibm.CORBA.channel.orb.ORBInboundChannelFactory;
import com.ibm.CORBA.channel.orb.ORBOutboundChannelFactory;
import com.ibm.CORBA.channel.orb.ORBWorkQueueUsePolicy;
import com.ibm.CORBA.iiop.ClientDelegate;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.iiop.channel.impl.ConnectionKeyGeneratorImpl;
import com.ibm.ws.iiop.channel.impl.DefaultChainManager;
import com.ibm.ws.iiop.channel.impl.IIOPChannelConstants;
import com.ibm.ws.orb.transport.ConnectionInterceptor;
import com.ibm.ws.orb.transport.DefaultConnectionInterceptor;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.ChannelFrameworkFactory;
import com.ibm.wsspi.iiop.channel.ChainManager;
import com.ibm.wsspi.iiop.channel.TransportPlugin;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.TRANSIENT;

public class ChannelTransport
implements IIOPChannelPlugin,
TransportPlugin {
    private static String ME = ChannelTransport.class.getName();
    private static Logger log = Logger.getLogger(ME, "com.ibm.ws.iiop.channel.resources.IIOPMsgs");
    protected ORB orb;
    protected ChannelFramework cfw;
    protected String inboundGroupName;
    protected String outboundGroupName;
    protected String outboundSecureGroupName;
    protected ConnectionInterceptor interceptor;
    protected ChainManager chainMgr;
    protected Class orbInFactory;
    protected Class orbOutFactory;
    protected Class giopInFactory;
    protected Class giopOutFactory;
    protected Class tcpFactory;
    protected Class sslFactory;
    protected Class httpInFactory;
    protected Class httpOutFactory;
    protected Class httpTunnelInFactory;
    protected Class httpTunnelOutFactory;
    protected boolean isServerManaged;
    protected Boolean inboundTunnelingEnabled = null;
    protected Boolean outboundTunnelingEnabled = null;
    protected String tunnelURLProp = null;

    public ChannelTransport() {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "<constructor>");
            log.exiting(ME, "<constructor>");
        }
    }

    public ConnectionKeyGenerator getConnectionKeyGenerator(IOR iOR, ClientDelegate clientDelegate, String string) {
        String string2;
        String string3 = ME + "." + "getConnectionKeyGenerator";
        if (iOR == null) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Cannot generate ConnectionKeyGenerator with null IOR");
            }
            return null;
        }
        Profile profile = iOR.getProfile();
        String string4 = null;
        ConnectionKeyGeneratorImpl connectionKeyGeneratorImpl = null;
        if (log.isLoggable(Level.FINE)) {
            string2 = "Profile host and port=" + profile.getHost() + ":" + profile.getPort() + ", operation=" + string + " ClientDelegate=" + clientDelegate;
            log.entering(ME, "getConnectionKeyGenerator", string2);
        }
        try {
            connectionKeyGeneratorImpl = new ConnectionKeyGeneratorImpl(this, this.orb);
            string2 = null;
            IOR iOR2 = clientDelegate.locatedIOR();
            if (clientDelegate != null && iOR2 != null && !iOR2.isBootstrap()) {
                string2 = this.orb.IORToObject(iOR);
                string4 = string2.getClass().getName();
            }
            connectionKeyGeneratorImpl.init(iOR, string, string4, null);
        }
        catch (Exception exception) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Caught Exception", exception);
            }
            FFDCFilter.processException((Throwable)exception, (String)string3, (String)"184", (Object)this);
            String string5 = "Exception occurred in getConnectionKeyGenerator() operation returned false.";
            log.logp(Level.SEVERE, ME, "getConnectionKeyGenerator", "get.conn.key", new Object[]{"IIOP profile=" + profile + ", ClientDelegate=" + clientDelegate, string5});
            TRANSIENT tRANSIENT = new TRANSIENT(string5, 1229066353, CompletionStatus.COMPLETED_NO);
            FFDCFilter.processException((Throwable)tRANSIENT, (String)string3, (String)"192", (Object)this);
            throw tRANSIENT;
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "getConnectionKeyGenerator", connectionKeyGeneratorImpl);
        }
        return connectionKeyGeneratorImpl;
    }

    public ChannelFramework getChannelFramework() {
        return this.cfw;
    }

    public String getChainGroupName() {
        return this.inboundGroupName;
    }

    public String getOutboundChainGroupName() {
        return this.outboundGroupName;
    }

    public String getOutboundSecureChainGroupName() {
        return this.outboundSecureGroupName;
    }

    public Object getServerConnectionData(GIOPConnectionContext gIOPConnectionContext) {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "getServerConnectionData", gIOPConnectionContext);
        }
        Object object = this.interceptor.getServerConnectionData(gIOPConnectionContext);
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "getServerConnectionData", object);
        }
        return object;
    }

    public void shutdown() {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "shutdown");
            log.exiting(ME, "shutdown");
        }
    }

    protected void getChannelTransportProperties() {
        String string = null;
        string = this.orb.getProperty("com.ibm.ws.iiop.channel.ServerManaged");
        if (string != null && string.length() != 0 && string.equalsIgnoreCase("true")) {
            this.isServerManaged = true;
            this.inboundGroupName = "WAS-IIOP";
        } else {
            this.isServerManaged = false;
            this.inboundGroupName = "WAS-IIOP-IN-" + this.orb.getORBId();
        }
        this.outboundGroupName = "WAS-IIOP-OUT-" + this.orb.getORBId();
        this.outboundSecureGroupName = "WAS-IIOP-OUT_SECURE-" + this.orb.getORBId();
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "getChannelTransportProperties", new Object[]{this.inboundGroupName, this.outboundGroupName, this.outboundSecureGroupName});
        }
    }

    protected void createChainManager() {
        if (this.chainMgr != null) {
            return;
        }
        Object object = this.newInstance("com.ibm.ws.iiop.channel.ChainManager");
        this.chainMgr = object instanceof ChainManager ? (ChainManager)object : new DefaultChainManager();
    }

    protected void createConnectionInterceptor() {
        if (this.interceptor != null) {
            return;
        }
        Object object = this.newInstance("com.ibm.ws.orb.transport.ConnectionInterceptorName");
        this.interceptor = object instanceof ConnectionInterceptor ? (ConnectionInterceptor)object : new DefaultConnectionInterceptor();
    }

    protected void initializeFactories() throws ClassNotFoundException {
        this.httpInFactory = null;
        this.httpOutFactory = null;
        this.httpTunnelInFactory = null;
        this.httpTunnelOutFactory = null;
        if (this.isServerManaged) {
            this.orbInFactory = Class.forName(IIOPChannelConstants.ORB_IN_FACTORY_CLASS_NAME);
            this.orbOutFactory = Class.forName(IIOPChannelConstants.ORB_OUT_FACTORY_CLASS_NAME);
            this.giopInFactory = Class.forName(IIOPChannelConstants.GIOP_IN_FACTORY_CLASS_NAME);
            this.giopOutFactory = Class.forName(IIOPChannelConstants.GIOP_OUT_FACTORY_CLASS_NAME);
            this.tcpFactory = Class.forName(IIOPChannelConstants.TCP_SERVER_FACTORY_CLASS_NAME);
            this.sslFactory = Class.forName(IIOPChannelConstants.SSL_SERVER_FACTORY_CLASS_NAME);
        } else {
            this.orbInFactory = ORBInboundChannelFactory.class;
            this.orbOutFactory = ORBOutboundChannelFactory.class;
            this.giopInFactory = GIOPInboundChannelFactory.class;
            this.giopOutFactory = GIOPOutboundChannelFactory.class;
            this.tcpFactory = this.tryFactoryClass(IIOPChannelConstants.TCP_SERVER_FACTORY_CLASS_NAME, IIOPChannelConstants.TCP_FACTORY_CLASS);
            this.sslFactory = this.tryFactoryClass(IIOPChannelConstants.SSL_SERVER_FACTORY_CLASS_NAME, IIOPChannelConstants.SSL_FACTORY_CLASS);
        }
    }

    protected Class tryFactoryClass(String string, Class clazz) {
        Class clazz2 = null;
        try {
            clazz2 = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz2 = clazz;
        }
        return clazz2;
    }

    public void init(ORB oRB) {
        String string = ME + "." + "init";
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "init", oRB);
        }
        GIOPChannelHelper.setOrb((ORB)oRB);
        this.orb = oRB;
        this.cfw = ChannelFrameworkFactory.getChannelFramework();
        try {
            this.getChannelTransportProperties();
            this.initializeFactories();
            this.createChainManager();
            this.createConnectionInterceptor();
            this.interceptor.init(oRB);
            this.chainMgr.init(oRB, this, this.interceptor);
            this.chainMgr.notifyConnectionInterceptor();
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Caught Exception", classNotFoundException);
            }
            FFDCFilter.processException((Throwable)classNotFoundException, (String)string, (String)"468", (Object)this);
            log.logp(Level.SEVERE, ME, "init", "init.config", classNotFoundException.getMessage());
            INITIALIZE iNITIALIZE = new INITIALIZE(classNotFoundException.getMessage(), 1229066367, CompletionStatus.COMPLETED_NO);
            throw iNITIALIZE;
        }
        catch (Exception exception) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Caught Exception", exception);
            }
            FFDCFilter.processException((Throwable)exception, (String)string, (String)"480", (Object)this);
            log.logp(Level.SEVERE, ME, "init", "init.config", exception.getMessage());
            INITIALIZE iNITIALIZE = new INITIALIZE(exception.getMessage(), 1229066366, CompletionStatus.COMPLETED_NO);
            throw iNITIALIZE;
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "init", this);
        }
    }

    private Object newInstance(String string) {
        String string2 = ME + "." + "newInstance";
        String string3 = this.orb.getProperty(string);
        Object var5_4 = null;
        if (string3 != null && string3.length() != 0) {
            try {
                var5_4 = Class.forName(string3).newInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)string2, (String)"514", (Object)this);
                String string4 = "The value of ORB property " + string + "=" + string3 + " is invalid, verify the ORB service configuration.";
                log.logp(Level.WARNING, ME, "newInstance", "init.config", string4);
            }
        }
        return var5_4;
    }

    public boolean isServerManaged() {
        return this.isServerManaged;
    }

    public ConnectionInterceptor getInterceptor() {
        return this.interceptor;
    }

    public ChainManager getChainManager() {
        return this.chainMgr;
    }

    public Class getORBInboundChannelFactoryClass() {
        return this.orbInFactory;
    }

    public Class getORBOutboundChannelFactoryClass() {
        return this.orbOutFactory;
    }

    public Class getGIOPInboundChannelFactoryClass() {
        return this.giopInFactory;
    }

    public Class getGIOPOutboundChannelFactoryClass() {
        return this.giopOutFactory;
    }

    public Class getTCPChannelFactoryClass() {
        return this.tcpFactory;
    }

    public Class getSSLChannelFactoryClass() {
        return this.sslFactory;
    }

    public Class getHTTPInboundChannelFactoryClass() {
        String string = ME + "." + "getHTTPInboundChannelFactoryClass";
        if (this.httpInFactory == null) {
            try {
                this.httpInFactory = Class.forName("com.ibm.ws.http.channel.inbound.impl.HttpInboundChannelFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Caught Exception", classNotFoundException);
                }
                FFDCFilter.processException((Throwable)classNotFoundException, (String)string, (String)"620", (Object)this);
                log.logp(Level.SEVERE, ME, "getHTTPInboundChannelFactoryClass", "init.config", classNotFoundException.getMessage());
                INITIALIZE iNITIALIZE = new INITIALIZE(classNotFoundException.getMessage(), 1229066480, CompletionStatus.COMPLETED_NO);
                throw iNITIALIZE;
            }
        }
        return this.httpInFactory;
    }

    public Class getHTTPOutboundChannelFactoryClass() {
        String string = ME + "." + "getHTTPOutboundChannelFactoryClass";
        if (this.httpOutFactory == null) {
            try {
                this.httpOutFactory = Class.forName("com.ibm.ws.http.channel.outbound.impl.HttpOutboundChannelFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Caught Exception", classNotFoundException);
                }
                FFDCFilter.processException((Throwable)classNotFoundException, (String)string, (String)"651", (Object)this);
                log.logp(Level.SEVERE, ME, "getHTTPOutboundChannelFactoryClass", "init.config", classNotFoundException.getMessage());
                INITIALIZE iNITIALIZE = new INITIALIZE(classNotFoundException.getMessage(), 1229066481, CompletionStatus.COMPLETED_NO);
                throw iNITIALIZE;
            }
        }
        return this.httpOutFactory;
    }

    public Class getHTTPTunnelInboundChannelFactoryClass() {
        String string = ME + "." + "getHTTPTunnelInboundChannelFactoryClass";
        if (this.httpTunnelInFactory == null) {
            try {
                this.httpTunnelInFactory = Class.forName("com.ibm.wkplc.httptunnel.inbound.impl.HttpTunnelProtocolChannelFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Caught Exception", classNotFoundException);
                }
                FFDCFilter.processException((Throwable)classNotFoundException, (String)string, (String)"681", (Object)this);
                log.logp(Level.SEVERE, ME, "getHTTPTunnelInboundChannelFactoryClass", "init.config", classNotFoundException.getMessage());
                INITIALIZE iNITIALIZE = new INITIALIZE(classNotFoundException.getMessage(), 1229066482, CompletionStatus.COMPLETED_NO);
                throw iNITIALIZE;
            }
        }
        return this.httpTunnelInFactory;
    }

    public Class getHTTPTunnelOutboundChannelFactoryClass() {
        String string = ME + "." + "getHTTPTunnelOutboundChannelFactoryClass";
        if (this.httpTunnelOutFactory == null) {
            try {
                this.httpTunnelOutFactory = Class.forName("com.ibm.wkplc.httptunnel.outbound.impl.HttpTunnelOutboundProtocolChannelFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Caught Exception", classNotFoundException);
                }
                FFDCFilter.processException((Throwable)classNotFoundException, (String)string, (String)"711", (Object)this);
                log.logp(Level.SEVERE, ME, "getHTTPTunnelOutboundChannelFactoryClass", "init.config", classNotFoundException.getMessage());
                INITIALIZE iNITIALIZE = new INITIALIZE(classNotFoundException.getMessage(), 1229066483, CompletionStatus.COMPLETED_NO);
                throw iNITIALIZE;
            }
        }
        return this.httpTunnelOutFactory;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[hashCode=" + this.hashCode() + ",orbId=" + (this.orb == null ? "<unknown>" : this.orb.getORBId()) + "]";
    }

    public boolean isInboundTunnelingEnabled() {
        if (this.inboundTunnelingEnabled == null) {
            this.inboundTunnelingEnabled = Boolean.FALSE;
            String string = this.orb.getProperty("com.ibm.ws.iiop.channel.EnableInboundTunneling");
            if (string != null && string.equalsIgnoreCase("true")) {
                this.inboundTunnelingEnabled = Boolean.TRUE;
            }
        }
        if (log.isLoggable(Level.FINER)) {
            log.logp(Level.FINER, ME, "isInboundTunnelingEnabled", this.inboundTunnelingEnabled.toString());
        }
        return this.inboundTunnelingEnabled;
    }

    public boolean isOutboundTunnelingEnabled() {
        if (this.outboundTunnelingEnabled == null) {
            this.outboundTunnelingEnabled = Boolean.FALSE;
            if (!this.getHTTPTunnelURL().equals("") && (this.getForceTunnel().equals("whenrequired") || this.getForceTunnel().equals("always"))) {
                this.outboundTunnelingEnabled = Boolean.TRUE;
            }
        }
        if (log.isLoggable(Level.FINER)) {
            log.logp(Level.FINER, ME, "newInstance", this.outboundTunnelingEnabled.toString());
        }
        return this.outboundTunnelingEnabled;
    }

    public String getHTTPTunnelURL() {
        if (this.tunnelURLProp == null) {
            this.tunnelURLProp = "";
            String string = this.orb.getProperty("com.ibm.CORBA.TunnelAgentURL");
            if (string != null && !string.equals("")) {
                this.tunnelURLProp = string;
            }
            this.getForceTunnel();
        }
        if (log.isLoggable(Level.FINER)) {
            log.logp(Level.FINER, ME, "newInstance", "tunnel URL=" + this.tunnelURLProp);
        }
        return this.tunnelURLProp;
    }

    private String getForceTunnel() {
        String string = this.orb.getProperty("com.ibm.CORBA.ForceTunnel");
        if (string != null) {
            string = string.toLowerCase();
            if (log.isLoggable(Level.FINER)) {
                log.logp(Level.FINER, ME, "newInstance", "com.ibm.CORBA.ForceTunnel=" + string);
            }
            if (string.equals("never")) {
                this.tunnelURLProp = "";
            } else if (string.equals("always")) {
                if (this.tunnelURLProp == null || this.tunnelURLProp.equals("")) {
                    log.logp(Level.WARNING, ME, "newInstance", "force.tunnel.prop", "Tunnel URL is not set; tunneling not enabled.");
                }
            } else if (!string.equals("whenrequired")) {
                string = "";
            }
        } else {
            string = "";
        }
        return string;
    }

    public int nextRequestId(GIOPConnectionContext gIOPConnectionContext) {
        return 0;
    }

    public ORBWorkQueueUsePolicy getOrbWorkQueueUsePolicy() {
        return ORBWorkQueueUsePolicy.ALWAYS;
    }
}

