/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.iiop.channel.impl;

import com.ibm.CORBA.channel.ConnectionKeyGenerator;
import com.ibm.CORBA.channel.giop.GIOPConnectionKey;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ORBUtil;
import com.ibm.ws.iiop.channel.impl.ChannelTransport;
import com.ibm.ws.iiop.channel.impl.IIOPEndpoint;
import com.ibm.ws.orb.transport.IIOPEndpointProfile;
import com.ibm.wsspi.iiop.channel.TransportPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;

public class ConnectionKeyGeneratorImpl
implements ConnectionKeyGenerator {
    private static final String ME = ConnectionKeyGeneratorImpl.class.getName();
    private static final Logger log = Logger.getLogger(ME, "com.ibm.ws.iiop.channel.resources.IIOPMsgs");
    protected TransportPlugin plugin;
    protected ORB orb;
    protected IOR activeIOR;
    protected String operation;
    protected String stubClassName;
    protected ArrayList possibleConnections;
    protected int retryCount = 0;

    public ConnectionKeyGeneratorImpl(ChannelTransport channelTransport, ORB oRB) {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "<constructor>", new Object[]{channelTransport, oRB});
        }
        if (oRB == null) {
            throw new BAD_PARAM("ORB not initialized in ConnectionKeyGeneratorImpl", 1229066492, CompletionStatus.COMPLETED_NO);
        }
        if (channelTransport == null) {
            throw new BAD_PARAM("ChannelTransport not initialized in ConnectionKeyGeneratorImpl", 1229066492, CompletionStatus.COMPLETED_NO);
        }
        this.orb = oRB;
        this.plugin = channelTransport;
        this.possibleConnections = new ArrayList();
        this.retryCount = 0;
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "<constructor>");
        }
    }

    public void initLocate(IOR iOR) {
        this.init(iOR, null, null, null);
    }

    public void init(IOR iOR, String string) {
        this.init(iOR, string, null, null);
    }

    public void init(IOR iOR, String string, String string2) {
        this.init(iOR, string, string2, null);
    }

    public void init(IOR iOR, String string, String string2, GIOPConnectionKey gIOPConnectionKey) {
        if (iOR == null) {
            throw new BAD_PARAM("ConnectionKeyGenerator can not be initialized without a target IOR", 1229066492, CompletionStatus.COMPLETED_NO);
        }
        String string3 = iOR.getTypeId();
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "init", string3);
        }
        this.activeIOR = iOR;
        this.operation = string;
        if (string2 == null && string3 != null && string3.length() > 0) {
            string2 = ORBUtil.stubNameFromRepId((String)string3);
        }
        this.stubClassName = string2;
        if (log.isLoggable(Level.FINER)) {
            if (string != null) {
                log.log(Level.FINER, "init - operation", string);
            }
            log.log(Level.FINER, "init - stubClass", iOR);
            log.log(Level.FINER, "init - IOR", iOR);
        }
        IIOPEndpointProfile[] iIOPEndpointProfileArray = this.plugin.getInterceptor().getIIOPEndpointProfiles(iOR, this.stubClassName, string);
        this.possibleConnections.addAll(Arrays.asList(iIOPEndpointProfileArray));
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "init", this);
        }
    }

    public GIOPConnectionKey getNextKey() {
        if (this.activeIOR == null) {
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "getNextKey", new Object[]{this.activeIOR, "attempt=" + Integer.valueOf(this.retryCount)});
        }
        IIOPEndpoint iIOPEndpoint = null;
        if (this.retryCount < this.possibleConnections.size()) {
            IIOPEndpointProfile iIOPEndpointProfile = (IIOPEndpointProfile)this.possibleConnections.get(this.retryCount);
            this.plugin.getChainManager().findOutboundChain(iIOPEndpointProfile);
            iIOPEndpoint = this.createKey((IIOPEndpointProfile)this.possibleConnections.get(this.retryCount));
        }
        ++this.retryCount;
        return iIOPEndpoint;
    }

    protected IIOPEndpoint createKey(IIOPEndpointProfile iIOPEndpointProfile) {
        return new IIOPEndpoint(this.plugin, iIOPEndpointProfile.getChainName(), iIOPEndpointProfile, this.orb.getConnectTimeout());
    }
}

