/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.iiop.channel.impl;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChainGroupData;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.channel.common.ChannelUtilsLogger;
import com.ibm.ws.iiop.channel.impl.ChannelTransport;
import com.ibm.ws.orb.transport.ConnectionData;
import com.ibm.ws.orb.transport.ConnectionInterceptor;
import com.ibm.ws.orb.transport.IIOPEndpointProfile;
import com.ibm.ws.orb.transport.ServerConnectionData;
import com.ibm.ws.orbimpl.transport.DefaultServerConnectionDataImpl;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChainGroupException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.InvalidChannelFactoryException;
import com.ibm.wsspi.iiop.channel.ChainManager;
import com.ibm.wsspi.iiop.channel.TransportPlugin;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.TRANSIENT;

public class DefaultChainManager
implements ChainManager {
    private static final String ME = DefaultChainManager.class.getName();
    private static final Logger log = Logger.getLogger(ME, "com.ibm.ws.iiop.channel.resources.IIOPMsgs");
    private static final String tracePrefix = "ORBRas";
    private static int dynamicPorts = 0;
    protected TransportPlugin plugin;
    protected ORB orb;
    protected ChannelFramework cfw;
    protected ConnectionInterceptor interceptor;
    protected ServerConnectionData[] inboundEndpoints;
    protected ArrayList secureChains;
    protected ArrayList insecureChains;
    protected boolean bootstrapChainEnabled;
    protected int bootstrapPort;
    protected String inChainGroupName = null;
    protected String outChainGroupName = null;
    protected String outSecureGroupName = null;

    protected static int getDynamicChainID() {
        return ++dynamicPorts;
    }

    public DefaultChainManager() {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "<constructor>");
        }
        this.bootstrapChainEnabled = true;
        this.bootstrapPort = 0;
        this.secureChains = new ArrayList();
        this.insecureChains = new ArrayList();
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "<constructor>");
        }
    }

    public String findOutboundChain(IIOPEndpointProfile iIOPEndpointProfile) throws TRANSIENT {
        String string = ME + "." + "findOutboundChain";
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "findOutboundChain", iIOPEndpointProfile);
        }
        Object var4_3 = null;
        Object var5_4 = null;
        ChannelFramework channelFramework = this.plugin.getChannelFramework();
        String string2 = iIOPEndpointProfile.getChainName();
        ConnectionData connectionData = iIOPEndpointProfile.getConnectionData();
        if (connectionData == null) {
            String string3 = "ConnectionData must be specified as part of outbound connection profile.";
            log.logp(Level.SEVERE, ME, "findOutboundChain", "get.conn.key", new Object[]{connectionData, string3});
            TRANSIENT tRANSIENT = new TRANSIENT(string3, 1229066364, CompletionStatus.COMPLETED_NO);
            FFDCFilter.processException((Throwable)tRANSIENT, (String)string, (String)"182", (Object)this);
            throw tRANSIENT;
        }
        if (string2 == null) {
            string2 = this.interceptor.getChainName(this.orb, connectionData.getConnectionType());
            iIOPEndpointProfile.setChainName(string2);
        }
        if (string2 != null && channelFramework.getChain(string2) != null) {
            if (log.isLoggable(Level.FINE)) {
                log.exiting(ME, "findOutboundChain", string2);
            }
            return string2;
        }
        string2 = this.defineOutboundChain(channelFramework, iIOPEndpointProfile);
        if (string2 == null) {
            String string4 = "No IIOP transport outbound chains available.";
            log.logp(Level.SEVERE, ME, "findOutboundChain", "get.conn.key", new Object[]{connectionData, string4});
            TRANSIENT tRANSIENT = new TRANSIENT(string4, 1229066365, CompletionStatus.COMPLETED_NO);
            FFDCFilter.processException((Throwable)tRANSIENT, (String)string, (String)"211", (Object)this);
            throw tRANSIENT;
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "findOutboundChain", string2);
        }
        return string2;
    }

    public String defineOutboundChain(ChannelFramework channelFramework, IIOPEndpointProfile iIOPEndpointProfile) throws INITIALIZE {
        String string = ME + "." + "defineOutboundChain";
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "defineOutboundChain", iIOPEndpointProfile);
        }
        String string2 = null;
        String string3 = iIOPEndpointProfile.getChainName();
        ConnectionData connectionData = iIOPEndpointProfile.getConnectionData();
        String[] stringArray = null;
        Object var9_8 = null;
        if (channelFramework.getChain(string3) != null) {
            if (log.isLoggable(Level.FINE)) {
                log.exiting(ME, "defineOutboundChain", string3 + " is already defined, do not add it.");
            }
            return string3;
        }
        try {
            Map map = null;
            Map map2 = null;
            HashMap<String, ORB> hashMap = new HashMap<String, ORB>();
            hashMap.put("ORB", this.orb);
            HashMap hashMap2 = new HashMap();
            hashMap.put("ORB", this.orb);
            channelFramework.addChannel(string3 + "-orb", this.plugin.getORBOutboundChannelFactoryClass(), hashMap);
            channelFramework.addChannel(string3 + "-giop", this.plugin.getGIOPOutboundChannelFactoryClass(), hashMap2);
            channelFramework.addChannel(string3 + "-tcp", this.plugin.getTCPChannelFactoryClass(), map);
            switch ((int)connectionData.getConnectionType()) {
                case 1: {
                    channelFramework.addChannel(string3 + "-ssl", this.plugin.getSSLChannelFactoryClass(), map2);
                    stringArray = new String[]{string3 + "-orb", string3 + "-giop", string3 + "-ssl", string3 + "-tcp"};
                    string2 = this.plugin.getOutboundSecureChainGroupName();
                    break;
                }
                case 2: {
                    stringArray = new String[]{string3 + "-orb", string3 + "-giop", string3 + "-tcp"};
                    string2 = this.plugin.getOutboundChainGroupName();
                }
            }
            if (this.plugin.isOutboundTunnelingEnabled()) {
                stringArray = this.addTunnelingChannelsToOutboundChain(channelFramework, connectionData, stringArray);
            }
            channelFramework.addChain(string3, FlowType.OUTBOUND, stringArray);
            this.addChainToGroup(channelFramework, string2, string3);
        }
        catch (Exception exception) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Caught Exception", exception);
            }
            FFDCFilter.processException((Throwable)exception, (String)string, (String)"299", (Object)this);
            log.logp(Level.SEVERE, ME, "defineOutboundChain", "init.config", exception.getMessage());
            INITIALIZE iNITIALIZE = new INITIALIZE(exception.getMessage(), 1229066484, CompletionStatus.COMPLETED_NO);
            throw iNITIALIZE;
        }
        if (log.isLoggable(Level.FINE)) {
            ChannelUtilsLogger.displayChains(log, channelFramework, string2, "outbound chains", tracePrefix);
            log.exiting(ME, "defineOutboundChain", string3 + " defined");
        }
        return string3;
    }

    protected String defineInboundChain(ChannelFramework channelFramework, String string, ServerConnectionData serverConnectionData) throws Exception {
        String string2 = ME + "." + "defineInboundChain";
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "defineInboundChain", serverConnectionData);
        }
        String[] stringArray = null;
        int n = serverConnectionData.getServerPort();
        String string3 = n == 0 ? "in-dyn-" + DefaultChainManager.getDynamicChainID() : "in-" + n;
        String string4 = "iiop-" + string3;
        if (channelFramework.getChain(string4) != null) {
            if (log.isLoggable(Level.FINE)) {
                log.exiting(ME, "defineInboundChain", string4 + " is already defined, do not add it.");
            }
            return string4;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("port", Integer.toString(serverConnectionData.getServerPort()));
        Map map = null;
        HashMap<String, ORB> hashMap2 = new HashMap<String, ORB>();
        hashMap2.put("ORB", this.orb);
        HashMap<String, ORB> hashMap3 = new HashMap<String, ORB>();
        hashMap3.put("ORB", this.orb);
        channelFramework.addChannel(string3 + "-orb", this.plugin.getORBInboundChannelFactoryClass(), hashMap2);
        channelFramework.addChannel(string3 + "-giop", this.plugin.getGIOPInboundChannelFactoryClass(), hashMap3);
        channelFramework.addChannel(string3 + "-tcp", this.plugin.getTCPChannelFactoryClass(), hashMap);
        switch ((int)serverConnectionData.getConnectionType()) {
            case 1: {
                channelFramework.addChannel(string3 + "-ssl", this.plugin.getSSLChannelFactoryClass(), map);
                stringArray = new String[]{string3 + "-tcp", string3 + "-ssl", string3 + "-giop", string3 + "-orb"};
                this.secureChains.add(string4);
                break;
            }
            default: {
                stringArray = new String[]{string3 + "-tcp", string3 + "-giop", string3 + "-orb"};
                this.insecureChains.add(string4);
            }
        }
        channelFramework.addChain(string4, FlowType.INBOUND, stringArray);
        this.addChainToGroup(channelFramework, string, string4);
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "defineInboundChain", string4 + " defined");
        }
        return string4;
    }

    public ChainData[] defineInboundChainGroup(String string, ChannelFramework channelFramework) throws INITIALIZE {
        String string2 = ME + "." + "defineInboundChainGroup";
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "defineInboundChainGroup", string);
        }
        if (string == null) {
            if (log.isLoggable(Level.FINE)) {
                log.exiting(ME, "defineInboundChainGroup", string);
            }
            return null;
        }
        boolean bl = this.plugin.isServerManaged();
        ChainData[] chainDataArray = null;
        Object var7_6 = null;
        try {
            INITIALIZE iNITIALIZE;
            if (bl) {
                chainDataArray = channelFramework.getAllChains(this.plugin.getORBInboundChannelFactoryClass());
                if (log.isLoggable(Level.FINER)) {
                    ChannelUtilsLogger.displayChains(log, chainDataArray, "defineInboundChainGroup: checking for inbound chains", tracePrefix);
                }
                if (chainDataArray != null && chainDataArray.length > 0) {
                    Class clazz = null;
                    Class clazz2 = this.plugin.getTCPChannelFactoryClass();
                    Class clazz3 = this.plugin.getSSLChannelFactoryClass();
                    String[] stringArray = new String[chainDataArray.length];
                    for (int i = 0; i < chainDataArray.length; ++i) {
                        if (chainDataArray[i].getType() != FlowType.INBOUND) continue;
                        stringArray[i] = chainDataArray[i].getName();
                        boolean bl2 = false;
                        List<ChannelData> list = Arrays.asList(chainDataArray[i].getChannelList());
                        Iterator<ChannelData> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            iNITIALIZE = iterator.next();
                            clazz = iNITIALIZE.getFactoryType();
                            if (clazz == clazz3) {
                                bl2 = true;
                                break;
                            }
                            if (clazz == clazz2) continue;
                        }
                        if (bl2) {
                            this.secureChains.add(stringArray[i]);
                            continue;
                        }
                        this.insecureChains.add(stringArray[i]);
                    }
                    this.addChainsToGroup(channelFramework, string, stringArray);
                    if (log.isLoggable(Level.FINER)) {
                        ChannelUtilsLogger.displayChains(log, channelFramework, string, "defineInboundChainGroup: inbound chain group defined", tracePrefix);
                    }
                }
            }
            if (chainDataArray == null || chainDataArray.length <= 0) {
                chainDataArray = this.configureEndpointsInChainGroup(string, channelFramework);
            }
            if (chainDataArray == null || chainDataArray.length <= 0) {
                String string3 = bl ? "No server IIOP inbound chains or transport endpoints were found by the ORB" : "No client IIOP inbound transport endpoints were found by the ORB";
                iNITIALIZE = new INITIALIZE(string3, 1229066485, CompletionStatus.COMPLETED_NO);
                FFDCFilter.processException((Throwable)iNITIALIZE, (String)string2, (String)"528", (Object)this);
                throw iNITIALIZE;
            }
            if (bl) {
                this.manageBootstrapEndpoint(string, channelFramework);
                if (this.plugin.isInboundTunnelingEnabled()) {
                    this.defineInboundTunnelingChains(string, channelFramework);
                }
            }
        }
        catch (Exception exception) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Caught Exception", exception);
            }
            FFDCFilter.processException((Throwable)exception, (String)string2, (String)"549", (Object)this);
            log.logp(Level.SEVERE, ME, "defineInboundChainGroup", "init.config", exception.getMessage());
            INITIALIZE iNITIALIZE = new INITIALIZE(exception.getMessage(), 1229066486, CompletionStatus.COMPLETED_NO);
            throw iNITIALIZE;
        }
        chainDataArray = this.getConfiguredChainsInGroup(string);
        if (log.isLoggable(Level.FINE)) {
            ChannelUtilsLogger.displayChains(log, chainDataArray, "defineInboundChainGroup: inbound chain group defined", tracePrefix);
            log.exiting(ME, "defineInboundChainGroup", (chainDataArray == null ? 0 : chainDataArray.length) + " inbound chains defined");
        }
        return chainDataArray;
    }

    public void init(ORB oRB, TransportPlugin transportPlugin, ConnectionInterceptor connectionInterceptor) throws INITIALIZE {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "init");
        }
        this.orb = oRB;
        this.cfw = transportPlugin.getChannelFramework();
        this.plugin = transportPlugin;
        this.interceptor = connectionInterceptor;
        this.inChainGroupName = transportPlugin.getChainGroupName();
        this.outChainGroupName = transportPlugin.getOutboundChainGroupName();
        this.outSecureGroupName = transportPlugin.getOutboundSecureChainGroupName();
        this.getChainManagerProperties(oRB);
        String string = transportPlugin.getChainGroupName();
        if (string != null) {
            this.defineInboundChainGroup(string, this.cfw);
        }
        this.findConfiguredOutboundChains(this.cfw);
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "init", this);
        }
    }

    protected ChainData[] getConfiguredChainsInGroup(String string) throws INITIALIZE {
        ChainGroupData chainGroupData = null;
        ChainData[] chainDataArray = null;
        chainGroupData = this.plugin.getChannelFramework().getChainGroup(string);
        if (chainGroupData != null) {
            chainDataArray = chainGroupData.getChains();
        }
        return chainDataArray;
    }

    protected void findConfiguredOutboundChains(ChannelFramework channelFramework) throws INITIALIZE {
        String string = ME + "." + "findOutboundChains";
        String string2 = this.plugin.getOutboundChainGroupName();
        String string3 = this.plugin.getOutboundSecureChainGroupName();
        Class clazz = this.plugin.getSSLChannelFactoryClass();
        try {
            ChainData[] chainDataArray = channelFramework.getAllChains(this.plugin.getORBOutboundChannelFactoryClass());
            if (chainDataArray == null) {
                return;
            }
            List<ChainData> list = Arrays.asList(chainDataArray);
            Iterator<ChainData> iterator = list.iterator();
            while (iterator.hasNext()) {
                ChainData chainData = iterator.next();
                String string4 = chainData.getName();
                String string5 = string2;
                List<ChannelData> list2 = Arrays.asList(chainData.getChannelList());
                Iterator<ChannelData> iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    ChannelData channelData = iterator2.next();
                    Class clazz2 = channelData.getFactoryType();
                    if (!clazz.isAssignableFrom(clazz2)) continue;
                    string5 = string3;
                    break;
                }
                this.addChainToGroup(channelFramework, string5, string4);
            }
        }
        catch (Exception exception) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Caught Exception", exception);
            }
            FFDCFilter.processException((Throwable)exception, (String)string, (String)"696", (Object)this);
            log.logp(Level.SEVERE, ME, "findOutboundChains", "init.config", exception.getMessage());
            INITIALIZE iNITIALIZE = new INITIALIZE(exception.getMessage(), 1229066487, CompletionStatus.COMPLETED_NO);
            throw iNITIALIZE;
        }
    }

    protected ChainData[] configureEndpointsInChainGroup(String string, ChannelFramework channelFramework) throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "configureEndpointsInChainGroup", new Object[]{string});
        }
        boolean bl = this.plugin.isServerManaged();
        ServerConnectionData[] serverConnectionDataArray = null;
        if (bl) {
            serverConnectionDataArray = this.interceptor.getServerConnectionData(this.orb);
        } else {
            DefaultServerConnectionDataImpl defaultServerConnectionDataImpl = new DefaultServerConnectionDataImpl();
            defaultServerConnectionDataImpl.setServerPort(this.orb.getListenerPort());
            defaultServerConnectionDataImpl.setConnectionType(2L);
            serverConnectionDataArray = new ServerConnectionData[]{defaultServerConnectionDataImpl};
        }
        if (serverConnectionDataArray == null || serverConnectionDataArray.length <= 0) {
            if (log.isLoggable(Level.FINE)) {
                log.exiting(ME, "configureEndpointsInChainGroup", "No endpoints configured");
            }
            return null;
        }
        for (int i = 0; i < serverConnectionDataArray.length; ++i) {
            this.defineInboundChain(channelFramework, string, serverConnectionDataArray[i]);
        }
        ChainData[] chainDataArray = this.getConfiguredChainsInGroup(string);
        if (log.isLoggable(Level.FINE)) {
            ChannelUtilsLogger.displayChains(log, chainDataArray, "configureEndpointsInChainGroup", tracePrefix);
            log.exiting(ME, "configureEndpointsInChainGroup", (chainDataArray == null ? 0 : chainDataArray.length) + " chains configured");
        }
        return chainDataArray;
    }

    public String toString() {
        if (this.plugin != null) {
            ChainData[] chainDataArray = this.getConfiguredChainsInGroup(this.inChainGroupName);
            ChainData[] chainDataArray2 = this.getConfiguredChainsInGroup(this.outChainGroupName);
            ChainData[] chainDataArray3 = this.getConfiguredChainsInGroup(this.outSecureGroupName);
            return this.getClass().getSimpleName() + "[hashCode=" + this.hashCode() + ",orbId=" + (this.orb == null ? "<unknown>" : this.orb.getORBId()) + ",inbound: " + (chainDataArray == null ? 0 : chainDataArray.length) + ",outbound: " + (chainDataArray2 == null ? 0 : chainDataArray2.length) + " (secure), " + (chainDataArray3 == null ? 0 : chainDataArray3.length) + " (unsecure)]";
        }
        return super.toString();
    }

    protected String[] addTunnelingChannelsToOutboundChain(ChannelFramework channelFramework, ConnectionData connectionData, String[] stringArray) throws INITIALIZE {
        String string = ME + "." + "addTunnelingChannelsToOutboundChain";
        String[] stringArray2 = stringArray;
        try {
            String string2;
            String string3 = "out-" + connectionData.getLocalHost();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string4 = connectionData.getRemoteHost();
            int n = connectionData.getRemotePort();
            hashMap.put("uriPattern", this.getHttpTunnelURIPattern(string4, n));
            if (this.plugin instanceof ChannelTransport && !(string2 = ((ChannelTransport)this.plugin).getHTTPTunnelURL()).equals("")) {
                URL uRL = new URL(string2);
                connectionData.setRemoteHost(uRL.getHost());
                connectionData.setRemotePort(uRL.getPort());
            }
            channelFramework.addChannel("httptunnel-" + string3, this.plugin.getHTTPTunnelOutboundChannelFactoryClass(), hashMap);
            channelFramework.addChannel("http-" + string3, this.plugin.getHTTPOutboundChannelFactoryClass(), null);
            stringArray2 = new String[stringArray.length + 2];
            int n2 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (channelFramework.getChannel(stringArray[i]).getFactoryType() == this.plugin.getTCPChannelFactoryClass()) {
                    stringArray2[n2++] = "httptunnel-" + string3;
                    stringArray2[n2++] = "http-" + string3;
                }
                stringArray2[n2++] = stringArray[i];
            }
        }
        catch (Exception exception) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Caught Exception", exception);
            }
            FFDCFilter.processException((Throwable)exception, (String)string, (String)"862", (Object)this);
            log.logp(Level.SEVERE, ME, "addTunnelingChannelsToOutboundChain", "init.config", exception.getMessage());
            INITIALIZE iNITIALIZE = new INITIALIZE(exception.getMessage(), 1229066488, CompletionStatus.COMPLETED_NO);
            throw iNITIALIZE;
        }
        return stringArray2;
    }

    protected ChainData[] defineInboundTunnelingChains(String string, ChannelFramework channelFramework) throws INITIALIZE {
        String string2 = ME + "." + "defineInboundTunnelingChains";
        boolean bl = this.plugin.isServerManaged();
        int n = 0;
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "defineInboundTunnelingChains", "Chain group=" + string + ", isServerManaged=" + bl);
        }
        if (!bl) {
            if (log.isLoggable(Level.FINER)) {
                log.logp(Level.FINER, ME, "defineInboundTunnelingChains", "This is not a server. No tunneling chains will be built.");
            }
        } else {
            try {
                HashSet<String> hashSet = new HashSet<String>();
                ChainData[] chainDataArray = this.getConfiguredChainsInGroup(string);
                int n2 = chainDataArray == null ? 0 : chainDataArray.length;
                for (int i = 0; i < n2; ++i) {
                    String string3 = chainDataArray[i].getName();
                    if (log.isLoggable(Level.FINER)) {
                        log.logp(Level.FINER, ME, "defineInboundTunnelingChains", "iiop chain name=" + string3);
                    }
                    ChannelData[] channelDataArray = chainDataArray[i].getChannelList();
                    String[] stringArray = new String[channelDataArray.length + 2];
                    int n3 = 0;
                    boolean bl2 = false;
                    for (int j = 0; j < channelDataArray.length; ++j) {
                        String string4 = channelDataArray[j].getName();
                        stringArray[n3++] = string4;
                        Class clazz = channelDataArray[j].getFactoryType();
                        if (clazz == this.plugin.getTCPChannelFactoryClass()) {
                            bl2 = true;
                            String string5 = string4.replaceFirst("tcp", "http");
                            if (string5.equals(string4)) {
                                string5 = "http" + string4;
                            }
                            if (!hashSet.contains(string5)) {
                                channelFramework.addChannel(string5, this.plugin.getHTTPInboundChannelFactoryClass(), null);
                                channelFramework.updateChannelWeight(string5, 2);
                                hashSet.add(string5);
                            }
                            stringArray[n3++] = string5;
                            String string6 = string4.replaceFirst("tcp", "httptunnel");
                            if (string6.equals(string4)) {
                                string6 = "httptunnel" + string4;
                            }
                            if (!hashSet.contains(string6)) {
                                HashMap<String, String> hashMap = new HashMap<String, String>();
                                hashMap.put("pluginConfigurable", "true");
                                channelFramework.addChannel(string6, this.plugin.getHTTPTunnelInboundChannelFactoryClass(), hashMap);
                                hashSet.add(string6);
                            }
                            stringArray[n3++] = string6;
                            continue;
                        }
                        if (clazz != this.plugin.getHTTPTunnelInboundChannelFactoryClass()) continue;
                        bl2 = false;
                        break;
                    }
                    if (!bl2) continue;
                    String string7 = string3.replaceFirst("iiop", "iioptunnel");
                    if (string7.equals(string3)) {
                        string7 = "iioptunnel-" + string3;
                    }
                    if (log.isLoggable(Level.FINER)) {
                        log.logp(Level.FINER, ME, "defineInboundTunnelingChains", "adding tunneling iiop chain name=" + string7);
                    }
                    channelFramework.addChain(string7, FlowType.INBOUND, stringArray);
                    this.addChainToGroup(channelFramework, string, string7);
                    ++n;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)string2, (String)"1004", (Object)this);
                log.logp(Level.SEVERE, ME, "defineInboundTunnelingChains", "init.config", exception.getMessage());
                INITIALIZE iNITIALIZE = new INITIALIZE(exception.getMessage(), 1229066489, CompletionStatus.COMPLETED_NO);
                throw iNITIALIZE;
            }
        }
        if (log.isLoggable(Level.FINE)) {
            ChannelUtilsLogger.displayChains(log, channelFramework, string, "defineInboundTunnelingChains", tracePrefix);
            log.exiting(ME, "defineInboundTunnelingChains", "Number of tunneling chains configured: " + n);
        }
        return this.getConfiguredChainsInGroup(string);
    }

    protected String getHttpTunnelURIPattern(String string, int n) throws INITIALIZE {
        String string2 = ME + "." + "getHttpTunnelURIPattern";
        String string3 = "";
        try {
            Class<?> clazz = Class.forName("com.ibm.ws.httptunnel.channel.WSHttpTunnelPluginConfigHelper");
            Method method2 = clazz.getMethod("getURIAddition", String.class, Integer.TYPE);
            string3 = (String)method2.invoke(null, string, new Integer(n));
        }
        catch (Exception exception) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Caught Exception", exception);
            }
            FFDCFilter.processException((Throwable)exception, (String)string2, (String)"1050", (Object)this);
            log.logp(Level.SEVERE, ME, "getHttpTunnelURIPattern", "init.config", exception.getMessage());
            INITIALIZE iNITIALIZE = new INITIALIZE(exception.getMessage(), 1229066490, CompletionStatus.COMPLETED_NO);
            throw iNITIALIZE;
        }
        if (log.isLoggable(Level.FINER)) {
            log.logp(Level.FINER, ME, "getHttpTunnelURIPattern", string3);
        }
        return string3;
    }

    protected void manageBootstrapEndpoint(String string, ChannelFramework channelFramework) throws ChannelException, ChainException, ChainGroupException, InvalidChannelFactoryException {
        String[] stringArray;
        Object object;
        Object object2;
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "manageBootstrapEndpoint", "Chain group=" + string + ", isServerManaged=" + this.plugin.isServerManaged() + ", enabled=" + this.bootstrapChainEnabled + ", port=" + this.bootstrapPort);
        }
        ChainData[] chainDataArray = this.getConfiguredChainsInGroup(string);
        String string2 = Integer.toString(this.bootstrapPort);
        String string3 = null;
        boolean bl = false;
        if (chainDataArray != null && this.bootstrapPort >= 0) {
            object2 = Arrays.asList(chainDataArray);
            object = object2.iterator();
            while (object.hasNext()) {
                String string4;
                Map map;
                ChannelData channelData;
                stringArray = object.next();
                String string5 = stringArray.getName();
                if (stringArray.getType() != FlowType.INBOUND || (channelData = stringArray.getChannelList()[0]) == null || (map = channelData.getPropertyBag()) == null || (string4 = (String)map.get("port")) == null || !string4.equals(string2)) continue;
                bl = true;
                string3 = string5;
                break;
            }
        }
        if (bl) {
            if (this.bootstrapChainEnabled) {
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, ME, "manageBootstrapEndpoint", string3 + " chain is already defined, do not add it.");
                }
            } else {
                channelFramework.removeChain(string3);
                if (log.isLoggable(Level.FINER)) {
                    log.logp(Level.FINER, ME, "manageBootstrapEndpoint", "Bootstrap chain: " + string3 + " has been removed");
                }
            }
        } else if (this.bootstrapChainEnabled) {
            object2 = "in-" + string2;
            string3 = "iiop-" + (String)object2;
            object = new HashMap();
            object.put("port", string2);
            channelFramework.addChannel("tcp-" + (String)object2, this.plugin.getTCPChannelFactoryClass(), (Map)object);
            channelFramework.addChannel("giop-" + (String)object2, this.plugin.getGIOPInboundChannelFactoryClass(), null);
            channelFramework.addChannel("orb-" + (String)object2, this.plugin.getORBInboundChannelFactoryClass(), null);
            stringArray = new String[]{"tcp-" + (String)object2, "giop-" + (String)object2, "orb-" + (String)object2};
            channelFramework.addChain(string3, FlowType.INBOUND, stringArray);
            this.addChainToGroup(channelFramework, string, string3);
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "manageBootstrapEndpoint");
        }
    }

    protected void getChainManagerProperties(ORB oRB) {
        this.bootstrapPort = oRB.getBootstrapPort();
        String string = oRB.getProperty("com.ibm.ws.iiop.channel.BootstrapPortEnabled");
        boolean bl = this.plugin.isServerManaged();
        if (this.bootstrapChainEnabled && string != null && string.equalsIgnoreCase("false")) {
            this.bootstrapChainEnabled = false;
        }
        if (bl && this.bootstrapChainEnabled && this.bootstrapPort < 0) {
            String string2 = "com.ibm.CORBA.BootstrapPort=" + this.bootstrapPort + " is invalid.";
            log.logp(Level.SEVERE, ME, "getChainManagerProperties", "init.config", string2);
            INITIALIZE iNITIALIZE = new INITIALIZE(string2, 1229066491, CompletionStatus.COMPLETED_NO);
            throw iNITIALIZE;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("getChainManagerProperties: bootstrap(enabled=" + this.bootstrapChainEnabled + ", port=" + this.bootstrapPort + "), isServer=" + bl);
        }
    }

    protected void addChainToGroup(ChannelFramework channelFramework, String string, String string2) throws ChainException, ChainGroupException {
        if (channelFramework == null || string == null || string2 == null) {
            return;
        }
        ChainGroupData chainGroupData = channelFramework.getChainGroup(string);
        if (chainGroupData == null) {
            channelFramework.addChainGroup(string, new String[]{string2});
        } else if (!chainGroupData.containsChain(string2)) {
            channelFramework.addChainToGroup(string, string2);
        }
    }

    protected void addChainsToGroup(ChannelFramework channelFramework, String string, String[] stringArray) throws ChainException, ChainGroupException {
        if (channelFramework == null || string == null || stringArray == null || stringArray.length == 0) {
            return;
        }
        ChainGroupData chainGroupData = channelFramework.getChainGroup(string);
        if (chainGroupData == null) {
            channelFramework.addChainGroup(string, stringArray);
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                if (chainGroupData.containsChain(stringArray[i])) continue;
                channelFramework.addChainToGroup(string, stringArray[i]);
            }
        }
    }

    public void notifyConnectionInterceptor() {
        this.interceptor.notifyChainInitializationComplete(this.cfw, this.orb, this.secureChains, this.insecureChains);
    }
}

