/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.iiop.channel.impl;

import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.channel.giop.GIOPConnectionKey;
import com.ibm.CORBA.iiop.GIOPConnectionProfile;
import com.ibm.ws.connmgmt.ConnectionHandle;
import com.ibm.ws.orb.transport.ConnectionData;
import com.ibm.ws.orb.transport.ConnectionInformation;
import com.ibm.ws.orb.transport.IIOPEndpointProfile;
import com.ibm.ws.orbimpl.transport.ConnectionInformationImpl;
import com.ibm.wsspi.iiop.channel.TransportPlugin;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IIOPEndpoint
extends GIOPConnectionKey {
    private static String ME = IIOPEndpoint.class.getName();
    private static Logger log = Logger.getLogger(ME, "com.ibm.ws.iiop.channel.resources.IIOPMsgs");
    protected TransportPlugin plugin;
    protected ConnectionInformation connectionInfo;

    public IIOPEndpoint(TransportPlugin transportPlugin) {
        this.plugin = transportPlugin;
    }

    public IIOPEndpoint(TransportPlugin transportPlugin, String string, IIOPEndpointProfile iIOPEndpointProfile, int n) {
        this.plugin = transportPlugin;
        this.init(string, iIOPEndpointProfile, n);
    }

    protected void init(String string, IIOPEndpointProfile iIOPEndpointProfile, int n) {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "<constructor>", new Object[]{string, iIOPEndpointProfile});
        }
        X509Certificate[] x509CertificateArray = null;
        long l = System.currentTimeMillis();
        this.connectionInfo = new ConnectionInformationImpl(iIOPEndpointProfile.getConnectionData(), x509CertificateArray, l, null, -1);
        super.init(string, (GIOPConnectionProfile)iIOPEndpointProfile, n);
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "<constructor>", new Object[]{this.connectionInfo.toString()});
        }
    }

    public boolean equals(Object object) {
        Object object2;
        Object object3;
        boolean bl = false;
        if (object == this) {
            return true;
        }
        if (object instanceof IIOPEndpoint && (object3 = ((IIOPEndpoint)((Object)object)).getConnectionData()) instanceof ConnectionInformation && (object2 = ((ConnectionInformation)object3).getConnectionData()) instanceof ConnectionData) {
            String string = ((ConnectionData)object2).getConnectionKey();
            String string2 = ((ConnectionData)this.connectionInfo.getConnectionData()).getConnectionKey();
            bl = string2.equals(string);
        }
        return bl;
    }

    public int hashCode() {
        String string = ((ConnectionData)this.connectionInfo.getConnectionData()).getConnectionKey();
        int n = string.hashCode();
        return n;
    }

    public void addConnection(GIOPConnectionContext gIOPConnectionContext) {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "addConnection", "GIOPConnectionContext=" + gIOPConnectionContext);
        }
        ConnectionData connectionData = (ConnectionData)this.connectionInfo.getConnectionData();
        int n = gIOPConnectionContext.getLocalPort();
        connectionData.setLocalPort(n);
        ConnectionHandle connectionHandle = ConnectionHandle.getConnectionHandle(gIOPConnectionContext.getVirtualConnection());
        connectionData.setConnectionHandle(connectionHandle);
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "addConnection", "ConnectionData local port=" + n + ", Remote=" + this.getRemoteAddress());
        }
    }

    public void removeConnection() {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "removeConnection");
        }
        this.plugin.getInterceptor().notifyBrokenConnection(this.connectionInfo);
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "removeConnection");
        }
    }

    public Object getConnectionData() {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "getConnectionData");
            log.exiting(ME, "getConnectionData", this.connectionInfo);
        }
        return this.connectionInfo;
    }

    public void recycle() {
    }

    public String toString() {
        return super.toString() + " " + this.connectionInfo.toString();
    }
}

