/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.iiop.channel.impl;

import com.ibm.websphere.models.config.channelservice.InboundTransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelFactory;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.iiop.channel.impl.IIOPChannelConstants;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.WSAggregateChannelFactory;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFactoryData;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.OutboundChannelDefinition;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.ChannelFactoryException;
import com.ibm.wsspi.channel.framework.exception.ChannelFactoryPropertyIgnoredException;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IIOPInboundChannelFactory
implements WSAggregateChannelFactory {
    private static String ME;
    private Logger log;
    private Class[] deviceInterface = new Class[]{TCPConnectionContext.class};

    public IIOPInboundChannelFactory() {
        String string = this.getClass().getName();
        this.log = Logger.getLogger(string, "com.ibm.ws.iiop.channel.resources.IIOPMsgs");
        ME = string.substring(string.lastIndexOf(46) + 1);
    }

    public Class[] getAggregateChannelFactories(TransportChannel transportChannel, ChannelFrameworkService channelFrameworkService) throws ConfigurationError {
        if (this.log.isLoggable(Level.FINER)) {
            this.log.entering(ME, "getAggregateChannelFactories", transportChannel);
        }
        Class[] classArray = new Class[]{IIOPChannelConstants.GIOP_IN_FACTORY_CLASS, IIOPChannelConstants.ORB_IN_FACTORY_CLASS};
        if (this.log.isLoggable(Level.FINER)) {
            this.log.exiting(ME, "getAggregateChannelFactories", "Factories of aggregate channel in order: " + IIOPChannelConstants.GIOP_IN_FACTORY_CLASS_NAME + ", " + IIOPChannelConstants.ORB_IN_FACTORY_CLASS_NAME);
        }
        return classArray;
    }

    public Map createFactoryConfigurationMap(TransportChannelFactory transportChannelFactory, ChannelFrameworkService channelFrameworkService) throws ConfigurationError {
        throw new ConfigurationError("createFactoryConfigurationMap operation is invalid for an IIOP channel.");
    }

    public Map createChannelConfigurationMap(TransportChannel transportChannel, ChannelFrameworkService channelFrameworkService) throws ConfigurationError {
        throw new ConfigurationError("createChannelConfigurationMap operation is invalid for an IIOP channel.");
    }

    public OutboundChannelDefinition getOutboundChannelDefinition(Map map) {
        return null;
    }

    public String determineAcceptorID(InboundTransportChannel inboundTransportChannel) throws ConfigurationError {
        if (this.log.isLoggable(Level.FINER)) {
            this.log.entering(ME, "determineAcceptorID", inboundTransportChannel);
        }
        String string = IIOPChannelConstants.ORB_IN_FACTORY_CLASS_NAME;
        if (this.log.isLoggable(Level.FINER)) {
            this.log.exiting(ME, "determineAcceptorID", string);
        }
        return string;
    }

    public Channel findOrCreateChannel(ChannelData channelData) throws ChannelException {
        throw new ChannelException("findOrCreateChannel operation is invalid for an IIOP channel.");
    }

    public void updateProperties(Map map) throws ChannelFactoryPropertyIgnoredException {
        throw new ChannelFactoryPropertyIgnoredException("updateProperties operation is invalid for an IIOP channel.");
    }

    public void init(ChannelFactoryData channelFactoryData) throws ChannelFactoryException {
        if (this.log.isLoggable(Level.FINER)) {
            this.log.entering(ME, "init");
            this.log.exiting(ME, "init");
        }
    }

    public void destroy() {
        if (this.log.isLoggable(Level.FINER)) {
            this.log.entering(ME, "destroy");
            this.log.exiting(ME, "destroy");
        }
    }

    public Map getProperties() {
        return null;
    }

    public Class getApplicationInterface() {
        return null;
    }

    public Class[] getDeviceInterface() {
        return this.deviceInterface;
    }
}

