/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager;

import com.ibm.ws.install.configmanager.ConfigManagerActionListener;
import com.ibm.ws.install.configmanager.ConfigManagerConstants;
import com.ibm.ws.install.configmanager.actionengine.ActionArgument;
import com.ibm.ws.install.configmanager.actionengine.ConfigAction;
import com.ibm.ws.install.configmanager.launcher.ArgumentValueFetcher;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.ClassPathModifier;
import com.ibm.ws.install.configmanager.utils.DefaultValueManager;
import com.ibm.ws.install.configmanager.utils.SystemPropertiesUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigManager {
    private final boolean m_fInitializeResult;
    private boolean m_fAllActionsExecutedSuccessfully = false;
    private Vector m_vcaAllActionsSorted = null;
    private Vector m_vcaOptionalActions = null;
    private Vector m_vcaSuccessActionsSorted = new Vector();
    private Vector m_vcaFailedActionsSorted = new Vector();
    private String[] m_asOmittedActions = null;
    private static Vector m_vcmal = new Vector();
    private static Vector m_vcaNestedFailedConfigActions = new Vector();
    private static final String S_LIB = "lib";
    private static final String S_DEFAULT_ACTION_REGISTRY = "actionRegistry.xml";
    private static final Logger LOGGER = LoggerFactory.createLogger(ConfigManager.class);
    private static final String S_CLASS_NAME = ConfigManager.class.getName();

    private ConfigManager() {
        LOGGER.entering(ConfigManager.class.getName(), "ConfigManager");
        String string = ArgumentValueFetcher.getArgumentValue(ConfigManagerConstants.S_ARG_CONFIG_DIR);
        this.m_fInitializeResult = this.initialize(string);
        if (!this.m_fInitializeResult) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "ConfigManager", "Config manager initialization failed");
        }
        LOGGER.exiting(ConfigManager.class.getName(), "ConfigManager");
    }

    public static List getAllFailedConfigActionsFromNestedRuns() {
        LOGGER.entering(ConfigManager.class.getName(), "getAllFailedConfigActionsFromNestedRuns");
        LOGGER.exiting(ConfigManager.class.getName(), "getAllFailedConfigActionsFromNestedRuns");
        return m_vcaNestedFailedConfigActions;
    }

    public static List getRequiredArgumentsList(String string) {
        LOGGER.entering(ConfigManager.class.getName(), "getRequiredArgumentsList");
        System.setProperty(ConfigManagerConstants.S_ARG_CONFIG_DIR, string);
        ArrayList<ActionArgument> arrayList = new ArrayList<ActionArgument>();
        Iterator iterator = new ConfigManager().m_vcaAllActionsSorted.iterator();
        while (iterator.hasNext()) {
            ConfigAction configAction = (ConfigAction)iterator.next();
            Iterator iterator2 = configAction.getActionArgumentList().iterator();
            while (iterator2.hasNext()) {
                ActionArgument actionArgument = (ActionArgument)iterator2.next();
                if (!actionArgument.isRequired()) continue;
                arrayList.add(actionArgument);
            }
        }
        LOGGER.exiting(ConfigManager.class.getName(), "getRequiredArgumentsList");
        return arrayList;
    }

    public static List getOptionalArgumentsList(String string) {
        LOGGER.entering(ConfigManager.class.getName(), "getOptionalArgumentsList");
        System.setProperty(ConfigManagerConstants.S_ARG_CONFIG_DIR, string);
        ArrayList<ActionArgument> arrayList = new ArrayList<ActionArgument>();
        Iterator iterator = new ConfigManager().m_vcaAllActionsSorted.iterator();
        while (iterator.hasNext()) {
            ConfigAction configAction = (ConfigAction)iterator.next();
            Iterator iterator2 = configAction.getActionArgumentList().iterator();
            while (iterator2.hasNext()) {
                ActionArgument actionArgument = (ActionArgument)iterator2.next();
                if (actionArgument.isRequired() || arrayList.contains(actionArgument)) continue;
                arrayList.add(actionArgument);
            }
        }
        LOGGER.exiting(ConfigManager.class.getName(), "getOptionalArgumentsList");
        return arrayList;
    }

    public static List getOptionalConfigActionsList(String string) {
        LOGGER.entering(ConfigManager.class.getName(), "getOptionalConfigActionsList");
        String string2 = string + File.separator + S_DEFAULT_ACTION_REGISTRY;
        LOGGER.exiting(ConfigManager.class.getName(), "getOptionalConfigActionsList");
        return ConfigManager.getOptionalConfigActionsList(string, string2);
    }

    public static List getOptionalConfigActionsList(String string, String string2) {
        LOGGER.entering(ConfigManager.class.getName(), "getOptionalConfigActionsList");
        System.setProperty(ConfigManagerConstants.S_ARG_CONFIG_DIR, string);
        System.setProperty(ConfigManagerConstants.S_ARG_ACTION_REGISTRY, string2);
        Vector vector = new ConfigManager().m_vcaOptionalActions;
        LOGGER.exiting(ConfigManager.class.getName(), "getOptionalConfigActionsList");
        return vector;
    }

    public static List getRequiredConfigActionsList(String string) {
        LOGGER.entering(ConfigManager.class.getName(), "getRequiredConfigActionsList");
        String string2 = string + File.separator + S_DEFAULT_ACTION_REGISTRY;
        LOGGER.exiting(ConfigManager.class.getName(), "getRequiredConfigActionsList");
        return ConfigManager.getRequiredConfigActionsList(string, string2);
    }

    public static List getRequiredConfigActionsList(String string, String string2) {
        LOGGER.entering(ConfigManager.class.getName(), "getRequiredConfigActionsList");
        System.setProperty(ConfigManagerConstants.S_ARG_CONFIG_DIR, string);
        System.setProperty(ConfigManagerConstants.S_ARG_ACTION_REGISTRY, string2);
        Vector vector = (Vector)ConfigAction.createRequiredActions(new ConfigManager().m_vcaAllActionsSorted);
        LOGGER.exiting(ConfigManager.class.getName(), "getRequiredConfigActionsList");
        return vector;
    }

    public static Hashtable getDefaulterHashtable(String string) {
        LOGGER.entering(ConfigManager.class.getName(), "getDefaulterHashtable");
        System.setProperty(ConfigManagerConstants.S_ARG_CONFIG_DIR, string);
        Vector vector = new ConfigManager().m_vcaAllActionsSorted;
        Hashtable hashtable = ConfigManager.createDefaulterHashtable(vector);
        LOGGER.exiting(ConfigManager.class.getName(), "getDefaulterHashtable");
        return hashtable;
    }

    public static Hashtable getValidatorHashtable(String string) {
        LOGGER.entering(ConfigManager.class.getName(), "getValidatorHashtable");
        System.setProperty(ConfigManagerConstants.S_ARG_CONFIG_DIR, string);
        Vector vector = new ConfigManager().m_vcaAllActionsSorted;
        Hashtable hashtable = ConfigManager.createValidatorHashtable(vector);
        LOGGER.exiting(ConfigManager.class.getName(), "getValidatorHashtable");
        return hashtable;
    }

    public static int launch() {
        LOGGER.entering(ConfigManager.class.getName(), "launch");
        ConfigManager configManager = new ConfigManager();
        if (!configManager.getInitializeResult()) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "launch", "ConfigManager Initialization Failed");
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "launch", "Returning with return code: " + ConfigManagerConstants.AS_RETURN_CODES[1]);
            LOGGER.exiting(ConfigManager.class.getName(), "launch");
            return 1;
        }
        if (!configManager.executeActions()) {
            if (configManager.m_vcaFailedActionsSorted != null) {
                m_vcaNestedFailedConfigActions.addAll(configManager.m_vcaFailedActionsSorted);
            }
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "launch", "ConfigManager action execution failed on a fatal action");
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "launch", "Returning with return code: " + ConfigManagerConstants.AS_RETURN_CODES[1]);
            LOGGER.exiting(ConfigManager.class.getName(), "launch");
            return 1;
        }
        if (configManager.didAllActionsExecuteSuccessfully()) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "launch", "No errors were encountered while executing the repository actions");
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "launch", "Returning with return code: " + ConfigManagerConstants.AS_RETURN_CODES[0]);
            LOGGER.exiting(ConfigManager.class.getName(), "launch");
            return 0;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "launch", "There were some errors encountered while executing the repository actions, but none were fatal");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "launch", "Information about actions that failed, follows");
        configManager.dumpNonFatalFailedActionsInfoToLogFile();
        if (configManager.m_vcaFailedActionsSorted != null) {
            m_vcaNestedFailedConfigActions.addAll(configManager.m_vcaFailedActionsSorted);
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "launch", "Returning with return code: " + ConfigManagerConstants.AS_RETURN_CODES[2]);
        LOGGER.exiting(ConfigManager.class.getName(), "launch");
        return 2;
    }

    public static void addConfigManagerActionListener(ConfigManagerActionListener configManagerActionListener) {
        LOGGER.entering(ConfigManager.class.getName(), "addConfigManagerActionListener");
        m_vcmal.add(configManagerActionListener);
        LOGGER.exiting(ConfigManager.class.getName(), "addConfigManagerActionListener");
    }

    public static void removeConfigManagerActionListener(ConfigManagerActionListener configManagerActionListener) {
        LOGGER.entering(ConfigManager.class.getName(), "removeConfigManagerActionListener");
        m_vcmal.remove(configManagerActionListener);
        LOGGER.exiting(ConfigManager.class.getName(), "removeConfigManagerActionListener");
    }

    public static void reset() {
        LOGGER.entering(ConfigManager.class.getName(), "reset");
        LOGGER.exiting(ConfigManager.class.getName(), "reset");
        m_vcaNestedFailedConfigActions = new Vector();
    }

    public void dumpNonFatalFailedActionsInfoToLogFile() {
        LOGGER.entering(ConfigManager.class.getName(), "dumpNonFatalFailedActions");
        for (int i = 0; i < this.m_vcaFailedActionsSorted.size(); ++i) {
            ConfigAction configAction = (ConfigAction)this.m_vcaFailedActionsSorted.elementAt(i);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "dumpNonFatalFailedActionsInfoToLogFile", "This action failed to execute: " + configAction.getActionPath());
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "dumpNonFatalFailedActionsInfoToLogFile", "To manually apply this action, please execute this command: " + configAction.getActionManualCommand());
        }
        LOGGER.exiting(ConfigManager.class.getName(), "dumpNonFatalFailedActions");
    }

    public boolean initialize(String string) {
        LOGGER.entering(ConfigManager.class.getName(), "initialize");
        this.m_vcaAllActionsSorted = (Vector)ConfigAction.createActionsSorted(string);
        this.m_vcaOptionalActions = (Vector)ConfigAction.createOptionalActions(this.m_vcaAllActionsSorted);
        this.m_asOmittedActions = this.createOmittedActions();
        if (this.m_vcaAllActionsSorted == null) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "initialize", "Failed to locate any config actions, most probably the action registry file is corrupt");
            LOGGER.exiting(ConfigManager.class.getName(), "initialize");
            return false;
        }
        if (!this.validateOmittedActionsAreOptional(this.m_vcaOptionalActions, this.m_asOmittedActions)) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "initialize", "Validation of omitted actions failed in ConfigManager.initialize()");
            LOGGER.exiting(ConfigManager.class.getName(), "initialize");
            return false;
        }
        this.m_vcaAllActionsSorted = this.removeOmittedActions(this.m_vcaAllActionsSorted, this.m_asOmittedActions);
        if (!this.setupClassPath()) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "initialize", "Classpath setup failed in ConfigManager.initialize()");
            LOGGER.exiting(ConfigManager.class.getName(), "initialize");
            return false;
        }
        if (!this.performSanityCheck()) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "initialize", "Sanity check failed in ConfigManager.initialize()");
            LOGGER.exiting(ConfigManager.class.getName(), "initialize");
            return false;
        }
        LOGGER.exiting(ConfigManager.class.getName(), "initialize");
        return true;
    }

    public boolean executeActions() {
        LOGGER.entering(ConfigManager.class.getName(), "executeActions");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeActions", "List of all actions found in the repository: " + this.m_vcaAllActionsSorted.toString());
        Properties properties = this.setDefaultValuesIfApplicable();
        boolean bl = this.executeAllActionsFound();
        this.restoreSystemProperties(properties);
        LOGGER.exiting(ConfigManager.class.getName(), "executeActions");
        return bl;
    }

    public boolean didAllActionsExecuteSuccessfully() {
        LOGGER.entering(ConfigManager.class.getName(), "didAllActionsExecuteSuccessfully");
        LOGGER.exiting(ConfigManager.class.getName(), "didAllActionsExecuteSuccessfully");
        return this.m_fAllActionsExecutedSuccessfully;
    }

    protected boolean getInitializeResult() {
        return this.m_fInitializeResult;
    }

    private String[] createOmittedActions() {
        LOGGER.entering(ConfigManager.class.getName(), "createOmittedActions");
        LOGGER.exiting(ConfigManager.class.getName(), "createOmittedActions");
        return ArgumentValueFetcher.getArgumentValues(ConfigManagerConstants.S_ARG_OMITTED_ACTION);
    }

    private static Hashtable createDefaulterHashtable(Vector vector) {
        LOGGER.entering(ConfigManager.class.getName(), "createDefaulterHashtable");
        Hashtable<String, ConfigAction> hashtable = new Hashtable<String, ConfigAction>();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ConfigAction configAction = (ConfigAction)iterator.next();
            Iterator iterator2 = configAction.getActionArgumentList().iterator();
            while (iterator2.hasNext()) {
                ActionArgument actionArgument = (ActionArgument)iterator2.next();
                if (actionArgument.getDefaulter() == null) continue;
                hashtable.put(actionArgument.getKey(), actionArgument.getDefaulter());
            }
        }
        LOGGER.exiting(ConfigManager.class.getName(), "createDefaulterHashtable");
        return hashtable;
    }

    private static Hashtable createValidatorHashtable(Vector vector) {
        LOGGER.entering(ConfigManager.class.getName(), "createValidatorHashtable");
        Hashtable<String, List> hashtable = new Hashtable<String, List>();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ConfigAction configAction = (ConfigAction)iterator.next();
            Iterator iterator2 = configAction.getActionArgumentList().iterator();
            while (iterator2.hasNext()) {
                ActionArgument actionArgument = (ActionArgument)iterator2.next();
                if (actionArgument.getValidatorList() == null || actionArgument.getValidatorList().size() <= 0) continue;
                if (hashtable.containsKey(actionArgument.getKey())) {
                    List list = (List)hashtable.get(actionArgument.getKey());
                    list.addAll(actionArgument.getValidatorList());
                    hashtable.put(actionArgument.getKey(), list);
                    continue;
                }
                hashtable.put(actionArgument.getKey(), actionArgument.getValidatorList());
            }
        }
        LOGGER.exiting(ConfigManager.class.getName(), "createValidatorHashtable");
        return hashtable;
    }

    private Vector removeOmittedActions(Vector vector, String[] stringArray) {
        LOGGER.entering(ConfigManager.class.getName(), "removeOmittedActions");
        if (vector == null || stringArray == null) {
            LOGGER.exiting(ConfigManager.class.getName(), "removeOmittedActions");
            return vector;
        }
        block0: for (int i = 0; i < vector.size(); ++i) {
            for (int j = 0; j < stringArray.length; ++j) {
                ConfigAction configAction = (ConfigAction)vector.elementAt(i);
                if (stringArray[j] == null || !stringArray[j].equals(configAction.getActionName())) continue;
                vector.remove(i);
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "removeOmittedActions", "Optional action " + configAction.getActionName() + " has been omitted.");
                --i;
                continue block0;
            }
        }
        LOGGER.exiting(ConfigManager.class.getName(), "removeOmittedActions");
        return vector;
    }

    private boolean validateOmittedActionsAreOptional(Vector vector, String[] stringArray) {
        LOGGER.entering(ConfigManager.class.getName(), "validateOmittedActionsAreOptional");
        for (int i = 0; i < stringArray.length; ++i) {
            ConfigAction configAction;
            int n;
            boolean bl = false;
            for (n = 0; n < vector.size(); ++n) {
                configAction = (ConfigAction)vector.elementAt(n);
                if (stringArray[i] == null || !stringArray[i].equals(configAction.getActionName())) continue;
                bl = true;
            }
            if (bl) continue;
            for (n = 0; n < this.m_vcaAllActionsSorted.size(); ++n) {
                configAction = (ConfigAction)this.m_vcaAllActionsSorted.elementAt(n);
                if (stringArray[i] == null || !stringArray[i].equals(configAction.getActionName())) continue;
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "validateOmittedActionsAreOptional", "Omitted action " + stringArray[i] + " is not an optional action.");
                return false;
            }
        }
        LOGGER.exiting(ConfigManager.class.getName(), "validateOmittedActionsAreOptional");
        return true;
    }

    private void restoreSystemProperties(Properties properties) {
        LOGGER.entering(ConfigManager.class.getName(), "restoreSystemProperties");
        SystemPropertiesUtils.resetSystemProperties(properties);
        LOGGER.exiting(ConfigManager.class.getName(), "restoreSystemProperties");
    }

    private boolean performSanityCheck() {
        LOGGER.entering(ConfigManager.class.getName(), "performSanityCheck");
        if (ArgumentValueFetcher.getArgumentValue(ConfigManagerConstants.S_ARG_CONFIG_DIR) == null) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "performSanityCheck", "Config repository location could not be located");
            LOGGER.exiting(ConfigManager.class.getName(), "performSanityCheck");
            return false;
        }
        LOGGER.exiting(ConfigManager.class.getName(), "performSanityCheck");
        return true;
    }

    private boolean executeAllActionsFound() {
        LOGGER.entering(ConfigManager.class.getName(), "executeAllActionsFound");
        this.m_fAllActionsExecutedSuccessfully = true;
        for (int i = 0; i < this.m_vcaAllActionsSorted.size(); ++i) {
            ConfigAction configAction = (ConfigAction)this.m_vcaAllActionsSorted.elementAt(i);
            ConfigManager.broadcastActionLaunch(configAction.getActionName(), i, this.m_vcaAllActionsSorted.size());
            if (!configAction.executeAction()) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "executeAllActionsFound", "Configuration action failed: " + configAction.toString());
                this.m_fAllActionsExecutedSuccessfully = false;
                this.m_vcaFailedActionsSorted.add(configAction);
                if (!configAction.isActionFailureFatalToConfiguration()) continue;
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "executeAllActionsFound", "Fatal configuration action failed: " + configAction.toString());
                LOGGER.exiting(ConfigManager.class.getName(), "executeAllActionsFound");
                return false;
            }
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeAllActionsFound", "Configuration action succeeded: " + configAction.toString());
            this.m_vcaSuccessActionsSorted.add(configAction);
        }
        LOGGER.exiting(ConfigManager.class.getName(), "executeAllActionsFound");
        return true;
    }

    private Properties setDefaultValuesIfApplicable() {
        LOGGER.entering(ConfigManager.class.getName(), "setDefaultValuesIfApplicable");
        List list = this.findArgumentsToDefault();
        Hashtable hashtable = new Hashtable();
        if (list.size() > 0) {
            Hashtable hashtable2 = ConfigManager.createDefaulterHashtable(this.m_vcaAllActionsSorted);
            DefaultValueManager defaultValueManager = new DefaultValueManager(hashtable2);
            hashtable = defaultValueManager.getDefaultValues(list, new Hashtable());
        }
        LOGGER.exiting(ConfigManager.class.getName(), "setDefaultValuesIfApplicable");
        return SystemPropertiesUtils.setArgumentsIntoSystemProperties(hashtable);
    }

    private List findArgumentsToDefault() {
        LOGGER.entering(ConfigManager.class.getName(), "findArgumentsToDefault");
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.m_vcaAllActionsSorted.size(); ++i) {
            ConfigAction configAction = (ConfigAction)this.m_vcaAllActionsSorted.elementAt(i);
            List list = configAction.getActionArgumentList();
            for (int j = 0; j < list.size(); ++j) {
                String string;
                ActionArgument actionArgument = (ActionArgument)list.get(j);
                String string2 = actionArgument.getKey();
                if (ArgumentValueFetcher.getArgumentValue(string2, false) != null || !actionArgument.isRequired() || (string = ArgumentValueFetcher.getArgumentValue(string2)) == null || string.equals("")) continue;
                vector.add(string2);
            }
        }
        LOGGER.exiting(ConfigManager.class.getName(), "findArgumentsToDefault");
        return vector;
    }

    private boolean setupClassPath() {
        LOGGER.entering(ConfigManager.class.getName(), "setupClassPath");
        try {
            this.addIJCLibDirectoryToClassPath();
        }
        catch (IOException iOException) {
            LogUtils.logException(LOGGER, iOException);
            LOGGER.exiting(ConfigManager.class.getName(), "setupClassPath");
            return false;
        }
        LOGGER.exiting(ConfigManager.class.getName(), "setupClassPath");
        return true;
    }

    private void addIJCLibDirectoryToClassPath() throws IOException {
        LOGGER.entering(ConfigManager.class.getName(), "addIJCLibDirectoryToClassPath");
        String string = ArgumentValueFetcher.getArgumentValue(ConfigManagerConstants.S_ARG_CONFIG_DIR);
        String string2 = new File(string, S_LIB).getAbsolutePath();
        ClassPathModifier.addAllJARsInDirectoryToClassPath(string2);
        LOGGER.exiting(ConfigManager.class.getName(), "addIJCLibDirectoryToClassPath");
    }

    public static void broadcastActionLaunch(String string, int n, int n2) {
        LOGGER.entering(ConfigManager.class.getName(), "broadcastActionLaunch");
        for (int i = 0; i < m_vcmal.size(); ++i) {
            ConfigManagerActionListener configManagerActionListener = (ConfigManagerActionListener)m_vcmal.elementAt(i);
            configManagerActionListener.actionLaunched(string, n, n2);
        }
        LOGGER.exiting(ConfigManager.class.getName(), "broadcastActionLaunch");
    }
}

