/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine;

import com.ibm.ws.install.configmanager.actionengine.ConfigAction;
import com.ibm.ws.install.configmanager.actionengine.ant.utils.ANTLogToCmtLogAdapter;
import com.ibm.ws.install.configmanager.actionengine.ant.utils.InProcessAntRunner;
import com.ibm.ws.install.configmanager.launcher.OutputStreamHandler;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.install.configmanager.utils.ArrayUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ANTAction
extends ConfigAction {
    private String m_sOutput = "";
    private String m_sErrorOutput = "";
    public static final String S_IS_CONFIG_ACTION_FATAL_FLAG = "isConfigActionFatal";
    private static final String S_SPACE = " ";
    private static final String S_QUOTE = "\"";
    private static final String S_EMPTY = "";
    private static final String S_ANT_BUILD_FILE_OPTION = "-buildfile";
    private static final String S_ANT_LOGGER_OPTION = "-logger";
    private static final String S_BIN = "bin";
    private static final String S_ANT_EXEC_PARAM = PlatformConstants.getANTInterpretorName();
    private static final Logger LOGGER = LoggerFactory.createLogger(ANTAction.class);
    private static final String S_CLASS_NAME = ANTAction.class.getName();

    public boolean executeAction() {
        LOGGER.entering(ANTAction.class.getName(), "executeAction");
        boolean bl = false;
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeAction", "Using an InProcess ANT call to execute this action: " + this.getActionPath());
        bl = this.executeActionUsingAnInProcessANTCall();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeAction", "Result of executing " + this.getActionPath() + " was: " + bl);
        LOGGER.exiting(ANTAction.class.getName(), "executeAction");
        return bl;
    }

    public boolean rollBackAction() {
        LOGGER.entering(ANTAction.class.getName(), "rollBackAction");
        LOGGER.exiting(ANTAction.class.getName(), "rollBackAction");
        return false;
    }

    public String getActionManualCommand() {
        LOGGER.entering(ANTAction.class.getName(), "getActionManualCommand");
        String string = PlatformConstants.convertExecArrayToPlatformSpecificExecCommand(this.getExecStringArrayToExecuteThisActionUsingANT());
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "getActionManualCommand", "The manual command for " + this.getActionPath() + " action is: " + string);
        LOGGER.exiting(ANTAction.class.getName(), "getActionManualCommand");
        return string;
    }

    private boolean executeActionUsingAnInProcessANTCall() {
        LOGGER.entering(ANTAction.class.getName(), "executeActionUsingAnInProcessANTCall");
        String string = System.getProperty(S_IS_CONFIG_ACTION_FATAL_FLAG, S_EMPTY);
        System.setProperty(S_IS_CONFIG_ACTION_FATAL_FLAG, Boolean.toString(this.isActionFailureFatalToConfiguration()));
        boolean bl = InProcessAntRunner.start(new String[]{S_ANT_BUILD_FILE_OPTION, this.getActionPath(), S_ANT_LOGGER_OPTION, ANTLogToCmtLogAdapter.class.getName()}, null, null);
        this.m_sOutput = OutputStreamHandler.putOutputToString();
        System.setProperty(S_IS_CONFIG_ACTION_FATAL_FLAG, string);
        LOGGER.exiting(ANTAction.class.getName(), "executeActionUsingAnInProcessANTCall");
        return bl;
    }

    private String[] getExecStringArrayToExecuteThisActionUsingANT() {
        LOGGER.entering(ANTAction.class.getName(), "getExecStringArrayToExecuteThisActionUsingANT");
        String[] stringArray = PlatformConstants.getShellExecPrefixForCurrentPlatform();
        Object[] objectArray = new String[stringArray.length + 1];
        ArrayUtils.appendArray(objectArray, stringArray, 0);
        objectArray[stringArray.length] = S_ANT_EXEC_PARAM + S_SPACE + S_ANT_BUILD_FILE_OPTION + S_SPACE + this.getActionPathAsSafeShellParameter();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getExecStringArrayToExecuteThisActionUsingANT", "The string array to execute " + this.getActionPath() + " ANT action is: " + LogUtils.getArrayAsALoggableString(objectArray));
        LOGGER.exiting(ANTAction.class.getName(), "getExecStringArrayToExecuteThisActionUsingANT");
        return objectArray;
    }

    public String getActionErrorOutput() {
        LOGGER.entering(ANTAction.class.getName(), "getActionErrorOutput");
        LOGGER.exiting(ANTAction.class.getName(), "getActionErrorOutput");
        return this.m_sErrorOutput;
    }

    public String getActionOutput() {
        LOGGER.entering(ANTAction.class.getName(), "getActionOutput");
        LOGGER.exiting(ANTAction.class.getName(), "getActionOutput");
        return this.m_sOutput;
    }
}

