/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine;

import com.ibm.ws.install.configmanager.ConfigManagerConstants;
import com.ibm.ws.install.configmanager.actionengine.ActionArgument;
import com.ibm.ws.install.configmanager.actionengine.ConfigAction;
import com.ibm.ws.install.configmanager.launcher.ArgumentValueFetcher;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ActionRegistryParser {
    private static final String S_TAG_REG_ACTION = "action";
    private static final String S_TAG_REG_PATH = "path";
    private static final String S_TAG_REG_PRIORITY = "priority";
    private static final String S_TAG_REG_ISFATAL = "isFatal";
    private static final String S_TAG_REG_ISVISIBLE = "isVisible";
    private static final String S_TAG_REG_ISOPTIONAL = "isOptional";
    private static final String S_TAG_REG_DESCRIPTIONBUNDLE = "descriptionBundle";
    private static final String S_TAG_REG_ARGUMENT = "argument";
    private static final String S_TAG_REG_DEFAULTER = "defaulter";
    private static final String S_TAG_REG_VALIDATOR = "validator";
    private static final String S_TAG_REG_KEY = "key";
    private static final String S_TAG_REG_VALUES = "values";
    private static final String S_TAG_REG_REQUIRED = "required";
    private static final String S_TAG_REG_HELP_BUNDLE = "helpbundle";
    private static final String S_TAG_REG_PLATFORM = "platform";
    private static final String S_EMPTY = "";
    private static final String S_DEFAULTER_IS_FATAL = "false";
    private static final String S_DEFAULTER_IS_OPTIONAL = "false";
    private static final String S_VALIDATOR_IS_FATAL = "true";
    private static final String S_VALIDATOR_IS_OPTIONAL = "false";
    private static final String S_VALIDATOR_PRIORITY = "01";
    private static Hashtable m_htConfigActionList;
    private static final Logger LOGGER;
    private static final String S_CLASS_NAME;

    public static List getSortedActionListFromRegistryFile() {
        LOGGER.entering(ActionRegistryParser.class.getName(), "getSortedlistActionFromRegistryFile");
        File file = ActionRegistryParser.getActionRegistryFileObject();
        if (m_htConfigActionList == null) {
            m_htConfigActionList = new Hashtable();
        }
        if (file != null && m_htConfigActionList.containsKey(file.getAbsolutePath())) {
            List list = (List)m_htConfigActionList.get(file.getAbsolutePath());
            Vector<ConfigAction> vector = new Vector<ConfigAction>();
            for (int i = 0; i < list.size(); ++i) {
                vector.add((ConfigAction)list.get(i));
            }
            return vector;
        }
        try {
            Document document = ActionRegistryParser.parseActionRegistryXMLFileIntoADOMModel(file);
            List list = ActionRegistryParser.convertDOMToActionList(document, file);
            ActionRegistryParser.removeAbsentActionsFromList(list);
            Collections.sort(list);
            m_htConfigActionList.put(file.getAbsolutePath(), list);
            LOGGER.exiting(ActionRegistryParser.class.getName(), "getSortedlistActionFromRegistryFile");
            return list;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LogUtils.logException(LOGGER, parserConfigurationException);
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "getSortedActionListFromRegistryFile", "XML parser initialization exception while trying to parse the action registry, returning null as action list");
            return null;
        }
        catch (SAXException sAXException) {
            LogUtils.logException(LOGGER, sAXException);
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "getSortedActionListFromRegistryFile", "Action registry is corrupt, returning null as action list");
            return null;
        }
        catch (IOException iOException) {
            LogUtils.logException(LOGGER, iOException);
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "getSortedActionListFromRegistryFile", "I/O exception in accessing the action registry, returning null as action list");
            return null;
        }
    }

    public static boolean isAnActionRegistryAvailable() {
        File file = ActionRegistryParser.getActionRegistryFileObject();
        if (file == null) {
            return false;
        }
        return file.exists();
    }

    private static File getActionRegistryFileObject() {
        String string = ArgumentValueFetcher.getArgumentValue(ConfigManagerConstants.S_ARG_ACTION_REGISTRY);
        if (string == null) {
            return null;
        }
        return new File(string);
    }

    private static Document parseActionRegistryXMLFileIntoADOMModel(File file) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        LOGGER.entering(ActionRegistryParser.class.getName(), "parseActionRegistryXMLFileIntoADOMModel");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        LOGGER.exiting(ActionRegistryParser.class.getName(), "parseActionRegistryXMLFileIntoADOMModel");
        return document;
    }

    private static List convertDOMToActionList(Document document, File file) {
        LOGGER.entering(ActionRegistryParser.class.getName(), "convertDOMToActionList");
        Vector<ConfigAction> vector = new Vector<ConfigAction>();
        NodeList nodeList = document.getElementsByTagName(S_TAG_REG_ACTION);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string = ActionRegistryParser.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_PATH, namedNodeMap);
            String string2 = ActionRegistryParser.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_ISFATAL, namedNodeMap);
            String string3 = ActionRegistryParser.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_ISOPTIONAL, namedNodeMap);
            String string4 = ActionRegistryParser.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_DESCRIPTIONBUNDLE, namedNodeMap);
            if (string == null || string2 == null) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "convertDOMToActionList", "Encountered invalid or missing attributes for an action, skipping it, action registry is possibly corrupt");
                continue;
            }
            String string5 = ActionRegistryParser.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_PRIORITY, namedNodeMap);
            List list = ActionRegistryParser.getActionArgumentListForTheGivenActionNode(node);
            int n = 999999999;
            if (string5 != null) {
                n = Integer.parseInt(string5);
            }
            boolean bl = Boolean.valueOf(string2);
            boolean bl2 = Boolean.valueOf(string3);
            String string6 = new File(ArgumentValueFetcher.getArgumentValue(ConfigManagerConstants.S_ARG_CONFIG_DIR), string).getAbsolutePath();
            ConfigAction configAction = ConfigAction.createAction(string6, n, bl, list, string4, bl2);
            vector.add(configAction);
        }
        LOGGER.exiting(ActionRegistryParser.class.getName(), "convertDOMToActionList");
        return vector;
    }

    private static List getActionArgumentListForTheGivenActionNode(Node node) {
        LOGGER.entering(ActionRegistryParser.class.getName(), "getActionArgumentListForTheGivenActionNode");
        Vector<ActionArgument> vector = new Vector<ActionArgument>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(S_TAG_REG_ARGUMENT)) continue;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            String string = ActionRegistryParser.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_KEY, namedNodeMap);
            if (string == null) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getActionArgumentListForTheGivenActionNode", "Invalid argument entries found for an action, skipping, action registry is possibly corrupt");
                continue;
            }
            String string2 = ActionRegistryParser.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_VALUES, namedNodeMap);
            int n = 0;
            if (string2 != null) {
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getActionArgumentListForTheGivenActionNode", "Priority coded incorrectly for argument: " + string);
                    LogUtils.logException(LOGGER, numberFormatException);
                }
            }
            String string3 = ActionRegistryParser.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_REQUIRED, namedNodeMap);
            boolean bl = Boolean.valueOf(string3);
            String string4 = ActionRegistryParser.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_HELP_BUNDLE, namedNodeMap);
            String string5 = ActionRegistryParser.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_ISVISIBLE, namedNodeMap);
            String string6 = ActionRegistryParser.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_PLATFORM, namedNodeMap);
            ConfigAction configAction = ActionRegistryParser.getDefaulterForTheGivenArgumentNode(node2);
            List list = ActionRegistryParser.getValidatorsForTheGivenArgumentNode(node2);
            if (string6 != null && !PlatformConstants.getCurrentPlatformName().equalsIgnoreCase(string6)) continue;
            ActionArgument actionArgument = null;
            if (string5 != null) {
                boolean bl2 = Boolean.valueOf(string5);
                actionArgument = new ActionArgument(string, n, bl, bl2, string4, configAction, list);
            } else {
                actionArgument = new ActionArgument(string, n, bl, string4, configAction, list);
            }
            vector.add(actionArgument);
        }
        LOGGER.exiting(ActionRegistryParser.class.getName(), "getActionArgumentListForTheGivenActionNode");
        return vector;
    }

    private static List getValidatorsForTheGivenArgumentNode(Node node) {
        LOGGER.entering(ActionRegistryParser.class.getName(), "getValidatorsForTheGivenArgumentNode");
        Vector<ConfigAction> vector = new Vector<ConfigAction>();
        NodeList nodeList = node.getChildNodes();
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = ActionRegistryParser.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_KEY, namedNodeMap);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(S_TAG_REG_VALIDATOR)) continue;
            NamedNodeMap namedNodeMap2 = node2.getAttributes();
            String string2 = ActionRegistryParser.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_PATH, namedNodeMap2);
            String string3 = S_VALIDATOR_IS_FATAL;
            String string4 = "false";
            String string5 = S_VALIDATOR_PRIORITY;
            String string6 = S_EMPTY;
            if (string2 == null || string3 == null) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getValidatorsForTheGivenArgumentNode", "Encountered invalid or missing attributes for a validator, skipping it, action registry is possibly corrupt");
                continue;
            }
            Vector vector2 = new Vector();
            int n = 999999999;
            if (string5 != null) {
                n = Integer.parseInt(string5);
            }
            boolean bl = Boolean.valueOf(string3);
            boolean bl2 = Boolean.valueOf(string4);
            String string7 = new File(ArgumentValueFetcher.getArgumentValue(ConfigManagerConstants.S_ARG_CONFIG_DIR), string2).getAbsolutePath();
            ConfigAction configAction = ConfigAction.createAction(string7, n, bl, vector2, string6, bl2);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getValidatorsForTheGivenArgumentNode", "Registered a validator for the argument: " + string);
            vector.add(configAction);
        }
        LOGGER.exiting(ActionRegistryParser.class.getName(), "getValidatorsForTheGivenArgumentNode");
        return vector;
    }

    private static ConfigAction getDefaulterForTheGivenArgumentNode(Node node) {
        LOGGER.entering(ActionRegistryParser.class.getName(), "getDefaultersForTheGivenArgumentNode");
        ConfigAction configAction = null;
        NodeList nodeList = node.getChildNodes();
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = ActionRegistryParser.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_KEY, namedNodeMap);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(S_TAG_REG_DEFAULTER)) continue;
            NamedNodeMap namedNodeMap2 = node2.getAttributes();
            String string2 = ActionRegistryParser.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_PATH, namedNodeMap2);
            String string3 = ActionRegistryParser.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_PRIORITY, namedNodeMap2);
            String string4 = "false";
            String string5 = "false";
            String string6 = S_EMPTY;
            if (string2 == null || string4 == null) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getDefaulterForTheGivenArgumentNode", "Encountered invalid or missing attributes for a defaulter, skipping it, action registry is possibly corrupt");
                continue;
            }
            Vector vector = new Vector();
            int n = 999999999;
            if (string3 != null) {
                n = Integer.parseInt(string3);
            }
            boolean bl = Boolean.valueOf(string4);
            boolean bl2 = Boolean.valueOf(string5);
            String string7 = new File(ArgumentValueFetcher.getArgumentValue(ConfigManagerConstants.S_ARG_CONFIG_DIR), string2).getAbsolutePath();
            ConfigAction configAction2 = ConfigAction.createAction(string7, n, bl, vector, string6, bl2);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getDefaulterForTheGivenArgumentNode", "Registered a defaulter for the argument: " + string);
            configAction = configAction2;
        }
        LOGGER.exiting(ActionRegistryParser.class.getName(), "getDefaultersForTheGivenArgumentNode");
        return configAction;
    }

    private static String getAttributeValueFromGivenNamedNodeMapOfAttributes(String string, NamedNodeMap namedNodeMap) {
        LOGGER.entering(ActionRegistryParser.class.getName(), "getAttributeValueFromGivenNamedNodeMapOfAttributes");
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            String string2 = node.getNodeName();
            if (!string2.equals(string)) continue;
            return node.getNodeValue();
        }
        LOGGER.exiting(ActionRegistryParser.class.getName(), "getAttributeValueFromGivenNamedNodeMapOfAttributes");
        return null;
    }

    private static void removeAbsentActionsFromList(List list) {
        LOGGER.entering(ActionRegistryParser.class.getName(), "removeAbsentActionsFromList");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ConfigAction configAction = (ConfigAction)iterator.next();
            if (configAction.isThisActionActuallyPresentOnTheFileSystem()) continue;
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "removeAbsentActionsFromList", "Removing absent action " + configAction.getActionPath() + " from action list.");
            iterator.remove();
        }
        LOGGER.exiting(ActionRegistryParser.class.getName(), "removeAbsentActionsFromList");
    }

    static {
        LOGGER = LoggerFactory.createLogger(ActionRegistryParser.class);
        S_CLASS_NAME = ActionRegistryParser.class.getName();
    }
}

