/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine;

import com.ibm.ws.install.configmanager.actionengine.ANTAction;
import com.ibm.ws.install.configmanager.actionengine.ActionRegistryParser;
import com.ibm.ws.install.configmanager.actionengine.EmptyAction;
import com.ibm.ws.install.configmanager.actionengine.IJCAction;
import com.ibm.ws.install.configmanager.actionengine.JACLAction;
import com.ibm.ws.install.configmanager.actionengine.PlatformNativeShellScriptAction;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.install.configmanager.utils.FileUtils;
import com.ibm.ws.install.configmanager.utils.ResourceBundleUtils;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ConfigAction
implements Comparable {
    protected int m_nPriority = -1;
    protected boolean m_fActionFatalToConfigStatus = true;
    protected String m_sActionName = null;
    protected String m_sActionPath = null;
    protected List m_listArguments = null;
    protected boolean m_fActionIsOptional = false;
    protected String m_sResourceBundle = null;
    public static final Class CLASS_JACL_ACTION = JACLAction.class;
    public static final Class CLASS_PLATFORM_NATIVE_SHELL_SCRIPT_ACTION = PlatformNativeShellScriptAction.class;
    public static final Class CLASS_ANT_ACTION = ANTAction.class;
    public static final Class CLASS_IJC_ACTION = IJCAction.class;
    public static final Class CLASS_EMPTY_ACTION = EmptyAction.class;
    private static final String S_ACTION_NAME_WITH_PRIORITY_PATTERN = "(\\d+)([FSfs])([^\\s]+)(\\.)(\\w+)";
    private static final Pattern PATTERN_ACTION_NAME_WITH_PRIORITY = Pattern.compile("(\\d+)([FSfs])([^\\s]+)(\\.)(\\w+)");
    private static final int N_PRIORITY_GROUP = 1;
    private static final int N_FATAL_GROUP = 2;
    private static final int N_NAME_GROUP = 3;
    private static final int N_EXTENSION_GROUP = 5;
    private static final String S_ACTION_NAME_PATTERN = "([^\\s]+)(\\.)(\\w+)";
    private static final Pattern PATTERN_ACTION_NAME = Pattern.compile("([^\\s]+)(\\.)(\\w+)");
    private static final int N_NAME_GROUP_NO_PRIORITY_FATALITY_CODE_IN_ACTION_NAME = 1;
    private static final int N_SUFFIX_GROUP = 3;
    private static final String S_CONFIG_ACTION_DESCRIPTION_PREFIX = "ConfigAction.";
    private static final String S_CONFIG_ACTION_SHORT_DESCRIPTION_SUFFIX = ".shortDescription";
    private static final String S_CONFIG_ACTION_LONG_DESCRIPTION_SUFFIX = ".longDescription";
    private static final String S_FATAL_FLAG = "F";
    private static final String S_JACL = "jacl";
    private static final String S_SH = "sh";
    private static final String S_BAT = "bat";
    private static final String S_ANT = "ant";
    private static final String S_IJC = "ijc";
    private static final String S_DASH = "-";
    private static final String S_EMPTY = "";
    private static final Logger LOGGER = LoggerFactory.createLogger(ConfigAction.class);
    private static final String S_CLASS_NAME = ConfigAction.class.getName();

    public abstract boolean executeAction();

    public abstract boolean rollBackAction();

    public abstract String getActionManualCommand();

    public abstract String getActionOutput();

    public abstract String getActionErrorOutput();

    public int compareTo(Object object) {
        LOGGER.entering(ConfigAction.class.getName(), "compareTo");
        ConfigAction configAction = (ConfigAction)object;
        if (this.getThisActionPriority() < configAction.getThisActionPriority()) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "compareTo", "Returing less than from compareTo, actions are: " + this.getActionPath() + ", " + configAction.getActionPath());
            LOGGER.exiting(ConfigAction.class.getName(), "compareTo");
            return -1;
        }
        if (this.getThisActionPriority() > configAction.getThisActionPriority()) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "compareTo", "Returing greater than from compareTo, actions are: " + this.getActionPath() + ", " + configAction.getActionPath());
            LOGGER.exiting(ConfigAction.class.getName(), "compareTo");
            return 1;
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "compareTo", "Returing equal from compareTo, actions are: " + this.getActionPath() + ", " + configAction.getActionPath());
        LOGGER.exiting(ConfigAction.class.getName(), "compareTo");
        return 0;
    }

    public static List createActionsSorted(String string) {
        List list = null;
        list = ActionRegistryParser.isAnActionRegistryAvailable() ? ActionRegistryParser.getSortedActionListFromRegistryFile() : ConfigAction.getSortedActionListNoRegistryFile(string);
        return list;
    }

    public static ConfigAction createAction(String string) {
        LOGGER.entering(ConfigAction.class.getName(), "createAction");
        String string2 = new File(string).getName();
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "createAction", "Incoming action path was: " + string + ", the file name is: " + string2);
        if (!ConfigAction.isValidActionFileNameWithPriority(string2)) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "createAction", string + " could not be parsed as valid config action file name, returning an empty action for it");
            LOGGER.exiting(ConfigAction.class.getName(), "createAction");
            return ConfigAction.createEmtpyActionNoPriorityNotFatal(string);
        }
        try {
            Class clazz = ConfigAction.getActionClass(string2);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "createAction", string + " was mapped to this action class: " + clazz.getName());
            ConfigAction configAction = (ConfigAction)clazz.newInstance();
            ConfigAction.initializeActionProperties(configAction, string);
            LOGGER.exiting(ConfigAction.class.getName(), "createAction");
            return configAction;
        }
        catch (IllegalAccessException illegalAccessException) {
            LogUtils.logException(LOGGER, illegalAccessException);
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "createAction", "Returning empty action due to exception for " + string);
            LOGGER.exiting(ConfigAction.class.getName(), "createAction");
            return ConfigAction.createEmtpyActionNoPriorityNotFatal(string);
        }
        catch (InstantiationException instantiationException) {
            LogUtils.logException(LOGGER, instantiationException);
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "createAction", "Returning empty action due to exception for " + string);
            LOGGER.exiting(ConfigAction.class.getName(), "createAction");
            return ConfigAction.createEmtpyActionNoPriorityNotFatal(string);
        }
    }

    public static ConfigAction createAction(String string, int n, boolean bl, List list, String string2, boolean bl2) {
        LOGGER.entering(ConfigAction.class.getName(), "createAction");
        String string3 = new File(string).getName();
        if (!ConfigAction.isValidActionFileName(string3)) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "createAction", string + " could not be parsed as valid config action file name, returning an empty action for it");
            LOGGER.exiting(ConfigAction.class.getName(), "createAction");
            return ConfigAction.createEmtpyActionNoPriorityNotFatal(string);
        }
        Class clazz = ConfigAction.getActionClass(string);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "createAction", string + " was mapped to the action class: " + clazz.getName());
        try {
            ConfigAction configAction = (ConfigAction)clazz.newInstance();
            configAction.m_sActionPath = string;
            configAction.m_nPriority = n;
            configAction.m_fActionFatalToConfigStatus = bl;
            configAction.m_sActionName = ConfigAction.getActionName(string3);
            configAction.m_fActionIsOptional = bl2;
            configAction.m_listArguments = list;
            configAction.m_sResourceBundle = string2;
            LOGGER.exiting(ConfigAction.class.getName(), "createAction");
            return configAction;
        }
        catch (IllegalAccessException illegalAccessException) {
            LogUtils.logException(LOGGER, illegalAccessException);
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "createAction", "Returning empty action due to exception for " + string);
            LOGGER.exiting(ConfigAction.class.getName(), "createAction");
            return ConfigAction.createEmtpyActionNoPriorityNotFatal(string);
        }
        catch (InstantiationException instantiationException) {
            LogUtils.logException(LOGGER, instantiationException);
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "createAction", "Returning empty action due to exception for " + string);
            LOGGER.exiting(ConfigAction.class.getName(), "createAction");
            return ConfigAction.createEmtpyActionNoPriorityNotFatal(string);
        }
    }

    public static List createRequiredActions(List list) {
        LOGGER.entering(ConfigAction.class.getName(), "createRequiredActions");
        Vector<ConfigAction> vector = new Vector<ConfigAction>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ConfigAction configAction = (ConfigAction)iterator.next();
            if (configAction.isActionOptional()) continue;
            vector.add(configAction);
        }
        LOGGER.exiting(ConfigAction.class.getName(), "createRequiredActions");
        return vector;
    }

    public static List createOptionalActions(List list) {
        LOGGER.entering(ConfigAction.class.getName(), "createOptionalActions");
        Vector<ConfigAction> vector = new Vector<ConfigAction>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ConfigAction configAction = (ConfigAction)iterator.next();
            if (!configAction.isActionOptional()) continue;
            vector.add(configAction);
        }
        LOGGER.exiting(ConfigAction.class.getName(), "createOptionalActions");
        return vector;
    }

    public int getThisActionPriority() {
        LOGGER.entering(ConfigAction.class.getName(), "getThisActionPriority");
        LOGGER.exiting(ConfigAction.class.getName(), "getThisActionPriority");
        return this.m_nPriority;
    }

    public boolean isActionFailureFatalToConfiguration() {
        LOGGER.entering(ConfigAction.class.getName(), "isActionFailureFatalToConfiguration");
        LOGGER.exiting(ConfigAction.class.getName(), "isActionFailureFatalToConfiguration");
        return this.m_fActionFatalToConfigStatus;
    }

    public boolean isActionOptional() {
        LOGGER.entering(ConfigAction.class.getName(), "isActionOptional");
        LOGGER.exiting(ConfigAction.class.getName(), "isActionOptional");
        return this.m_fActionIsOptional;
    }

    public String getActionPath() {
        LOGGER.entering(ConfigAction.class.getName(), "getActionPath");
        LOGGER.exiting(ConfigAction.class.getName(), "getActionPath");
        return this.m_sActionPath;
    }

    public String getActionName() {
        return this.m_sActionName;
    }

    public String getActionPathAsSafeShellParameter() {
        LOGGER.entering(ConfigAction.class.getName(), "getActionPathAsSafeShellParameter");
        LOGGER.exiting(ConfigAction.class.getName(), "getActionPathAsSafeShellParameter");
        return PlatformConstants.convertToShellParam(this.m_sActionPath);
    }

    public List getActionArgumentList() {
        return this.m_listArguments;
    }

    public String getActionDescriptonBundle() {
        return this.m_sResourceBundle;
    }

    public String getLongDescription() {
        if (this.m_sResourceBundle == null) {
            return S_EMPTY;
        }
        String string = S_CONFIG_ACTION_DESCRIPTION_PREFIX + this.getActionName() + S_CONFIG_ACTION_LONG_DESCRIPTION_SUFFIX;
        return ResourceBundleUtils.getResourceBundleLocaleString(string, this.m_sResourceBundle);
    }

    public String getShortDescription() {
        if (this.m_sResourceBundle == null) {
            return S_EMPTY;
        }
        String string = S_CONFIG_ACTION_DESCRIPTION_PREFIX + this.getActionName() + S_CONFIG_ACTION_SHORT_DESCRIPTION_SUFFIX;
        return ResourceBundleUtils.getResourceBundleLocaleString(string, this.m_sResourceBundle);
    }

    public String toString() {
        LOGGER.entering(ConfigAction.class.getName(), "toString");
        LOGGER.exiting(ConfigAction.class.getName(), "toString");
        return this.getClass().getName() + S_DASH + this.getActionPath();
    }

    public boolean isThisActionActuallyPresentOnTheFileSystem() {
        return new File(this.getActionPath()).exists();
    }

    private static List getSortedActionListNoRegistryFile(String string) {
        LOGGER.entering(ConfigAction.class.getName(), "getSortedActionListNoRegistryFile");
        Vector<ConfigAction> vector = new Vector<ConfigAction>();
        String[] stringArray = FileUtils.getAllFilesInThisDirectory(string);
        if (stringArray == null) {
            LOGGER.exiting(ConfigAction.class.getName(), "getSortedActionListNoRegistryFile");
            return vector;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(string, stringArray[i]);
            String string2 = file.getAbsolutePath();
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "getSortedActionListNoRegistryFile", "Processing this file: " + string2);
            if (!file.exists() || !file.isFile()) continue;
            ConfigAction configAction = ConfigAction.createAction(string2);
            vector.add(configAction);
        }
        Collections.sort(vector);
        LOGGER.exiting(ConfigAction.class.getName(), "getSortedActionListNoRegistryFile");
        return vector;
    }

    private static boolean isValidActionFileNameWithPriority(String string) {
        LOGGER.entering(ConfigAction.class.getName(), "isValidActionFileNameWithPriority");
        boolean bl = PATTERN_ACTION_NAME_WITH_PRIORITY.matcher(string).matches();
        if (!bl) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "isValidActionFileNameWithPriority", string + " did not match the action name pattern");
        }
        LOGGER.exiting(ConfigAction.class.getName(), "isValidActionFileNameWithPriority");
        return bl;
    }

    private static boolean isValidActionFileName(String string) {
        LOGGER.entering(ConfigAction.class.getName(), "isValidActionFileName");
        boolean bl = PATTERN_ACTION_NAME.matcher(string).matches();
        if (!bl) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "isValidActionFileName", string + " did not match the action name pattern");
        }
        LOGGER.exiting(ConfigAction.class.getName(), "isValidActionFileName");
        return bl;
    }

    private static void initializeActionProperties(ConfigAction configAction, String string) {
        LOGGER.entering(ConfigAction.class.getName(), "initializeActionProperties");
        String string2 = new File(string).getName();
        configAction.m_sActionPath = string;
        configAction.m_nPriority = ConfigAction.getPriority(string2);
        configAction.m_fActionFatalToConfigStatus = ConfigAction.getFatalToConfigIfFailsFlag(string2);
        configAction.m_sActionName = ConfigAction.getActionName(string2);
        configAction.m_listArguments = new Vector();
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "initializeActionProperties", "Priority for " + string + " is: " + configAction.m_nPriority);
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "initializeActionProperties", "Fatal flag for " + string + " is: " + configAction.m_fActionFatalToConfigStatus);
        LOGGER.exiting(ConfigAction.class.getName(), "initializeActionProperties");
    }

    private static ConfigAction createEmtpyActionNoPriorityNotFatal(String string) {
        LOGGER.entering(ConfigAction.class.getName(), "createEmtpyActionNoPriorityNotFatal");
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "createEmtpyActionNoPriorityNotFatal", "Creating empty action for: " + string);
        EmptyAction emptyAction = new EmptyAction();
        emptyAction.m_sActionName = new File(string).getName();
        emptyAction.m_sActionPath = string;
        emptyAction.m_nPriority = 999999999;
        emptyAction.m_fActionFatalToConfigStatus = false;
        emptyAction.m_listArguments = new Vector();
        LOGGER.exiting(ConfigAction.class.getName(), "createEmtpyActionNoPriorityNotFatal");
        return emptyAction;
    }

    private static int getPriority(String string) {
        int n;
        LOGGER.entering(ConfigAction.class.getName(), "getPriority");
        Matcher matcher = PATTERN_ACTION_NAME_WITH_PRIORITY.matcher(string);
        if (matcher.matches()) {
            n = Integer.parseInt(matcher.group(1));
        } else {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getPriority", string + " did not match the action name pattern, assigning N_NO_PRIORITY to it");
            n = 999999999;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getPriority", "The parsed priority for " + string + " was: " + n);
        LOGGER.exiting(ConfigAction.class.getName(), "getPriority");
        return n;
    }

    private static String getActionName(String string) {
        LOGGER.entering(ConfigAction.class.getName(), "getActionName");
        Matcher matcher = PATTERN_ACTION_NAME_WITH_PRIORITY.matcher(string);
        Matcher matcher2 = PATTERN_ACTION_NAME.matcher(string);
        String string2 = S_EMPTY;
        if (matcher.matches()) {
            string2 = matcher.group(3);
        }
        if (matcher2.matches()) {
            string2 = matcher2.group(1);
        }
        if (string2.equals(S_EMPTY)) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getActionName", string + " did not match the action name pattern, assigning name as an empty string");
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getActionName", "The parsed name for " + string + " was: " + string2);
        LOGGER.exiting(ConfigAction.class.getName(), "getActionName");
        return string2;
    }

    private static boolean getFatalToConfigIfFailsFlag(String string) {
        boolean bl;
        LOGGER.entering(ConfigAction.class.getName(), "getFatalToConfigIfFailsFlag");
        Matcher matcher = PATTERN_ACTION_NAME_WITH_PRIORITY.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(2);
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "getFatalToConfigIfFailsFlag", "Fatal flag string for " + string + " was parsed to be: " + string2);
            if (S_FATAL_FLAG.equalsIgnoreCase(string2)) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getFatalToConfigIfFailsFlag", string + " was determined to be fatal to the overall configuration if it fails");
                bl = true;
            } else {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getFatalToConfigIfFailsFlag", string + " was not determined to be fatal to the overall configuration if it fails");
                bl = false;
            }
        } else {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getFatalToConfigIfFailsFlag", string + " could not be parsed as a valid action name, assuming its not fatal to configuration if it fails");
            bl = false;
        }
        LOGGER.exiting(ConfigAction.class.getName(), "getFatalToConfigIfFailsFlag");
        return bl;
    }

    private static Class getActionClass(String string) {
        LOGGER.entering(ConfigAction.class.getName(), "getActionClass");
        Class clazz = null;
        string = new File(string).getName();
        Matcher matcher = PATTERN_ACTION_NAME.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(3);
            if (string2.equalsIgnoreCase(S_JACL)) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getActionClass", string + " was parsed to be of type JACL (.jacl) action");
                clazz = CLASS_JACL_ACTION;
            }
            if (string2.equalsIgnoreCase(S_SH)) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getActionClass", string + " was parsed to be of type SHELL (.sh) action");
                clazz = CLASS_PLATFORM_NATIVE_SHELL_SCRIPT_ACTION;
            }
            if (string2.equalsIgnoreCase(S_BAT)) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getActionClass", string + " was parsed to be of type SHELL (.bat) action");
                clazz = CLASS_PLATFORM_NATIVE_SHELL_SCRIPT_ACTION;
            }
            if (string2.equalsIgnoreCase(S_ANT)) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getActionClass", string + " was parsed to be of type ANT (.ant) action");
                clazz = CLASS_ANT_ACTION;
            }
            if (string2.equalsIgnoreCase(S_IJC)) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getActionClass", string + " was parsed to be of type InProcess Java Call (.ijc) action");
                clazz = CLASS_IJC_ACTION;
            }
        } else {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getActionClass", string + " could not be parsed as a valid action name, assuming an empty action");
            clazz = CLASS_EMPTY_ACTION;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getActionClass", "Returning " + clazz.getName() + " as the executing class for " + string);
        LOGGER.exiting(ConfigAction.class.getName(), "getActionClass");
        return clazz;
    }
}

