/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine;

import com.ibm.ws.install.configmanager.actionengine.ConfigAction;
import com.ibm.ws.install.configmanager.actionengine.JACLAction;
import com.ibm.ws.install.configmanager.ijc.IJC;
import com.ibm.ws.install.configmanager.ijc.IJCParseException;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.FileUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IJCAction
extends ConfigAction {
    private String m_sOutput = "";
    private String m_sErrorOutput = "";
    private static final Pattern PATTERN_IN_PROC_CALL_PATTERN = Pattern.compile("<inproccall>(.*)</inproccall>");
    private static final int N_CLASS_NAME_GROUP = 1;
    private static final Logger LOGGER = LoggerFactory.createLogger(IJCAction.class);
    private static final String S_CLASS_NAME = IJCAction.class.getName();

    public boolean executeAction() {
        LOGGER.entering(IJCAction.class.getName(), "executeAction");
        boolean bl = false;
        try {
            String string = this.getClassNameForThisAction();
            Class<?> clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            IJC iJC = (IJC)constructor.newInstance(new Object[0]);
            bl = iJC.execute();
            this.m_sOutput = iJC.getOutput();
            this.m_sErrorOutput = iJC.getErrorOutput();
        }
        catch (Throwable throwable) {
            LogUtils.logException(LOGGER, throwable);
            bl = false;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeAction", "Result of executing " + this.getActionPath() + " was: " + bl);
        LOGGER.exiting(IJCAction.class.getName(), "executeAction");
        return bl;
    }

    public boolean rollBackAction() {
        LOGGER.entering(IJCAction.class.getName(), "rollBackAction");
        LOGGER.exiting(IJCAction.class.getName(), "rollBackAction");
        return false;
    }

    public String getActionManualCommand() {
        LOGGER.entering(IJCAction.class.getName(), "getActionManualCommand");
        LOGGER.exiting(IJCAction.class.getName(), "getActionManualCommand");
        return new String();
    }

    private String getClassNameForThisAction() throws IOException, FileNotFoundException, IJCParseException {
        LOGGER.entering(IJCAction.class.getName(), "getClassNameForThisAction");
        String string = FileUtils.readFile(this.getActionPath());
        Matcher matcher = PATTERN_IN_PROC_CALL_PATTERN.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getClassNameForThisAction", "Class to launch for " + this.getActionPath() + " is: " + string2);
            LOGGER.exiting(IJCAction.class.getName(), "getClassNameForThisAction");
            return string2;
        }
        LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getClassNameForThisAction", "IJC file for " + this.getActionPath() + " could not be parsed successfully");
        LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getClassNameForThisAction", "The IJC file contents follow for " + this.getActionPath() + "\n" + string);
        LOGGER.throwing(IJCAction.class.getName(), "getClassNameForThisAction", new IJCParseException());
        throw new IJCParseException();
    }

    public String getActionErrorOutput() {
        LOGGER.entering(JACLAction.class.getName(), "getActionErrorOutput");
        LOGGER.exiting(JACLAction.class.getName(), "getActionErrorOutput");
        return this.m_sErrorOutput;
    }

    public String getActionOutput() {
        LOGGER.entering(JACLAction.class.getName(), "getActionOutput");
        LOGGER.exiting(JACLAction.class.getName(), "getActionOutput");
        return this.m_sOutput;
    }
}

