/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine;

import com.ibm.ws.install.configmanager.ConfigManagerConstants;
import com.ibm.ws.install.configmanager.actionengine.ConfigAction;
import com.ibm.ws.install.configmanager.execengine.ExecEngine;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.install.configmanager.utils.ArrayUtils;
import com.ibm.ws.install.configmanager.utils.WASHomeLocater;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JACLAction
extends ConfigAction {
    private String m_sOutput = "";
    private String m_sErrorOutput = "";
    private static final String S_SPACE = " ";
    private static final String S_BIN = "bin";
    private static final String S_WSADMIN_EXEC_PARAM = PlatformConstants.convertToShellParam(WASHomeLocater.getWASHome() + PlatformConstants.getFileSystemPathSeparator() + "bin" + PlatformConstants.getFileSystemPathSeparator() + PlatformConstants.getWSAdminInterpretorName());
    private static final String S_WSADMIN_EXEC_COMMAND = S_WSADMIN_EXEC_PARAM + " " + "-conntype NONE -f" + " ";
    private static final Logger LOGGER = LoggerFactory.createLogger(JACLAction.class);
    private static final String S_CLASS_NAME = JACLAction.class.getName();

    public boolean executeAction() {
        LOGGER.entering(JACLAction.class.getName(), "executeAction");
        ExecEngine execEngine = new ExecEngine();
        int n = execEngine.executeIncomingArguments(this.getExecStringArrayToExecuteThisActionUsingWSAdmin(), ConfigManagerConstants.getProcessTimeOutTime());
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "executeAction", this.getActionPath() + " returned " + n + ", 0 is expected on success");
        this.m_sOutput = execEngine.getProcessStdOut();
        this.m_sErrorOutput = execEngine.getProcessStdErr();
        boolean bl = false;
        if (n == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeAction", this.getActionPath() + " executed successfully");
            bl = true;
        } else {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "executeAction", this.getActionPath() + " failed to execute");
            bl = false;
        }
        LOGGER.exiting(JACLAction.class.getName(), "executeAction");
        return bl;
    }

    public boolean rollBackAction() {
        LOGGER.entering(JACLAction.class.getName(), "rollBackAction");
        LOGGER.exiting(JACLAction.class.getName(), "rollBackAction");
        return false;
    }

    public String getActionManualCommand() {
        LOGGER.entering(JACLAction.class.getName(), "getActionManualCommand");
        String string = PlatformConstants.convertExecArrayToPlatformSpecificExecCommand(this.getExecStringArrayToExecuteThisActionUsingWSAdmin());
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "getActionManualCommand", "The manual command for " + this.getActionPath() + " action is: " + string);
        LOGGER.exiting(JACLAction.class.getName(), "getActionManualCommand");
        return string;
    }

    private String[] getExecStringArrayToExecuteThisActionUsingWSAdmin() {
        LOGGER.entering(JACLAction.class.getName(), "getExecStringArrayToExecuteThisActionUsingWSAdmin");
        String[] stringArray = PlatformConstants.getShellExecPrefixForCurrentPlatform();
        Object[] objectArray = new String[stringArray.length + 1];
        ArrayUtils.appendArray(objectArray, stringArray, 0);
        objectArray[stringArray.length] = S_WSADMIN_EXEC_COMMAND + this.getActionPathAsSafeShellParameter();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getExecStringArrayToExecuteThisActionUsingWSAdmin", "The string array to execute " + this.getActionPath() + " JACL action is: " + LogUtils.getArrayAsALoggableString(objectArray));
        LOGGER.exiting(JACLAction.class.getName(), "getExecStringArrayToExecuteThisActionUsingWSAdmin");
        return objectArray;
    }

    public String getActionErrorOutput() {
        LOGGER.entering(JACLAction.class.getName(), "getActionErrorOutput");
        LOGGER.exiting(JACLAction.class.getName(), "getActionErrorOutput");
        return this.m_sErrorOutput;
    }

    public String getActionOutput() {
        LOGGER.entering(JACLAction.class.getName(), "getActionOutput");
        LOGGER.exiting(JACLAction.class.getName(), "getActionOutput");
        return this.m_sOutput;
    }
}

